/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.digests.GOST3411Digest;
import org.bouncycastle.crypto.engines.GOST28147Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.GOFBBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithSBox;
import org.bouncycastle.crypto.test.BlockCipherVectorTest;
import org.bouncycastle.crypto.test.CipherTest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class GOST28147Test
extends CipherTest {
    static String input1 = "0000000000000000";
    static String output1 = "1b0bbc32cebcab42";
    static String input2 = "bc350e71aac5f5c2";
    static String output2 = "d35ab653493b49f5";
    static String input3 = "bc350e71aa11345709acde";
    static String output3 = "8824c124c4fd14301fb1e8";
    static String input4 = "000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f";
    static String output4 = "29b7083e0a6d955ca0ec5b04fdb4ea41949f1dd2efdf17baffc1780b031f3934";
    static byte[] TestSBox = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
    static byte[] TestSBox_1 = new byte[]{14, 3, 12, 13, 1, 15, 10, 9, 11, 6, 2, 7, 5, 0, 8, 4, 13, 9, 0, 4, 7, 1, 3, 11, 6, 12, 2, 10, 15, 14, 5, 8, 8, 11, 10, 7, 1, 13, 5, 12, 6, 3, 9, 0, 15, 14, 2, 4, 13, 7, 12, 9, 15, 0, 5, 8, 10, 2, 11, 6, 4, 3, 1, 14, 11, 4, 6, 5, 0, 15, 1, 12, 9, 14, 13, 8, 3, 7, 10, 2, 13, 15, 9, 4, 2, 12, 5, 10, 6, 0, 3, 8, 7, 14, 1, 11, 15, 14, 9, 5, 11, 2, 1, 8, 6, 0, 13, 3, 4, 7, 12, 10, 10, 3, 14, 2, 0, 1, 4, 6, 11, 8, 12, 7, 13, 5, 15, 9};
    static SimpleTest[] tests = new SimpleTest[]{new BlockCipherVectorTest(1, (BlockCipher)new GOST28147Engine(), (CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), input1, output1), new BlockCipherVectorTest(2, (BlockCipher)new CBCBlockCipher((BlockCipher)new GOST28147Engine()), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(Hex.decode((String)"00112233445566778899AABBCCDDEEFF00112233445566778899AABBCCDDEEFF")), Hex.decode((String)"1234567890abcdef")), input2, output2), new BlockCipherVectorTest(3, (BlockCipher)new GOFBBlockCipher((BlockCipher)new GOST28147Engine()), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(Hex.decode((String)"0011223344556677889900112233445566778899001122334455667788990011")), Hex.decode((String)"1234567890abcdef")), input3, output3), new BlockCipherVectorTest(4, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 64), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(Hex.decode((String)"aafd12f659cae63489b479e5076ddec2f06cb58faafd12f659cae63489b479e5")), Hex.decode((String)"aafd12f659cae634")), input4, output4), new BlockCipherVectorTest(5, (BlockCipher)new GOST28147Engine(), (CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), input1, output1), new BlockCipherVectorTest(6, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 64), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox((String)"D-Test")), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "b587f7a0814c911d"), new BlockCipherVectorTest(7, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 64), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox((String)"E-Test")), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "e8287f53f991d52b"), new BlockCipherVectorTest(8, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 64), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox((String)"E-A")), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "c41009dba22ebe35"), new BlockCipherVectorTest(9, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 8), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox((String)"E-B")), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "80d8723fcd3aba28"), new BlockCipherVectorTest(10, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 8), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox((String)"E-C")), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "739f6f95068499b5"), new BlockCipherVectorTest(11, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 8), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox((String)"E-D")), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "4663f720f4340f57"), new BlockCipherVectorTest(12, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 8), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox((String)"D-A")), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "5bb0a31d218ed564"), new BlockCipherVectorTest(13, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 8), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), TestSBox), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "c3af96ef788667c5"), new BlockCipherVectorTest(14, (BlockCipher)new GOFBBlockCipher((BlockCipher)new GOST28147Engine()), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"4ef72b778f0b0bebeef4f077551cb74a927b470ad7d7f2513454569a247e989d")), GOST28147Engine.getSBox((String)"E-A")), Hex.decode((String)"1234567890abcdef")), "bc350e71aa11345709acde", "1bcc2282707c676fb656dc"), new BlockCipherVectorTest(15, (BlockCipher)new GOFBBlockCipher((BlockCipher)new GOST28147Engine()), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"0A43145BA8B9E9FF0AEA67D3F26AD87854CED8D9017B3D33ED81301F90FDF993")), TestSBox_1), Hex.decode((String)"8001069080010690")), "094C912C5EFDD703D42118971694580B", "2707B58DF039D1A64460735FFE76D55F"), new BlockCipherVectorTest(16, (BlockCipher)new GOFBBlockCipher((BlockCipher)new GOST28147Engine()), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"0A43145BA8B9E9FF0AEA67D3F26AD87854CED8D9017B3D33ED81301F90FDF993")), TestSBox_1), Hex.decode((String)"800107A0800107A0")), "FE780800E0690083F20C010CF00C0329", "9AF623DFF948B413B53171E8D546188D"), new BlockCipherVectorTest(17, (BlockCipher)new GOFBBlockCipher((BlockCipher)new GOST28147Engine()), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"0A43145BA8B9E9FF0AEA67D3F26AD87854CED8D9017B3D33ED81301F90FDF993")), TestSBox_1), Hex.decode((String)"8001114080011140")), "D1088FD8C0A86EE8F1DCD1088FE8C058", "62A6B64D12253BCD8241A4BB0CFD3E7C"), new BlockCipherVectorTest(18, (BlockCipher)new GOFBBlockCipher((BlockCipher)new GOST28147Engine()), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"0A43145BA8B9E9FF0AEA67D3F26AD87854CED8D9017B3D33ED81301F90FDF993")), TestSBox_1), Hex.decode((String)"80011A3080011A30")), "D431FACD011C502C501B500A12921090", "07313C89D302FF73234B4A0506AB00F3")};
    private static final int GOST28147_KEY_LENGTH = 32;

    private byte[] generateKey(byte[] startkey) {
        byte[] newKey = new byte[32];
        GOST3411Digest digest = new GOST3411Digest();
        digest.update(startkey, 0, startkey.length);
        digest.doFinal(newKey, 0);
        return newKey;
    }

    GOST28147Test() {
        super(tests, (BlockCipher)new GOST28147Engine(), new KeyParameter(new byte[32]));
    }

    public void performTest() throws Exception {
        super.performTest();
        byte[] in = Hex.decode((String)"4e6f77206973207468652074696d6520666f7220616c6c20");
        byte[] output = Hex.decode((String)"8ad3c8f56b27ff1fbd46409359bdc796bc350e71aac5f5c0");
        byte[] out = new byte[in.length];
        byte[] key = this.generateKey(Hex.decode((String)"0123456789abcdef"));
        ParametersWithSBox param = new ParametersWithSBox((CipherParameters)new KeyParameter(key), GOST28147Engine.getSBox((String)"E-A"));
        BufferedBlockCipher cipher = new BufferedBlockCipher((BlockCipher)new GOST28147Engine());
        cipher.init(true, (CipherParameters)param);
        int len1 = cipher.processBytes(in, 0, in.length, out, 0);
        try {
            cipher.doFinal(out, len1);
        }
        catch (CryptoException e) {
            this.fail("failed - exception " + e.toString(), e);
        }
        if (out.length != output.length) {
            this.fail("failed - expected " + new String(Hex.encode((byte[])output)) + " got " + new String(Hex.encode((byte[])out)));
        }
        int i = 0;
        while (i != out.length) {
            if (out[i] != output[i]) {
                this.fail("failed - expected " + new String(Hex.encode((byte[])output)) + " got " + new String(Hex.encode((byte[])out)));
            }
            ++i;
        }
        in = Hex.decode((String)"bc350e71aac5f5c2");
        output = Hex.decode((String)"0ebbbafcf38f14a5");
        out = new byte[in.length];
        key = this.generateKey(Hex.decode((String)"0123456789abcdef"));
        param = new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(key), GOST28147Engine.getSBox((String)"E-A")), Hex.decode((String)"1234567890abcdef"));
        cipher = new BufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 64));
        cipher.init(true, (CipherParameters)param);
        len1 = cipher.processBytes(in, 0, in.length, out, 0);
        try {
            cipher.doFinal(out, len1);
        }
        catch (CryptoException e) {
            this.fail("failed - exception " + e.toString(), e);
        }
        if (out.length != output.length) {
            this.fail("failed - expected " + new String(Hex.encode((byte[])output)) + " got " + new String(Hex.encode((byte[])out)));
        }
        int i2 = 0;
        while (i2 != out.length) {
            if (out[i2] != output[i2]) {
                this.fail("failed - expected " + new String(Hex.encode((byte[])output)) + " got " + new String(Hex.encode((byte[])out)));
            }
            ++i2;
        }
        in = Hex.decode((String)"000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f");
        output = Hex.decode((String)"64988982819f0a1655e226e19ecad79d10cc73bac95c5d7da034786c12294225");
        out = new byte[in.length];
        key = this.generateKey(Hex.decode((String)"aafd12f659cae63489b479e5076ddec2f06cb58faafd12f659cae63489b479e5"));
        param = new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(key), GOST28147Engine.getSBox((String)"E-A")), Hex.decode((String)"aafd12f659cae634"));
        cipher = new BufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 64));
        cipher.init(true, (CipherParameters)param);
        len1 = cipher.processBytes(in, 0, in.length, out, 0);
        cipher.doFinal(out, len1);
        if (out.length != output.length) {
            this.fail("failed - expected " + new String(Hex.encode((byte[])output)) + " got " + new String(Hex.encode((byte[])out)));
        }
        int i3 = 0;
        while (i3 != out.length) {
            if (out[i3] != output[i3]) {
                this.fail("failed - expected " + new String(Hex.encode((byte[])output)) + " got " + new String(Hex.encode((byte[])out)));
            }
            ++i3;
        }
        in = Hex.decode((String)"bc350e71aa11345709acde");
        output = Hex.decode((String)"1bcc2282707c676fb656dc");
        out = new byte[in.length];
        key = this.generateKey(Hex.decode((String)"0123456789abcdef"));
        param = new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(key), GOST28147Engine.getSBox((String)"E-A")), Hex.decode((String)"1234567890abcdef"));
        cipher = new BufferedBlockCipher((BlockCipher)new GOFBBlockCipher((BlockCipher)new GOST28147Engine()));
        cipher.init(true, (CipherParameters)param);
        len1 = cipher.processBytes(in, 0, in.length, out, 0);
        cipher.doFinal(out, len1);
        if (out.length != output.length) {
            this.fail("failed - expected " + new String(Hex.encode((byte[])output)) + " got " + new String(Hex.encode((byte[])out)));
        }
        int i4 = 0;
        while (i4 != out.length) {
            if (out[i4] != output[i4]) {
                this.fail("failed - expected " + new String(Hex.encode((byte[])output)) + " got " + new String(Hex.encode((byte[])out)));
            }
            ++i4;
        }
        param = new ParametersWithIV(null, Hex.decode((String)"1234567890abcdef"));
        cipher.init(true, (CipherParameters)param);
        len1 = cipher.processBytes(in, 0, in.length, out, 0);
        cipher.doFinal(out, len1);
        if (out.length != output.length) {
            this.fail("failed - expected " + new String(Hex.encode((byte[])output)) + " got " + new String(Hex.encode((byte[])out)));
        }
        int i5 = 0;
        while (i5 != out.length) {
            if (out[i5] != output[i5]) {
                this.fail("failed - expected " + new String(Hex.encode((byte[])output)) + " got " + new String(Hex.encode((byte[])out)));
            }
            ++i5;
        }
    }

    public String getName() {
        return "GOST28147";
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new GOST28147Test());
    }
}

