/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.GOST28147Engine;
import org.bouncycastle.crypto.macs.GOST28147Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithSBox;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class GOST28147MacTest
implements Test {
    static byte[] gkeyBytes1 = Hex.decode((String)"6d145dc993f4019e104280df6fcd8cd8e01e101e4c113d7ec4f469ce6dcd9e49");
    static byte[] gkeyBytes2 = Hex.decode((String)"6d145dc993f4019e104280df6fcd8cd8e01e101e4c113d7ec4f469ce6dcd9e49");
    static byte[] input3 = Hex.decode((String)"7768617420646f2079612077616e7420666f72206e6f7468696e673f");
    static byte[] input4 = Hex.decode((String)"7768617420646f2079612077616e7420666f72206e6f7468696e673f");
    static byte[] output7 = Hex.decode((String)"93468a46");
    static byte[] output8 = Hex.decode((String)"93468a46");

    public TestResult perform() {
        GOST28147Mac mac = new GOST28147Mac();
        KeyParameter key = new KeyParameter(gkeyBytes1);
        mac.init((CipherParameters)key);
        mac.update(input3, 0, input3.length);
        byte[] out = new byte[4];
        mac.doFinal(out, 0);
        if (!Arrays.areEqual((byte[])out, (byte[])output7)) {
            return new SimpleTestResult(false, this.getName() + ": Failed test 1 - expected " + new String(Hex.encode((byte[])output7)) + " got " + new String(Hex.encode((byte[])out)));
        }
        key = new KeyParameter(gkeyBytes2);
        ParametersWithSBox gparam = new ParametersWithSBox((CipherParameters)key, GOST28147Engine.getSBox((String)"E-A"));
        mac.init((CipherParameters)gparam);
        mac.update(input4, 0, input4.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!Arrays.areEqual((byte[])out, (byte[])output8)) {
            return new SimpleTestResult(false, this.getName() + ": Failed test 2 - expected " + new String(Hex.encode((byte[])output8)) + " got " + new String(Hex.encode((byte[])out)));
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "GOST28147Mac";
    }

    public static void main(String[] args) {
        GOST28147MacTest test = new GOST28147MacTest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

