/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyEncoder;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.KeyParser;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.engines.IESEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.kems.ECIESKEMExtractor;
import org.bouncycastle.crypto.kems.ECIESKEMGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECNamedDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.IESParameters;
import org.bouncycastle.crypto.params.IESWithCipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.parsers.ECIESPublicKeyParser;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ECIESTest
extends SimpleTest {
    private static byte[] TWOFISH_IV = Hex.decode((String)"000102030405060708090a0b0c0d0e0f");

    ECIESTest() {
    }

    public String getName() {
        return "ECIES";
    }

    private void doStaticTest(byte[] iv) throws Exception {
        byte[] out2;
        BigInteger n = new BigInteger("6277101735386680763835789423176059013767194773182842284081");
        ECCurve.Fp curve = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16), n, ECConstants.ONE);
        ECDomainParameters params = new ECDomainParameters((ECCurve)curve, curve.decodePoint(Hex.decode((String)"03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), n);
        ECPrivateKeyParameters priKey = new ECPrivateKeyParameters(new BigInteger("651056770906015076056810763456358567190100156695615665659"), params);
        ECPublicKeyParameters pubKey = new ECPublicKeyParameters(curve.decodePoint(Hex.decode((String)"0262b12d60690cdcf330babab6e69763b471f994dd702d16a5")), params);
        AsymmetricCipherKeyPair p1 = new AsymmetricCipherKeyPair((AsymmetricKeyParameter)pubKey, (AsymmetricKeyParameter)priKey);
        AsymmetricCipherKeyPair p2 = new AsymmetricCipherKeyPair((AsymmetricKeyParameter)pubKey, (AsymmetricKeyParameter)priKey);
        IESEngine i1 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()));
        IESEngine i2 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()));
        byte[] d = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] e = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        IESParameters p = new IESParameters(d, e, 64);
        i1.init(true, (CipherParameters)p1.getPrivate(), (CipherParameters)p2.getPublic(), (CipherParameters)p);
        i2.init(false, (CipherParameters)p2.getPrivate(), (CipherParameters)p1.getPublic(), (CipherParameters)p);
        byte[] message = Hex.decode((String)"1234567890abcdef");
        byte[] out1 = i1.processBlock(message, 0, message.length);
        if (!this.areEqual(out1, Hex.decode((String)"468d89877e8238802403ec4cb6b329faeccfa6f3a730f2cdb3c0a8e8"))) {
            this.fail("stream cipher test failed on enc");
        }
        if (!this.areEqual(out2 = i2.processBlock(out1, 0, out1.length), message)) {
            this.fail("stream cipher test failed");
        }
        PaddedBufferedBlockCipher c1 = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new TwofishEngine()));
        PaddedBufferedBlockCipher c2 = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new TwofishEngine()));
        i1 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()), (BufferedBlockCipher)c1);
        i2 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()), (BufferedBlockCipher)c2);
        d = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        e = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        p = new IESWithCipherParameters(d, e, 64, 128);
        if (iv != null) {
            p = new ParametersWithIV((CipherParameters)p, iv);
        }
        i1.init(true, (CipherParameters)p1.getPrivate(), (CipherParameters)p2.getPublic(), (CipherParameters)p);
        i2.init(false, (CipherParameters)p2.getPrivate(), (CipherParameters)p1.getPublic(), (CipherParameters)p);
        message = Hex.decode((String)"1234567890abcdef");
        out1 = i1.processBlock(message, 0, message.length);
        if (!this.areEqual(out1, iv == null ? Hex.decode((String)"b8a06ea5c2b9df28b58a0a90a734cde8c9c02903e5c220021fe4417410d1e53a32a71696") : Hex.decode((String)"f246b0e26a2711992cac9c590d08e45c5e730b7c0f4218bb064e27b7dd7c8a3bd8bf01c3"))) {
            this.fail("twofish cipher test failed on enc");
        }
        if (!this.areEqual(out2 = i2.processBlock(out1, 0, out1.length), message)) {
            this.fail("twofish cipher test failed");
        }
    }

    private void doShortTest(byte[] iv) throws Exception {
        block7: {
            byte[] out2;
            byte[] out1;
            byte[] message;
            IESParameters p;
            IESEngine i2;
            IESEngine i1;
            AsymmetricCipherKeyPair p2;
            ECDomainParameters params;
            block6: {
                BigInteger n = new BigInteger("6277101735386680763835789423176059013767194773182842284081");
                ECCurve.Fp curve = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16), n, ECConstants.ONE);
                params = new ECDomainParameters((ECCurve)curve, curve.decodePoint(Hex.decode((String)"03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), n);
                ECPrivateKeyParameters priKey = new ECPrivateKeyParameters(new BigInteger("651056770906015076056810763456358567190100156695615665659"), params);
                ECPublicKeyParameters pubKey = new ECPublicKeyParameters(curve.decodePoint(Hex.decode((String)"0262b12d60690cdcf330babab6e69763b471f994dd702d16a5")), params);
                AsymmetricCipherKeyPair p1 = new AsymmetricCipherKeyPair((AsymmetricKeyParameter)pubKey, (AsymmetricKeyParameter)priKey);
                p2 = new AsymmetricCipherKeyPair((AsymmetricKeyParameter)pubKey, (AsymmetricKeyParameter)priKey);
                i1 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()));
                i2 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()));
                byte[] d = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
                byte[] e = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
                p = new IESParameters(d, e, 64);
                i1.init(true, (CipherParameters)p1.getPrivate(), (CipherParameters)p2.getPublic(), (CipherParameters)p);
                i2.init(false, (CipherParameters)p2.getPrivate(), (CipherParameters)p1.getPublic(), (CipherParameters)p);
                message = new byte[]{};
                out1 = i1.processBlock(message, 0, message.length);
                out2 = i2.processBlock(out1, 0, out1.length);
                if (!this.areEqual(out2, message)) {
                    this.fail("stream cipher test failed");
                }
                try {
                    i2.processBlock(out1, 0, out1.length - 1);
                    this.fail("no exception");
                }
                catch (InvalidCipherTextException ex) {
                    if ("Length of input must be greater than the MAC and V combined".equals(ex.getMessage())) break block6;
                    this.fail("wrong exception");
                }
            }
            ECKeyPairGenerator gen = new ECKeyPairGenerator();
            gen.init((KeyGenerationParameters)new ECKeyGenerationParameters(params, new SecureRandom()));
            EphemeralKeyPairGenerator ephKeyGen = new EphemeralKeyPairGenerator((AsymmetricCipherKeyPairGenerator)gen, new KeyEncoder(){

                public byte[] getEncoded(AsymmetricKeyParameter keyParameter) {
                    return ((ECPublicKeyParameters)keyParameter).getQ().getEncoded(false);
                }
            });
            i1.init(p2.getPublic(), (CipherParameters)p, ephKeyGen);
            i2.init(p2.getPrivate(), (CipherParameters)p, (KeyParser)new ECIESPublicKeyParser(params));
            out1 = i1.processBlock(message, 0, message.length);
            out2 = i2.processBlock(out1, 0, out1.length);
            if (!this.areEqual(out2, message)) {
                this.fail("V cipher test failed");
            }
            try {
                i2.processBlock(out1, 0, out1.length - 1);
                this.fail("no exception");
            }
            catch (InvalidCipherTextException ex) {
                if ("Length of input must be greater than the MAC and V combined".equals(ex.getMessage())) break block7;
                this.fail("wrong exception");
            }
        }
    }

    private void doEphemeralTest(byte[] iv, final boolean usePointCompression) throws Exception {
        BigInteger n = new BigInteger("6277101735386680763835789423176059013767194773182842284081");
        ECCurve.Fp curve = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16), n, ECConstants.ONE);
        ECDomainParameters params = new ECDomainParameters((ECCurve)curve, curve.decodePoint(Hex.decode((String)"03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), n);
        ECPrivateKeyParameters priKey = new ECPrivateKeyParameters(new BigInteger("651056770906015076056810763456358567190100156695615665659"), params);
        ECPublicKeyParameters pubKey = new ECPublicKeyParameters(curve.decodePoint(Hex.decode((String)"0262b12d60690cdcf330babab6e69763b471f994dd702d16a5")), params);
        AsymmetricCipherKeyPair p1 = new AsymmetricCipherKeyPair((AsymmetricKeyParameter)pubKey, (AsymmetricKeyParameter)priKey);
        AsymmetricCipherKeyPair p2 = new AsymmetricCipherKeyPair((AsymmetricKeyParameter)pubKey, (AsymmetricKeyParameter)priKey);
        ECKeyPairGenerator gen = new ECKeyPairGenerator();
        gen.init((KeyGenerationParameters)new ECKeyGenerationParameters(params, new SecureRandom()));
        EphemeralKeyPairGenerator ephKeyGen = new EphemeralKeyPairGenerator((AsymmetricCipherKeyPairGenerator)gen, new KeyEncoder(){

            public byte[] getEncoded(AsymmetricKeyParameter keyParameter) {
                return ((ECPublicKeyParameters)keyParameter).getQ().getEncoded(usePointCompression);
            }
        });
        IESEngine i1 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()));
        IESEngine i2 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()));
        byte[] d = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] e = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        IESParameters p = new IESParameters(d, e, 64);
        i1.init(p2.getPublic(), (CipherParameters)p, ephKeyGen);
        i2.init(p2.getPrivate(), (CipherParameters)p, (KeyParser)new ECIESPublicKeyParser(params));
        byte[] message = Hex.decode((String)"1234567890abcdef");
        byte[] out1 = i1.processBlock(message, 0, message.length);
        byte[] out2 = i2.processBlock(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail("stream cipher test failed");
        }
        PaddedBufferedBlockCipher c1 = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new TwofishEngine()));
        PaddedBufferedBlockCipher c2 = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new TwofishEngine()));
        i1 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()), (BufferedBlockCipher)c1);
        i2 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()), (BufferedBlockCipher)c2);
        d = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        e = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        p = new IESWithCipherParameters(d, e, 64, 128);
        if (iv != null) {
            p = new ParametersWithIV((CipherParameters)p, iv);
        }
        i1.init(p2.getPublic(), (CipherParameters)p, ephKeyGen);
        i2.init(p2.getPrivate(), (CipherParameters)p, (KeyParser)new ECIESPublicKeyParser(params));
        message = Hex.decode((String)"1234567890abcdef");
        out1 = i1.processBlock(message, 0, message.length);
        out2 = i2.processBlock(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail("twofish cipher test failed");
        }
    }

    private void doTest(AsymmetricCipherKeyPair p1, AsymmetricCipherKeyPair p2) throws Exception {
        IESEngine i1 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()));
        IESEngine i2 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()));
        byte[] d = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] e = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        IESParameters p = new IESParameters(d, e, 64);
        i1.init(true, (CipherParameters)p1.getPrivate(), (CipherParameters)p2.getPublic(), (CipherParameters)p);
        i2.init(false, (CipherParameters)p2.getPrivate(), (CipherParameters)p1.getPublic(), (CipherParameters)p);
        byte[] message = Hex.decode((String)"1234567890abcdef");
        byte[] out1 = i1.processBlock(message, 0, message.length);
        byte[] out2 = i2.processBlock(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail("stream cipher test failed");
        }
        PaddedBufferedBlockCipher c1 = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new TwofishEngine()));
        PaddedBufferedBlockCipher c2 = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new TwofishEngine()));
        i1 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()), (BufferedBlockCipher)c1);
        i2 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()), (BufferedBlockCipher)c2);
        d = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        e = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        p = new IESWithCipherParameters(d, e, 64, 128);
        i1.init(true, (CipherParameters)p1.getPrivate(), (CipherParameters)p2.getPublic(), (CipherParameters)p);
        i2.init(false, (CipherParameters)p2.getPrivate(), (CipherParameters)p1.getPublic(), (CipherParameters)p);
        message = Hex.decode((String)"1234567890abcdef");
        out1 = i1.processBlock(message, 0, message.length);
        out2 = i2.processBlock(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail("twofish cipher test failed");
        }
    }

    public void performTest() throws Exception {
        this.doStaticTest(null);
        this.doStaticTest(TWOFISH_IV);
        this.doShortTest(null);
        BigInteger n = new BigInteger("6277101735386680763835789423176059013767194773182842284081");
        ECCurve.Fp curve = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16), n, ECConstants.ONE);
        ECDomainParameters params = new ECDomainParameters((ECCurve)curve, curve.decodePoint(Hex.decode((String)"03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), n);
        ECKeyPairGenerator eGen = new ECKeyPairGenerator();
        ECKeyGenerationParameters gParam = new ECKeyGenerationParameters(params, new SecureRandom());
        eGen.init((KeyGenerationParameters)gParam);
        AsymmetricCipherKeyPair p1 = eGen.generateKeyPair();
        AsymmetricCipherKeyPair p2 = eGen.generateKeyPair();
        this.doTest(p1, p2);
        this.doEphemeralTest(null, false);
        this.doEphemeralTest(null, true);
        this.doEphemeralTest(TWOFISH_IV, false);
        this.doEphemeralTest(TWOFISH_IV, true);
        this.doCofactorTest(true, false);
        this.doCofactorTest(false, false);
        this.doCofactorTest(false, true);
        this.doCofactorTest(true, true);
    }

    private void doCofactorTest(boolean newCofactorMode, boolean oldCofactorMode) {
        ECKeyPairGenerator myGenerator = new ECKeyPairGenerator();
        SecureRandom myRandom = new SecureRandom();
        String myCurve = "sect571k1";
        X9ECParameters x9 = ECNamedCurveTable.getByName((String)myCurve);
        ASN1ObjectIdentifier myOid = ECNamedCurveTable.getOID((String)myCurve);
        ECNamedDomainParameters myDomain = new ECNamedDomainParameters(myOid, x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
        ECKeyGenerationParameters myParams = new ECKeyGenerationParameters((ECDomainParameters)myDomain, myRandom);
        myGenerator.init((KeyGenerationParameters)myParams);
        AsymmetricCipherKeyPair myPair = myGenerator.generateKeyPair();
        int myFieldSize = x9.getCurve().getFieldSize();
        myFieldSize = (myFieldSize + 8 - 1) / 8;
        int myLen = 2 * myFieldSize + 1;
        byte[] myMessage = new byte[myLen];
        int myKeyLen = 32;
        ECIESKEMGenerator kemGen = new ECIESKEMGenerator(myKeyLen, (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA512Digest()), myRandom, newCofactorMode, oldCofactorMode, false);
        SecretWithEncapsulation secEnc = kemGen.generateEncapsulated(myPair.getPublic());
        KeyParameter mySender = new KeyParameter(secEnc.getSecret());
        byte[] mySenderKey = mySender.getKey();
        ECIESKEMExtractor kemExt = new ECIESKEMExtractor((ECPrivateKeyParameters)myPair.getPrivate(), myKeyLen, (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA512Digest()), newCofactorMode, oldCofactorMode, false);
        KeyParameter myReceiver = new KeyParameter(kemExt.extractSecret(secEnc.getEncapsulation()));
        byte[] myReceiverKey = myReceiver.getKey();
        this.isTrue("new " + newCofactorMode + " old " + oldCofactorMode, Arrays.areEqual((byte[])mySenderKey, (byte[])myReceiverKey));
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new ECIESTest());
    }
}

