/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.kems.ECIESKEMExtractor;
import org.bouncycastle.crypto.kems.ECIESKEMGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.test.SimpleTest;

public class ECIESKeyEncapsulationTest
extends SimpleTest {
    public String getName() {
        return "ECIESKeyEncapsulation";
    }

    public void performTest() throws Exception {
        X9ECParameters spec = SECNamedCurves.getByName((String)"secp224r1");
        ECDomainParameters ecDomain = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN());
        ECKeyPairGenerator ecGen = new ECKeyPairGenerator();
        ecGen.init((KeyGenerationParameters)new ECKeyGenerationParameters(ecDomain, new SecureRandom()));
        AsymmetricCipherKeyPair keys = ecGen.generateKeyPair();
        KDF2BytesGenerator kdf = new KDF2BytesGenerator((Digest)new SHA1Digest());
        SecureRandom rnd = new SecureRandom();
        byte[] out = new byte[57];
        ECIESKEMGenerator kemGen = new ECIESKEMGenerator(16, (DerivationFunction)kdf, rnd);
        SecretWithEncapsulation secEnc = kemGen.generateEncapsulated(keys.getPublic());
        KeyParameter key1 = new KeyParameter(secEnc.getSecret());
        ECIESKEMExtractor kemExt = new ECIESKEMExtractor((ECPrivateKeyParameters)keys.getPrivate(), 16, (DerivationFunction)kdf);
        KeyParameter key2 = new KeyParameter(kemExt.extractSecret(secEnc.getEncapsulation()));
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed basic test");
        }
        kemGen = new ECIESKEMGenerator(16, (DerivationFunction)kdf, rnd, true, false, false);
        secEnc = kemGen.generateEncapsulated(keys.getPublic());
        key1 = new KeyParameter(secEnc.getSecret());
        kemExt = new ECIESKEMExtractor((ECPrivateKeyParameters)keys.getPrivate(), 16, (DerivationFunction)kdf, true, false, false);
        key2 = new KeyParameter(kemExt.extractSecret(secEnc.getEncapsulation()));
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed cofactor test");
        }
        kemGen = new ECIESKEMGenerator(16, (DerivationFunction)kdf, rnd, false, true, false);
        secEnc = kemGen.generateEncapsulated(keys.getPublic());
        key1 = new KeyParameter(secEnc.getSecret());
        kemExt = new ECIESKEMExtractor((ECPrivateKeyParameters)keys.getPrivate(), 16, (DerivationFunction)kdf, false, true, false);
        key2 = new KeyParameter(kemExt.extractSecret(secEnc.getEncapsulation()));
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed old cofactor test");
        }
        kemGen = new ECIESKEMGenerator(16, (DerivationFunction)kdf, rnd, false, false, true);
        secEnc = kemGen.generateEncapsulated(keys.getPublic());
        key1 = new KeyParameter(secEnc.getSecret());
        kemExt = new ECIESKEMExtractor((ECPrivateKeyParameters)keys.getPrivate(), 16, (DerivationFunction)kdf, false, false, true);
        key2 = new KeyParameter(kemExt.extractSecret(secEnc.getEncapsulation()));
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed single hash test");
        }
        kemGen = new ECIESKEMGenerator(16, (DerivationFunction)kdf, rnd, true, false, true);
        secEnc = kemGen.generateEncapsulated(keys.getPublic());
        key1 = new KeyParameter(secEnc.getSecret());
        kemExt = new ECIESKEMExtractor((ECPrivateKeyParameters)keys.getPrivate(), 16, (DerivationFunction)kdf, true, false, true);
        key2 = new KeyParameter(kemExt.extractSecret(secEnc.getEncapsulation()));
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed cofactor and single hash test");
        }
        kemGen = new ECIESKEMGenerator(16, (DerivationFunction)kdf, rnd, false, true, true);
        secEnc = kemGen.generateEncapsulated(keys.getPublic());
        key1 = new KeyParameter(secEnc.getSecret());
        kemExt = new ECIESKEMExtractor((ECPrivateKeyParameters)keys.getPrivate(), 16, (DerivationFunction)kdf, false, true, true);
        key2 = new KeyParameter(kemExt.extractSecret(secEnc.getEncapsulation()));
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed old cofactor and single hash test");
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new ECIESKeyEncapsulationTest());
    }
}

