/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherKeyGenerator;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.test.SimpleTest;

public abstract class CipherTest
extends SimpleTest {
    private SimpleTest[] _tests;
    private BlockCipher _engine;
    private KeyParameter _validKey;

    protected CipherTest(SimpleTest[] tests, BlockCipher engine, KeyParameter validKey) {
        this._tests = tests;
        this._engine = engine;
        this._validKey = validKey;
    }

    public abstract String getName();

    public void performTest() throws Exception {
        int i = 0;
        while (i != this._tests.length) {
            this._tests[i].performTest();
            ++i;
        }
        if (this._engine != null) {
            byte[] buf = new byte[128];
            try {
                this._engine.processBlock(buf, 0, buf, 0);
                this.fail("failed initialisation check");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.bufferSizeCheck(this._engine);
        }
    }

    private void bufferSizeCheck(BlockCipher engine) {
        byte[] correctBuf = new byte[engine.getBlockSize()];
        byte[] shortBuf = new byte[correctBuf.length / 2];
        engine.init(true, (CipherParameters)this._validKey);
        try {
            engine.processBlock(shortBuf, 0, correctBuf, 0);
            this.fail("failed short input check");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
        try {
            engine.processBlock(correctBuf, 0, shortBuf, 0);
            this.fail("failed short output check");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
        engine.init(false, (CipherParameters)this._validKey);
        try {
            engine.processBlock(shortBuf, 0, correctBuf, 0);
            this.fail("failed short input check");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
        try {
            engine.processBlock(correctBuf, 0, shortBuf, 0);
            this.fail("failed short output check");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
    }

    static void checkCipher(int aeadLen, int ivLen, int msgLen, Instace instace) {
        AEADCipher pCipher = instace.CreateInstace();
        try {
            byte[] myData = new byte[msgLen];
            SecureRandom myRandom = new SecureRandom();
            myRandom.nextBytes(myData);
            byte[] myAEAD = new byte[aeadLen];
            myRandom.nextBytes(myAEAD);
            CipherKeyGenerator myGenerator = new CipherKeyGenerator();
            KeyGenerationParameters myGenParams = new KeyGenerationParameters(myRandom, 128);
            myGenerator.init(myGenParams);
            byte[] myKey = myGenerator.generateKey();
            KeyParameter myKeyParams = new KeyParameter(myKey);
            byte[] myNonce = new byte[ivLen];
            myRandom.nextBytes(myNonce);
            ParametersWithIV myParams = new ParametersWithIV((CipherParameters)myKeyParams, myNonce);
            pCipher.init(true, (CipherParameters)myParams);
            int myMaxOutLen = pCipher.getOutputSize(msgLen);
            byte[] myEncrypted = new byte[myMaxOutLen];
            pCipher.processAADBytes(myAEAD, 0, aeadLen);
            int myOutLen = pCipher.processBytes(myData, 0, msgLen, myEncrypted, 0);
            myOutLen += pCipher.doFinal(myEncrypted, myOutLen);
            pCipher = instace.CreateInstace();
            pCipher.init(false, (CipherParameters)myParams);
            int myMaxClearLen = pCipher.getOutputSize(myOutLen);
            byte[] myDecrypted = new byte[myMaxClearLen];
            pCipher.processAADBytes(myAEAD, 0, aeadLen);
            int myClearLen = pCipher.processBytes(myEncrypted, 0, myEncrypted.length, myDecrypted, 0);
            myClearLen += pCipher.doFinal(myDecrypted, myClearLen);
            byte[] myResult = Arrays.copyOf((byte[])myDecrypted, (int)msgLen);
            if (!Arrays.areEqual((byte[])myData, (byte[])myResult)) {
                System.out.println("Cipher " + pCipher.getAlgorithmName() + " failed");
            }
        }
        catch (InvalidCipherTextException e) {
            throw new RuntimeException(e.toString());
        }
    }

    static interface Instace {
        public AEADCipher CreateInstace();
    }
}

