/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DefaultBufferedBlockCipher;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.engines.CAST5Engine;
import org.bouncycastle.crypto.engines.CAST6Engine;
import org.bouncycastle.crypto.engines.CamelliaEngine;
import org.bouncycastle.crypto.engines.ChaChaEngine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.Grain128Engine;
import org.bouncycastle.crypto.engines.Grainv1Engine;
import org.bouncycastle.crypto.engines.HC128Engine;
import org.bouncycastle.crypto.engines.HC256Engine;
import org.bouncycastle.crypto.engines.NoekeonEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.engines.RC6Engine;
import org.bouncycastle.crypto.engines.SEEDEngine;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.engines.SerpentEngine;
import org.bouncycastle.crypto.engines.TEAEngine;
import org.bouncycastle.crypto.engines.ThreefishEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.engines.XSalsa20Engine;
import org.bouncycastle.crypto.engines.XTEAEngine;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.crypto.io.InvalidCipherTextIOException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.CTSBlockCipher;
import org.bouncycastle.crypto.modes.EAXBlockCipher;
import org.bouncycastle.crypto.modes.NISTCTSBlockCipher;
import org.bouncycastle.crypto.modes.OCBBlockCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.test.SimpleTest;

public class CipherStreamTest
extends SimpleTest {
    private int streamSize;

    public String getName() {
        return "CipherStreamTest";
    }

    private void testMode(Object cipher, CipherParameters params) throws Exception {
        this.testWriteRead(cipher, params, false);
        this.testWriteRead(cipher, params, true);
        this.testReadWrite(cipher, params, false);
        this.testReadWrite(cipher, params, true);
        if (!(cipher instanceof CTSBlockCipher) && !(cipher instanceof NISTCTSBlockCipher)) {
            this.testWriteReadEmpty(cipher, params, false);
            this.testWriteReadEmpty(cipher, params, true);
        }
        if (cipher instanceof AEADBlockCipher) {
            this.testTamperedRead((AEADBlockCipher)cipher, params);
            this.testTruncatedRead((AEADBlockCipher)cipher, params);
            this.testTamperedWrite((AEADBlockCipher)cipher, params);
        }
    }

    private OutputStream createCipherOutputStream(OutputStream output, Object cipher) {
        if (cipher instanceof BufferedBlockCipher) {
            return new CipherOutputStream(output, (BufferedBlockCipher)cipher);
        }
        if (cipher instanceof AEADBlockCipher) {
            return new CipherOutputStream(output, (AEADBlockCipher)cipher);
        }
        return new CipherOutputStream(output, (StreamCipher)cipher);
    }

    private InputStream createCipherInputStream(byte[] data, Object cipher) {
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        if (cipher instanceof BufferedBlockCipher) {
            return new CipherInputStream((InputStream)input, (BufferedBlockCipher)cipher);
        }
        if (cipher instanceof AEADBlockCipher) {
            return new CipherInputStream((InputStream)input, (AEADBlockCipher)cipher);
        }
        return new CipherInputStream((InputStream)input, (StreamCipher)cipher);
    }

    private void testTamperedRead(AEADBlockCipher cipher, CipherParameters params) throws Exception {
        cipher.init(true, params);
        byte[] ciphertext = new byte[cipher.getOutputSize(this.streamSize)];
        cipher.doFinal(ciphertext, cipher.processBytes(new byte[this.streamSize], 0, this.streamSize, ciphertext, 0));
        ciphertext[0] = (byte)(ciphertext[0] + 1);
        cipher.init(false, params);
        InputStream input = this.createCipherInputStream(ciphertext, cipher);
        try {
            while (input.read() >= 0) {
            }
            this.fail("Expected invalid ciphertext after tamper and read : " + cipher.getAlgorithmName());
        }
        catch (InvalidCipherTextIOException e) {
            // empty catch block
        }
        try {
            input.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception after tamper and read : " + cipher.getAlgorithmName());
        }
    }

    private void testTruncatedRead(AEADBlockCipher cipher, CipherParameters params) throws Exception {
        InputStream input;
        block6: {
            int read;
            cipher.init(true, params);
            byte[] ciphertext = new byte[cipher.getOutputSize(this.streamSize)];
            cipher.doFinal(ciphertext, cipher.processBytes(new byte[this.streamSize], 0, this.streamSize, ciphertext, 0));
            byte[] truncated = new byte[ciphertext.length - this.streamSize - 1];
            System.arraycopy(ciphertext, 0, truncated, 0, truncated.length);
            cipher.init(false, params);
            input = this.createCipherInputStream(truncated, cipher);
            do {
                read = 0;
                try {
                    read = input.read();
                }
                catch (InvalidCipherTextIOException e) {
                    break block6;
                }
                catch (Exception e) {
                    this.fail("Unexpected exception  on truncated read : " + cipher.getAlgorithmName());
                    break block6;
                }
            } while (read >= 0);
            this.fail("Expected invalid ciphertext after truncate and read : " + cipher.getAlgorithmName());
        }
        try {
            input.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception after truncate and read : " + cipher.getAlgorithmName());
        }
    }

    private void testTamperedWrite(AEADBlockCipher cipher, CipherParameters params) throws Exception {
        cipher.init(true, params);
        byte[] ciphertext = new byte[cipher.getOutputSize(this.streamSize)];
        cipher.doFinal(ciphertext, cipher.processBytes(new byte[this.streamSize], 0, this.streamSize, ciphertext, 0));
        ciphertext[0] = (byte)(ciphertext[0] + 1);
        cipher.init(false, params);
        ByteArrayOutputStream plaintext = new ByteArrayOutputStream();
        OutputStream output = this.createCipherOutputStream(plaintext, cipher);
        int i = 0;
        while (i < ciphertext.length) {
            output.write(ciphertext[i]);
            ++i;
        }
        try {
            output.close();
            this.fail("Expected invalid ciphertext after tamper and write : " + cipher.getAlgorithmName());
        }
        catch (InvalidCipherTextIOException e) {
            // empty catch block
        }
    }

    private void testWriteRead(Object cipher, CipherParameters params, boolean blocks) throws Exception {
        byte[] data = new byte[this.streamSize];
        int i = 0;
        while (i < data.length) {
            data[i] = (byte)(i % 255);
            ++i;
        }
        this.testWriteRead(cipher, params, blocks, data);
    }

    private void testWriteReadEmpty(Object cipher, CipherParameters params, boolean blocks) {
        byte[] data = new byte[]{};
        this.testWriteRead(cipher, params, blocks, data);
    }

    /*
     * Unable to fully structure code
     */
    private void testWriteRead(Object cipher, CipherParameters params, boolean blocks, byte[] data) {
        bOut = new ByteArrayOutputStream();
        try {
            block9: {
                this.init(cipher, true, params);
                cOut = this.createCipherOutputStream(bOut, cipher);
                if (blocks) {
                    chunkSize = Math.max(1, data.length / 8);
                    i = 0;
                    while (i < data.length) {
                        cOut.write(data, i, Math.min(chunkSize, data.length - i));
                        i += chunkSize;
                    }
                } else {
                    i = 0;
                    while (i < data.length) {
                        cOut.write(data[i]);
                        ++i;
                    }
                }
                cOut.close();
                cipherText = bOut.toByteArray();
                bOut.reset();
                this.init(cipher, false, params);
                cIn = this.createCipherInputStream(cipherText, cipher);
                if (!blocks) ** GOTO lbl30
                block = new byte[this.getBlockSize(cipher) + 1];
                while ((c = cIn.read(block)) >= 0) {
                    bOut.write(block, 0, (int)var10_14);
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    bOut.write((int)block);
lbl30:
                    // 2 sources

                    ** while ((c = cIn.read()) >= 0)
                }
            }
            cIn.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception " + this.getName(cipher), e);
        }
        decrypted = bOut.toByteArray();
        if (!Arrays.areEqual((byte[])data, (byte[])decrypted)) {
            this.fail("Failed - decrypted data doesn't match: " + this.getName(cipher));
        }
    }

    private String getName(Object cipher) {
        if (cipher instanceof BufferedBlockCipher) {
            return ((BufferedBlockCipher)cipher).getUnderlyingCipher().getAlgorithmName();
        }
        if (cipher instanceof AEADBlockCipher) {
            return ((AEADBlockCipher)cipher).getUnderlyingCipher().getAlgorithmName();
        }
        if (cipher instanceof StreamCipher) {
            return ((StreamCipher)cipher).getAlgorithmName();
        }
        return null;
    }

    private int getBlockSize(Object cipher) {
        if (cipher instanceof BlockCipher) {
            return ((BlockCipher)cipher).getBlockSize();
        }
        if (cipher instanceof BufferedBlockCipher) {
            return ((BufferedBlockCipher)cipher).getBlockSize();
        }
        if (cipher instanceof AEADBlockCipher) {
            return ((AEADBlockCipher)cipher).getUnderlyingCipher().getBlockSize();
        }
        if (cipher instanceof StreamCipher) {
            return 1;
        }
        return 0;
    }

    private void init(Object cipher, boolean forEncrypt, CipherParameters params) {
        if (cipher instanceof BufferedBlockCipher) {
            ((BufferedBlockCipher)cipher).init(forEncrypt, params);
        } else if (cipher instanceof AEADBlockCipher) {
            ((AEADBlockCipher)cipher).init(forEncrypt, params);
        } else if (cipher instanceof StreamCipher) {
            ((StreamCipher)cipher).init(forEncrypt, params);
        }
    }

    protected void fail(String message, boolean authenticated, boolean bc) {
        if (bc || !authenticated) {
            super.fail(message);
        } else {
            System.err.println("Broken JCE Streams: " + message);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void testReadWrite(Object cipher, CipherParameters params, boolean blocks) {
        lCode = "ABCDEFGHIJKLMNOPQRSTU";
        bOut = new ByteArrayOutputStream();
        try {
            block8: {
                block7: {
                    this.init(cipher, true, params);
                    cIn = this.createCipherInputStream(lCode.getBytes(), cipher);
                    ct = new ByteArrayOutputStream();
                    if (!blocks) ** GOTO lbl14
                    block = new byte[this.getBlockSize(cipher) + 1];
                    while ((c = cIn.read(block)) >= 0) {
                        ct.write(block, 0, (int)var9_11);
                    }
                    break block7;
lbl-1000:
                    // 1 sources

                    {
                        ct.write((int)block);
lbl14:
                        // 2 sources

                        ** while ((c = cIn.read()) >= 0)
                    }
                }
                cIn.close();
                this.init(cipher, false, params);
                dataIn = new ByteArrayInputStream(ct.toByteArray());
                cOut = this.createCipherOutputStream(bOut, cipher);
                if (!blocks) ** GOTO lbl27
                block = new byte[this.getBlockSize(cipher) + 1];
                while ((c = dataIn.read(block)) >= 0) {
                    cOut.write(block, 0, (int)var11_15);
                }
                break block8;
lbl-1000:
                // 1 sources

                {
                    cOut.write((int)block);
lbl27:
                    // 2 sources

                    ** while ((c = dataIn.read()) >= 0)
                }
            }
            cOut.flush();
            cOut.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception " + this.getName(cipher), e);
        }
        res = new String(bOut.toByteArray());
        if (!res.equals(lCode)) {
            this.fail("Failed read/write - decrypted data doesn't match: " + this.getName(cipher), lCode, res);
        }
    }

    public void performTest() throws Exception {
        int[] testSizes = new int[]{0, 1, 7, 8, 9, 15, 16, 17, 1023, 1024, 1025, 2047, 2048, 2049, 4095, 4096, 4097};
        int i = 0;
        while (i < testSizes.length) {
            this.streamSize = testSizes[i];
            this.performTests();
            ++i;
        }
    }

    private void performTests() throws Exception {
        this.testModes((BlockCipher)new BlowfishEngine(), (BlockCipher)new BlowfishEngine(), 16);
        this.testModes((BlockCipher)new DESEngine(), (BlockCipher)new DESEngine(), 8);
        this.testModes((BlockCipher)new DESedeEngine(), (BlockCipher)new DESedeEngine(), 24);
        this.testModes((BlockCipher)new TEAEngine(), (BlockCipher)new TEAEngine(), 16);
        this.testModes((BlockCipher)new CAST5Engine(), (BlockCipher)new CAST5Engine(), 16);
        this.testModes((BlockCipher)new RC2Engine(), (BlockCipher)new RC2Engine(), 16);
        this.testModes((BlockCipher)new XTEAEngine(), (BlockCipher)new XTEAEngine(), 16);
        this.testModes((BlockCipher)AESEngine.newInstance(), (BlockCipher)AESEngine.newInstance(), 16);
        this.testModes((BlockCipher)new NoekeonEngine(), (BlockCipher)new NoekeonEngine(), 16);
        this.testModes((BlockCipher)new TwofishEngine(), (BlockCipher)new TwofishEngine(), 16);
        this.testModes((BlockCipher)new CAST6Engine(), (BlockCipher)new CAST6Engine(), 16);
        this.testModes((BlockCipher)new SEEDEngine(), (BlockCipher)new SEEDEngine(), 16);
        this.testModes((BlockCipher)new SerpentEngine(), (BlockCipher)new SerpentEngine(), 16);
        this.testModes((BlockCipher)new RC6Engine(), (BlockCipher)new RC6Engine(), 16);
        this.testModes((BlockCipher)new CamelliaEngine(), (BlockCipher)new CamelliaEngine(), 16);
        this.testModes((BlockCipher)new ThreefishEngine(512), (BlockCipher)new ThreefishEngine(512), 64);
        this.testMode(new RC4Engine(), (CipherParameters)new KeyParameter(new byte[16]));
        this.testMode(new Salsa20Engine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[16]), new byte[8]));
        this.testMode(new XSalsa20Engine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[32]), new byte[24]));
        this.testMode(new ChaChaEngine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[16]), new byte[8]));
        this.testMode(new Grainv1Engine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[10]), new byte[8]));
        this.testMode(new Grain128Engine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[16]), new byte[12]));
        this.testMode(new HC128Engine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[16]), new byte[16]));
        this.testMode(new HC256Engine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[16]), new byte[16]));
        this.testSkipping((StreamCipher)new Salsa20Engine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[16]), new byte[8]));
        this.testSkipping((StreamCipher)SICBlockCipher.newInstance((BlockCipher)AESEngine.newInstance()), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[16]), new byte[16]));
    }

    private void testModes(BlockCipher cipher1, BlockCipher cipher2, int keySize) throws Exception {
        KeyParameter key = new KeyParameter(new byte[keySize]);
        int blockSize = this.getBlockSize(cipher1);
        ParametersWithIV withIv = new ParametersWithIV((CipherParameters)key, new byte[blockSize]);
        if (blockSize > 1) {
            this.testMode(new PaddedBufferedBlockCipher(cipher1, (BlockCipherPadding)new PKCS7Padding()), (CipherParameters)key);
            this.testMode(new PaddedBufferedBlockCipher((BlockCipher)CBCBlockCipher.newInstance((BlockCipher)cipher1), (BlockCipherPadding)new PKCS7Padding()), (CipherParameters)withIv);
            this.testMode(new DefaultBufferedBlockCipher((BlockCipher)new OFBBlockCipher(cipher1, blockSize)), (CipherParameters)withIv);
            this.testMode(new DefaultBufferedBlockCipher((BlockCipher)CFBBlockCipher.newInstance((BlockCipher)cipher1, (int)blockSize)), (CipherParameters)withIv);
            this.testMode(new DefaultBufferedBlockCipher((BlockCipher)SICBlockCipher.newInstance((BlockCipher)cipher1)), (CipherParameters)withIv);
        }
        if (blockSize <= 16 && this.streamSize >= blockSize) {
            this.testMode(new CTSBlockCipher(cipher1), (CipherParameters)key);
        }
        if (blockSize <= 16 && this.streamSize >= blockSize) {
            this.testMode(new NISTCTSBlockCipher(1, cipher1), (CipherParameters)key);
            this.testMode(new NISTCTSBlockCipher(2, cipher1), (CipherParameters)key);
            this.testMode(new NISTCTSBlockCipher(3, cipher1), (CipherParameters)key);
        }
        if (blockSize == 8 || blockSize == 16) {
            this.testMode(new EAXBlockCipher(cipher1), (CipherParameters)withIv);
        }
        if (blockSize == 16) {
            this.testMode(CCMBlockCipher.newInstance((BlockCipher)cipher1), (CipherParameters)new ParametersWithIV((CipherParameters)key, new byte[7]));
            this.testMode(new OCBBlockCipher(cipher1, cipher2), (CipherParameters)new ParametersWithIV((CipherParameters)key, new byte[15]));
        }
    }

    private void testSkipping(StreamCipher cipher, CipherParameters params) throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.init(cipher, true, params);
        OutputStream cOut = this.createCipherOutputStream(bOut, cipher);
        byte[] data = new byte[5000];
        new SecureRandom().nextBytes(data);
        cOut.write(data);
        cOut.close();
        this.init(cipher, false, params);
        InputStream cIn = this.createCipherInputStream(bOut.toByteArray(), cipher);
        long skip = cIn.skip(50L);
        if (skip != 50L) {
            this.fail("wrong number of bytes skipped: " + skip);
        }
        byte[] block = new byte[50];
        cIn.read(block);
        if (!this.areEqual(data, 50, block, 0)) {
            this.fail("initial skip mismatch");
        }
        if ((skip = cIn.skip(3000L)) != 3000L) {
            this.fail("wrong number of bytes skipped: " + skip);
        }
        cIn.read(block);
        if (!this.areEqual(data, 3100, block, 0)) {
            this.fail("second skip mismatch");
        }
        cipher.reset();
        cIn = this.createCipherInputStream(bOut.toByteArray(), cipher);
        if (!cIn.markSupported()) {
            this.fail("marking not supported");
        }
        cIn.mark(100);
        cIn.read(block);
        if (!this.areEqual(data, 0, block, 0)) {
            this.fail("initial mark read failed");
        }
        cIn.reset();
        cIn.read(block);
        if (!this.areEqual(data, 0, block, 0)) {
            this.fail(cipher.getAlgorithmName() + " initial reset read failed");
        }
        cIn.reset();
        cIn.read(block);
        cIn.mark(100);
        cIn.read(block);
        if (!this.areEqual(data, 50, block, 0)) {
            this.fail("second mark read failed");
        }
        cIn.reset();
        cIn.read(block);
        if (!this.areEqual(data, 50, block, 0)) {
            this.fail(cipher.getAlgorithmName() + " second reset read failed");
        }
        cIn.mark(3000);
        skip = cIn.skip(2050L);
        if (skip != 2050L) {
            this.fail("wrong number of bytes skipped: " + skip);
        }
        cIn.reset();
        cIn.read(block);
        if (!this.areEqual(data, 100, block, 0)) {
            this.fail(cipher.getAlgorithmName() + " third reset read failed");
        }
        cIn.read(new byte[2150]);
        cIn.reset();
        cIn.read(block);
        if (!this.areEqual(data, 100, block, 0)) {
            this.fail(cipher.getAlgorithmName() + " fourth reset read failed");
        }
        cIn.close();
    }

    private boolean areEqual(byte[] a, int aOff, byte[] b, int bOff) {
        int i = bOff;
        while (i != b.length) {
            if (a[aOff + i - bOff] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new CipherStreamTest());
    }
}

