/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.macs.SipHash;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.modes.ChaCha20Poly1305;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.AEADTestUtil;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.Times;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ChaCha20Poly1305Test
extends SimpleTest {
    private static final String[][] TEST_VECTORS = new String[][]{{"Test Case 1", "808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9f", "4c616469657320616e642047656e746c656d656e206f662074686520636c617373206f66202739393a204966204920636f756c64206f6666657220796f75206f6e6c79206f6e652074697020666f7220746865206675747572652c2073756e73637265656e20776f756c642062652069742e", "50515253c0c1c2c3c4c5c6c7", "070000004041424344454647", "d31a8d34648e60db7b86afbc53ef7ec2a4aded51296e08fea9e2b5a736ee62d63dbea45e8ca9671282fafb69da92728b1a71de0a9e060b2905d6a5b67ecd3b3692ddbd7f2d778b8c9803aee328091b58fab324e4fad675945585808b4831d7bc3ff4def08e4b7a9de576d26586cec64b6116", "1ae10b594f09e26a7e902ecbd0600691"}};

    public String getName() {
        return "ChaCha20Poly1305";
    }

    public void performTest() throws Exception {
        int i = 0;
        while (i < TEST_VECTORS.length) {
            this.runTestCase(TEST_VECTORS[i]);
            ++i;
        }
        this.outputSizeTests();
        this.randomTests();
        this.testExceptions();
    }

    private void checkTestCase(ChaCha20Poly1305 encCipher, ChaCha20Poly1305 decCipher, String testName, byte[] SA, byte[] P, byte[] C, byte[] T) throws InvalidCipherTextException {
        byte[] enc = new byte[encCipher.getOutputSize(P.length)];
        if (SA != null) {
            encCipher.processAADBytes(SA, 0, SA.length);
        }
        int len = encCipher.processBytes(P, 0, P.length, enc, 0);
        if (enc.length != (len += encCipher.doFinal(enc, len))) {
            this.fail("encryption reported incorrect length: " + testName);
        }
        byte[] mac = encCipher.getMac();
        byte[] data = new byte[P.length];
        System.arraycopy(enc, 0, data, 0, data.length);
        byte[] tail = new byte[enc.length - P.length];
        System.arraycopy(enc, P.length, tail, 0, tail.length);
        if (!this.areEqual(C, data)) {
            this.fail("incorrect encrypt in: " + testName);
        }
        if (!this.areEqual(T, mac)) {
            this.fail("getMac() returned wrong mac in: " + testName);
        }
        if (!this.areEqual(T, tail)) {
            this.fail("stream contained wrong mac in: " + testName);
        }
        byte[] dec = new byte[decCipher.getOutputSize(enc.length)];
        if (SA != null) {
            decCipher.processAADBytes(SA, 0, SA.length);
        }
        len = decCipher.processBytes(enc, 0, enc.length, dec, 0);
        len += decCipher.doFinal(dec, len);
        mac = decCipher.getMac();
        data = new byte[C.length];
        System.arraycopy(dec, 0, data, 0, data.length);
        if (!this.areEqual(P, data)) {
            this.fail("incorrect decrypt in: " + testName);
        }
    }

    private ChaCha20Poly1305 initCipher(boolean forEncryption, AEADParameters parameters) {
        ChaCha20Poly1305 c = new ChaCha20Poly1305();
        c.init(forEncryption, (CipherParameters)parameters);
        return c;
    }

    private static int nextInt(SecureRandom rand, int n) {
        int value;
        int bits;
        if ((n & -n) == n) {
            return (int)((long)n * (long)(rand.nextInt() >>> 1) >> 31);
        }
        while ((bits = rand.nextInt() >>> 1) - (value = bits % n) + (n - 1) < 0) {
        }
        return value;
    }

    private void outputSizeTests() {
        byte[] K = new byte[32];
        byte[] N = new byte[12];
        byte[] A = null;
        AEADParameters parameters = new AEADParameters(new KeyParameter(K), 128, N, A);
        ChaCha20Poly1305 cipher = this.initCipher(true, parameters);
        if (cipher.getUpdateOutputSize(0) != 0) {
            this.fail("incorrect getUpdateOutputSize for initial 0 bytes encryption");
        }
        if (cipher.getOutputSize(0) != 16) {
            this.fail("incorrect getOutputSize for initial 0 bytes encryption");
        }
        cipher.init(false, (CipherParameters)parameters);
        if (cipher.getUpdateOutputSize(0) != 0) {
            this.fail("incorrect getUpdateOutputSize for initial 0 bytes decryption");
        }
        if (cipher.getOutputSize(0) != 0) {
            this.fail("fragile getOutputSize for initial 0 bytes decryption");
        }
        if (cipher.getOutputSize(16) != 0) {
            this.fail("incorrect getOutputSize for initial MAC-size bytes decryption");
        }
    }

    private void randomTests() throws InvalidCipherTextException {
        SecureRandom random = new SecureRandom();
        random.setSeed(Times.nanoTime());
        int i = 0;
        while (i < 100) {
            this.randomTest(random);
            ++i;
        }
    }

    private void randomTest(SecureRandom random) throws InvalidCipherTextException {
        byte[] decT;
        int kLength = 32;
        byte[] K = new byte[kLength];
        random.nextBytes(K);
        int pHead = random.nextInt() >>> 24;
        int pLength = random.nextInt() >>> 16;
        int pTail = random.nextInt() >>> 24;
        byte[] P = new byte[pHead + pLength + pTail];
        random.nextBytes(P);
        int aLength = random.nextInt() >>> 24;
        byte[] A = new byte[aLength];
        random.nextBytes(A);
        int saLength = random.nextInt() >>> 24;
        byte[] SA = new byte[saLength];
        random.nextBytes(SA);
        int nonceLength = 12;
        byte[] nonce = new byte[nonceLength];
        random.nextBytes(nonce);
        AEADParameters parameters = new AEADParameters(new KeyParameter(K), 128, nonce, A);
        ChaCha20Poly1305 cipher = this.initCipher(true, parameters);
        int ctLength = cipher.getOutputSize(pLength);
        byte[] C = new byte[saLength + ctLength];
        System.arraycopy(SA, 0, C, 0, saLength);
        int split = ChaCha20Poly1305Test.nextInt(random, saLength + 1);
        cipher.processAADBytes(C, 0, split);
        cipher.processAADBytes(C, split, saLength - split);
        int predicted = cipher.getUpdateOutputSize(pLength);
        int len = cipher.processBytes(P, pHead, pLength, C, saLength);
        if (predicted != len) {
            this.fail("encryption reported incorrect update length in randomised test");
        }
        if (ctLength != (len += cipher.doFinal(C, saLength + len))) {
            this.fail("encryption reported incorrect length in randomised test");
        }
        byte[] encT = cipher.getMac();
        byte[] tail = new byte[ctLength - pLength];
        System.arraycopy(C, saLength + pLength, tail, 0, tail.length);
        if (!this.areEqual(encT, tail)) {
            this.fail("stream contained wrong mac in randomised test");
        }
        cipher.init(false, (CipherParameters)parameters);
        int decPHead = random.nextInt() >>> 24;
        int decPLength = cipher.getOutputSize(ctLength);
        int decPTail = random.nextInt() >>> 24;
        byte[] decP = new byte[decPHead + decPLength + decPTail];
        split = ChaCha20Poly1305Test.nextInt(random, saLength + 1);
        cipher.processAADBytes(C, 0, split);
        cipher.processAADBytes(C, split, saLength - split);
        predicted = cipher.getUpdateOutputSize(ctLength);
        len = cipher.processBytes(C, saLength, ctLength, decP, decPHead);
        if (predicted != len) {
            this.fail("decryption reported incorrect update length in randomised test");
        }
        len += cipher.doFinal(decP, decPHead + len);
        if (!this.areEqual(P, pHead, pHead + pLength, decP, decPHead, decPHead + decPLength)) {
            this.fail("incorrect decrypt in randomised test");
        }
        if (!this.areEqual(encT, decT = cipher.getMac())) {
            this.fail("decryption produced different mac from encryption");
        }
        cipher.init(false, (CipherParameters)AEADTestUtil.reuseKey(parameters));
        decPHead = random.nextInt() >>> 24;
        decPLength = cipher.getOutputSize(ctLength);
        decPTail = random.nextInt() >>> 24;
        decP = new byte[decPHead + decPLength + decPTail];
        split = ChaCha20Poly1305Test.nextInt(random, saLength + 1);
        cipher.processAADBytes(C, 0, split);
        cipher.processAADBytes(C, split, saLength - split);
        len = cipher.processBytes(C, saLength, ctLength, decP, decPHead);
        len += cipher.doFinal(decP, decPHead + len);
        if (!this.areEqual(P, pHead, pHead + pLength, decP, decPHead, decPHead + decPLength)) {
            this.fail("incorrect decrypt in randomised test");
        }
        if (!this.areEqual(encT, decT = cipher.getMac())) {
            this.fail("decryption produced different mac from encryption");
        }
    }

    private void runTestCase(String[] testVector) throws InvalidCipherTextException {
        int pos = 0;
        String testName = testVector[pos++];
        byte[] K = Hex.decode((String)testVector[pos++]);
        byte[] P = Hex.decode((String)testVector[pos++]);
        byte[] A = Hex.decode((String)testVector[pos++]);
        byte[] N = Hex.decode((String)testVector[pos++]);
        byte[] C = Hex.decode((String)testVector[pos++]);
        byte[] T = Hex.decode((String)testVector[pos++]);
        this.runTestCase(testName, K, N, A, P, C, T);
    }

    private void runTestCase(String testName, byte[] K, byte[] N, byte[] A, byte[] P, byte[] C, byte[] T) throws InvalidCipherTextException {
        byte[] fa = new byte[A.length / 2];
        byte[] la = new byte[A.length - A.length / 2];
        System.arraycopy(A, 0, fa, 0, fa.length);
        System.arraycopy(A, fa.length, la, 0, la.length);
        this.runTestCase(testName + " all initial associated data", K, N, A, null, P, C, T);
        this.runTestCase(testName + " all subsequent associated data", K, N, null, A, P, C, T);
        this.runTestCase(testName + " split associated data", K, N, fa, la, P, C, T);
    }

    private void runTestCase(String testName, byte[] K, byte[] N, byte[] A, byte[] SA, byte[] P, byte[] C, byte[] T) throws InvalidCipherTextException {
        AEADParameters parameters = new AEADParameters(new KeyParameter(K), T.length * 8, N, A);
        ChaCha20Poly1305 encCipher = this.initCipher(true, parameters);
        ChaCha20Poly1305 decCipher = this.initCipher(false, parameters);
        this.checkTestCase(encCipher, decCipher, testName, SA, P, C, T);
        encCipher = this.initCipher(true, parameters);
        this.checkTestCase(encCipher, decCipher, testName + " (reused)", SA, P, C, T);
        AEADParameters keyReuseParams = AEADTestUtil.reuseKey(parameters);
        try {
            encCipher.init(true, (CipherParameters)keyReuseParams);
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isTrue("wrong message", "cannot reuse nonce for ChaCha20Poly1305 encryption".equals(e.getMessage()));
        }
    }

    private void testExceptions() throws InvalidCipherTextException {
        ChaCha20Poly1305 c = new ChaCha20Poly1305();
        try {
            c = new ChaCha20Poly1305((Mac)new SipHash());
            this.fail("incorrect mac size not picked up");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            c.init(false, (CipherParameters)new KeyParameter(new byte[32]));
            this.fail("illegal argument not picked up");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        AEADTestUtil.testTampering(this, (AEADCipher)c, (CipherParameters)new AEADParameters(new KeyParameter(new byte[32]), 128, new byte[12]));
        byte[] P = Strings.toByteArray((String)"Hello world!");
        byte[] buf = new byte[100];
        c = new ChaCha20Poly1305();
        AEADParameters aeadParameters = new AEADParameters(new KeyParameter(new byte[32]), 128, new byte[12]);
        c.init(true, (CipherParameters)aeadParameters);
        c.processBytes(P, 0, P.length, buf, 0);
        c.doFinal(buf, 0);
        try {
            c.doFinal(buf, 0);
            this.fail("no exception on reuse");
        }
        catch (IllegalStateException e) {
            this.isTrue("wrong message", e.getMessage().equals("ChaCha20Poly1305 cannot be reused for encryption"));
        }
        try {
            c.init(true, (CipherParameters)aeadParameters);
            this.fail("no exception on reuse");
        }
        catch (IllegalArgumentException e) {
            this.isTrue("wrong message", e.getMessage().equals("cannot reuse nonce for ChaCha20Poly1305 encryption"));
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new ChaCha20Poly1305Test());
    }
}

