/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.CSHAKEDigest;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class CSHAKETest
extends SimpleTest {
    public String getName() {
        return "CSHAKE";
    }

    public void performTest() throws Exception {
        CSHAKEDigest cshake = new CSHAKEDigest(128, new byte[0], Strings.toByteArray((String)"Email Signature"));
        cshake.update(Hex.decode((String)"00010203"), 0, 4);
        byte[] res = new byte[32];
        cshake.doOutput(res, 0, res.length);
        this.isTrue("oops!", Arrays.areEqual((byte[])Hex.decode((String)"c1c36925b6409a04f1b504fcbca9d82b4017277cb5ed2b2065fc1d3814d5aaf5"), (byte[])res));
        cshake = new CSHAKEDigest(128, new byte[0], Strings.toByteArray((String)"Email Signature"));
        cshake.update(Hex.decode((String)"000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7"), 0, 200);
        res = new byte[32];
        cshake.doOutput(res, 0, res.length);
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"C5221D50E4F822D96A2E8881A961420F294B7B24FE3D2094BAED2C6524CC166B "), (byte[])res));
        cshake = new CSHAKEDigest(256, new byte[0], Strings.toByteArray((String)"Email Signature"));
        cshake.update(Hex.decode((String)"00010203"), 0, 4);
        res = new byte[64];
        cshake.doOutput(res, 0, res.length);
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"D008828E2B80AC9D2218FFEE1D070C48B8E4C87BFF32C9699D5B6896EEE0EDD164020E2BE0560858D9C00C037E34A96937C561A74C412BB4C746469527281C8C"), (byte[])res));
        cshake = new CSHAKEDigest(256, new byte[0], Strings.toByteArray((String)"Email Signature"));
        cshake.update(Hex.decode((String)"000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7"), 0, 200);
        res = new byte[64];
        cshake.doOutput(res, 0, res.length);
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"07DC27B11E51FBAC75BC7B3C1D983E8B4B85FB1DEFAF218912AC86430273091727F42B17ED1DF63E8EC118F04B23633C1DFB1574C8FB55CB45DA8E25AFB092BB"), (byte[])res));
        this.doFinalTest();
        this.longBlockTest();
        this.checkZeroPadZ();
        this.checkSHAKE(128, new CSHAKEDigest(128, new byte[0], new byte[0]), Hex.decode((String)"eeaabeef"));
        this.checkSHAKE(256, new CSHAKEDigest(256, new byte[0], null), Hex.decode((String)"eeaabeef"));
        this.checkSHAKE(128, new CSHAKEDigest(128, null, new byte[0]), Hex.decode((String)"eeaabeef"));
        this.checkSHAKE(128, new CSHAKEDigest(128, null, null), Hex.decode((String)"eeaabeef"));
        this.checkSHAKE(256, new CSHAKEDigest(256, null, null), Hex.decode((String)"eeaabeef"));
    }

    private void checkZeroPadZ() {
        byte[] buf = new byte[20];
        CSHAKEDigest cshake1 = new CSHAKEDigest(256, new byte[0], new byte[265]);
        cshake1.doOutput(buf, 0, buf.length);
        this.isTrue(this.areEqual(Hex.decode((String)"6e393540387004f087c4180db008acf6825190cf"), buf));
        CSHAKEDigest cshake2 = new CSHAKEDigest(128, new byte[0], new byte[329]);
        cshake2.doOutput(buf, 0, buf.length);
        this.isTrue(this.areEqual(Hex.decode((String)"309bd7c285fcf8b839c9686b2cc00bd578947bee"), buf));
        cshake2 = new CSHAKEDigest(128, new byte[29], new byte[300]);
        cshake2.doOutput(buf, 0, buf.length);
        this.isTrue(this.areEqual(Hex.decode((String)"ff6aafd83b8d22fc3e2e9b9948b581967ed9c5e7"), buf));
    }

    private void doFinalTest() {
        CSHAKEDigest cshake = new CSHAKEDigest(128, new byte[0], Strings.toByteArray((String)"Email Signature"));
        cshake.update(Hex.decode((String)"00010203"), 0, 4);
        byte[] res = new byte[32];
        cshake.doOutput(res, 0, res.length);
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"c1c36925b6409a04f1b504fcbca9d82b4017277cb5ed2b2065fc1d3814d5aaf5"), (byte[])res));
        cshake.doOutput(res, 0, res.length);
        this.isTrue(!Arrays.areEqual((byte[])Hex.decode((String)"c1c36925b6409a04f1b504fcbca9d82b4017277cb5ed2b2065fc1d3814d5aaf5"), (byte[])res));
        cshake.doFinal(res, 0, res.length);
        cshake.update(Hex.decode((String)"00010203"), 0, 4);
        cshake.doFinal(res, 0, res.length);
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"c1c36925b6409a04f1b504fcbca9d82b4017277cb5ed2b2065fc1d3814d5aaf5"), (byte[])res));
        cshake.update(Hex.decode((String)"00010203"), 0, 4);
        cshake.doOutput(res, 0, res.length);
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"c1c36925b6409a04f1b504fcbca9d82b4017277cb5ed2b2065fc1d3814d5aaf5"), (byte[])res));
        cshake.doFinal(res, 0, res.length);
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"9cbce830079c452abdeb875366a49ebfe75b89ef17396e34898e904830b0e136"), (byte[])res));
    }

    private void longBlockTest() {
        CSHAKEDigest cshake;
        byte[] data = new byte[16000];
        byte[] res = new byte[32];
        int i = 0;
        while (i != data.length) {
            data[i] = (byte)i;
            ++i;
        }
        byte[] hex0123 = Hex.decodeStrict((String)"00010203");
        int i2 = 10000;
        while (i2 != data.length) {
            cshake = new CSHAKEDigest(128, new byte[0], Arrays.copyOfRange((byte[])data, (int)0, (int)i2));
            cshake.update(hex0123, 0, 4);
            cshake.doFinal(res, 0, 16);
            ++i2;
        }
        cshake = new CSHAKEDigest(256, new byte[0], new byte[200]);
        cshake.update(data, 0, 200);
        cshake.doFinal(res, 0, 32);
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"4a899b5be460d85a9789215bc17f88b8f8ac049bd3b519f561e7b5d3870dafa3"), (byte[])res));
    }

    private void checkSHAKE(int bitSize, CSHAKEDigest cshake, byte[] msg) {
        SHAKEDigest ref = new SHAKEDigest(bitSize);
        ref.update(msg, 0, msg.length);
        cshake.update(msg, 0, msg.length);
        byte[] res1 = new byte[32];
        byte[] res2 = new byte[32];
        ref.doFinal(res1, 0, res1.length);
        cshake.doFinal(res2, 0, res2.length);
        this.isTrue(Arrays.areEqual((byte[])res1, (byte[])res2));
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new CSHAKETest());
    }
}

