/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.engines.AESLightEngine;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.engines.CAST5Engine;
import org.bouncycastle.crypto.engines.CAST6Engine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.NoekeonEngine;
import org.bouncycastle.crypto.engines.RC6Engine;
import org.bouncycastle.crypto.engines.SEEDEngine;
import org.bouncycastle.crypto.engines.SerpentEngine;
import org.bouncycastle.crypto.engines.TEAEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.engines.XTEAEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.GOFBBlockCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import org.bouncycastle.crypto.modes.PGPCFBBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class BlockCipherResetTest
extends SimpleTest {
    public String getName() {
        return "Block Cipher Reset";
    }

    public void performTest() throws Exception {
        this.testReset("AESFastEngine", (BlockCipher)new AESFastEngine(), (BlockCipher)new AESFastEngine(), (CipherParameters)new KeyParameter(new byte[16]));
        this.testReset("AESEngine", (BlockCipher)new AESEngine(), (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(new byte[16]));
        this.testReset("AESLightEngine", (BlockCipher)new AESLightEngine(), (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(new byte[16]));
        this.testReset("Twofish", (BlockCipher)new TwofishEngine(), (BlockCipher)new TwofishEngine(), (CipherParameters)new KeyParameter(new byte[16]));
        this.testReset("NoekeonEngine", (BlockCipher)new NoekeonEngine(), (BlockCipher)new NoekeonEngine(), (CipherParameters)new KeyParameter(new byte[16]));
        this.testReset("SerpentEngine", (BlockCipher)new SerpentEngine(), (BlockCipher)new SerpentEngine(), (CipherParameters)new KeyParameter(new byte[16]));
        this.testReset("SEEDEngine", (BlockCipher)new SEEDEngine(), (BlockCipher)new SEEDEngine(), (CipherParameters)new KeyParameter(new byte[16]));
        this.testReset("CAST6Engine", (BlockCipher)new CAST6Engine(), (BlockCipher)new CAST6Engine(), (CipherParameters)new KeyParameter(new byte[16]));
        this.testReset("RC6Engine", (BlockCipher)new RC6Engine(), (BlockCipher)new RC6Engine(), (CipherParameters)new KeyParameter(new byte[16]));
        this.testReset("DESEngine", (BlockCipher)new DESEngine(), (BlockCipher)new DESEngine(), (CipherParameters)new KeyParameter(new byte[8]));
        this.testReset("BlowfishEngine", (BlockCipher)new BlowfishEngine(), (BlockCipher)new BlowfishEngine(), (CipherParameters)new KeyParameter(new byte[8]));
        this.testReset("CAST5Engine", (BlockCipher)new CAST5Engine(), (BlockCipher)new CAST5Engine(), (CipherParameters)new KeyParameter(new byte[8]));
        this.testReset("DESedeEngine", (BlockCipher)new DESedeEngine(), (BlockCipher)new DESedeEngine(), (CipherParameters)new KeyParameter(new byte[24]));
        this.testReset("TEAEngine", (BlockCipher)new TEAEngine(), (BlockCipher)new TEAEngine(), (CipherParameters)new KeyParameter(new byte[16]));
        this.testReset("XTEAEngine", (BlockCipher)new XTEAEngine(), (BlockCipher)new XTEAEngine(), (CipherParameters)new KeyParameter(new byte[16]));
        this.testModeReset("AES/CBC", (BlockCipher)CBCBlockCipher.newInstance((BlockCipher)AESEngine.newInstance()), (BlockCipher)CBCBlockCipher.newInstance((BlockCipher)AESEngine.newInstance()), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[16]), new byte[16]));
        this.testModeReset("AES/SIC", (BlockCipher)SICBlockCipher.newInstance((BlockCipher)AESEngine.newInstance()), (BlockCipher)SICBlockCipher.newInstance((BlockCipher)AESEngine.newInstance()), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[16]), new byte[16]));
        this.testModeReset("AES/CFB", (BlockCipher)CFBBlockCipher.newInstance((BlockCipher)AESEngine.newInstance(), (int)128), (BlockCipher)CFBBlockCipher.newInstance((BlockCipher)AESEngine.newInstance(), (int)128), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[16]), new byte[16]));
        this.testModeReset("AES/OFB", (BlockCipher)new OFBBlockCipher((BlockCipher)AESEngine.newInstance(), 128), (BlockCipher)new OFBBlockCipher((BlockCipher)AESEngine.newInstance(), 128), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[16]), new byte[16]));
        this.testModeReset("AES/GCTR", (BlockCipher)new GOFBBlockCipher((BlockCipher)new DESEngine()), (BlockCipher)new GOFBBlockCipher((BlockCipher)new DESEngine()), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[8]), new byte[8]));
        this.testModeReset("AES/OpenPGPCFB", (BlockCipher)new OpenPGPCFBBlockCipher((BlockCipher)AESEngine.newInstance()), (BlockCipher)new OpenPGPCFBBlockCipher((BlockCipher)AESEngine.newInstance()), (CipherParameters)new KeyParameter(new byte[16]));
        this.testModeReset("AES/PGPCFB", (BlockCipher)new PGPCFBBlockCipher((BlockCipher)new AESEngine(), false), (BlockCipher)new PGPCFBBlockCipher((BlockCipher)new AESEngine(), false), (CipherParameters)new KeyParameter(new byte[16]));
    }

    private void testModeReset(String test, BlockCipher cipher1, BlockCipher cipher2, CipherParameters params) throws InvalidCipherTextException {
        this.testReset(test, false, cipher1, cipher2, params);
    }

    private void testReset(String test, BlockCipher cipher1, BlockCipher cipher2, CipherParameters params) throws InvalidCipherTextException {
        this.testReset(test, true, cipher1, cipher2, params);
    }

    private void testReset(String test, boolean testCryptReset, BlockCipher cipher1, BlockCipher cipher2, CipherParameters params) throws InvalidCipherTextException {
        cipher1.init(true, params);
        byte[] plaintext = new byte[cipher1.getBlockSize()];
        byte[] ciphertext = new byte[cipher1.getAlgorithmName().indexOf("PGPCFBwithIV") > -1 ? 2 * cipher1.getBlockSize() + 2 : cipher1.getBlockSize()];
        BlockCipherResetTest.crypt(cipher1, true, plaintext, ciphertext);
        this.checkReset(test, testCryptReset, cipher1, params, true, plaintext, ciphertext);
        cipher2.init(false, params);
        this.checkReset(test, testCryptReset, cipher2, params, false, ciphertext, plaintext);
    }

    private void checkReset(String test, boolean testCryptReset, BlockCipher cipher, CipherParameters params, boolean encrypt, byte[] pretext, byte[] posttext) throws InvalidCipherTextException {
        byte[] output = new byte[posttext.length];
        BlockCipherResetTest.crypt(cipher, encrypt, pretext, output);
        if (testCryptReset) {
            BlockCipherResetTest.crypt(cipher, encrypt, pretext, output);
            if (!Arrays.areEqual((byte[])output, (byte[])posttext)) {
                this.fail(test + (encrypt ? " encrypt" : " decrypt") + " did not reset cipher.");
            }
        }
        cipher.processBlock(pretext, 0, output, 0);
        cipher.init(encrypt, params);
        try {
            BlockCipherResetTest.crypt(cipher, encrypt, pretext, output);
        }
        catch (DataLengthException e) {
            this.fail(test + " init did not reset data.");
        }
        if (!Arrays.areEqual((byte[])output, (byte[])posttext)) {
            this.fail(test + " init did not reset data.", new String(Hex.encode((byte[])posttext)), new String(Hex.encode((byte[])output)));
        }
        cipher.processBlock(pretext, 0, output, 0);
        cipher.reset();
        try {
            BlockCipherResetTest.crypt(cipher, encrypt, pretext, output);
        }
        catch (DataLengthException e) {
            this.fail(test + " reset did not reset data.");
        }
        if (!Arrays.areEqual((byte[])output, (byte[])posttext)) {
            this.fail(test + " reset did not reset data.");
        }
    }

    private static void crypt(BlockCipher cipher1, boolean encrypt, byte[] plaintext, byte[] output) throws InvalidCipherTextException {
        cipher1.processBlock(plaintext, 0, output, 0);
        if (cipher1.getAlgorithmName().indexOf("PGPCFBwithIV") > -1 && !encrypt) {
            cipher1.processBlock(plaintext, cipher1.getBlockSize(), output, 0);
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new BlockCipherResetTest());
    }
}

