/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class BlockCipherMonteCarloTest
extends SimpleTest {
    int id;
    int iterations;
    BlockCipher engine;
    CipherParameters param;
    byte[] input;
    byte[] output;

    public BlockCipherMonteCarloTest(int id, int iterations, BlockCipher engine, CipherParameters param, String input, String output) {
        this.id = id;
        this.iterations = iterations;
        this.engine = engine;
        this.param = param;
        this.input = Hex.decode((String)input);
        this.output = Hex.decode((String)output);
    }

    public String getName() {
        return this.engine.getAlgorithmName() + " Monte Carlo Test " + this.id;
    }

    public void performTest() throws Exception {
        BufferedBlockCipher cipher = new BufferedBlockCipher(this.engine);
        cipher.init(true, this.param);
        byte[] out = new byte[this.input.length];
        System.arraycopy(this.input, 0, out, 0, out.length);
        int i = 0;
        while (i != this.iterations) {
            int len1 = cipher.processBytes(out, 0, out.length, out, 0);
            cipher.doFinal(out, len1);
            ++i;
        }
        if (!this.areEqual(out, this.output)) {
            this.fail("failed - expected " + new String(Hex.encode((byte[])this.output)) + " got " + new String(Hex.encode((byte[])out)));
        }
        cipher.init(false, this.param);
        int i2 = 0;
        while (i2 != this.iterations) {
            int len1 = cipher.processBytes(out, 0, out.length, out, 0);
            cipher.doFinal(out, len1);
            ++i2;
        }
        if (!this.areEqual(this.input, out)) {
            this.fail("failed reversal");
        }
    }
}

