/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.crypto.digests.Blake2bpDigest;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class Blake2bpDigestTest
extends TestCase {
    public void testKATfile() throws Exception {
        InputStream src = TestResourceFinder.findTestResource("crypto", "Blake2KAT.txt");
        BufferedReader bin = new BufferedReader(new InputStreamReader(src));
        String line = null;
        String name = null;
        String input = null;
        String key = null;
        String output = null;
        byte[] hash = new byte[64];
        while ((line = bin.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") && name.equals("blake2bp")) {
                Blake2bpDigest digest = new Blake2bpDigest(Hex.decode(key));
                byte[] message = Hex.decode((String)input);
                digest.update(message, 0, message.length);
                digest.doFinal(hash, 0);
                Assert.assertTrue((String)("BLAKE2bp mismatch on test vector: " + output + ", " + Hex.toHexString((byte[])hash)), (boolean)Arrays.areEqual((byte[])Hex.decode((String)output), (byte[])hash));
            }
            name = line;
            input = bin.readLine();
            key = bin.readLine();
            output = bin.readLine();
        }
    }

    public void testOffset() {
        byte[] key = Hex.decode((String)"000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f");
        String res = "30302c3fc999065d10dc982c8feef41bbb6642718f624af6e3eabea083e7fe785340db4b0897efff39cee1dc1eb737cd1eea0fe75384984e7d8f446faa683b80";
        String in = "000102";
        byte[] output = new byte[64];
        Blake2bpDigest digest = new Blake2bpDigest(key);
        digest.update(Hex.decode((String)("9999" + in)), 2, 3);
        digest.doFinal(output, 0);
        Assert.assertTrue((String)"BLAKE2bp mismatch on update offset", (boolean)Arrays.areEqual((byte[])Hex.decode((String)res), (byte[])output));
        Arrays.fill((byte[])output, (byte)0);
        output = Arrays.concatenate((byte[])Hex.decode((String)"9999"), (byte[])output);
        digest.update(Hex.decode((String)in), 0, 3);
        digest.doFinal(output, 2);
        Assert.assertTrue((String)"BLAKE2bp mismatch on doFinal offset", (boolean)Arrays.areEqual((byte[])Hex.decode((String)("9999" + res)), (byte[])output));
    }

    public void testReset() {
        byte[] key = new byte[64];
        byte[] buf = new byte[256];
        byte[][] stepOne = new byte[256][64];
        int i = 0;
        while (i < 64) {
            key[i] = (byte)i;
            ++i;
        }
        int i2 = 0;
        while (i2 < 256) {
            buf[i2] = (byte)i2;
            ++i2;
        }
        Blake2bpDigest digest = new Blake2bpDigest(key);
        int step = 1;
        while (step < 128) {
            int i3 = 0;
            while (i3 < 256) {
                digest.reset();
                int mlen = i3;
                int pOffset = 0;
                byte[] hash = new byte[64];
                while (mlen >= step) {
                    digest.update(buf, pOffset, step);
                    mlen -= step;
                    pOffset += step;
                }
                digest.update(buf, pOffset, mlen);
                digest.doFinal(hash, 0);
                if (step == 1) {
                    System.arraycopy(hash, 0, stepOne[i3], 0, hash.length);
                } else {
                    Assert.assertTrue((String)"BLAKE2b mismatch on test vector: ", (boolean)Arrays.areEqual((byte[])stepOne[i3], (byte[])hash));
                }
                ++i3;
            }
            ++step;
        }
    }
}

