/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestRandomData;

public class BigIntegersTest
extends SimpleTest {
    public String getName() {
        return "BigIntegers";
    }

    public void performTest() throws Exception {
        BigInteger min = BigInteger.valueOf(5L);
        this.isTrue(min.equals(BigIntegers.createRandomPrime((int)min.bitLength(), (int)1, (SecureRandom)new TestRandomData(BigIntegers.asUnsignedByteArray((BigInteger)min)))));
        BigInteger max = BigInteger.valueOf(743L);
        this.isTrue(max.equals(BigIntegers.createRandomPrime((int)max.bitLength(), (int)1, (SecureRandom)new TestRandomData(BigIntegers.asUnsignedByteArray((BigInteger)max)))));
        this.isTrue(1 == BigIntegers.asUnsignedByteArray((BigInteger)BigIntegers.ZERO).length);
        this.isTrue(1 == BigIntegers.getUnsignedByteLength((BigInteger)BigIntegers.ZERO));
        this.isTrue(1 == BigIntegers.getUnsignedByteLength((BigInteger)BigIntegers.ONE));
    }

    public static void main(String[] args) throws Exception {
        SimpleTest.runTest(new BigIntegersTest());
    }
}

