/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServiceConstraintsException;
import org.bouncycastle.crypto.CryptoServicesConstraints;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.RawAgreement;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.agreement.DHAgreement;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.agreement.DHStandardGroups;
import org.bouncycastle.crypto.agreement.DHUnifiedAgreement;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHCStagedAgreement;
import org.bouncycastle.crypto.agreement.ECDHCUnifiedAgreement;
import org.bouncycastle.crypto.agreement.ECMQVBasicAgreement;
import org.bouncycastle.crypto.agreement.ECVKOAgreement;
import org.bouncycastle.crypto.agreement.MQVBasicAgreement;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.agreement.X448Agreement;
import org.bouncycastle.crypto.agreement.XDHBasicAgreement;
import org.bouncycastle.crypto.agreement.XDHUnifiedAgreement;
import org.bouncycastle.crypto.constraints.BitsOfSecurityConstraint;
import org.bouncycastle.crypto.constraints.LegacyBitsOfSecurityConstraint;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.CramerShoupCoreEngine;
import org.bouncycastle.crypto.engines.ElGamalEngine;
import org.bouncycastle.crypto.engines.NaccacheSternEngine;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.generators.CramerShoupKeyPairGenerator;
import org.bouncycastle.crypto.generators.CramerShoupParametersGenerator;
import org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import org.bouncycastle.crypto.generators.DHKeyPairGenerator;
import org.bouncycastle.crypto.generators.DSAKeyPairGenerator;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import org.bouncycastle.crypto.generators.Ed448KeyPairGenerator;
import org.bouncycastle.crypto.generators.ElGamalKeyPairGenerator;
import org.bouncycastle.crypto.generators.GOST3410KeyPairGenerator;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.generators.NaccacheSternKeyPairGenerator;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import org.bouncycastle.crypto.generators.X448KeyPairGenerator;
import org.bouncycastle.crypto.kems.RSAKEMExtractor;
import org.bouncycastle.crypto.kems.RSAKEMGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.CramerShoupKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHMQVPrivateParameters;
import org.bouncycastle.crypto.params.DHMQVPublicParameters;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.params.DHUPrivateParameters;
import org.bouncycastle.crypto.params.DHUPublicParameters;
import org.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECDHUPrivateParameters;
import org.bouncycastle.crypto.params.ECDHUPublicParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.Ed25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.Ed448KeyGenerationParameters;
import org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import org.bouncycastle.crypto.params.ElGamalParameters;
import org.bouncycastle.crypto.params.GOST3410KeyGenerationParameters;
import org.bouncycastle.crypto.params.GOST3410Parameters;
import org.bouncycastle.crypto.params.MQVPrivateParameters;
import org.bouncycastle.crypto.params.MQVPublicParameters;
import org.bouncycastle.crypto.params.NaccacheSternKeyGenerationParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.ParametersWithUKM;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.X448KeyGenerationParameters;
import org.bouncycastle.crypto.params.XDHUPrivateParameters;
import org.bouncycastle.crypto.params.XDHUPublicParameters;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.DSTU4145Signer;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.ECGOST3410Signer;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.Ed25519ctxSigner;
import org.bouncycastle.crypto.signers.Ed25519phSigner;
import org.bouncycastle.crypto.signers.Ed448Signer;
import org.bouncycastle.crypto.signers.Ed448phSigner;
import org.bouncycastle.crypto.signers.GOST3410Signer;
import org.bouncycastle.crypto.signers.GenericSigner;
import org.bouncycastle.crypto.signers.ISO9796d2PSSSigner;
import org.bouncycastle.crypto.signers.ISO9796d2Signer;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.crypto.signers.X931Signer;
import org.bouncycastle.util.test.SimpleTest;

public class AsymmetricConstraintsTest
extends SimpleTest {
    public String getName() {
        return "AsymmetricConstraintsTest";
    }

    public void performTest() throws Exception {
        this.test1024bitDSA();
        this.test1024bitRSA();
        this.testEdwards();
        this.testEC();
        this.testDSA();
        this.testDH();
        this.testElgamal();
        this.testGost3410();
        this.testRSA();
        this.testRsaKEM();
        this.testECIESKEM();
        this.testSM2Cipher();
        this.testCramerShoup();
        this.testNaccacheStern();
    }

    private void test1024bitDSA() {
        BigInteger p = new BigInteger("178011905478542266528237562450159990145232156369120674273274450314442865788737020770612695252123463079567156784778466449970650770920727857050009668388144034129745221171818506047231150039301079959358067395348717066319802262019714966524135060945913707594956514672855690606794135837542707371727429551343320695239");
        BigInteger q = new BigInteger("864205495604807476120572616017955259175325408501");
        BigInteger g = new BigInteger("174068207532402095185811980123523436538604490794561350978495831040599953488455823147851597408940950725307797094915759492368300574252438761037084473467180148876118103083043754985190983472601550494691329488083395492313850000361646482644608492304078721818959999056496097769368017749273708962006689187956744210730");
        BigInteger x = new BigInteger("774290984479563168206130828532207106685994961942");
        BigInteger y = new BigInteger("114139536920622570869938062331723306749387755293373930319777713731297469469109142401130232217217777321368184441397443931576984650449330134427587575682738623671153548160095548080912063040969633652666498299669170854742832973750730854597032012872351800053401243970059348061331526243448471205166130497310892424132");
        DSAPublicKeyParameters pk = new DSAPublicKeyParameters(y, new DSAParameters(p, q, g));
        DSAPrivateKeyParameters sk = new DSAPrivateKeyParameters(x, new DSAParameters(p, q, g));
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new LegacyBitsOfSecurityConstraint(128));
        DSASigner signer = new DSASigner();
        try {
            signer.init(true, (CipherParameters)sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 128 bits of security only 80", e.getMessage());
        }
        signer.init(false, (CipherParameters)pk);
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void test1024bitRSA() {
        BigInteger mod = new BigInteger("dbe3d9e35c7b3791e235e9146a5e27be06f202bbd2bc4c772e892b6d613da42cea1f0bffdd45220c1e7e9a21f94b0d86363986238e07d8b28fabde84ed35f1620daef807f27e021be84c7dffecc1106ab414a004a06c410f7cf96c720fbc70a2b357a4edd709ed23c7dc6e6e01433cd8a3e5b49b09ef4f4b6b0086f2fb07b4d9", 16);
        BigInteger pubExp = new BigInteger("10001", 16);
        BigInteger privExp = new BigInteger("2f06cbd29434c5edad335a65c359dfa604563dbf6d9257c8256bb09df3edfaeea02383ad74e514230362901433fc9927daf0f27f282105772ac2d71416a732b820163b22f7e808fa27af5d5e7952ba9f8ecd8e0724469a57bd0d3de828d4953aad0be5ed63ad5b726b012abf5540d4a766b6009124077aac577bcf2ef677531", 16);
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new LegacyBitsOfSecurityConstraint(112, 80));
        RSAKeyParameters pk = new RSAKeyParameters(false, mod, pubExp);
        RSAKeyParameters sk = new RSAKeyParameters(true, mod, privExp);
        RSAEngine rsaEngine = new RSAEngine();
        try {
            rsaEngine.init(true, (CipherParameters)sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 112 bits of security only 80", e.getMessage());
        }
        rsaEngine.init(false, (CipherParameters)pk);
        try {
            rsaEngine.init(true, (CipherParameters)pk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 112 bits of security only 80", e.getMessage());
        }
        this.signer1024Test(pk, sk, (Signer)new RSADigestSigner((Digest)SHA256Digest.newInstance()));
        this.signer1024Test(pk, sk, (Signer)new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)SHA256Digest.newInstance(), 20));
        this.signer1024Test(pk, sk, (Signer)new ISO9796d2PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)SHA256Digest.newInstance(), 20));
        this.signer1024Test(pk, sk, (Signer)new ISO9796d2Signer((AsymmetricBlockCipher)new RSAEngine(), (Digest)SHA256Digest.newInstance()));
        this.signer1024Test(pk, sk, (Signer)new X931Signer((AsymmetricBlockCipher)new RSAEngine(), (Digest)SHA256Digest.newInstance()));
        this.signer1024Test(pk, sk, (Signer)new GenericSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)SHA256Digest.newInstance()));
        rsaEngine.init(false, (CipherParameters)sk);
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void signer1024Test(RSAKeyParameters pk, RSAKeyParameters sk, Signer signer) {
        signer.init(false, (CipherParameters)pk);
        try {
            signer.init(true, (CipherParameters)sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 112 bits of security only 80", e.getMessage());
        }
    }

    private void testEdwards() {
        SecureRandom random = new SecureRandom();
        Ed25519KeyPairGenerator ed25519kpGen = new Ed25519KeyPairGenerator();
        ed25519kpGen.init((KeyGenerationParameters)new Ed25519KeyGenerationParameters(random));
        Ed448KeyPairGenerator ed448kpGen = new Ed448KeyPairGenerator();
        ed448kpGen.init((KeyGenerationParameters)new Ed448KeyGenerationParameters(random));
        X25519KeyPairGenerator x25519kpGen = new X25519KeyPairGenerator();
        x25519kpGen.init((KeyGenerationParameters)new X25519KeyGenerationParameters(random));
        X448KeyPairGenerator x448kpGen = new X448KeyPairGenerator();
        x448kpGen.init((KeyGenerationParameters)new X448KeyGenerationParameters(random));
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new LegacyBitsOfSecurityConstraint(256, 128));
        AsymmetricCipherKeyPair kp = ed25519kpGen.generateKeyPair();
        this.edwardsSignerTest(kp.getPublic(), kp.getPrivate(), (Signer)new Ed25519Signer(), "128");
        this.edwardsSignerTest(kp.getPublic(), kp.getPrivate(), (Signer)new Ed25519phSigner(new byte[1]), "128");
        this.edwardsSignerTest(kp.getPublic(), kp.getPrivate(), (Signer)new Ed25519ctxSigner(new byte[1]), "128");
        kp = ed448kpGen.generateKeyPair();
        this.edwardsSignerTest(kp.getPublic(), kp.getPrivate(), (Signer)new Ed448Signer(new byte[1]), "224");
        this.edwardsSignerTest(kp.getPublic(), kp.getPrivate(), (Signer)new Ed448phSigner(new byte[1]), "224");
        kp = x25519kpGen.generateKeyPair();
        this.edwardsAgreementTest((CipherParameters)kp.getPublic(), (CipherParameters)kp.getPrivate(), (RawAgreement)new X25519Agreement(), "128");
        this.edwardsAgreementTest(kp.getPublic(), kp.getPrivate(), new XDHBasicAgreement(), "128");
        this.edwardsAgreementTest((CipherParameters)new XDHUPublicParameters(kp.getPublic(), kp.getPublic()), (CipherParameters)new XDHUPrivateParameters(kp.getPrivate(), kp.getPrivate()), (RawAgreement)new XDHUnifiedAgreement((RawAgreement)new X25519Agreement()), "128");
        kp = x448kpGen.generateKeyPair();
        this.edwardsAgreementTest((CipherParameters)kp.getPublic(), (CipherParameters)kp.getPrivate(), (RawAgreement)new X448Agreement(), "224");
        this.edwardsAgreementTest(kp.getPublic(), kp.getPrivate(), new XDHBasicAgreement(), "224");
        try {
            ed25519kpGen.init((KeyGenerationParameters)new Ed25519KeyGenerationParameters(random));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 256 bits of security only 128", e.getMessage());
        }
        try {
            ed448kpGen.init((KeyGenerationParameters)new Ed448KeyGenerationParameters(random));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 256 bits of security only 224", e.getMessage());
        }
        try {
            x25519kpGen.init((KeyGenerationParameters)new X25519KeyGenerationParameters(random));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 256 bits of security only 128", e.getMessage());
        }
        try {
            x448kpGen.init((KeyGenerationParameters)new X448KeyGenerationParameters(random));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 256 bits of security only 224", e.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void edwardsSignerTest(AsymmetricKeyParameter pk, AsymmetricKeyParameter sk, Signer signer, String sBits) {
        signer.init(false, (CipherParameters)pk);
        try {
            signer.init(true, (CipherParameters)sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 256 bits of security only " + sBits, e.getMessage());
        }
    }

    private void edwardsAgreementTest(CipherParameters pk, CipherParameters sk, RawAgreement agreement, String sBits) {
        try {
            agreement.init(sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 256 bits of security only " + sBits, e.getMessage());
        }
    }

    private void edwardsAgreementTest(AsymmetricKeyParameter pk, AsymmetricKeyParameter sk, XDHBasicAgreement agreement, String sBits) {
        try {
            agreement.init((CipherParameters)sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 256 bits of security only " + sBits, e.getMessage());
        }
    }

    private void testEC() {
        SecureRandom random = new SecureRandom();
        ECKeyPairGenerator ecKp = new ECKeyPairGenerator();
        ecKp.init((KeyGenerationParameters)new ECKeyGenerationParameters(new ECDomainParameters(X962NamedCurves.getByName((String)"prime192v1")), random));
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair kp = ecKp.generateKeyPair();
        this.ecSignerTest(kp.getPublic(), kp.getPrivate(), (DSA)new ECDSASigner());
        this.ecSignerTest(kp.getPublic(), kp.getPrivate(), (DSA)new DSTU4145Signer());
        this.ecSignerTest(kp.getPublic(), kp.getPrivate(), (DSA)new ECGOST3410Signer());
        this.ecSignerTest(kp.getPublic(), kp.getPrivate(), (Signer)new SM2Signer());
        this.ecAgreementTest(kp.getPublic(), kp.getPrivate(), (BasicAgreement)new ECDHBasicAgreement());
        this.ecAgreementTest(kp.getPublic(), kp.getPrivate(), (BasicAgreement)new ECDHCBasicAgreement());
        this.ecAgreementTest(kp.getPublic(), kp.getPrivate(), (BasicAgreement)new ECDHCStagedAgreement());
        this.ecAgreementTest(new ECDHUPublicParameters((ECPublicKeyParameters)kp.getPublic(), (ECPublicKeyParameters)kp.getPublic()), new ECDHUPrivateParameters((ECPrivateKeyParameters)kp.getPrivate(), (ECPrivateKeyParameters)kp.getPrivate()), new ECDHCUnifiedAgreement());
        this.ecAgreementTest(new MQVPublicParameters((ECPublicKeyParameters)kp.getPublic(), (ECPublicKeyParameters)kp.getPublic()), new MQVPrivateParameters((ECPrivateKeyParameters)kp.getPrivate(), (ECPrivateKeyParameters)kp.getPrivate()), new ECMQVBasicAgreement());
        this.ecAgreementTest(kp.getPublic(), kp.getPrivate(), new ECVKOAgreement((Digest)SHA256Digest.newInstance()));
        try {
            ecKp.init((KeyGenerationParameters)new ECKeyGenerationParameters(new ECDomainParameters(X962NamedCurves.getByName((String)"prime192v1")), random));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 96", e.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void ecSignerTest(AsymmetricKeyParameter pk, AsymmetricKeyParameter sk, DSA signer) {
        signer.init(false, (CipherParameters)pk);
        try {
            signer.init(true, (CipherParameters)sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 128 bits of security only 96", e.getMessage());
        }
    }

    private void ecAgreementTest(AsymmetricKeyParameter pk, AsymmetricKeyParameter sk, BasicAgreement agreement) {
        try {
            agreement.init((CipherParameters)sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 128 bits of security only 96", e.getMessage());
        }
    }

    private void ecAgreementTest(MQVPublicParameters pk, MQVPrivateParameters sk, ECMQVBasicAgreement agreement) {
        try {
            agreement.init((CipherParameters)sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 128 bits of security only 96", e.getMessage());
        }
    }

    private void ecAgreementTest(ECDHUPublicParameters pk, ECDHUPrivateParameters sk, ECDHCUnifiedAgreement agreement) {
        try {
            agreement.init((CipherParameters)sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 128 bits of security only 96", e.getMessage());
        }
    }

    private void ecAgreementTest(AsymmetricKeyParameter pk, AsymmetricKeyParameter sk, ECVKOAgreement agreement) {
        try {
            agreement.init((CipherParameters)new ParametersWithUKM((CipherParameters)sk, new byte[32]));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 128 bits of security only 96", e.getMessage());
        }
    }

    private void ecSignerTest(AsymmetricKeyParameter pk, AsymmetricKeyParameter sk, Signer signer) {
        signer.init(false, (CipherParameters)pk);
        try {
            signer.init(true, (CipherParameters)sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals("service does not provide 128 bits of security only 96", e.getMessage());
        }
    }

    private void testDSA() {
        DSAParameters dsaParams = new DSAParameters(new BigInteger("F56C2A7D366E3EBDEAA1891FD2A0D099436438A673FED4D75F594959CFFEBCA7BE0FC72E4FE67D91D801CBA0693AC4ED9E411B41D19E2FD1699C4390AD27D94C69C0B143F1DC88932CFE2310C886412047BD9B1C7A67F8A25909132627F51A0C866877E672E555342BDF9355347DBD43B47156B2C20BAD9D2B071BC2FDCF9757F75C168C5D9FC43131BE162A0756D1BDEC2CA0EB0E3B018A8B38D3EF2487782AEB9FBF99D8B30499C55E4F61E5C7DCEE2A2BB55BD7F75FCDF00E48F2E8356BDB59D86114028F67B8E07B127744778AFF1CF1399A4D679D92FDE7D941C5C85C5D7BFF91BA69F9489D531D1EBFA727CFDA651390F8021719FA9F7216CEB177BD75", 16), new BigInteger("C24ED361870B61E0D367F008F99F8A1F75525889C89DB1B673C45AF5867CB467", 16), new BigInteger("8DC6CC814CAE4A1C05A3E186A6FE27EABA8CDB133FDCE14A963A92E809790CBA096EAA26140550C129FA2B98C16E84236AA33BF919CD6F587E048C52666576DB6E925C6CBE9B9EC5C16020F9A44C9F1C8F7A8E611C1F6EC2513EA6AA0B8D0F72FED73CA37DF240DB57BBB27431D618697B9E771B0B301D5DF05955425061A30DC6D33BB6D2A32BD0A75A0A71D2184F506372ABF84A56AEEEA8EB693BF29A640345FA1298A16E85421B2208D00068A5A42915F82CF0B858C8FA39D43D704B6927E0B2F916304E86FB6A1B487F07D8139E428BB096C6D67A76EC0B8D4EF274B8A2CF556D279AD267CCEF5AF477AFED029F485B5597739F5D0240F67C2D948A6279", 16));
        SecureRandom random = new SecureRandom();
        DSAKeyPairGenerator dsaKp = new DSAKeyPairGenerator();
        dsaKp.init((KeyGenerationParameters)new DSAKeyGenerationParameters(random, dsaParams));
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair kp = dsaKp.generateKeyPair();
        this.dsaSignerTest(kp.getPublic(), kp.getPrivate(), (DSA)new DSASigner());
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new BitsOfSecurityConstraint(256));
        try {
            dsaKp.init((KeyGenerationParameters)new DSAKeyGenerationParameters(random, dsaParams));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 256 bits of security only 112", e.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void dsaSignerTest(AsymmetricKeyParameter pk, AsymmetricKeyParameter sk, DSA signer) {
        signer.init(false, (CipherParameters)pk);
        try {
            signer.init(true, (CipherParameters)sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 112", e.getMessage());
        }
    }

    private void testGost3410() {
        GOST3410Parameters gostParams = new GOST3410Parameters(new BigInteger("F56C2A7D366E3EBDEAA1891FD2A0D099436438A673FED4D75F594959CFFEBCA7BE0FC72E4FE67D91D801CBA0693AC4ED9E411B41D19E2FD1699C4390AD27D94C69C0B143F1DC88932CFE2310C886412047BD9B1C7A67F8A25909132627F51A0C866877E672E555342BDF9355347DBD43B47156B2C20BAD9D2B071BC2FDCF9757F75C168C5D9FC43131BE162A0756D1BDEC2CA0EB0E3B018A8B38D3EF2487782AEB9FBF99D8B30499C55E4F61E5C7DCEE2A2BB55BD7F75FCDF00E48F2E8356BDB59D86114028F67B8E07B127744778AFF1CF1399A4D679D92FDE7D941C5C85C5D7BFF91BA69F9489D531D1EBFA727CFDA651390F8021719FA9F7216CEB177BD75", 16), new BigInteger("C24ED361870B61E0D367F008F99F8A1F75525889C89DB1B673C45AF5867CB467", 16), new BigInteger("8DC6CC814CAE4A1C05A3E186A6FE27EABA8CDB133FDCE14A963A92E809790CBA096EAA26140550C129FA2B98C16E84236AA33BF919CD6F587E048C52666576DB6E925C6CBE9B9EC5C16020F9A44C9F1C8F7A8E611C1F6EC2513EA6AA0B8D0F72FED73CA37DF240DB57BBB27431D618697B9E771B0B301D5DF05955425061A30DC6D33BB6D2A32BD0A75A0A71D2184F506372ABF84A56AEEEA8EB693BF29A640345FA1298A16E85421B2208D00068A5A42915F82CF0B858C8FA39D43D704B6927E0B2F916304E86FB6A1B487F07D8139E428BB096C6D67A76EC0B8D4EF274B8A2CF556D279AD267CCEF5AF477AFED029F485B5597739F5D0240F67C2D948A6279", 16));
        SecureRandom random = new SecureRandom();
        GOST3410KeyPairGenerator gost3410 = new GOST3410KeyPairGenerator();
        gost3410.init((KeyGenerationParameters)new GOST3410KeyGenerationParameters(random, gostParams));
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair kp = gost3410.generateKeyPair();
        this.dsaSignerTest(kp.getPublic(), kp.getPrivate(), (DSA)new GOST3410Signer());
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new BitsOfSecurityConstraint(256));
        try {
            gost3410.init((KeyGenerationParameters)new GOST3410KeyGenerationParameters(random, gostParams));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 256 bits of security only 112", e.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testDH() {
        SecureRandom random = new SecureRandom();
        DHKeyPairGenerator dhKp = new DHKeyPairGenerator();
        dhKp.init((KeyGenerationParameters)new DHKeyGenerationParameters(random, DHStandardGroups.rfc2409_1024));
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new LegacyBitsOfSecurityConstraint(128, 112));
        AsymmetricCipherKeyPair kp = dhKp.generateKeyPair();
        this.dhTest(kp.getPublic(), kp.getPrivate(), new DHAgreement());
        this.dhTest(kp.getPublic(), kp.getPrivate(), (BasicAgreement)new DHBasicAgreement());
        this.dhTest((CipherParameters)new DHUPublicParameters((DHPublicKeyParameters)kp.getPublic(), (DHPublicKeyParameters)kp.getPublic()), (CipherParameters)new DHUPrivateParameters((DHPrivateKeyParameters)kp.getPrivate(), (DHPrivateKeyParameters)kp.getPrivate()), new DHUnifiedAgreement());
        this.dhTest((CipherParameters)new DHMQVPublicParameters((DHPublicKeyParameters)kp.getPublic(), (DHPublicKeyParameters)kp.getPublic()), (CipherParameters)new DHMQVPrivateParameters((DHPrivateKeyParameters)kp.getPrivate(), (DHPrivateKeyParameters)kp.getPrivate()), new MQVBasicAgreement());
        try {
            dhKp.init((KeyGenerationParameters)new DHKeyGenerationParameters(random, DHStandardGroups.rfc2409_768));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 20", e.getMessage());
        }
        try {
            DHBasicKeyPairGenerator bKg = new DHBasicKeyPairGenerator();
            bKg.init((KeyGenerationParameters)new DHKeyGenerationParameters(random, DHStandardGroups.rfc2409_768));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 20", e.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void dhTest(AsymmetricKeyParameter pk, AsymmetricKeyParameter sk, DHAgreement agreement) {
        try {
            agreement.init((CipherParameters)sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 80", e.getMessage());
        }
    }

    private void dhTest(AsymmetricKeyParameter pk, AsymmetricKeyParameter sk, BasicAgreement agreement) {
        try {
            agreement.init((CipherParameters)sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 80", e.getMessage());
        }
    }

    private void dhTest(CipherParameters pk, CipherParameters sk, MQVBasicAgreement agreement) {
        try {
            agreement.init(sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 80", e.getMessage());
        }
    }

    private void dhTest(CipherParameters pk, CipherParameters sk, DHUnifiedAgreement agreement) {
        try {
            agreement.init(sk);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 80", e.getMessage());
        }
    }

    private void testCramerShoup() {
        SecureRandom random = new SecureRandom();
        CramerShoupKeyPairGenerator kpGen = new CramerShoupKeyPairGenerator();
        CramerShoupParametersGenerator pGen = new CramerShoupParametersGenerator();
        pGen.init(1024, 1, random);
        kpGen.init((KeyGenerationParameters)new CramerShoupKeyGenerationParameters(random, pGen.generateParameters(DHStandardGroups.rfc2409_1024)));
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair kp = kpGen.generateKeyPair();
        CramerShoupCoreEngine csEngine = new CramerShoupCoreEngine();
        try {
            csEngine.init(true, (CipherParameters)kp.getPublic());
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 80", e.getMessage());
        }
        csEngine.init(false, (CipherParameters)kp.getPrivate());
        try {
            kpGen.init((KeyGenerationParameters)new CramerShoupKeyGenerationParameters(random, pGen.generateParameters(DHStandardGroups.rfc2409_1024)));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 80", e.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testElgamal() {
        SecureRandom random = new SecureRandom();
        ElGamalKeyPairGenerator eKpg = new ElGamalKeyPairGenerator();
        eKpg.init((KeyGenerationParameters)new ElGamalKeyGenerationParameters(random, new ElGamalParameters(DHStandardGroups.rfc2409_1024.getP(), DHStandardGroups.rfc2409_1024.getG())));
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair kp = eKpg.generateKeyPair();
        ElGamalEngine eEngine = new ElGamalEngine();
        try {
            eEngine.init(true, (CipherParameters)kp.getPublic());
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 80", e.getMessage());
        }
        eEngine.init(false, (CipherParameters)kp.getPrivate());
        try {
            eKpg.init((KeyGenerationParameters)new ElGamalKeyGenerationParameters(random, new ElGamalParameters(DHStandardGroups.rfc2409_1024.getP(), DHStandardGroups.rfc2409_1024.getG())));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 80", e.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testRSA() {
        SecureRandom random = new SecureRandom();
        RSAKeyPairGenerator rsaKpg = new RSAKeyPairGenerator();
        rsaKpg.init((KeyGenerationParameters)new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), random, 1024, 100));
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair kp = rsaKpg.generateKeyPair();
        RSAEngine rsaEngine = new RSAEngine();
        try {
            rsaEngine.init(true, (CipherParameters)kp.getPublic());
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 80", e.getMessage());
        }
        rsaEngine.init(false, (CipherParameters)kp.getPrivate());
        try {
            rsaKpg.init((KeyGenerationParameters)new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), random, 1024, 100));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 80", e.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testRsaKEM() {
        SecureRandom random = new SecureRandom();
        RSAKeyPairGenerator rsaKpg = new RSAKeyPairGenerator();
        rsaKpg.init((KeyGenerationParameters)new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), random, 1024, 100));
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair kp = rsaKpg.generateKeyPair();
        KDF2BytesGenerator kdf = new KDF2BytesGenerator((Digest)new SHA1Digest());
        SecureRandom rnd = new SecureRandom();
        RSAKEMGenerator rsaKem = new RSAKEMGenerator(16, (DerivationFunction)kdf, rnd);
        try {
            rsaKem.generateEncapsulated(kp.getPublic());
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 80", e.getMessage());
        }
        RSAKEMExtractor rsaExt = new RSAKEMExtractor((RSAKeyParameters)kp.getPrivate(), 16, (DerivationFunction)kdf);
        try {
            rsaKpg.init((KeyGenerationParameters)new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), random, 1024, 100));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 80", e.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testECIESKEM() {
        SecureRandom random = new SecureRandom();
        KDF2BytesGenerator kdf = new KDF2BytesGenerator((Digest)new SHA1Digest());
        ECKeyPairGenerator ecKp = new ECKeyPairGenerator();
        ecKp.init((KeyGenerationParameters)new ECKeyGenerationParameters(new ECDomainParameters(X962NamedCurves.getByName((String)"prime192v1")), random));
        AsymmetricCipherKeyPair kp = ecKp.generateKeyPair();
        byte[] out = new byte[49];
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testSM2Cipher() {
        SecureRandom random = new SecureRandom();
        ECKeyPairGenerator kpGen = new ECKeyPairGenerator();
        kpGen.init((KeyGenerationParameters)new ECKeyGenerationParameters(new ECDomainParameters(ECNamedCurveTable.getByName((String)"P-256")), random));
        AsymmetricCipherKeyPair kp = kpGen.generateKeyPair();
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new LegacyBitsOfSecurityConstraint(256, 128));
        SM2Engine engine = new SM2Engine();
        try {
            engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)kp.getPublic(), random));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 256 bits of security only 128", e.getMessage());
        }
        engine.init(false, (CipherParameters)kp.getPrivate());
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testNaccacheStern() {
        SecureRandom random = new SecureRandom();
        NaccacheSternKeyPairGenerator kpGen = new NaccacheSternKeyPairGenerator();
        kpGen.init((KeyGenerationParameters)new NaccacheSternKeyGenerationParameters(random, 1024, 8, 40));
        CryptoServicesRegistrar.setServicesConstraints((CryptoServicesConstraints)new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair kp = kpGen.generateKeyPair();
        NaccacheSternEngine nsEngine = new NaccacheSternEngine();
        try {
            nsEngine.init(true, (CipherParameters)kp.getPublic());
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 80", e.getMessage());
        }
        nsEngine.init(false, (CipherParameters)kp.getPrivate());
        try {
            kpGen.init((KeyGenerationParameters)new NaccacheSternKeyGenerationParameters(random, 1024, 8, 40));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException e) {
            this.isEquals(e.getMessage(), "service does not provide 128 bits of security only 80", e.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new AsymmetricConstraintsTest());
    }
}

