/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Random;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.digests.AsconDigest;
import org.bouncycastle.crypto.digests.AsconXof;
import org.bouncycastle.crypto.engines.AsconEngine;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class AsconTest
extends SimpleTest {
    public static void main(String[] args) {
        SimpleTest.runTest(new AsconTest());
    }

    public String getName() {
        return "Ascon";
    }

    public void performTest() throws Exception {
        this.testBufferingEngine_ascon128();
        this.testBufferingEngine_ascon128a();
        this.testBufferingEngine_ascon80();
        this.testExceptionsDigest_AsconHash();
        this.testExceptionsDigest_AsconHashA();
        this.testExceptionsEngine_ascon128();
        this.testExceptionsEngine_ascon128a();
        this.testExceptionsEngine_ascon80pq();
        this.testExceptionsXof_AsconXof();
        this.testExceptionsXof_AsconXofA();
        this.testParametersDigest_AsconHash();
        this.testParametersDigest_AsconHashA();
        this.testParametersEngine_ascon128();
        this.testParametersEngine_ascon128a();
        this.testParametersEngine_ascon80pq();
        this.testParametersXof_AsconXof();
        this.testParametersXof_AsconXofA();
        this.testVectorsDigest_AsconHash();
        this.testVectorsDigest_AsconHashA();
        this.testVectorsEngine_ascon128();
        this.testVectorsEngine_ascon128a();
        this.testVectorsEngine_ascon80pq();
        this.testVectorsXof_AsconXof();
        this.testVectorsXof_AsconXofA();
    }

    public void testBufferingEngine_ascon128() throws Exception {
        this.implTestBufferingEngine(AsconEngine.AsconParameters.ascon128);
    }

    public void testBufferingEngine_ascon128a() throws Exception {
        this.implTestBufferingEngine(AsconEngine.AsconParameters.ascon128a);
    }

    public void testBufferingEngine_ascon80() throws Exception {
        this.implTestBufferingEngine(AsconEngine.AsconParameters.ascon80pq);
    }

    public void testExceptionsDigest_AsconHash() throws Exception {
        this.implTestExceptionsDigest(AsconDigest.AsconParameters.AsconHash);
    }

    public void testExceptionsDigest_AsconHashA() throws Exception {
        this.implTestExceptionsDigest(AsconDigest.AsconParameters.AsconHashA);
    }

    public void testExceptionsEngine_ascon128() throws Exception {
        this.implTestExceptionsEngine(AsconEngine.AsconParameters.ascon128);
    }

    public void testExceptionsEngine_ascon128a() throws Exception {
        this.implTestExceptionsEngine(AsconEngine.AsconParameters.ascon128a);
    }

    public void testExceptionsEngine_ascon80pq() throws Exception {
        this.implTestExceptionsEngine(AsconEngine.AsconParameters.ascon80pq);
    }

    public void testExceptionsXof_AsconXof() throws Exception {
        this.implTestExceptionsXof(AsconXof.AsconParameters.AsconXof);
    }

    public void testExceptionsXof_AsconXofA() throws Exception {
        this.implTestExceptionsXof(AsconXof.AsconParameters.AsconXofA);
    }

    public void testParametersDigest_AsconHash() throws Exception {
        this.implTestParametersDigest(AsconDigest.AsconParameters.AsconHash, 32);
    }

    public void testParametersDigest_AsconHashA() throws Exception {
        this.implTestParametersDigest(AsconDigest.AsconParameters.AsconHashA, 32);
    }

    public void testParametersEngine_ascon128() throws Exception {
        this.implTestParametersEngine(AsconEngine.AsconParameters.ascon128, 16, 16, 16);
    }

    public void testParametersEngine_ascon128a() throws Exception {
        this.implTestParametersEngine(AsconEngine.AsconParameters.ascon128a, 16, 16, 16);
    }

    public void testParametersEngine_ascon80pq() throws Exception {
        this.implTestParametersEngine(AsconEngine.AsconParameters.ascon80pq, 20, 16, 16);
    }

    public void testParametersXof_AsconXof() throws Exception {
        this.implTestParametersXof(AsconXof.AsconParameters.AsconXof, 32);
    }

    public void testParametersXof_AsconXofA() throws Exception {
        this.implTestParametersXof(AsconXof.AsconParameters.AsconXofA, 32);
    }

    public void testVectorsDigest_AsconHash() throws Exception {
        this.implTestVectorsDigest(AsconDigest.AsconParameters.AsconHash, "asconhash");
    }

    public void testVectorsDigest_AsconHashA() throws Exception {
        this.implTestVectorsDigest(AsconDigest.AsconParameters.AsconHashA, "asconhasha");
    }

    public void testVectorsEngine_ascon128() throws Exception {
        this.implTestVectorsEngine(AsconEngine.AsconParameters.ascon128, "128_128");
    }

    public void testVectorsEngine_ascon128a() throws Exception {
        this.implTestVectorsEngine(AsconEngine.AsconParameters.ascon128a, "128_128_a");
    }

    public void testVectorsEngine_ascon80pq() throws Exception {
        this.implTestVectorsEngine(AsconEngine.AsconParameters.ascon80pq, "160_128");
    }

    public void testVectorsXof_AsconXof() throws Exception {
        this.implTestVectorsXof(AsconXof.AsconParameters.AsconXof, "asconxof");
    }

    public void testVectorsXof_AsconXofA() throws Exception {
        this.implTestVectorsXof(AsconXof.AsconParameters.AsconXofA, "asconxofa");
    }

    private static AsconDigest createDigest(AsconDigest.AsconParameters asconParameters) {
        return new AsconDigest(asconParameters);
    }

    private static AsconEngine createEngine(AsconEngine.AsconParameters asconParameters) {
        return new AsconEngine(asconParameters);
    }

    private static AsconXof createXof(AsconXof.AsconParameters asconParameters) {
        return new AsconXof(asconParameters);
    }

    private void implTestBufferingEngine(AsconEngine.AsconParameters asconParameters) throws Exception {
        Random random = new Random();
        int plaintextLength = 256;
        byte[] plaintext = new byte[plaintextLength];
        random.nextBytes(plaintext);
        AsconEngine ascon0 = AsconTest.createEngine(asconParameters);
        AsconTest.initEngine(ascon0, true);
        byte[] ciphertext = new byte[ascon0.getOutputSize(plaintextLength)];
        random.nextBytes(ciphertext);
        int ciphertextLength = ascon0.processBytes(plaintext, 0, plaintextLength, ciphertext, 0);
        ciphertextLength += ascon0.doFinal(ciphertext, ciphertextLength);
        byte[] output = new byte[ciphertextLength];
        int split = 1;
        while (split < plaintextLength) {
            AsconEngine ascon = AsconTest.createEngine(asconParameters);
            AsconTest.initEngine(ascon, true);
            random.nextBytes(output);
            int length = ascon.processBytes(plaintext, 0, split, output, 0);
            if (0 != ascon.getUpdateOutputSize(0)) {
                this.fail("");
            }
            length += ascon.processBytes(plaintext, split, plaintextLength - split, output, length);
            if (!Arrays.areEqual((byte[])ciphertext, (int)0, (int)ciphertextLength, (byte[])output, (int)0, (int)(length += ascon.doFinal(output, length)))) {
                this.fail("encryption failed with split: " + split);
            }
            ++split;
        }
        int split2 = 1;
        while (split2 < ciphertextLength) {
            AsconEngine ascon = AsconTest.createEngine(asconParameters);
            AsconTest.initEngine(ascon, false);
            random.nextBytes(output);
            int length = ascon.processBytes(ciphertext, 0, split2, output, 0);
            if (0 != ascon.getUpdateOutputSize(0)) {
                this.fail("");
            }
            length += ascon.processBytes(ciphertext, split2, ciphertextLength - split2, output, length);
            if (!Arrays.areEqual((byte[])plaintext, (int)0, (int)plaintextLength, (byte[])output, (int)0, (int)(length += ascon.doFinal(output, length)))) {
                this.fail("decryption failed with split: " + split2);
            }
            ++split2;
        }
    }

    private void implTestExceptionsDigest(AsconDigest.AsconParameters asconParameters) {
        AsconDigest ascon = AsconTest.createDigest(asconParameters);
        try {
            ascon.update(new byte[1], 1, 1);
            this.fail(ascon.getAlgorithmName() + ": input for update is too short");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
        try {
            ascon.doFinal(new byte[ascon.getDigestSize() - 1], 2);
            this.fail(ascon.getAlgorithmName() + ": output for dofinal is too short");
        }
        catch (OutputLengthException outputLengthException) {
            // empty catch block
        }
    }

    private void implTestExceptionsEngine(AsconEngine.AsconParameters asconParameters) throws Exception {
        int randomNum;
        AsconEngine ascon = AsconTest.createEngine(asconParameters);
        int keySize = ascon.getKeyBytesSize();
        int ivSize = ascon.getIVBytesSize();
        byte[] k = new byte[keySize];
        byte[] iv = new byte[ivSize];
        byte[] m = new byte[]{};
        ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(k), iv);
        try {
            ascon.processBytes(m, 0, m.length, null, 0);
            this.fail(ascon.getAlgorithmName() + " need to be initialized before processBytes");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            ascon.processByte((byte)0, null, 0);
            this.fail(ascon.getAlgorithmName() + " need to be initialized before processByte");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            ascon.reset();
            this.fail(ascon.getAlgorithmName() + " need to be initialized before reset");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            ascon.doFinal(null, m.length);
            this.fail(ascon.getAlgorithmName() + " need to be initialized before dofinal");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            ascon.getMac();
            ascon.getOutputSize(0);
            ascon.getUpdateOutputSize(0);
        }
        catch (IllegalStateException e) {
            this.fail(ascon.getAlgorithmName() + " functions can be called before initialization");
        }
        Random rand = new Random();
        while ((randomNum = rand.nextInt(100)) == keySize) {
        }
        byte[] k1 = new byte[randomNum];
        while ((randomNum = rand.nextInt(100)) == ivSize) {
        }
        byte[] iv1 = new byte[randomNum];
        try {
            ascon.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(k1), iv));
            this.fail(ascon.getAlgorithmName() + " k size does not match");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ascon.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(k), iv1));
            this.fail(ascon.getAlgorithmName() + "iv size does not match");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ascon.init(true, (CipherParameters)new AEADParameters(new KeyParameter(k), 0, iv));
            this.fail(ascon.getAlgorithmName() + " wrong type of CipherParameters");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        ascon.init(true, (CipherParameters)params);
        byte[] c1 = new byte[ascon.getOutputSize(m.length)];
        try {
            ascon.doFinal(c1, m.length);
        }
        catch (Exception e) {
            this.fail(ascon.getAlgorithmName() + " allows no input for AAD and plaintext");
        }
        byte[] mac2 = ascon.getMac();
        if (mac2 == null) {
            this.fail("mac should not be empty after dofinal");
        }
        if (!this.areEqual(mac2, c1)) {
            this.fail("mac should be equal when calling dofinal and getMac");
        }
        ascon.init(true, (CipherParameters)params);
        ascon.processAADByte((byte)0);
        byte[] mac1 = new byte[ascon.getOutputSize(0)];
        ascon.doFinal(mac1, 0);
        if (this.areEqual(mac1, mac2)) {
            this.fail("mac should not match");
        }
        ascon.init(true, (CipherParameters)params);
        ascon.processByte((byte)0, null, 0);
        try {
            ascon.processAADByte((byte)0);
            this.fail("processAADByte(s) cannot be called after encryption/decryption");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            ascon.processAADBytes(new byte[]{0}, 0, 1);
            this.fail("processAADByte(s) cannot be called once only");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        ascon.reset();
        try {
            ascon.processAADBytes(new byte[]{0}, 1, 1);
            this.fail("input for processAADBytes is too short");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
        try {
            ascon.processBytes(new byte[]{0}, 1, 1, c1, 0);
            this.fail("input for processBytes is too short");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
        ascon.init(true, (CipherParameters)params);
        try {
            int need = ascon.getUpdateOutputSize(64);
            ascon.processBytes(new byte[64], 0, 64, new byte[need], 1);
            this.fail("output for processBytes is too short");
        }
        catch (OutputLengthException e) {
            // empty catch block
        }
        try {
            ascon.doFinal(new byte[2], 2);
            this.fail("output for dofinal is too short");
        }
        catch (OutputLengthException e) {
            // empty catch block
        }
        this.implTestExceptionsGetUpdateOutputSize(ascon, false, (CipherParameters)params, 100);
        this.implTestExceptionsGetUpdateOutputSize(ascon, true, (CipherParameters)params, 100);
        mac1 = new byte[ascon.getOutputSize(0)];
        mac2 = new byte[ascon.getOutputSize(0)];
        ascon.init(true, (CipherParameters)params);
        ascon.processAADBytes(new byte[]{0, 0}, 0, 2);
        ascon.doFinal(mac1, 0);
        ascon.init(true, (CipherParameters)params);
        ascon.processAADByte((byte)0);
        ascon.processAADByte((byte)0);
        ascon.doFinal(mac2, 0);
        if (!this.areEqual(mac1, mac2)) {
            this.fail("mac should match for the same AAD with different ways of inputing");
        }
        byte[] c2 = new byte[ascon.getOutputSize(10)];
        byte[] c3 = new byte[ascon.getOutputSize(10) + 2];
        byte[] aad2 = new byte[]{0, 1, 2, 3, 4};
        byte[] aad3 = new byte[]{0, 0, 1, 2, 3, 4, 5};
        byte[] m2 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] m3 = new byte[]{0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] m4 = new byte[m2.length];
        ascon.init(true, (CipherParameters)params);
        ascon.processAADBytes(aad2, 0, aad2.length);
        int offset = ascon.processBytes(m2, 0, m2.length, c2, 0);
        ascon.doFinal(c2, offset);
        ascon.init(true, (CipherParameters)params);
        ascon.processAADBytes(aad3, 1, aad2.length);
        offset = ascon.processBytes(m3, 1, m2.length, c3, 1);
        ascon.doFinal(c3, offset + 1);
        byte[] c3_partial = new byte[c2.length];
        System.arraycopy(c3, 1, c3_partial, 0, c2.length);
        if (!this.areEqual(c2, c3_partial)) {
            this.fail("mac should match for the same AAD and message with different offset for both input and output");
        }
        ascon.init(false, (CipherParameters)params);
        ascon.processAADBytes(aad2, 0, aad2.length);
        offset = ascon.processBytes(c2, 0, c2.length, m4, 0);
        ascon.doFinal(m4, offset);
        if (!this.areEqual(m2, m4)) {
            this.fail("The encryption and decryption does not recover the plaintext");
        }
        int n = c2.length - 1;
        c2[n] = (byte)(c2[n] ^ 1);
        ascon.init(false, (CipherParameters)params);
        ascon.processAADBytes(aad2, 0, aad2.length);
        offset = ascon.processBytes(c2, 0, c2.length, m4, 0);
        try {
            ascon.doFinal(m4, offset);
            this.fail("The decryption should fail");
        }
        catch (InvalidCipherTextException e) {
            // empty catch block
        }
        byte[] m7 = new byte[32 + rand.nextInt(32)];
        rand.nextBytes(m7);
        ascon.init(true, (CipherParameters)params);
        byte[] c7 = new byte[ascon.getOutputSize(m7.length)];
        byte[] c8 = new byte[c7.length];
        byte[] c9 = new byte[c7.length];
        ascon.processAADBytes(aad2, 0, aad2.length);
        offset = ascon.processBytes(m7, 0, m7.length, c7, 0);
        ascon.doFinal(c7, offset);
        ascon.init(true, (CipherParameters)params);
        ascon.processAADBytes(aad2, 0, aad2.length);
        offset = ascon.processBytes(m7, 0, m7.length / 2, c8, 0);
        offset += ascon.processBytes(m7, m7.length / 2, m7.length - m7.length / 2, c8, offset);
        offset += ascon.doFinal(c8, offset);
        ascon.init(true, (CipherParameters)params);
        int split = rand.nextInt(m7.length - 1) + 1;
        ascon.processAADBytes(aad2, 0, aad2.length);
        offset = ascon.processBytes(m7, 0, split, c9, 0);
        offset += ascon.processBytes(m7, split, m7.length - split, c9, offset);
        offset += ascon.doFinal(c9, offset);
        if (!this.areEqual(c7, c8) || !this.areEqual(c7, c9)) {
            this.fail("Splitting input of plaintext should output the same ciphertext");
        }
    }

    private void implTestExceptionsGetUpdateOutputSize(AsconEngine ascon, boolean forEncryption, CipherParameters parameters, int maxInputSize) {
        ascon.init(forEncryption, parameters);
        int maxOutputSize = ascon.getUpdateOutputSize(maxInputSize);
        byte[] input = new byte[maxInputSize];
        byte[] output = new byte[maxOutputSize];
        int inputSize = 0;
        while (inputSize <= maxInputSize) {
            ascon.init(forEncryption, parameters);
            int outputSize = ascon.getUpdateOutputSize(inputSize);
            if (outputSize > 0) {
                try {
                    ascon.processBytes(input, 0, inputSize, output, maxOutputSize - outputSize + 1);
                    this.fail("output for processBytes is too short");
                }
                catch (OutputLengthException e) {}
            } else {
                ascon.processBytes(input, 0, inputSize, null, 0);
            }
            ++inputSize;
        }
    }

    private void implTestExceptionsXof(AsconXof.AsconParameters asconParameters) {
        AsconXof ascon = AsconTest.createXof(asconParameters);
        try {
            ascon.update(new byte[1], 1, 1);
            this.fail(ascon.getAlgorithmName() + ": input for update is too short");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
        try {
            ascon.doFinal(new byte[ascon.getDigestSize() - 1], 2);
            this.fail(ascon.getAlgorithmName() + ": output for dofinal is too short");
        }
        catch (OutputLengthException outputLengthException) {
            // empty catch block
        }
    }

    private void implTestParametersDigest(AsconDigest.AsconParameters asconParameters, int digestSize) {
        AsconDigest ascon = AsconTest.createDigest(asconParameters);
        if (ascon.getDigestSize() != digestSize) {
            this.fail(ascon.getAlgorithmName() + ": digest size is not correct");
        }
    }

    private void implTestParametersEngine(AsconEngine.AsconParameters asconParameters, int keySize, int ivSize, int macSize) {
        AsconEngine ascon = AsconTest.createEngine(asconParameters);
        if (ascon.getKeyBytesSize() != keySize) {
            this.fail("key bytes of " + ascon.getAlgorithmName() + " is not correct");
        }
        if (ascon.getIVBytesSize() != ivSize) {
            this.fail("iv bytes of " + ascon.getAlgorithmName() + " is not correct");
        }
        ParametersWithIV parameters = new ParametersWithIV((CipherParameters)new KeyParameter(new byte[keySize]), new byte[ivSize]);
        ascon.init(true, (CipherParameters)parameters);
        if (ascon.getOutputSize(0) != macSize) {
            this.fail("getOutputSize of " + ascon.getAlgorithmName() + " is incorrect for encryption");
        }
        ascon.init(false, (CipherParameters)parameters);
        if (ascon.getOutputSize(macSize) != 0) {
            this.fail("getOutputSize of " + ascon.getAlgorithmName() + " is incorrect for decryption");
        }
    }

    private void implTestParametersXof(AsconXof.AsconParameters asconParameters, int digestSize) {
        AsconXof ascon = AsconTest.createXof(asconParameters);
        if (ascon.getDigestSize() != digestSize) {
            this.fail(ascon.getAlgorithmName() + ": digest size is not correct");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void implTestVectorsDigest(AsconDigest.AsconParameters asconParameters, String filename) throws Exception {
        String line;
        Random random = new Random();
        AsconDigest ascon = AsconTest.createDigest(asconParameters);
        InputStream src = TestResourceFinder.findTestResource("crypto/ascon", filename + "_LWC_HASH_KAT_256.txt");
        BufferedReader bin = new BufferedReader(new InputStreamReader(src));
        HashMap<String, String> map = new HashMap<String, String>();
        while ((line = bin.readLine()) != null) {
            void var7_8;
            int a = var7_8.indexOf(61);
            if (a < 0) {
                byte[] ptByte = Hex.decode((String)((String)map.get("Msg")));
                byte[] expected = Hex.decode((String)((String)map.get("MD")));
                byte[] hash = new byte[ascon.getDigestSize()];
                ascon.update(ptByte, 0, ptByte.length);
                ascon.doFinal(hash, 0);
                if (!this.areEqual(hash, expected)) {
                    this.mismatch("Keystream " + map.get("Count"), (String)map.get("MD"), hash);
                }
                if (ptByte.length > 1) {
                    int split = random.nextInt(ptByte.length - 1) + 1;
                    ascon.update(ptByte, 0, split);
                    ascon.update(ptByte, split, ptByte.length - split);
                    ascon.doFinal(hash, 0);
                    if (!this.areEqual(hash, expected)) {
                        this.mismatch("Keystream " + map.get("Count"), (String)map.get("MD"), hash);
                    }
                }
                map.clear();
                continue;
            }
            map.put(var7_8.substring(0, a).trim(), var7_8.substring(a + 1).trim());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void implTestVectorsEngine(AsconEngine.AsconParameters asconParameters, String filename) throws Exception {
        String line;
        Random random = new Random();
        AsconEngine ascon = AsconTest.createEngine(asconParameters);
        InputStream src = TestResourceFinder.findTestResource("crypto/ascon", "LWC_AEAD_KAT_" + filename + ".txt");
        BufferedReader bin = new BufferedReader(new InputStreamReader(src));
        HashMap<String, String> map = new HashMap<String, String>();
        while ((line = bin.readLine()) != null) {
            void var7_8;
            int a = var7_8.indexOf(61);
            if (a < 0) {
                byte[] key = Hex.decode((String)((String)map.get("Key")));
                byte[] nonce = Hex.decode((String)((String)map.get("Nonce")));
                byte[] ad = Hex.decode((String)((String)map.get("AD")));
                byte[] pt = Hex.decode((String)((String)map.get("PT")));
                byte[] ct = Hex.decode((String)((String)map.get("CT")));
                ParametersWithIV parameters = new ParametersWithIV((CipherParameters)new KeyParameter(key), nonce);
                ascon.init(true, (CipherParameters)parameters);
                byte[] rv = new byte[ascon.getOutputSize(pt.length)];
                random.nextBytes(rv);
                ascon.processAADBytes(ad, 0, ad.length);
                int len = ascon.processBytes(pt, 0, pt.length, rv, 0);
                len += ascon.doFinal(rv, len);
                if (!this.areEqual(rv, 0, len, ct, 0, ct.length)) {
                    this.mismatch("Keystream " + map.get("Count"), (String)map.get("CT"), rv);
                }
                ascon.init(false, (CipherParameters)parameters);
                rv = new byte[ascon.getOutputSize(ct.length)];
                random.nextBytes(rv);
                ascon.processAADBytes(ad, 0, ad.length);
                len = ascon.processBytes(ct, 0, ct.length, rv, 0);
                len += ascon.doFinal(rv, len);
                if (!this.areEqual(rv, 0, len, pt, 0, pt.length)) {
                    this.mismatch("Reccover Keystream " + map.get("Count"), (String)map.get("PT"), rv);
                }
                map.clear();
                continue;
            }
            map.put(var7_8.substring(0, a).trim(), var7_8.substring(a + 1).trim());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void implTestVectorsXof(AsconXof.AsconParameters asconParameters, String filename) throws Exception {
        String line;
        Random random = new Random();
        AsconXof ascon = AsconTest.createXof(asconParameters);
        InputStream src = TestResourceFinder.findTestResource("crypto/ascon", filename + "_LWC_HASH_KAT_256.txt");
        BufferedReader bin = new BufferedReader(new InputStreamReader(src));
        HashMap<String, String> map = new HashMap<String, String>();
        while ((line = bin.readLine()) != null) {
            void var7_8;
            int a = var7_8.indexOf(61);
            if (a < 0) {
                byte[] ptByte = Hex.decode((String)((String)map.get("Msg")));
                byte[] expected = Hex.decode((String)((String)map.get("MD")));
                byte[] hash = new byte[ascon.getDigestSize()];
                ascon.update(ptByte, 0, ptByte.length);
                ascon.doFinal(hash, 0);
                if (!this.areEqual(hash, expected)) {
                    this.mismatch("Keystream " + map.get("Count"), (String)map.get("MD"), hash);
                }
                if (ptByte.length <= 1) continue;
                int split = random.nextInt(ptByte.length - 1) + 1;
                ascon.update(ptByte, 0, split);
                ascon.update(ptByte, split, ptByte.length - split);
                ascon.doFinal(hash, 0);
                if (this.areEqual(hash, expected)) continue;
                this.mismatch("Keystream " + map.get("Count"), (String)map.get("MD"), hash);
                continue;
            }
            map.put(var7_8.substring(0, a).trim(), var7_8.substring(a + 1).trim());
        }
    }

    private void mismatch(String name, String expected, byte[] found) {
        this.fail("mismatch on " + name, expected, new String(Hex.encode((byte[])found)));
    }

    private static void initEngine(AsconEngine ascon, boolean forEncryption) {
        int keySize = ascon.getKeyBytesSize();
        int ivSize = ascon.getIVBytesSize();
        int macSize = ivSize * 8;
        AEADParameters parameters = new AEADParameters(new KeyParameter(new byte[keySize]), macSize, new byte[ivSize], null);
        ascon.init(forEncryption, (CipherParameters)parameters);
    }
}

