/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.ARIAEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ARIATest
extends SimpleTest {
    private static SecureRandom R = new SecureRandom();
    private static final String[][] TEST_VECTORS_RFC5794 = new String[][]{{"128-Bit Key", "000102030405060708090a0b0c0d0e0f", "00112233445566778899aabbccddeeff", "d718fbd6ab644c739da95f3be6451778"}, {"192-Bit Key", "000102030405060708090a0b0c0d0e0f1011121314151617", "00112233445566778899aabbccddeeff", "26449c1805dbe7aa25a468ce263a9e79"}, {"256-Bit Key", "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "00112233445566778899aabbccddeeff", "f92bd7c79fb72e2f2b8f80c1972d24fc"}};

    public String getName() {
        return "ARIA";
    }

    public void performTest() throws Exception {
        this.checkTestVectors_RFC5794();
        int i = 0;
        while (i < 100) {
            this.checkRandomRoundtrips();
            ++i;
        }
        new MyARIAEngine().checkImplementation();
    }

    private void checkRandomRoundtrips() {
        ARIAEngine ce = new ARIAEngine();
        ARIAEngine cd = new ARIAEngine();
        byte[] txt = new byte[ce.getBlockSize()];
        byte[] enc = new byte[ce.getBlockSize()];
        byte[] dec = new byte[ce.getBlockSize()];
        int keyLen = 16;
        while (keyLen <= 32) {
            byte[] K = new byte[keyLen];
            R.nextBytes(K);
            KeyParameter key = new KeyParameter(K);
            ce.init(true, (CipherParameters)key);
            cd.init(false, (CipherParameters)key);
            R.nextBytes(txt);
            int i = 0;
            while (i < 100) {
                ce.processBlock(txt, 0, enc, 0);
                cd.processBlock(enc, 0, dec, 0);
                this.isTrue(Arrays.areEqual((byte[])txt, (byte[])dec));
                System.arraycopy(enc, 0, txt, 0, enc.length);
                ++i;
            }
            keyLen += 8;
        }
    }

    private void checkTestVector_RFC5794(String[] tv) {
        String name = "'" + tv[0] + "'";
        ARIAEngine c = new ARIAEngine();
        int blockSize = c.getBlockSize();
        this.isTrue("Wrong block size returned from getBlockSize() for " + name, 16 == blockSize);
        KeyParameter key = new KeyParameter(Hex.decode((String)tv[1]));
        byte[] plaintext = Hex.decode((String)tv[2]);
        byte[] ciphertext = Hex.decode((String)tv[3]);
        this.isTrue("Unexpected plaintext length for " + name, blockSize == plaintext.length);
        this.isTrue("Unexpected ciphertext length for " + name, blockSize == ciphertext.length);
        c.init(true, (CipherParameters)key);
        byte[] actual = new byte[blockSize];
        int num = c.processBlock(plaintext, 0, actual, 0);
        this.isTrue("Wrong length returned from processBlock() (encryption) for " + name, blockSize == num);
        this.isTrue("Incorrect ciphertext computed for " + name, Arrays.areEqual((byte[])ciphertext, (byte[])actual));
        c.init(false, (CipherParameters)key);
        num = c.processBlock(ciphertext, 0, actual, 0);
        this.isTrue("Wrong length returned from processBlock() (decryption) for " + name, blockSize == num);
        this.isTrue("Incorrect plaintext computed for " + name, Arrays.areEqual((byte[])plaintext, (byte[])actual));
    }

    private void checkTestVectors_RFC5794() {
        int i = 0;
        while (i < TEST_VECTORS_RFC5794.length) {
            this.checkTestVector_RFC5794(TEST_VECTORS_RFC5794[i]);
            ++i;
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new ARIATest());
    }

    private class MyARIAEngine
    extends ARIAEngine {
        private MyARIAEngine() {
        }

        public void checkImplementation() {
            this.checkInvolution();
            this.checkSBoxes();
        }

        private void checkInvolution() {
            byte[] x = new byte[16];
            byte[] y = new byte[16];
            int i = 0;
            while (i < 100) {
                R.nextBytes(x);
                System.arraycopy(x, 0, y, 0, 16);
                ARIAEngine.A((byte[])y);
                ARIAEngine.A((byte[])y);
                ARIATest.super.isTrue(Arrays.areEqual((byte[])x, (byte[])y));
                ++i;
            }
        }

        private void checkSBoxes() {
            int i = 0;
            while (i < 256) {
                byte x = (byte)i;
                ARIATest.super.isTrue(x == ARIAEngine.SB1((byte)ARIAEngine.SB3((byte)x)));
                ARIATest.super.isTrue(x == ARIAEngine.SB3((byte)ARIAEngine.SB1((byte)x)));
                ARIATest.super.isTrue(x == ARIAEngine.SB2((byte)ARIAEngine.SB4((byte)x)));
                ARIATest.super.isTrue(x == ARIAEngine.SB4((byte)ARIAEngine.SB2((byte)x)));
                ++i;
            }
        }
    }
}

