/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESWrapPadEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.test.RNGUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class AESWrapPadTest
extends SimpleTest {
    private final int numOfRandomIterations = 100;

    private void wrapAndUnwrap(byte[] kek, byte[] key, byte[] expected) throws Exception {
        AESWrapPadEngine wrapper = new AESWrapPadEngine();
        wrapper.init(true, (CipherParameters)new KeyParameter(kek));
        byte[] cipherText = wrapper.wrap(key, 0, key.length);
        if (!this.areEqual(cipherText, expected)) {
            this.fail("Wrapped value does not match expected.");
        }
        wrapper.init(false, (CipherParameters)new KeyParameter(kek));
        byte[] plainText = wrapper.unwrap(cipherText, 0, cipherText.length);
        if (!this.areEqual(key, plainText)) {
            this.fail("Unwrapped value does not match original.");
        }
    }

    private void wrapAndUnwrap(byte[] kek, byte[] key) throws Exception {
        AESWrapPadEngine wrapper = new AESWrapPadEngine();
        wrapper.init(true, (CipherParameters)new KeyParameter(kek));
        byte[] cipherText = wrapper.wrap(key, 0, key.length);
        wrapper.init(false, (CipherParameters)new KeyParameter(kek));
        byte[] plainText = wrapper.unwrap(cipherText, 0, cipherText.length);
        if (!this.areEqual(key, plainText)) {
            this.fail("Unwrapped value does not match original.");
        }
    }

    private void wrapWithIVTest() throws Exception {
        byte[] kek = Hex.decode((String)"5840df6e29b02af1ab493b705bf16ea1ae8338f4dcc176a8");
        byte[] key = Hex.decode((String)"c37b7e6492584340bed12207808941155068f738");
        byte[] expected = Hex.decode((String)"5cbdb3fb71351d0e628b85dbcba1a1890d4db26d1335e11d1aabea11124caad0");
        AESWrapPadEngine wrapper = new AESWrapPadEngine();
        wrapper.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(kek), Hex.decode((String)"33333333")));
        byte[] cipherText = wrapper.wrap(key, 0, key.length);
        if (!this.areEqual(cipherText, expected)) {
            this.fail("Wrapped value does not match expected.");
        }
        wrapper.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(kek), Hex.decode((String)"33333333")));
        byte[] plainText = wrapper.unwrap(cipherText, 0, cipherText.length);
        if (!this.areEqual(key, plainText)) {
            this.fail("Unwrapped value does not match original.");
        }
    }

    public String getName() {
        return "AESWrapPad";
    }

    public void performTest() throws Exception {
        byte[] kek = Hex.decode((String)"5840df6e29b02af1ab493b705bf16ea1ae8338f4dcc176a8");
        byte[] key = Hex.decode((String)"c37b7e6492584340bed12207808941155068f738");
        byte[] wrap = Hex.decode((String)"138bdeaa9b8fa7fc61f97742e72248ee5ae6ae5360d1ae6a5f54f373fa543b6a");
        this.wrapAndUnwrap(kek, key, wrap);
        wrap = Hex.decode((String)"afbeb0f07dfbf5419200f2ccb50bb24f");
        key = Hex.decode((String)"466f7250617369");
        this.wrapAndUnwrap(kek, key, wrap);
        this.wrapWithIVTest();
        AESWrapPadEngine wrapper = new AESWrapPadEngine();
        byte[] pText = new byte[5 + key.length];
        System.arraycopy(key, 0, pText, 5, key.length);
        wrapper.init(true, (CipherParameters)new KeyParameter(kek));
        byte[] cText = wrapper.wrap(pText, 5, key.length);
        if (!Arrays.areEqual((byte[])cText, (byte[])wrap)) {
            this.fail("failed offset wrap test expected " + new String(Hex.encode((byte[])wrap)) + " got " + new String(Hex.encode((byte[])cText)));
        }
        wrapper.init(false, (CipherParameters)new KeyParameter(kek));
        cText = new byte[6 + wrap.length];
        System.arraycopy(wrap, 0, cText, 6, wrap.length);
        pText = wrapper.unwrap(cText, 6, wrap.length);
        if (!Arrays.areEqual((byte[])pText, (byte[])key)) {
            this.fail("failed offset unwrap test expected " + new String(Hex.encode((byte[])key)) + " got " + new String(Hex.encode((byte[])pText)));
        }
        SecureRandom rnd = new SecureRandom();
        int i = 0;
        while (i < 100) {
            boolean shouldIncrease;
            int kekLength = 128;
            boolean bl = shouldIncrease = (rnd.nextInt() & 1) != 0;
            if (shouldIncrease) {
                kekLength = 256;
            }
            kek = new byte[kekLength / 8];
            rnd.nextBytes(kek);
            int keyToWrapSize = RNGUtils.nextInt(rnd, 24) + 8;
            byte[] keyToWrap = new byte[keyToWrapSize];
            rnd.nextBytes(keyToWrap);
            this.wrapAndUnwrap(kek, keyToWrap);
            ++i;
        }
        this.performFailTests();
    }

    private void performFailTests() {
        byte[] kek = Hex.decode((String)"5840df6e29b02af1ab493b705bf16ea1ae8338f4dcc176a8");
        AESWrapPadEngine wrapper = new AESWrapPadEngine();
        wrapper.init(false, (CipherParameters)new KeyParameter(kek));
        try {
            wrapper.unwrap(new byte[23], 0, 23);
            this.fail("Data which was not a multiple of 8 bytes was accepted");
        }
        catch (InvalidCipherTextException e) {
            // empty catch block
        }
        try {
            wrapper.unwrap(new byte[0], 0, 0);
            this.fail("Data of zero bytes was accepted");
        }
        catch (InvalidCipherTextException e) {
            // empty catch block
        }
        try {
            wrapper.unwrap(new byte[8], 0, 8);
            this.fail("Data which was not a multiple of 8 bytes was accepted");
        }
        catch (InvalidCipherTextException e) {
            // empty catch block
        }
        try {
            wrapper.unwrap(Hex.decode((String)"000000000000000000000000000000000000000000000000"), 0, 24);
            this.fail("Invalid data was accepted");
        }
        catch (InvalidCipherTextException e) {
            // empty catch block
        }
        try {
            wrapper.unwrap(Hex.decode((String)"000000000000000000000000000000000000000000000002"), 0, 24);
            this.fail("Invalid data was accepted");
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new AESWrapPadTest());
    }
}

