/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESLightEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.test.BlockCipherMonteCarloTest;
import org.bouncycastle.crypto.test.BlockCipherVectorTest;
import org.bouncycastle.crypto.test.CipherTest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class AESLightTest
extends CipherTest {
    static SimpleTest[] tests = new SimpleTest[]{new BlockCipherVectorTest(0, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"80000000000000000000000000000000")), "00000000000000000000000000000000", "0EDD33D3C621E546455BD8BA1418BEC8"), new BlockCipherVectorTest(1, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"00000000000000000000000000000080")), "00000000000000000000000000000000", "172AEAB3D507678ECAF455C12587ADB7"), new BlockCipherMonteCarloTest(2, 10000, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"00000000000000000000000000000000")), "00000000000000000000000000000000", "C34C052CC0DA8D73451AFE5F03BE297F"), new BlockCipherMonteCarloTest(3, 10000, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"5F060D3716B345C253F6749ABAC10917")), "355F697E8B868B65B25A04E18D782AFA", "ACC863637868E3E068D2FD6E3508454A"), new BlockCipherVectorTest(4, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "6CD02513E8D4DC986B4AFE087A60BD0C"), new BlockCipherMonteCarloTest(5, 10000, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"AAFE47EE82411A2BF3F6752AE8D7831138F041560631B114")), "F3F6752AE8D7831138F041560631B114", "77BA00ED5412DFF27C8ED91F3C376172"), new BlockCipherVectorTest(6, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"0000000000000000000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "DDC6BF790C15760D8D9AEB6F9A75FD4E"), new BlockCipherMonteCarloTest(7, 10000, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"28E79E2AFC5F7745FCCABE2F6257C2EF4C4EDFB37324814ED4137C288711A386")), "C737317FE0846F132B23C8C2A672CE22", "E58B82BFBA53C0040DC610C642121168"), new BlockCipherVectorTest(8, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"80000000000000000000000000000000")), "00000000000000000000000000000000", "0EDD33D3C621E546455BD8BA1418BEC8"), new BlockCipherVectorTest(9, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"00000000000000000000000000000080")), "00000000000000000000000000000000", "172AEAB3D507678ECAF455C12587ADB7"), new BlockCipherMonteCarloTest(10, 10000, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"00000000000000000000000000000000")), "00000000000000000000000000000000", "C34C052CC0DA8D73451AFE5F03BE297F"), new BlockCipherMonteCarloTest(11, 10000, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"5F060D3716B345C253F6749ABAC10917")), "355F697E8B868B65B25A04E18D782AFA", "ACC863637868E3E068D2FD6E3508454A"), new BlockCipherVectorTest(12, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "6CD02513E8D4DC986B4AFE087A60BD0C"), new BlockCipherMonteCarloTest(13, 10000, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"AAFE47EE82411A2BF3F6752AE8D7831138F041560631B114")), "F3F6752AE8D7831138F041560631B114", "77BA00ED5412DFF27C8ED91F3C376172"), new BlockCipherVectorTest(14, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"0000000000000000000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "DDC6BF790C15760D8D9AEB6F9A75FD4E"), new BlockCipherMonteCarloTest(15, 10000, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"28E79E2AFC5F7745FCCABE2F6257C2EF4C4EDFB37324814ED4137C288711A386")), "C737317FE0846F132B23C8C2A672CE22", "E58B82BFBA53C0040DC610C642121168"), new BlockCipherVectorTest(16, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"80000000000000000000000000000000")), "00000000000000000000000000000000", "0EDD33D3C621E546455BD8BA1418BEC8"), new BlockCipherVectorTest(17, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"00000000000000000000000000000080")), "00000000000000000000000000000000", "172AEAB3D507678ECAF455C12587ADB7"), new BlockCipherMonteCarloTest(18, 10000, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"00000000000000000000000000000000")), "00000000000000000000000000000000", "C34C052CC0DA8D73451AFE5F03BE297F"), new BlockCipherMonteCarloTest(19, 10000, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"5F060D3716B345C253F6749ABAC10917")), "355F697E8B868B65B25A04E18D782AFA", "ACC863637868E3E068D2FD6E3508454A"), new BlockCipherVectorTest(20, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "6CD02513E8D4DC986B4AFE087A60BD0C"), new BlockCipherMonteCarloTest(21, 10000, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"AAFE47EE82411A2BF3F6752AE8D7831138F041560631B114")), "F3F6752AE8D7831138F041560631B114", "77BA00ED5412DFF27C8ED91F3C376172"), new BlockCipherVectorTest(22, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"0000000000000000000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "DDC6BF790C15760D8D9AEB6F9A75FD4E"), new BlockCipherMonteCarloTest(23, 10000, (BlockCipher)new AESLightEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"28E79E2AFC5F7745FCCABE2F6257C2EF4C4EDFB37324814ED4137C288711A386")), "C737317FE0846F132B23C8C2A672CE22", "E58B82BFBA53C0040DC610C642121168")};
    private BlockCipher _engine = new AESLightEngine();

    AESLightTest() {
        super(tests, (BlockCipher)new AESLightEngine(), new KeyParameter(new byte[16]));
    }

    public String getName() {
        return "AESLight";
    }

    public void performTest() throws Exception {
        super.performTest();
        byte[] keyBytes = new byte[16];
        this._engine.init(true, (CipherParameters)new KeyParameter(keyBytes));
        try {
            byte[] dudKey = new byte[6];
            this._engine.init(true, (CipherParameters)new KeyParameter(dudKey));
            this.fail("failed key length check");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            byte[] iv = new byte[16];
            this._engine.init(true, (CipherParameters)new ParametersWithIV(null, iv));
            this.fail("failed parameter check");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new AESLightTest());
    }
}

