/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.prng.test;

import org.bouncycastle.crypto.prng.FixedSecureRandom;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class FixedSecureRandomTest
extends SimpleTest {
    byte[] base = Hex.decode((String)"deadbeefdeadbeef");
    byte[] r1 = Hex.decode((String)"cafebabecafebabe");
    byte[] r2 = Hex.decode((String)"ffffffffcafebabedeadbeef");

    public String getName() {
        return "FixedSecureRandom";
    }

    public void performTest() throws Exception {
        byte[] seed;
        FixedSecureRandom fixed = new FixedSecureRandom(this.base);
        byte[] buf = new byte[8];
        fixed.nextBytes(buf);
        if (!Arrays.areEqual((byte[])buf, (byte[])this.base)) {
            this.fail("wrong data returned");
        }
        if (!Arrays.areEqual((byte[])(seed = (fixed = new FixedSecureRandom(this.base)).generateSeed(8)), (byte[])this.base)) {
            this.fail("wrong seed data returned");
        }
        if (!fixed.isExhausted()) {
            this.fail("not exhausted");
        }
        if (!Arrays.areEqual((byte[])(seed = (fixed = new FixedSecureRandom((byte[][])new byte[][]{this.r1, this.r2})).generateSeed(12)), (byte[])Hex.decode((String)"cafebabecafebabeffffffff"))) {
            this.fail("wrong seed data returned - composite");
        }
        fixed.nextBytes(buf);
        if (!Arrays.areEqual((byte[])buf, (byte[])Hex.decode((String)"cafebabedeadbeef"))) {
            this.fail("wrong data returned");
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new FixedSecureRandomTest());
    }
}

