/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.agreement.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.SavableDigest;
import org.bouncycastle.crypto.agreement.jpake.JPAKEPrimeOrderGroup;
import org.bouncycastle.crypto.agreement.jpake.JPAKEPrimeOrderGroups;
import org.bouncycastle.crypto.agreement.jpake.JPAKEUtil;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;

public class JPAKEUtilTest
extends TestCase {
    private static final BigInteger TEN = BigInteger.valueOf(10L);

    public void testValidateGx4() throws CryptoException {
        JPAKEUtil.validateGx4((BigInteger)TEN);
        try {
            JPAKEUtil.validateGx4((BigInteger)BigInteger.ONE);
            Assert.fail();
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    public void testValidateGa() throws CryptoException {
        JPAKEUtil.validateGa((BigInteger)TEN);
        try {
            JPAKEUtil.validateGa((BigInteger)BigInteger.ONE);
            Assert.fail();
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    public void testValidateParticipantIdsDiffer() throws CryptoException {
        JPAKEUtil.validateParticipantIdsDiffer((String)"a", (String)"b");
        JPAKEUtil.validateParticipantIdsDiffer((String)"a", (String)"A");
        try {
            JPAKEUtil.validateParticipantIdsDiffer((String)"a", (String)"a");
            Assert.fail();
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    public void testValidateParticipantIdsEqual() throws CryptoException {
        JPAKEUtil.validateParticipantIdsEqual((String)"a", (String)"a");
        try {
            JPAKEUtil.validateParticipantIdsEqual((String)"a", (String)"b");
            Assert.fail();
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    public void testValidateMacTag() throws CryptoException {
        JPAKEPrimeOrderGroup pg1 = JPAKEPrimeOrderGroups.SUN_JCE_1024;
        SecureRandom random = new SecureRandom();
        SavableDigest digest = SHA256Digest.newInstance();
        BigInteger x1 = JPAKEUtil.generateX1((BigInteger)pg1.getQ(), (SecureRandom)random);
        BigInteger x2 = JPAKEUtil.generateX2((BigInteger)pg1.getQ(), (SecureRandom)random);
        BigInteger x3 = JPAKEUtil.generateX1((BigInteger)pg1.getQ(), (SecureRandom)random);
        BigInteger x4 = JPAKEUtil.generateX2((BigInteger)pg1.getQ(), (SecureRandom)random);
        BigInteger gx1 = JPAKEUtil.calculateGx((BigInteger)pg1.getP(), (BigInteger)pg1.getG(), (BigInteger)x1);
        BigInteger gx2 = JPAKEUtil.calculateGx((BigInteger)pg1.getP(), (BigInteger)pg1.getG(), (BigInteger)x2);
        BigInteger gx3 = JPAKEUtil.calculateGx((BigInteger)pg1.getP(), (BigInteger)pg1.getG(), (BigInteger)x3);
        BigInteger gx4 = JPAKEUtil.calculateGx((BigInteger)pg1.getP(), (BigInteger)pg1.getG(), (BigInteger)x4);
        BigInteger gB = JPAKEUtil.calculateGA((BigInteger)pg1.getP(), (BigInteger)gx3, (BigInteger)gx1, (BigInteger)gx2);
        BigInteger s = JPAKEUtil.calculateS((BigInteger)pg1.getQ(), (char[])"password".toCharArray());
        BigInteger xs = JPAKEUtil.calculateX2s((BigInteger)pg1.getQ(), (BigInteger)x4, (BigInteger)s);
        BigInteger B = JPAKEUtil.calculateA((BigInteger)pg1.getP(), (BigInteger)pg1.getQ(), (BigInteger)gB, (BigInteger)xs);
        BigInteger keyingMaterial = JPAKEUtil.calculateKeyingMaterial((BigInteger)pg1.getP(), (BigInteger)pg1.getQ(), (BigInteger)gx4, (BigInteger)x2, (BigInteger)s, (BigInteger)B);
        BigInteger macTag = JPAKEUtil.calculateMacTag((String)"participantId", (String)"partnerParticipantId", (BigInteger)gx1, (BigInteger)gx2, (BigInteger)gx3, (BigInteger)gx4, (BigInteger)keyingMaterial, (Digest)digest);
        JPAKEUtil.validateMacTag((String)"partnerParticipantId", (String)"participantId", (BigInteger)gx3, (BigInteger)gx4, (BigInteger)gx1, (BigInteger)gx2, (BigInteger)keyingMaterial, (Digest)digest, (BigInteger)macTag);
        try {
            JPAKEUtil.validateMacTag((String)"participantId", (String)"partnerParticipantId", (BigInteger)gx1, (BigInteger)gx2, (BigInteger)gx3, (BigInteger)gx4, (BigInteger)keyingMaterial, (Digest)digest, (BigInteger)macTag);
            Assert.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        try {
            JPAKEUtil.validateMacTag((String)"participantId", (String)"partnerParticipantId", (BigInteger)gx3, (BigInteger)gx4, (BigInteger)gx1, (BigInteger)gx2, (BigInteger)keyingMaterial, (Digest)digest, (BigInteger)macTag);
            Assert.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
    }

    public void testValidateNotNull() {
        JPAKEUtil.validateNotNull((Object)"a", (String)"description");
        try {
            JPAKEUtil.validateNotNull(null, (String)"description");
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testValidateZeroKnowledgeProof() throws CryptoException {
        JPAKEPrimeOrderGroup pg1 = JPAKEPrimeOrderGroups.SUN_JCE_1024;
        SecureRandom random = new SecureRandom();
        SavableDigest digest1 = SHA256Digest.newInstance();
        BigInteger x1 = JPAKEUtil.generateX1((BigInteger)pg1.getQ(), (SecureRandom)random);
        BigInteger gx1 = JPAKEUtil.calculateGx((BigInteger)pg1.getP(), (BigInteger)pg1.getG(), (BigInteger)x1);
        String participantId1 = "participant1";
        BigInteger[] zkp1 = JPAKEUtil.calculateZeroKnowledgeProof((BigInteger)pg1.getP(), (BigInteger)pg1.getQ(), (BigInteger)pg1.getG(), (BigInteger)gx1, (BigInteger)x1, (String)participantId1, (Digest)digest1, (SecureRandom)random);
        JPAKEUtil.validateZeroKnowledgeProof((BigInteger)pg1.getP(), (BigInteger)pg1.getQ(), (BigInteger)pg1.getG(), (BigInteger)gx1, (BigInteger[])zkp1, (String)participantId1, (Digest)digest1);
        JPAKEPrimeOrderGroup pg2 = JPAKEPrimeOrderGroups.NIST_3072;
        try {
            JPAKEUtil.validateZeroKnowledgeProof((BigInteger)pg2.getP(), (BigInteger)pg2.getQ(), (BigInteger)pg2.getG(), (BigInteger)gx1, (BigInteger[])zkp1, (String)participantId1, (Digest)digest1);
            Assert.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        SHA1Digest digest2 = new SHA1Digest();
        try {
            JPAKEUtil.validateZeroKnowledgeProof((BigInteger)pg1.getP(), (BigInteger)pg1.getQ(), (BigInteger)pg1.getG(), (BigInteger)gx1, (BigInteger[])zkp1, (String)participantId1, (Digest)digest2);
            Assert.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        String participantId2 = "participant2";
        try {
            JPAKEUtil.validateZeroKnowledgeProof((BigInteger)pg1.getP(), (BigInteger)pg1.getQ(), (BigInteger)pg1.getG(), (BigInteger)gx1, (BigInteger[])zkp1, (String)participantId2, (Digest)digest1);
            Assert.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        BigInteger x2 = JPAKEUtil.generateX1((BigInteger)pg1.getQ(), (SecureRandom)random);
        BigInteger gx2 = JPAKEUtil.calculateGx((BigInteger)pg1.getP(), (BigInteger)pg1.getG(), (BigInteger)x2);
        try {
            JPAKEUtil.validateZeroKnowledgeProof((BigInteger)pg1.getP(), (BigInteger)pg1.getQ(), (BigInteger)pg1.getG(), (BigInteger)gx2, (BigInteger[])zkp1, (String)participantId1, (Digest)digest1);
            Assert.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        BigInteger[] zkp2 = JPAKEUtil.calculateZeroKnowledgeProof((BigInteger)pg1.getP(), (BigInteger)pg1.getQ(), (BigInteger)pg1.getG(), (BigInteger)gx2, (BigInteger)x2, (String)participantId1, (Digest)digest1, (SecureRandom)random);
        try {
            JPAKEUtil.validateZeroKnowledgeProof((BigInteger)pg1.getP(), (BigInteger)pg1.getQ(), (BigInteger)pg1.getG(), (BigInteger)gx1, (BigInteger[])zkp2, (String)participantId1, (Digest)digest1);
            Assert.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        try {
            JPAKEUtil.validateZeroKnowledgeProof((BigInteger)pg1.getP(), (BigInteger)pg1.getQ(), (BigInteger)pg1.getG(), (BigInteger)BigInteger.ZERO, (BigInteger[])zkp1, (String)participantId1, (Digest)digest1);
            Assert.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        try {
            JPAKEUtil.validateZeroKnowledgeProof((BigInteger)pg1.getP(), (BigInteger)pg1.getQ(), (BigInteger)pg1.getG(), (BigInteger)pg1.getP(), (BigInteger[])zkp1, (String)participantId1, (Digest)digest1);
            Assert.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        try {
            JPAKEUtil.validateZeroKnowledgeProof((BigInteger)pg1.getP(), (BigInteger)pg1.getQ(), (BigInteger)pg1.getG(), (BigInteger)pg1.getQ().add(BigInteger.ONE), (BigInteger[])zkp1, (String)participantId1, (Digest)digest1);
            Assert.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
    }
}

