/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jcajce.interfaces.MLDSAKey;
import org.bouncycastle.jcajce.interfaces.SLHDSAKey;
import org.bouncycastle.jcajce.spec.MLDSAParameterSpec;
import org.bouncycastle.jcajce.spec.SLHDSAParameterSpec;
import org.bouncycastle.jce.X509KeyUsage;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pqc.jcajce.interfaces.FalconKey;
import org.bouncycastle.pqc.jcajce.interfaces.PicnicKey;
import org.bouncycastle.pqc.jcajce.spec.FalconParameterSpec;
import org.bouncycastle.pqc.jcajce.spec.PicnicParameterSpec;
import org.bouncycastle.pqc.jcajce.spec.SPHINCS256KeyGenParameterSpec;
import org.bouncycastle.pqc.jcajce.spec.SPHINCSPlusParameterSpec;

public class PQCTestUtil {
    public static KeyPair makeKeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("SPHINCS256", "BCPQC");
        kpGen.initialize((AlgorithmParameterSpec)new SPHINCS256KeyGenParameterSpec(), new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static KeyPair makeSphincsPlusKeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("SPHINCSPlus", "BCPQC");
        kpGen.initialize((AlgorithmParameterSpec)SPHINCSPlusParameterSpec.sha2_128f_robust, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static KeyPair makeFalconKeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("Falcon", "BCPQC");
        kpGen.initialize((AlgorithmParameterSpec)FalconParameterSpec.falcon_512, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static KeyPair makePicnicKeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("Picnic", "BCPQC");
        kpGen.initialize((AlgorithmParameterSpec)PicnicParameterSpec.picnicl1full, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static KeyPair makeMlDsaKeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("ML-DSA", "BC");
        kpGen.initialize((AlgorithmParameterSpec)MLDSAParameterSpec.ml_dsa_65, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static KeyPair makeSlhDsaKeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("SLH-DSA", "BC");
        kpGen.initialize((AlgorithmParameterSpec)SLHDSAParameterSpec.slh_dsa_sha2_128f, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static X509Certificate makeCertificate(KeyPair subKP, String subDN, KeyPair issKP, String issDN) throws Exception {
        PrivateKey issPriv = issKP.getPrivate();
        ContentSigner sigGen = issPriv instanceof FalconKey ? new JcaContentSignerBuilder(((FalconKey)issPriv).getParameterSpec().getName()).setProvider("BCPQC").build(issPriv) : (issPriv instanceof PicnicKey ? new JcaContentSignerBuilder("PICNIC").setProvider("BCPQC").build(issPriv) : (issPriv instanceof MLDSAKey ? new JcaContentSignerBuilder("ML-DSA").setProvider("BC").build(issPriv) : (issPriv instanceof SLHDSAKey ? new JcaContentSignerBuilder("SLH-DSA").setProvider("BC").build(issPriv) : new JcaContentSignerBuilder("SHA512withSPHINCS256").setProvider("BCPQC").build(issPriv))));
        X509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(new X500Name(issDN), BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), new X500Name(subDN), subKP.getPublic()).addExtension(new ASN1ObjectIdentifier("2.5.29.15"), true, (ASN1Encodable)new X509KeyUsage(128)).addExtension(new ASN1ObjectIdentifier("2.5.29.37"), true, (ASN1Encodable)new DERSequence((ASN1Encodable)KeyPurposeId.anyExtendedKeyUsage));
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certGen.build(sigGen));
    }
}

