/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.test.CMSTestSetup;
import org.bouncycastle.cms.test.PQCTestUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class PQCSignedDataTest
extends TestCase {
    private static final String BC = "BC";
    private static final String BCPQC = BouncyCastlePQCProvider.PROVIDER_NAME;
    boolean DEBUG = true;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static KeyPair _origFalconKP;
    private static X509Certificate _origFalconCert;
    private static KeyPair _origPicnicKP;
    private static X509Certificate _origPicnicCert;
    private static KeyPair _origMlDsaKP;
    private static X509Certificate _origMlDsaCert;
    private static KeyPair _origSlhDsaKP;
    private static X509Certificate _origSlhDsaCert;
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static KeyPair _signFalconKP;
    private static X509Certificate _signFalconCert;
    private static KeyPair _signPicnicKP;
    private static X509Certificate _signPicnicCert;
    private static KeyPair _signMlDsaKP;
    private static X509Certificate _signMlDsaCert;
    private static KeyPair _signSlhDsaKP;
    private static X509Certificate _signSlhDsaCert;
    private static boolean _initialised;
    private static final Set noParams;
    static /* synthetic */ Class class$org$bouncycastle$cms$test$PQCSignedDataTest;

    public PQCSignedDataTest(String name) {
        super(name);
    }

    public static void main(String[] args) throws Exception {
        PQCSignedDataTest.init();
        TestRunner.run((Class)(class$org$bouncycastle$cms$test$PQCSignedDataTest == null ? (class$org$bouncycastle$cms$test$PQCSignedDataTest = PQCSignedDataTest.class$("org.bouncycastle.cms.test.PQCSignedDataTest")) : class$org$bouncycastle$cms$test$PQCSignedDataTest));
    }

    public static Test suite() throws Exception {
        PQCSignedDataTest.init();
        return new CMSTestSetup((Test)new TestSuite(class$org$bouncycastle$cms$test$PQCSignedDataTest == null ? (class$org$bouncycastle$cms$test$PQCSignedDataTest = PQCSignedDataTest.class$("org.bouncycastle.cms.test.PQCSignedDataTest")) : class$org$bouncycastle$cms$test$PQCSignedDataTest));
    }

    public void setUp() throws Exception {
        PQCSignedDataTest.init();
    }

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            if (Security.getProvider(BC) == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            if (Security.getProvider(BCPQC) == null) {
                Security.addProvider((Provider)new BouncyCastlePQCProvider());
            }
            _origDN = "O=Bouncy Castle, C=AU";
            _origKP = PQCTestUtil.makeKeyPair();
            _origCert = PQCTestUtil.makeCertificate(_origKP, _origDN, _origKP, _origDN);
            _signDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _signKP = PQCTestUtil.makeKeyPair();
            _signCert = PQCTestUtil.makeCertificate(_signKP, _signDN, _origKP, _origDN);
            _origFalconKP = PQCTestUtil.makeFalconKeyPair();
            _origFalconCert = PQCTestUtil.makeCertificate(_origFalconKP, _origDN, _origFalconKP, _origDN);
            _signFalconKP = PQCTestUtil.makeFalconKeyPair();
            _signFalconCert = PQCTestUtil.makeCertificate(_signFalconKP, _signDN, _origFalconKP, _origDN);
            _origPicnicKP = PQCTestUtil.makePicnicKeyPair();
            _origPicnicCert = PQCTestUtil.makeCertificate(_origPicnicKP, _origDN, _origPicnicKP, _origDN);
            _signPicnicKP = PQCTestUtil.makePicnicKeyPair();
            _signPicnicCert = PQCTestUtil.makeCertificate(_signPicnicKP, _signDN, _origPicnicKP, _origDN);
            _origMlDsaKP = PQCTestUtil.makeMlDsaKeyPair();
            _origMlDsaCert = PQCTestUtil.makeCertificate(_origMlDsaKP, _origDN, _origMlDsaKP, _origDN);
            _signMlDsaKP = PQCTestUtil.makeMlDsaKeyPair();
            _signMlDsaCert = PQCTestUtil.makeCertificate(_signMlDsaKP, _signDN, _origMlDsaKP, _origDN);
            _origSlhDsaKP = PQCTestUtil.makeSlhDsaKeyPair();
            _origSlhDsaCert = PQCTestUtil.makeCertificate(_origSlhDsaKP, _origDN, _origSlhDsaKP, _origDN);
            _signSlhDsaKP = PQCTestUtil.makeSlhDsaKeyPair();
            _signSlhDsaCert = PQCTestUtil.makeCertificate(_signSlhDsaKP, _signDN, _origSlhDsaKP, _origDN);
        }
    }

    public void testSPHINCS256Encapsulated() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(digCalcProv).build(new JcaContentSignerBuilder("SHA512withSPHINCS256").setProvider(BCPQC).build(_origKP.getPrivate()), _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        ByteArrayInputStream bIn = new ByteArrayInputStream(s.getEncoded());
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        s = new CMSSignedData(ContentInfo.getInstance((Object)aIn.readObject()));
        certs = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        Object sid = null;
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().build(cert)));
            byte[] contentDigest = (byte[])gen.getGeneratedDigests().get(signer.getDigestAlgOID());
            AttributeTable table = signer.getSignedAttributes();
            Attribute hash = table.get(CMSAttributes.messageDigest);
            Assert.assertTrue((boolean)MessageDigest.isEqual(contentDigest, ((ASN1OctetString)hash.getAttrValues().getObjectAt(0)).getOctets()));
        }
    }

    public void testFalconEncapsulated() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_origFalconCert);
        certList.add(_signFalconCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(digCalcProv).build(new JcaContentSignerBuilder("Falcon-512").setProvider(BCPQC).build(_origFalconKP.getPrivate()), _origFalconCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        ByteArrayInputStream bIn = new ByteArrayInputStream(s.getEncoded());
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        s = new CMSSignedData(ContentInfo.getInstance((Object)aIn.readObject()));
        certs = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().build(cert)));
            byte[] contentDigest = (byte[])gen.getGeneratedDigests().get(signer.getDigestAlgOID());
            AttributeTable table = signer.getSignedAttributes();
            Attribute hash = table.get(CMSAttributes.messageDigest);
            Assert.assertTrue((boolean)MessageDigest.isEqual(contentDigest, ((ASN1OctetString)hash.getAttrValues().getObjectAt(0)).getOctets()));
        }
    }

    public void testPicnicEncapsulated() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_origPicnicCert);
        certList.add(_signPicnicCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(digCalcProv).build(new JcaContentSignerBuilder("PICNIC").setProvider(BCPQC).build(_origPicnicKP.getPrivate()), _origPicnicCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        this.checkSignature(s, gen);
    }

    public void testMLDSAEncapsulated() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_origMlDsaCert);
        certList.add(_signMlDsaCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(digCalcProv).build(new JcaContentSignerBuilder("ML-DSA").setProvider(BC).build(_origMlDsaKP.getPrivate()), _origMlDsaCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        this.checkSignature(s, gen);
    }

    public void testHashMLDSAEncapsulated() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_origMlDsaCert);
        certList.add(_signMlDsaCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(digCalcProv).build(new JcaContentSignerBuilder("HASH-ML-DSA").setProvider(BC).build(_origMlDsaKP.getPrivate()), _origMlDsaCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        this.checkSignature(s, gen);
    }

    public void testSLHDSAEncapsulated() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_origSlhDsaCert);
        certList.add(_signSlhDsaCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(digCalcProv).build(new JcaContentSignerBuilder("SLH-DSA").setProvider(BC).build(_origSlhDsaKP.getPrivate()), _origSlhDsaCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        this.checkSignature(s, gen);
    }

    public void testHashSLHDSAEncapsulated() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_origSlhDsaCert);
        certList.add(_signSlhDsaCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(digCalcProv).build(new JcaContentSignerBuilder("HASH-SLH-DSA").setProvider(BC).build(_origSlhDsaKP.getPrivate()), _origSlhDsaCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        this.checkSignature(s, gen);
    }

    private void checkSignature(CMSSignedData s, CMSSignedDataGenerator gen) throws IOException, CMSException, OperatorCreationException, CertificateException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(s.getEncoded());
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        s = new CMSSignedData(ContentInfo.getInstance((Object)aIn.readObject()));
        Store certs = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            cert.getSubjectPublicKeyInfo();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().build(cert)));
            byte[] contentDigest = (byte[])gen.getGeneratedDigests().get(signer.getDigestAlgOID());
            AttributeTable table = signer.getSignedAttributes();
            Attribute hash = table.get(CMSAttributes.messageDigest);
            Assert.assertTrue((boolean)MessageDigest.isEqual(contentDigest, ((ASN1OctetString)hash.getAttrValues().getObjectAt(0)).getOctets()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _initialised = false;
        noParams = new HashSet();
        noParams.add(BCObjectIdentifiers.sphincs256_with_SHA512);
        noParams.add(BCObjectIdentifiers.sphincs256_with_SHA3_512);
    }
}

