/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1Util;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCRLStore;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CRLHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSAttributeTableGenerationException;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.SignerInformationVerifierProvider;
import org.bouncycastle.cms.bc.BcRSASignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JcaSignerId;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.test.CMSTestSetup;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.Streams;

public class NewSignedDataTest
extends TestCase {
    private static final String BC = "BC";
    boolean DEBUG = true;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static KeyPair _signGostKP;
    private static X509Certificate _signGostCert;
    private static KeyPair _signEcDsaKP;
    private static X509Certificate _signEcDsaCert;
    private static KeyPair _signEcGostKP;
    private static X509Certificate _signEcGostCert;
    private static KeyPair _signDsaKP;
    private static X509Certificate _signDsaCert;
    private static KeyPair _signEd25519KP;
    private static X509Certificate _signEd25519Cert;
    private static KeyPair _signEd448KP;
    private static X509Certificate _signEd448Cert;
    private static String _reciDN;
    private static KeyPair _reciKP;
    private static X509Certificate _reciCert;
    private static X509CRL _signCrl;
    private static boolean _initialised;
    private byte[] disorderedMessage = Base64.decode((String)"SU9fc3RkaW5fdXNlZABfX2xpYmNfc3RhcnRfbWFpbgBnZXRob3N0aWQAX19nbW9uX3M=");
    private byte[] disorderedSet = Base64.decode((String)"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");
    public static byte[] xtraCounterSig;
    byte[] noSignedAttrSample2 = Base64.decode((String)"MIIIlAYJKoZIhvcNAQcCoIIIhTCCCIECAQExCzAJBgUrDgMCGgUAMAsGCSqGSIb3DQEHAaCCB3UwggOtMIIDa6ADAgECAgEzMAsGByqGSM44BAMFADCBkDELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRIwEAYDVQQHEwlQYWxvIEFsdG8xHTAbBgNVBAoTFFN1biBNaWNyb3N5c3RlbXMgSW5jMSMwIQYDVQQLExpKYXZhIFNvZnR3YXJlIENvZGUgU2lnbmluZzEcMBoGA1UEAxMTSkNFIENvZGUgU2lnbmluZyBDQTAeFw0wMTA1MjkxNjQ3MTFaFw0wNjA1MjgxNjQ3MTFaMG4xHTAbBgNVBAoTFFN1biBNaWNyb3N5c3RlbXMgSW5jMSMwIQYDVQQLExpKYXZhIFNvZnR3YXJlIENvZGUgU2lnbmluZzEoMCYGA1UEAxMfVGhlIExlZ2lvbiBvZiB0aGUgQm91bmN5IENhc3RsZTCCAbcwggEsBgcqhkjOOAQBMIIBHwKBgQD9f1OBHXUSKVLfSpwu7OTn9hG3UjzvRADDHj+AtlEmaUVdQCJR+1k9jVj6v8X1ujD2y5tVbNeBO4AdNG/yZmC3a5lQpaSfn+gEexAiwk+7qdf+t8Yb+DtX58aophUPBPuD9tPFHsMCNVQTWhaRMvZ1864rYdcq7/IiAxmd0UgBxwIVAJdgUI8VIwvMspK5gqLrhAvwWBz1AoGBAPfhoIXWmz3ey7yrXDa4V7l5lK+7+jrqgvlXTAs9B4JnUVlXjrrUWU/mcQcQgYC0SRZxI+hMKBYTt88JMozIpuE8FnqLVHyNKOCjrh4rs6Z1kW6jfwv6ITVi8ftiegEkO8yk8b6oUZCJqIPf4VrlnwaSi2ZegHtVJWQBTDv+z0kqA4GEAAKBgBWry/FCAZ6miyy39+ftsa+h9lxoL+JtV0MJcUyQE4VAhpAwWb8vyjba9AwOylYQTktHX5sAkFvjBiU0LOYDbFSTVZSHMRJgfjxBSHtICjOEvr1BJrrOrdzqdxcOUge5n7El124BCrv91x5Ol8UTwtiO9LrRXF/dSyK+RT5n1klRo3YwdDARBglghkgBhvhCAQEEBAMCAIcwDgYDVR0PAQH/BAQDAgHGMB0GA1UdDgQWBBQwMY4NRcco1AO3w1YsokfDLVseEjAPBgNVHRMBAf8EBTADAQH/MB8GA1UdIwQYMBaAFGXi9IbJ007wkU5Yomr12HhamsGmMAsGByqGSM44BAMFAAMvADAsAhRmigTu6QV0sTfEkVljgij/hhdVfAIUQZvMxAnIHc30y/u0C1T5UEG9glUwggPAMIIDfqADAgECAgEQMAsGByqGSM44BAMFADCBkDELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRIwEAYDVQQHEwlQYWxvIEFsdG8xHTAbBgNVBAoTFFN1biBNaWNyb3N5c3RlbXMgSW5jMSMwIQYDVQQLExpKYXZhIFNvZnR3YXJlIENvZGUgU2lnbmluZzEcMBoGA1UEAxMTSkNFIENvZGUgU2lnbmluZyBDQTAeFw0wMTA0MjUwNzAwMDBaFw0yMDA0MjUwNzAwMDBaMIGQMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExEjAQBgNVBAcTCVBhbG8gQWx0bzEdMBsGA1UEChMUU3VuIE1pY3Jvc3lzdGVtcyBJbmMxIzAhBgNVBAsTGkphdmEgU29mdHdhcmUgQ29kZSBTaWduaW5nMRwwGgYDVQQDExNKQ0UgQ29kZSBTaWduaW5nIENBMIIBtzCCASwGByqGSM44BAEwggEfAoGBAOuvNwQeylEeaV2w8o/2tUkfxqSZBdcpv3S3avUZ2B7kG/gKAZqY/3Cr4kpWhmxTs/zhyIGMMfDE87CL5nAG7PdpaNuDTHIpiSk2F1w7SgegIAIqRpdRHXDICBgLzgxum3b3BePn+9NheeFgmiSNBpWDPFEg4TDPOFeCphpyDc7TAhUAhCVF4bq5qWKreehbMLiJaxv/e3UCgYEAq8l0e3Tv7kK1alNNO92QBnJokQ8LpCl2LlU71a5NZVx+KjoEpmem0HGqpde34sFyDaTRqh6SVEwgAAmisAlBGTMAssNcrkL4sYvKfJbYEH83RFuqzHjI13J2N2tAmahVZvqoAx6LShECactMuCUGHKB30sms0j3pChD6dnC3+9wDgYQAAoGALQmYXKy4nMeZfu4gGSo0kPnXq6uu3WtylQ1m+O8nj0Sy7ShEx/6vsKYnbwBnRYJbB6hWVjvSKVFhXmk51y50dxLPGUr1LcjLcmHETm/6R0M/FLv6vBhmKMLZZot6LS/CYJJLFP5YPiF/aGK+bEhJ+aBLXoWdGRD5FUVRG3HU9wujZjBkMBEGCWCGSAGG+EIBAQQEAwIABzAPBgNVHRMBAf8EBTADAQH/MB8GA1UdIwQYMBaAFGXi9IbJ007wkU5Yomr12HhamsGmMB0GA1UdDgQWBBRl4vSGydNO8JFOWKJq9dh4WprBpjALBgcqhkjOOAQDBQADLwAwLAIUKvfPPJdd+Xi2CNdBtNkNRUzktJwCFEXNdWkOIfod1rMpsun3Mx0z/fxJMYHoMIHlAgEBMIGWMIGQMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExEjAQBgNVBAcTCVBhbG8gQWx0bzEdMBsGA1UEChMUU3VuIE1pY3Jvc3lzdGVtcyBJbmMxIzAhBgNVBAsTGkphdmEgU29mdHdhcmUgQ29kZSBTaWduaW5nMRwwGgYDVQQDExNKQ0UgQ29kZSBTaWduaW5nIENBAgEzMAkGBSsOAwIaBQAwCwYHKoZIzjgEAQUABC8wLQIVAIGVkhm+kbV4a/+EP45PHcq0hIViAhR4M9os6IrJnoEDS3Y3l7O6zrSosA==");
    private static final byte[] rawGost;
    private static final byte[] noAttrEncData;
    byte[] successResp = Base64.decode((String)"MIIFnAoBAKCCBZUwggWRBgkrBgEFBQcwAQEEggWCMIIFfjCCARehgZ8wgZwxCzAJBgNVBAYTAklOMRcwFQYDVQQIEw5BbmRocmEgcHJhZGVzaDESMBAGA1UEBxMJSHlkZXJhYmFkMQwwCgYDVQQKEwNUQ1MxDDAKBgNVBAsTA0FUQzEeMBwGA1UEAxMVVENTLUNBIE9DU1AgUmVzcG9uZGVyMSQwIgYJKoZIhvcNAQkBFhVvY3NwQHRjcy1jYS50Y3MuY28uaW4YDzIwMDMwNDAyMTIzNDU4WjBiMGAwOjAJBgUrDgMCGgUABBRs07IuoCWNmcEl1oHwIak1BPnX8QQUtGyl/iL9WJ1VxjxFj0hAwJ/s1AcCAQKhERgPMjAwMjA4MjkwNzA5MjZaGA8yMDAzMDQwMjEyMzQ1OFowDQYJKoZIhvcNAQEFBQADgYEAfbN0TCRFKdhsmvOdUoiJ+qvygGBzDxD/VWhXYA+16AphHLIWNABR3CgHB3zWtdy2j7DJmQ/R7qKj7dUhWLSqclAiPgFtQQ1YvSJAYfEIdyHkxv4NP0LSogxrumANcDyC9yt/W9yHjD2ICPBIqCsZLuLkOHYi5DlwWe9Zm9VFwCGgggPMMIIDyDCCA8QwggKsoAMCAQICAQYwDQYJKoZIhvcNAQEFBQAwgZQxFDASBgNVBAMTC1RDUy1DQSBPQ1NQMSYwJAYJKoZIhvcNAQkBFhd0Y3MtY2FAdGNzLWNhLnRjcy5jby5pbjEMMAoGA1UEChMDVENTMQwwCgYDVQQLEwNBVEMxEjAQBgNVBAcTCUh5ZGVyYWJhZDEXMBUGA1UECBMOQW5kaHJhIHByYWRlc2gxCzAJBgNVBAYTAklOMB4XDTAyMDgyOTA3MTE0M1oXDTAzMDgyOTA3MTE0M1owgZwxCzAJBgNVBAYTAklOMRcwFQYDVQQIEw5BbmRocmEgcHJhZGVzaDESMBAGA1UEBxMJSHlkZXJhYmFkMQwwCgYDVQQKEwNUQ1MxDDAKBgNVBAsTA0FUQzEeMBwGA1UEAxMVVENTLUNBIE9DU1AgUmVzcG9uZGVyMSQwIgYJKoZIhvcNAQkBFhVvY3NwQHRjcy1jYS50Y3MuY28uaW4wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAM+XWW4caMRv46D7L6Bv8iwtKgmQu0SAybmFRJiz12qXzdvTLt8C75OdgmUomxp0+gW/4XlTPUqOMQWv463aZRv9Ust4f8MHEJh4ekP/NS9+d8vEO3P40ntQkmSMcFmtA9E1koUtQ3MSJlcs441JjbgUaVnmjDmmniQnZY4bU3tVAgMBAAGjgZowgZcwDAYDVR0TAQH/BAIwADALBgNVHQ8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwkwNgYIKwYBBQUHAQEEKjAoMCYGCCsGAQUFBzABhhpodHRwOi8vMTcyLjE5LjQwLjExMDo3NzAwLzAtBgNVHR8EJjAkMCKgIKAehhxodHRwOi8vMTcyLjE5LjQwLjExMC9jcmwuY3JsMA0GCSqGSIb3DQEBBQUAA4IBAQB6FovM3B4VDDZ15o12gnADZsIk9fTAczLlcrmXLNN4PgmqgnwF0Ymj3bD5SavDOXxbA65AZJ7rBNAguLUo+xVkgxmoBH7R2sBxjTCcr07NEadxM3HQkt0aX5XYEl8eRoifwqYAI9h0ziZfTNes8elNfb3DoPPjqq6VmMg0f0iMS4W8LjNPorjRB+kIosa1deAGPhq0eJ8yr0/s2QR2/WFD5P4aXc8IKWleklnIImS3zqiPrq6tl2Bm8DZj7vXlTOwmraSQxUwzCKwYob1yGvNOUQTqpG6jxn7jgDawHU1+WjWQe4Q34/pWeGLysxTraMa+Ug9kPe+jy/qRX2xwvKBZ");
    private static byte[] mixedSignedData;
    List crlList = new ArrayList();
    private static final Set noParams;
    private static byte[] ecPublicKeyExample;
    private static byte[] wrongRSASHA1Message;
    private static byte[] wrongRSASHA1MessageWithAttributes;
    static /* synthetic */ Class class$org$bouncycastle$cms$test$NewSignedDataTest;

    public NewSignedDataTest(String name) {
        super(name);
    }

    public static void main(String[] args) throws Exception {
        if (Security.getProvider(BC) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        NewSignedDataTest.init();
        TestRunner.run((Class)(class$org$bouncycastle$cms$test$NewSignedDataTest == null ? (class$org$bouncycastle$cms$test$NewSignedDataTest = NewSignedDataTest.class$("org.bouncycastle.cms.test.NewSignedDataTest")) : class$org$bouncycastle$cms$test$NewSignedDataTest));
    }

    public static Test suite() throws Exception {
        NewSignedDataTest.init();
        return new CMSTestSetup((Test)new TestSuite(class$org$bouncycastle$cms$test$NewSignedDataTest == null ? (class$org$bouncycastle$cms$test$NewSignedDataTest = NewSignedDataTest.class$("org.bouncycastle.cms.test.NewSignedDataTest")) : class$org$bouncycastle$cms$test$NewSignedDataTest));
    }

    public void setUp() throws Exception {
        NewSignedDataTest.init();
    }

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            if (Security.getProvider(BC) == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            _origDN = "O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _origKP, _origDN);
            _signDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _origKP, _origDN);
            _signGostKP = CMSTestUtil.makeGostKeyPair();
            _signGostCert = CMSTestUtil.makeCertificate(_signGostKP, _signDN, _origKP, _origDN);
            _signDsaKP = CMSTestUtil.makeDsaKeyPair();
            _signDsaCert = CMSTestUtil.makeCertificate(_signDsaKP, _signDN, _origKP, _origDN);
            _signEcDsaKP = CMSTestUtil.makeEcDsaKeyPair();
            _signEcDsaCert = CMSTestUtil.makeCertificate(_signEcDsaKP, _signDN, _origKP, _origDN);
            _signEcGostKP = CMSTestUtil.makeEcGostKeyPair();
            _signEcGostCert = CMSTestUtil.makeCertificate(_signEcGostKP, _signDN, _origKP, _origDN);
            _signEd25519KP = CMSTestUtil.makeEd25519KeyPair();
            _signEd25519Cert = CMSTestUtil.makeCertificate(_signEd25519KP, _signDN, _origKP, _origDN);
            _signEd448KP = CMSTestUtil.makeEd448KeyPair();
            _signEd448Cert = CMSTestUtil.makeCertificate(_signEd448KP, _signDN, _origKP, _origDN);
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
            _signCrl = CMSTestUtil.makeCrl(_signKP);
        }
    }

    private void verifyRSASignatures(CMSSignedData s, byte[] contentDigest) throws Exception {
        Store certStore = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new BcRSASignerInfoVerifierBuilder((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), (DigestAlgorithmIdentifierFinder)new DefaultDigestAlgorithmIdentifierFinder(), (DigestCalculatorProvider)new BcDigestCalculatorProvider()).build(cert)));
            if (contentDigest == null) continue;
            Assert.assertTrue((boolean)MessageDigest.isEqual(contentDigest, signer.getContentDigest()));
        }
    }

    private void verifySignatures(CMSSignedData s, byte[] contentDigest) throws Exception {
        Store certStore = s.getCertificates();
        Store crlStore = s.getCRLs();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
            if (contentDigest == null) continue;
            Assert.assertTrue((boolean)MessageDigest.isEqual(contentDigest, signer.getContentDigest()));
        }
        Collection certColl = certStore.getMatches(null);
        Collection crlColl = crlStore.getMatches(null);
        Assert.assertEquals((int)certColl.size(), (int)s.getCertificates().getMatches(null).size());
        Assert.assertEquals((int)crlColl.size(), (int)s.getCRLs().getMatches(null).size());
    }

    private void verifySignatures(CMSSignedData s) throws Exception {
        this.verifySignatures(s, null);
    }

    public void testDetachedVerification() throws Exception {
        byte[] data = "Hello World!".getBytes();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray(data);
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        DigestCalculatorProvider digProvider = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        JcaSignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(digProvider);
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        ContentSigner md5Signer = new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(signerInfoGeneratorBuilder.build(sha1Signer, _origCert));
        gen.addSignerInfoGenerator(signerInfoGeneratorBuilder.build(md5Signer, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg);
        MessageDigest sha1 = MessageDigest.getInstance("SHA1", BC);
        MessageDigest md5 = MessageDigest.getInstance("MD5", BC);
        HashMap<ASN1ObjectIdentifier, byte[]> hashes = new HashMap<ASN1ObjectIdentifier, byte[]>();
        byte[] sha1Hash = sha1.digest(data);
        byte[] md5Hash = md5.digest(data);
        hashes.put(CMSAlgorithm.SHA1, sha1Hash);
        hashes.put(CMSAlgorithm.MD5, md5Hash);
        s = new CMSSignedData(hashes, s.getEncoded());
        this.verifySignatures(s, null);
    }

    public void testEmptyContent() throws Exception {
        try {
            new CMSSignedData(new byte[0]);
        }
        catch (CMSException e) {
            Assert.assertEquals((String)"No content found.", (String)e.getMessage());
        }
        try {
            new CMSSignedDataParser(new JcaDigestCalculatorProviderBuilder().build(), new byte[0]);
        }
        catch (CMSException e) {
            Assert.assertEquals((String)"No content found.", (String)e.getMessage());
        }
    }

    public void testSHA1AndMD5WithRSAEncapsulatedRepeated() throws Exception {
        X509CertificateHolder cert;
        Iterator certIt;
        Collection certCollection;
        SignerInformation signer;
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(digCalcProv).build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate()), _origCert));
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(digCalcProv).build(new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(_origKP.getPrivate()), _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        ByteArrayInputStream bIn = new ByteArrayInputStream(s.getEncoded());
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        s = new CMSSignedData(ContentInfo.getInstance((Object)aIn.readObject()));
        certs = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Assert.assertEquals((int)2, (int)signers.size());
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        SignerId sid = null;
        while (it.hasNext()) {
            signer = (SignerInformation)it.next();
            certCollection = certs.getMatches((Selector)signer.getSID());
            certIt = certCollection.iterator();
            cert = (X509CertificateHolder)certIt.next();
            sid = signer.getSID();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
            byte[] contentDigest = (byte[])gen.getGeneratedDigests().get(signer.getDigestAlgOID());
            AttributeTable table = signer.getSignedAttributes();
            Attribute hash = table.get(CMSAttributes.messageDigest);
            Assert.assertTrue((boolean)MessageDigest.isEqual(contentDigest, ((ASN1OctetString)hash.getAttrValues().getObjectAt(0)).getOctets()));
        }
        c = signers.getSigners(sid);
        Assert.assertEquals((int)2, (int)c.size());
        gen = new CMSSignedDataGenerator();
        gen.addSigners(s.getSignerInfos());
        gen.addCertificates(s.getCertificates());
        s = gen.generate((CMSTypedData)msg, true);
        bIn = new ByteArrayInputStream(s.getEncoded());
        aIn = new ASN1InputStream((InputStream)bIn);
        s = new CMSSignedData(ContentInfo.getInstance((Object)aIn.readObject()));
        certs = s.getCertificates();
        signers = s.getSignerInfos();
        c = signers.getSigners();
        it = c.iterator();
        Assert.assertEquals((int)2, (int)c.size());
        while (it.hasNext()) {
            signer = (SignerInformation)it.next();
            certCollection = certs.getMatches((Selector)signer.getSID());
            certIt = certCollection.iterator();
            cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        this.checkSignerStoreReplacement(s, signers);
    }

    public void testWithDefiniteLength() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        builder.setDirectSignature(true);
        gen.addSignerInfoGenerator(builder.build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        gen.setDefiniteLengthEncoding(true);
        CMSSignedData s = gen.generate((CMSTypedData)msg, false);
        Assert.assertTrue((boolean)(s.toASN1Structure().toASN1Primitive() instanceof DLSequence));
        ASN1Encodable content = s.toASN1Structure().getContent();
        Assert.assertTrue((boolean)(content instanceof SignedData));
        Assert.assertTrue((boolean)(content.toASN1Primitive() instanceof DLSequence));
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
    }

    public void testSHA1WithRSAWrongDigestOID() throws Exception {
        CMSSignedData s = new CMSSignedData(wrongRSASHA1Message);
        this.verifySignatures(s);
    }

    public void testAttributesSHA1WithRSAWrongDigestOIDRejected() throws Exception {
        CMSSignedData s = new CMSSignedData(wrongRSASHA1MessageWithAttributes);
        try {
            this.verifySignatures(s);
            Assert.fail((String)"no exception");
        }
        catch (CMSException e) {
            Assert.assertTrue((e.getMessage().indexOf("can't create digest calculator") == 0 ? 1 : 0) != 0);
        }
    }

    public void testSHA1WithRSANoAttributes() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        builder.setDirectSignature(true);
        gen.addSignerInfoGenerator(builder.build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, false);
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
    }

    public void testSHA1WithRSANoAttributesSimple() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        JcaSimpleSignerInfoGeneratorBuilder builder = new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).setDirectSignature(true);
        gen.addSignerInfoGenerator(builder.build("SHA1withRSA", _origKP.getPrivate(), _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, false);
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
    }

    public void testSHA1WithRSAAndOtherRevocation() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        ArrayList<OCSPResponse> otherInfo = new ArrayList<OCSPResponse>();
        OCSPResp response = new OCSPResp(this.successResp);
        otherInfo.add(response.toASN1Structure());
        gen.addOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response, (Store)new CollectionStore(otherInfo));
        CMSSignedData s = gen.generate((CMSTypedData)msg, false);
        Assert.assertEquals((int)5, (int)s.getVersion());
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
        Store dataOtherInfo = s.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response);
        Assert.assertEquals((int)1, (int)dataOtherInfo.getMatches(null).size());
        OCSPResp dataResponse = new OCSPResp(OCSPResponse.getInstance(dataOtherInfo.getMatches(null).iterator().next()));
        Assert.assertEquals((Object)response, (Object)dataResponse);
    }

    public void testSHA1WithRSAAndAttributeTableSimple() throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        Attribute attr = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(md.digest("Hello world!".getBytes()))));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)attr);
        JcaSimpleSignerInfoGeneratorBuilder builder = new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(new AttributeTable(v)));
        gen.addSignerInfoGenerator(builder.build("SHA1withRSA", _origKP.getPrivate(), _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)new CMSAbsentContent(), false);
        s = new CMSSignedData((CMSProcessable)msg, s.getEncoded());
        Assert.assertTrue((boolean)s.isDetachedSignature());
        Assert.assertFalse((boolean)s.isCertificateManagementMessage());
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
        this.verifyRSASignatures(s, md.digest("Hello world!".getBytes()));
    }

    public void testCMSAlgorithmProtection() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        JcaSimpleSignerInfoGeneratorBuilder builder = new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC);
        gen.addSignerInfoGenerator(builder.build("SHA1withRSA", _origKP.getPrivate(), _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        s = new CMSSignedData(s.getEncoded());
        Assert.assertFalse((boolean)s.isDetachedSignature());
        Assert.assertFalse((boolean)s.isCertificateManagementMessage());
        this.verifySignatures(s, true, null);
        ContentInfo cI = s.toASN1Structure();
        SignedData sd = SignedData.getInstance((Object)cI.getContent());
        SignerInfo sI = SignerInfo.getInstance((Object)sd.getSignerInfos().getObjectAt(0));
        SignerInfo sInew = new SignerInfo(sI.getSID(), new AlgorithmIdentifier(TeleTrusTObjectIdentifiers.ripemd128, (ASN1Encodable)DERNull.INSTANCE), sI.getAuthenticatedAttributes(), sI.getDigestEncryptionAlgorithm(), sI.getEncryptedDigest(), sI.getUnauthenticatedAttributes());
        this.verifySignatures(this.getCorruptedSignedData(sd, sInew), false, "CMS Algorithm Identifier Protection check failed for digestAlgorithm");
        sInew = new SignerInfo(sI.getSID(), sI.getDigestAlgorithm(), sI.getAuthenticatedAttributes(), new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS), sI.getEncryptedDigest(), sI.getUnauthenticatedAttributes());
        this.verifySignatures(this.getCorruptedSignedData(sd, sInew), false, "CMS Algorithm Identifier Protection check failed for signatureAlgorithm");
        AlgorithmIdentifier newAlgId = new AlgorithmIdentifier(sI.getDigestAlgorithm().getAlgorithm());
        Assert.assertFalse((boolean)newAlgId.equals((Object)sI.getDigestAlgorithm()));
        sInew = new SignerInfo(sI.getSID(), newAlgId, sI.getAuthenticatedAttributes(), sI.getDigestEncryptionAlgorithm(), sI.getEncryptedDigest(), sI.getUnauthenticatedAttributes());
        this.verifySignatures(this.getCorruptedSignedData(sd, sInew), true, null);
        newAlgId = new AlgorithmIdentifier(sI.getDigestEncryptionAlgorithm().getAlgorithm());
        Assert.assertFalse((boolean)newAlgId.equals((Object)sI.getDigestEncryptionAlgorithm()));
        sInew = new SignerInfo(sI.getSID(), sI.getDigestAlgorithm(), sI.getAuthenticatedAttributes(), newAlgId, sI.getEncryptedDigest(), sI.getUnauthenticatedAttributes());
        this.verifySignatures(this.getCorruptedSignedData(sd, sInew), true, null);
    }

    private CMSSignedData getCorruptedSignedData(SignedData sd, SignerInfo sI) throws CMSException {
        return new CMSSignedData(new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)new SignedData(sd.getDigestAlgorithms(), sd.getEncapContentInfo(), sd.getCertificates(), sd.getCRLs(), (ASN1Set)new DERSet((ASN1Encodable)sI))));
    }

    private void verifySignatures(CMSSignedData s, boolean shouldPass, String message) throws Exception {
        Store certStore = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            if (shouldPass) {
                Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
                continue;
            }
            try {
                Assert.assertEquals((boolean)false, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
                if (message == null) continue;
                Assert.fail((String)"No exception thrown");
            }
            catch (CMSException e) {
                Assert.assertEquals((String)message, (String)e.getMessage());
            }
        }
    }

    public void testSHA1WithRSAAndAttributeTable() throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        Attribute attr = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(md.digest("Hello world!".getBytes()))));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)attr);
        JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        builder.setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(new AttributeTable(v)));
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(builder.build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)new CMSAbsentContent(), false);
        s = new CMSSignedData((CMSProcessable)msg, s.getEncoded());
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
        this.verifyRSASignatures(s, md.digest("Hello world!".getBytes()));
    }

    public void testRemoveAttribute() throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        builder.setSignedAttributeGenerator(new CMSAttributeTableGenerator(){

            public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
                AttributeTable table = new DefaultSignedAttributeTableGenerator().getAttributes(parameters);
                return table.remove(CMSAttributes.cmsAlgorithmProtect);
            }
        });
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(builder.build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, false);
        s = new CMSSignedData((CMSProcessable)msg, s.getEncoded());
        Assert.assertNull((Object)((SignerInformation)s.getSignerInfos().iterator().next()).getSignedAttributes().get(CMSAttributes.cmsAlgorithmProtect));
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
        this.verifyRSASignatures(s, md.digest("Hello world!".getBytes()));
    }

    public void testSignerInformationExtension() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(builder.build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        s = new CMSSignedData((CMSProcessable)msg, s.getEncoded());
        Store certStore = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            SignerInformationVerifier verifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert);
            Assert.assertEquals((boolean)true, (boolean)signer.verify(verifier));
            Assert.assertEquals((boolean)false, (boolean)new MyWrongSignerInformation(signer).verify(verifier));
            MyRightSignerInformation rSigner = new MyRightSignerInformation(signer);
            Assert.assertTrue((boolean)rSigner.verify(verifier));
            Assert.assertTrue((boolean)rSigner.isUsed());
        }
    }

    public void testRawSHA256MissingNull() throws Exception {
        byte[] document = this.getInput("rawsha256nonull.p7m");
        CMSSignedData s = new CMSSignedData(document);
        Store certStore = s.getCertificates();
        SignerInformation signerInformation = (SignerInformation)s.getSignerInfos().getSigners().iterator().next();
        Collection certCollection = certStore.getMatches((Selector)signerInformation.getSID());
        Iterator certIt = certCollection.iterator();
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(BC).getCertificate((X509CertificateHolder)certIt.next());
        SignerInformationVerifier signerInformationVerifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert.getPublicKey());
        if (!signerInformation.verify(signerInformationVerifier)) {
            Assert.fail((String)"raw sig failed");
        }
    }

    public void testEcPublicKeyAlgorithm() throws Exception {
        CMSSignedData cms = new CMSSignedData(ecPublicKeyExample);
        this.verifySignatures(cms, null);
    }

    public void testLwSHA1WithRSAAndAttributeTable() throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        Attribute attr = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(md.digest("Hello world!".getBytes()))));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)attr);
        AsymmetricKeyParameter privKey = PrivateKeyFactory.createKey((byte[])_origKP.getPrivate().getEncoded());
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA1withRSA");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        BcRSAContentSignerBuilder contentSignerBuilder = new BcRSAContentSignerBuilder(sigAlgId, digAlgId);
        gen.addSignerInfoGenerator(new SignerInfoGeneratorBuilder((DigestCalculatorProvider)new BcDigestCalculatorProvider()).setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(new AttributeTable(v))).build(contentSignerBuilder.build(privKey), (X509CertificateHolder)new JcaX509CertificateHolder(_origCert)));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)new CMSAbsentContent(), false);
        s = new CMSSignedData((CMSProcessable)msg, s.getEncoded());
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
        this.verifyRSASignatures(s, md.digest("Hello world!".getBytes()));
    }

    public void testLwSHA3_256WithRSAAndAttributeTable() throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA3-256", BC);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        Attribute attr = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(md.digest("Hello world!".getBytes()))));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)attr);
        AsymmetricKeyParameter privKey = PrivateKeyFactory.createKey((byte[])_origKP.getPrivate().getEncoded());
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA3-256withRSA");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        BcRSAContentSignerBuilder contentSignerBuilder = new BcRSAContentSignerBuilder(sigAlgId, digAlgId);
        gen.addSignerInfoGenerator(new SignerInfoGeneratorBuilder((DigestCalculatorProvider)new BcDigestCalculatorProvider()).setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(new AttributeTable(v))).build(contentSignerBuilder.build(privKey), (X509CertificateHolder)new JcaX509CertificateHolder(_origCert)));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)new CMSAbsentContent(), false);
        s = new CMSSignedData((CMSProcessable)msg, s.getEncoded());
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
        this.verifyRSASignatures(s, md.digest("Hello world!".getBytes()));
    }

    public void testSHA1WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "SHA1withRSA");
    }

    public void testSHA1WithRSAEncapsulatedSubjectKeyID() throws Exception {
        this.subjectKeyIDTest(_signKP, _signCert, "SHA1withRSA");
    }

    public void testSHA1WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA1withRSAandMGF1");
    }

    public void testSHA224WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA224withRSAandMGF1");
    }

    public void testSHA256WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA256withRSAandMGF1");
    }

    public void testSHA384WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA384withRSAandMGF1");
    }

    public void testSHA3_224WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA3-224withRSAandMGF1");
    }

    public void testSHA3_256WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA3-256withRSAandMGF1");
    }

    public void testSHA3_384WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA3-384withRSAandMGF1");
    }

    public void testSHA1WithRSADigest() throws Exception {
        this.rsaDigestTest("SHA1withRSA");
    }

    public void testSHA224WithRSADigest() throws Exception {
        this.rsaDigestTest("SHA224withRSA");
    }

    public void testSHA256WithRSADigest() throws Exception {
        this.rsaDigestTest("SHA256withRSA");
    }

    public void testSHA384WithRSADigest() throws Exception {
        this.rsaDigestTest("SHA384withRSA");
    }

    public void testSHA512WithRSADigest() throws Exception {
        this.rsaDigestTest("SHA512withRSA");
    }

    public void testSHA3_224WithRSADigest() throws Exception {
        this.rsaDigestTest("SHA3-224withRSA");
    }

    public void testSHA3_256WithRSADigest() throws Exception {
        this.rsaDigestTest("SHA3-256withRSA");
    }

    public void testSHA3_384WithRSADigest() throws Exception {
        this.rsaDigestTest("SHA3-384withRSA");
    }

    public void testSHA3_512WithRSADigest() throws Exception {
        this.rsaDigestTest("SHA3-512withRSA");
    }

    public void testSHA512_224ithRSADigest() throws Exception {
        this.rsaDigestTest("SHA512(224)withRSA");
    }

    public void testSHA512_256ithRSADigest() throws Exception {
        this.rsaDigestTest("SHA512(256)withRSA");
    }

    public void testEd25519() throws Exception {
        this.encapsulatedTest(_signEd25519KP, _signEd25519Cert, "Ed25519", EdECObjectIdentifiers.id_Ed25519, new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512));
    }

    public void testEd448() throws Exception {
        this.encapsulatedTest(_signEd448KP, _signEd448Cert, "Ed448", EdECObjectIdentifiers.id_Ed448, new AlgorithmIdentifier(NISTObjectIdentifiers.id_shake256_len, (ASN1Encodable)new ASN1Integer(512L)));
    }

    public void testDetachedEd25519() throws Exception {
        this.detachedTest(_signEd25519KP, _signEd25519Cert, "Ed25519", EdECObjectIdentifiers.id_Ed25519, new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512));
    }

    public void testEdDetached448() throws Exception {
        this.detachedTest(_signEd448KP, _signEd448Cert, "Ed448", EdECObjectIdentifiers.id_Ed448, new AlgorithmIdentifier(NISTObjectIdentifiers.id_shake256_len, (ASN1Encodable)new ASN1Integer(512L)));
    }

    public void testEd25519WithNoAttr() throws Exception {
        this.directSignatureTest(_signEd25519KP, _signEd25519Cert, "Ed25519", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512));
    }

    public void testEd448WithNoAttr() throws Exception {
        this.directSignatureTest(_signEd448KP, _signEd448Cert, "Ed448", new AlgorithmIdentifier(NISTObjectIdentifiers.id_shake256));
    }

    public void testSHA3_224WithDSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signDsaKP, _signDsaCert, "SHA3-224withDSA", NISTObjectIdentifiers.id_dsa_with_sha3_224);
    }

    public void testSHA3_256WithDSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signDsaKP, _signDsaCert, "SHA3-256withDSA", NISTObjectIdentifiers.id_dsa_with_sha3_256);
    }

    public void testSHA3_384WithDSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signDsaKP, _signDsaCert, "SHA3-384withDSA", NISTObjectIdentifiers.id_dsa_with_sha3_384);
    }

    public void testSHA3_512WithDSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signDsaKP, _signDsaCert, "SHA3-512withDSA", NISTObjectIdentifiers.id_dsa_with_sha3_512);
    }

    public void testSHA224WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "SHA224withRSA", PKCSObjectIdentifiers.sha224WithRSAEncryption);
    }

    public void testSHA256WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "SHA256withRSA", PKCSObjectIdentifiers.sha256WithRSAEncryption);
    }

    public void testSHA3_224WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "SHA3-224withRSA", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224);
    }

    public void testSHA3_256WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "SHA3-256withRSA", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256);
    }

    public void testSHA3_384WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "SHA3-384withRSA", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384);
    }

    public void testSHA3_512WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "SHA3-512withRSA", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512);
    }

    public void testRIPEMD128WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "RIPEMD128withRSA");
    }

    public void testRIPEMD160WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "RIPEMD160withRSA");
    }

    public void testRIPEMD256WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "RIPEMD256withRSA");
    }

    public void testECDSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA1withECDSA");
    }

    public void testECDSAEncapsulatedSubjectKeyID() throws Exception {
        this.subjectKeyIDTest(_signEcDsaKP, _signEcDsaCert, "SHA1withECDSA");
    }

    public void testECDSASHA224Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA224withECDSA");
    }

    public void testECDSASHA256Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA256withECDSA");
    }

    public void testECDSASHA384Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA384withECDSA");
    }

    public void testECDSASHA512Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA512withECDSA");
    }

    public void testECDSASHA3_224Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA3-224withECDSA");
    }

    public void testECDSASHA3_256Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA3-256withECDSA");
    }

    public void testECDSASHA3_384Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA3-384withECDSA");
    }

    public void testECDSASHA3_512Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA3-512withECDSA");
    }

    public void testPLAIN_ECDSASHA224Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA224withPLAIN-ECDSA");
    }

    public void testPLAIN_ECDSASHA256Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA256withPLAIN-ECDSA");
    }

    public void testPLAIN_ECDSASHA384Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA384withPLAIN-ECDSA");
    }

    public void testPLAIN_ECDSASHA512Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA512withPLAIN-ECDSA");
    }

    public void testPLAIN_ECDSASHA3_224Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA3-224withPLAIN-ECDSA");
    }

    public void testPLAIN_ECDSASHA3_256Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA3-256withPLAIN-ECDSA");
    }

    public void testPLAIN_ECDSASHA3_384Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA3-384withPLAIN-ECDSA");
    }

    public void testPLAIN_ECDSASHA3_512Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA3-512withPLAIN-ECDSA");
    }

    public void testECDSASHA512EncapsulatedWithKeyFactoryAsEC() throws Exception {
        X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(_signEcDsaKP.getPublic().getEncoded());
        PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(_signEcDsaKP.getPrivate().getEncoded());
        KeyFactory keyFact = KeyFactory.getInstance("EC", BC);
        KeyPair kp = new KeyPair(keyFact.generatePublic(pubSpec), keyFact.generatePrivate(privSpec));
        this.encapsulatedTest(kp, _signEcDsaCert, "SHA512withECDSA");
    }

    public void testDSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signDsaKP, _signDsaCert, "SHA1withDSA");
    }

    public void testDSAEncapsulatedSubjectKeyID() throws Exception {
        this.subjectKeyIDTest(_signDsaKP, _signDsaCert, "SHA1withDSA");
    }

    public void testGOST3411WithGOST3410Encapsulated() throws Exception {
        this.encapsulatedTest(_signGostKP, _signGostCert, "GOST3411withGOST3410");
    }

    public void testGOST3411WithECGOST3410Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcGostKP, _signEcGostCert, "GOST3411withECGOST3410");
    }

    public void testGostNoAttributesEncapsulated() throws Exception {
        CMSSignedData data = new CMSSignedData(rawGost);
        Store certStore = data.getCertificates();
        SignerInformationStore signers = data.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
    }

    public void testSHA1WithRSACounterSignature() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_signCert);
        certList.add(_origCert);
        crlList.add(_signCrl);
        JcaCertStore certStore = new JcaCertStore(certList);
        JcaCRLStore crlStore = new JcaCRLStore(crlList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_signKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _signCert));
        gen.addCertificates((Store)certStore);
        gen.addCRLs((Store)crlStore);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        SignerInformation origSigner = (SignerInformation)s.getSignerInfos().getSigners().toArray()[0];
        SignerInformationStore counterSigners1 = gen.generateCounterSigners(origSigner);
        SignerInformationStore counterSigners2 = gen.generateCounterSigners(origSigner);
        SignerInformation signer1 = SignerInformation.addCounterSigners((SignerInformation)origSigner, (SignerInformationStore)counterSigners1);
        SignerInformation signer2 = SignerInformation.addCounterSigners((SignerInformation)signer1, (SignerInformationStore)counterSigners2);
        SignerInformationStore cs = signer2.getCounterSignatures();
        Collection csSigners = cs.getSigners();
        Assert.assertEquals((int)2, (int)csSigners.size());
        Iterator it = csSigners.iterator();
        while (it.hasNext()) {
            SignerInformation cSigner = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches((Selector)cSigner.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertTrue((boolean)cSigner.isCounterSignature());
            Assert.assertNull((Object)cSigner.getSignedAttributes().get(PKCSObjectIdentifiers.pkcs_9_at_contentType));
            Assert.assertEquals((boolean)true, (boolean)cSigner.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
    }

    public void testSHA1WithRSACounterSignatureAndVerifierProvider() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_signCert);
        certList.add(_origCert);
        crlList.add(_signCrl);
        JcaCertStore certStore = new JcaCertStore(certList);
        JcaCRLStore crlStore = new JcaCRLStore(crlList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_signKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _signCert));
        gen.addCertificates((Store)certStore);
        gen.addCRLs((Store)crlStore);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        Object vProv = new SignerInformationVerifierProvider(){

            public SignerInformationVerifier get(SignerId signerId) throws OperatorCreationException {
                return new JcaSimpleSignerInfoVerifierBuilder().setProvider(NewSignedDataTest.BC).build(_signCert);
            }
        };
        Set digAlgs = s.getDigestAlgorithmIDs();
        Assert.assertTrue((digAlgs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)digAlgs.contains(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, (ASN1Encodable)DERNull.INSTANCE)));
        Assert.assertTrue((boolean)s.verifySignatures(vProv));
        SignerInformation origSigner = (SignerInformation)s.getSignerInfos().getSigners().toArray()[0];
        gen = new CMSSignedDataGenerator();
        ContentSigner sha256Signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha256Signer, _origCert));
        SignerInformationStore counterSigners = gen.generateCounterSigners(origSigner);
        SignerInformation signer1 = SignerInformation.addCounterSigners((SignerInformation)origSigner, (SignerInformationStore)counterSigners);
        ArrayList<SignerInformation> signers = new ArrayList<SignerInformation>();
        signers.add(signer1);
        s = CMSSignedData.replaceSigners((CMSSignedData)s, (SignerInformationStore)new SignerInformationStore(signers));
        Assert.assertTrue((boolean)s.verifySignatures(vProv, true));
        Assert.assertFalse((boolean)s.verifySignatures(vProv, false));
        vProv = new SignerInformationVerifierProvider(){

            public SignerInformationVerifier get(SignerId signerId) throws OperatorCreationException {
                if (_signCert.getSerialNumber().equals(signerId.getSerialNumber())) {
                    return new JcaSimpleSignerInfoVerifierBuilder().setProvider(NewSignedDataTest.BC).build(_signCert);
                }
                if (_origCert.getSerialNumber().equals(signerId.getSerialNumber())) {
                    return new JcaSimpleSignerInfoVerifierBuilder().setProvider(NewSignedDataTest.BC).build(_origCert);
                }
                throw new IllegalStateException("no signerID matched");
            }
        };
        digAlgs = s.getDigestAlgorithmIDs();
        Assert.assertTrue((digAlgs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)digAlgs.contains(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, (ASN1Encodable)DERNull.INSTANCE)));
        Assert.assertTrue((boolean)digAlgs.contains(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256)));
        Assert.assertTrue((boolean)s.verifySignatures(vProv, false));
    }

    public void testAddDigestAlgorithm() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_signCert);
        certList.add(_origCert);
        crlList.add(_signCrl);
        JcaCertStore certStore = new JcaCertStore(certList);
        JcaCRLStore crlStore = new JcaCRLStore(crlList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_signKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _signCert));
        gen.addCertificates((Store)certStore);
        gen.addCRLs((Store)crlStore);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        SignerInformationVerifierProvider vProv = new SignerInformationVerifierProvider(){

            public SignerInformationVerifier get(SignerId signerId) throws OperatorCreationException {
                return new JcaSimpleSignerInfoVerifierBuilder().setProvider(NewSignedDataTest.BC).build(_signCert);
            }
        };
        Set digAlgs = s.getDigestAlgorithmIDs();
        Assert.assertTrue((digAlgs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)digAlgs.contains(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, (ASN1Encodable)DERNull.INSTANCE)));
        Assert.assertTrue((boolean)s.verifySignatures(vProv));
        CMSSignedData oldS = s;
        s = CMSSignedData.addDigestAlgorithm((CMSSignedData)s, (AlgorithmIdentifier)new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, (ASN1Encodable)DERNull.INSTANCE));
        Assert.assertTrue((oldS == s ? 1 : 0) != 0);
        s = CMSSignedData.addDigestAlgorithm((CMSSignedData)s, (AlgorithmIdentifier)new AlgorithmIdentifier(TeleTrusTObjectIdentifiers.ripemd160, (ASN1Encodable)DERNull.INSTANCE));
        Assert.assertTrue((oldS != s ? 1 : 0) != 0);
        digAlgs = s.getDigestAlgorithmIDs();
        Assert.assertTrue((digAlgs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)digAlgs.contains(new AlgorithmIdentifier(TeleTrusTObjectIdentifiers.ripemd160, (ASN1Encodable)DERNull.INSTANCE)));
    }

    private void rsaPSSTest(String signatureAlgorithmName) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithmName).setProvider(BC).build(_origKP.getPrivate());
        JcaSignerInfoGeneratorBuilder siBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        siBuilder.setDirectSignature(true);
        gen.addSignerInfoGenerator(siBuilder.build(contentSigner, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, false);
        String digestName = signatureAlgorithmName.substring(0, signatureAlgorithmName.indexOf(119));
        MessageDigest md = MessageDigest.getInstance(digestName, BC);
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
    }

    private void rsaDigestTest(String signatureAlgorithmName) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithmName).setProvider(BC).build(_origKP.getPrivate());
        JcaSignerInfoGeneratorBuilder siBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        gen.addSignerInfoGenerator(siBuilder.build(contentSigner, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, false);
        String digestName = signatureAlgorithmName.substring(0, signatureAlgorithmName.indexOf(119));
        MessageDigest md = MessageDigest.getInstance(digestName, BC);
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
    }

    private void directSignatureTest(KeyPair signaturePair, X509Certificate signatureCert, String signatureAlgorithm, AlgorithmIdentifier digAlgId) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(signatureCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(BC).build(signaturePair.getPrivate());
        JcaSignerInfoGeneratorBuilder siBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        siBuilder.setDirectSignature(true);
        gen.addSignerInfoGenerator(siBuilder.build(contentSigner, signatureCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, false);
        Assert.assertTrue((boolean)s.getDigestAlgorithmIDs().contains(digAlgId));
        this.verifySignatures(s, null);
    }

    private void subjectKeyIDTest(KeyPair signaturePair, X509Certificate signatureCert, String signatureAlgorithm) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(signatureCert);
        certList.add(_origCert);
        crlList.add(_signCrl);
        JcaCertStore certStore = new JcaCertStore(certList);
        JcaCRLStore crlStore = new JcaCRLStore(crlList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(BC).build(signaturePair.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(contentSigner, CMSTestUtil.createSubjectKeyId(signatureCert.getPublicKey()).getKeyIdentifier()));
        gen.addCertificates((Store)certStore);
        gen.addCRLs((Store)crlStore);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        Assert.assertEquals((int)3, (int)s.getVersion());
        ByteArrayInputStream bIn = new ByteArrayInputStream(s.getEncoded());
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        s = new CMSSignedData(ContentInfo.getInstance((Object)aIn.readObject()));
        certStore = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        Collection crls = crlStore.getMatches(null);
        Assert.assertEquals((int)1, (int)crls.size());
        Assert.assertTrue((boolean)crls.contains(new JcaX509CRLHolder(_signCrl)));
        gen = new CMSSignedDataGenerator();
        gen.addSigners(s.getSignerInfos());
        gen.addCertificates(s.getCertificates());
        s = gen.generate((CMSTypedData)msg, true);
        bIn = new ByteArrayInputStream(s.getEncoded());
        aIn = new ASN1InputStream((InputStream)bIn);
        s = new CMSSignedData(ContentInfo.getInstance((Object)aIn.readObject()));
        certStore = s.getCertificates();
        signers = s.getSignerInfos();
        c = signers.getSigners();
        it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        this.checkSignerStoreReplacement(s, signers);
    }

    private void encapsulatedTest(KeyPair signaturePair, X509Certificate signatureCert, String signatureAlgorithm) throws Exception {
        this.encapsulatedTest(signaturePair, signatureCert, signatureAlgorithm, null);
    }

    private void encapsulatedTest(KeyPair signaturePair, X509Certificate signatureCert, String signatureAlgorithm, ASN1ObjectIdentifier sigAlgOid) throws Exception {
        this.encapsulatedTest(signaturePair, signatureCert, signatureAlgorithm, sigAlgOid, null);
    }

    private void encapsulatedTest(KeyPair signaturePair, X509Certificate signatureCert, String signatureAlgorithm, ASN1ObjectIdentifier sigAlgOid, AlgorithmIdentifier digAlgId) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(signatureCert);
        certList.add(_origCert);
        crlList.add(_signCrl);
        JcaCertStore certs = new JcaCertStore(certList);
        JcaCRLStore crlStore = new JcaCRLStore(crlList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(BC).build(signaturePair.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(contentSigner, signatureCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        ByteArrayInputStream bIn = new ByteArrayInputStream(s.getEncoded());
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        s = new CMSSignedData(ContentInfo.getInstance((Object)aIn.readObject()));
        HashSet digestAlgorithms = new HashSet(s.getDigestAlgorithmIDs());
        Assert.assertTrue((digestAlgorithms.size() > 0 ? 1 : 0) != 0);
        if (digAlgId != null) {
            Assert.assertTrue((boolean)digestAlgorithms.contains(digAlgId));
        }
        certs = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            if (sigAlgOid != null) {
                Assert.assertEquals((String)sigAlgOid.getId(), (String)signer.getEncryptionAlgOID());
                if (noParams.contains(sigAlgOid)) {
                    Assert.assertNull((Object)signer.getEncryptionAlgParams());
                } else {
                    Assert.assertEquals((Object)DERNull.INSTANCE, (Object)ASN1Primitive.fromByteArray((byte[])signer.getEncryptionAlgParams()));
                }
            }
            digestAlgorithms.remove(signer.getDigestAlgorithmID());
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        Assert.assertTrue((digestAlgorithms.size() == 0 ? 1 : 0) != 0);
        JcaSignerId sid = new JcaSignerId(signatureCert);
        Collection collection = signers.getSigners((SignerId)sid);
        Assert.assertEquals((int)1, (int)collection.size());
        Assert.assertTrue((boolean)(collection.iterator().next() instanceof SignerInformation));
        Collection crls = crlStore.getMatches(null);
        Assert.assertEquals((int)1, (int)crls.size());
        Assert.assertTrue((boolean)crls.contains(new JcaX509CRLHolder(_signCrl)));
        gen = new CMSSignedDataGenerator();
        gen.addSigners(s.getSignerInfos());
        gen.addCertificates(s.getCertificates());
        s = gen.generate((CMSTypedData)msg, true);
        bIn = new ByteArrayInputStream(s.getEncoded());
        aIn = new ASN1InputStream((InputStream)bIn);
        s = new CMSSignedData(ContentInfo.getInstance((Object)aIn.readObject()));
        certs = s.getCertificates();
        signers = s.getSignerInfos();
        c = signers.getSigners();
        it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        this.checkSignerStoreReplacement(s, signers);
    }

    private void detachedTest(KeyPair signaturePair, X509Certificate signatureCert, String signatureAlgorithm, ASN1ObjectIdentifier sigAlgOid) throws Exception {
        this.detachedTest(signaturePair, signatureCert, signatureAlgorithm, sigAlgOid, null);
    }

    private void detachedTest(KeyPair signaturePair, X509Certificate signatureCert, String signatureAlgorithm, ASN1ObjectIdentifier sigAlgOid, AlgorithmIdentifier digAlgId) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(signatureCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(BC).build(signaturePair.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(contentSigner, signatureCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        ByteArrayInputStream bIn = new ByteArrayInputStream(s.getEncoded());
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        s = new CMSSignedData((CMSProcessable)msg, ContentInfo.getInstance((Object)aIn.readObject()));
        HashSet digestAlgorithms = new HashSet(s.getDigestAlgorithmIDs());
        Assert.assertTrue((digestAlgorithms.size() > 0 ? 1 : 0) != 0);
        if (digAlgId != null) {
            Assert.assertTrue((boolean)digestAlgorithms.contains(digAlgId));
        }
        certs = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            if (sigAlgOid != null) {
                Assert.assertEquals((String)sigAlgOid.getId(), (String)signer.getEncryptionAlgOID());
                if (noParams.contains(sigAlgOid)) {
                    Assert.assertNull((Object)signer.getEncryptionAlgParams());
                } else {
                    Assert.assertEquals((Object)DERNull.INSTANCE, (Object)ASN1Primitive.fromByteArray((byte[])signer.getEncryptionAlgParams()));
                }
            }
            digestAlgorithms.remove(signer.getDigestAlgorithmID());
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        Assert.assertTrue((digestAlgorithms.size() == 0 ? 1 : 0) != 0);
        JcaSignerId sid = new JcaSignerId(signatureCert);
        Collection collection = signers.getSigners((SignerId)sid);
        Assert.assertEquals((int)1, (int)collection.size());
        Assert.assertTrue((boolean)(collection.iterator().next() instanceof SignerInformation));
        gen = new CMSSignedDataGenerator();
        gen.addSigners(s.getSignerInfos());
        gen.addCertificates(s.getCertificates());
        s = gen.generate((CMSTypedData)msg);
        s = new CMSSignedData((CMSProcessable)msg, s.getEncoded());
        certs = s.getCertificates();
        signers = s.getSignerInfos();
        c = signers.getSigners();
        it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        this.checkSignerStoreReplacement(s, signers);
    }

    private void checkSignerStoreReplacement(CMSSignedData orig, SignerInformationStore signers) throws Exception {
        CMSSignedData s = CMSSignedData.replaceSigners((CMSSignedData)orig, (SignerInformationStore)signers);
        Store certs = s.getCertificates();
        signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
    }

    public void testUnsortedAttributes() throws Exception {
        CMSSignedData s = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(this.disorderedMessage), this.disorderedSet);
        Store certs = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)false, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
            Signature sig = Signature.getInstance("SHA1withRSA", BC);
            sig.initVerify(new JcaX509CertificateConverter().getCertificate(cert).getPublicKey());
            sig.update(signer.toASN1Structure().getAuthenticatedAttributes().getEncoded());
            Assert.assertEquals((boolean)true, (boolean)sig.verify(signer.getSignature()));
        }
    }

    public void testNullContentWithSigner() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)new CMSAbsentContent(), false);
        ByteArrayInputStream bIn = new ByteArrayInputStream(s.getEncoded());
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        s = new CMSSignedData(ContentInfo.getInstance((Object)aIn.readObject()));
        this.verifySignatures(s);
    }

    public void testWithAttributeCertificate() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_signDsaCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(builder.build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        X509AttributeCertificateHolder attrCert = CMSTestUtil.getAttributeCertificate();
        ArrayList<X509AttributeCertificateHolder> attrList = new ArrayList<X509AttributeCertificateHolder>();
        attrList.add(new X509AttributeCertificateHolder(attrCert.getEncoded()));
        CollectionStore store = new CollectionStore(attrList);
        gen.addAttributeCertificates((Store)store);
        CMSSignedData sd = gen.generate((CMSTypedData)msg);
        Assert.assertEquals((int)4, (int)sd.getVersion());
        store = sd.getAttributeCertificates();
        Collection coll = store.getMatches(null);
        Assert.assertEquals((int)1, (int)coll.size());
        Assert.assertTrue((boolean)coll.contains(new X509AttributeCertificateHolder(attrCert.getEncoded())));
        certList = new ArrayList();
        certList.add(_origCert);
        certList.add(_signCert);
        certs = new JcaCertStore(certList);
        sd = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)sd, (Store)certs, null, null);
        this.verifySignatures(sd);
    }

    public void testCertStoreReplacement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_signDsaCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData sd = gen.generate((CMSTypedData)msg);
        certList = new ArrayList();
        certList.add(_origCert);
        certList.add(_signCert);
        certs = new JcaCertStore(certList);
        sd = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)sd, (Store)certs, null, null);
        this.verifySignatures(sd);
    }

    public void testEncapsulatedCertStoreReplacement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_signDsaCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData sd = gen.generate((CMSTypedData)msg, true);
        certList = new ArrayList();
        certList.add(_origCert);
        certList.add(_signCert);
        certs = new JcaCertStore(certList);
        sd = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)sd, (Store)certs, null, null);
        this.verifySignatures(sd);
    }

    public void testCertOrdering1() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        certList.add(_signDsaCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData sd = gen.generate((CMSTypedData)msg, true);
        certs = sd.getCertificates();
        Iterator it = certs.getMatches(null).iterator();
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_origCert), it.next());
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_signCert), it.next());
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_signDsaCert), it.next());
    }

    public void testCertOrdering2() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_signCert);
        certList.add(_signDsaCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData sd = gen.generate((CMSTypedData)msg, true);
        certs = sd.getCertificates();
        Iterator it = certs.getMatches(null).iterator();
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_signCert), it.next());
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_signDsaCert), it.next());
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_origCert), it.next());
    }

    public void testSignerStoreReplacement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData original = gen.generate((CMSTypedData)msg, true);
        gen = new CMSSignedDataGenerator();
        ContentSigner sha224Signer = new JcaContentSignerBuilder("SHA224withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha224Signer, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData newSD = gen.generate((CMSTypedData)msg, true);
        CMSSignedData sd = CMSSignedData.replaceSigners((CMSSignedData)original, (SignerInformationStore)newSD.getSignerInfos());
        SignerInformation signer = (SignerInformation)sd.getSignerInfos().getSigners().iterator().next();
        Assert.assertEquals((String)CMSAlgorithm.SHA224.getId(), (String)signer.getDigestAlgOID());
        CMSSignedDataParser sp = new CMSSignedDataParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), sd.getEncoded());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
    }

    public void testEncapsulatedSamples() throws Exception {
        this.testSample("PSSSignDataSHA1Enc.sig");
        this.testSample("PSSSignDataSHA256Enc.sig");
        this.testSample("PSSSignDataSHA512Enc.sig");
    }

    public void testSamples() throws Exception {
        this.testSample("PSSSignData.data", "PSSSignDataSHA1.sig");
        this.testSample("PSSSignData.data", "PSSSignDataSHA256.sig");
        this.testSample("PSSSignData.data", "PSSSignDataSHA512.sig");
    }

    public void testNoAttrEncapsulatedSample() throws Exception {
        CMSSignedData s = new CMSSignedData(noAttrEncData);
        Store certStore = s.getCertificates();
        Assert.assertNotNull((Object)certStore);
        SignerInformationStore signers = s.getSignerInfos();
        Assert.assertNotNull((Object)signers);
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            if (signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert))) continue;
            Assert.fail((String)"Verification FAILED! ");
        }
    }

    public void testCounterSig() throws Exception {
        CMSSignedData sig = new CMSSignedData(this.getInput("counterSig.p7m"));
        SignerInformationStore ss = sig.getSignerInfos();
        Collection signers = ss.getSigners();
        SignerInformationStore cs = ((SignerInformation)signers.iterator().next()).getCounterSignatures();
        Collection csSigners = cs.getSigners();
        Assert.assertEquals((int)1, (int)csSigners.size());
        Iterator it = csSigners.iterator();
        while (it.hasNext()) {
            SignerInformation cSigner = (SignerInformation)it.next();
            Collection certCollection = sig.getCertificates().getMatches((Selector)cSigner.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertTrue((boolean)cSigner.isCounterSignature());
            Assert.assertNull((Object)cSigner.getSignedAttributes().get(PKCSObjectIdentifiers.pkcs_9_at_contentType));
            Assert.assertEquals((boolean)true, (boolean)cSigner.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        this.verifySignatures(sig);
    }

    public void testCertificateManagement() throws Exception {
        CMSSignedDataGenerator sGen = new CMSSignedDataGenerator();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        sGen.addCertificates((Store)certs);
        CMSSignedData sData = sGen.generate((CMSTypedData)new CMSAbsentContent(), true);
        CMSSignedData rsData = new CMSSignedData(sData.getEncoded());
        Assert.assertTrue((boolean)sData.isCertificateManagementMessage());
        Assert.assertFalse((boolean)sData.isDetachedSignature());
        Assert.assertEquals((int)2, (int)rsData.getCertificates().getMatches(null).size());
    }

    public void testMixed() throws Exception {
        ASN1TaggedObject appTag = ASN1TaggedObject.getInstance((Object)mixedSignedData);
        Assert.assertTrue((boolean)appTag.hasTag(64, 23));
        Assert.assertNotNull((Object)ASN1Util.tryGetBaseUniversal((ASN1TaggedObject)appTag, (int)64, (int)23, (boolean)true, (int)16));
        ASN1Sequence seq = (ASN1Sequence)appTag.getBaseUniversal(true, 16);
        CMSSignedData s = new CMSSignedData(ContentInfo.getInstance((Object)seq));
        Store certs = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
    }

    public void testMSPKCS7() throws Exception {
        byte[] data = this.getInput("SignedMSPkcs7.sig");
        CMSSignedData sData = new CMSSignedData(data);
        Store certStore = sData.getCertificates();
        SignerInformationStore signers = sData.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData local = gen.generate(sData.getSignedContent(), true);
        certStore = local.getCertificates();
        signers = local.getSignerInfos();
        c = signers.getSigners();
        it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
    }

    private void testSample(String sigName) throws Exception {
        CMSSignedData sig = new CMSSignedData(this.getInput(sigName));
        this.verifySignatures(sig);
    }

    private void testSample(String messageName, String sigName) throws Exception {
        CMSSignedData sig = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(this.getInput(messageName)), this.getInput(sigName));
        this.verifySignatures(sig);
    }

    private byte[] getInput(String name) throws IOException {
        return Streams.readAll((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(name));
    }

    public void testForMultipleCounterSignatures() throws Exception {
        CMSSignedData sd = new CMSSignedData(xtraCounterSig);
        Iterator sI = sd.getSignerInfos().getSigners().iterator();
        while (sI.hasNext()) {
            SignerInformation sigI = (SignerInformation)sI.next();
            SignerInformationStore counter = sigI.getCounterSignatures();
            ArrayList sigs = new ArrayList(counter.getSigners());
            Assert.assertEquals((int)2, (int)sigs.size());
        }
    }

    private void verifySignatures(CMSSignedDataParser sp) throws Exception {
        Store certs = sp.getCertificates();
        SignerInformationStore signers = sp.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _initialised = false;
        xtraCounterSig = Base64.decode((String)"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");
        rawGost = Base64.decode((String)"MIIEBwYJKoZIhvcNAQcCoIID+DCCA/QCAQExDDAKBgYqhQMCAgkFADAfBgkqhkiG9w0BBwGgEgQQU29tZSBEYXRhIEhFUkUhIaCCAuYwggLiMIICkaADAgECAgopoLG9AAIAArWeMAgGBiqFAwICAzBlMSAwHgYJKoZIhvcNAQkBFhFpbmZvQGNyeXB0b3Byby5ydTELMAkGA1UEBhMCUlUxEzARBgNVBAoTCkNSWVBUTy1QUk8xHzAdBgNVBAMTFlRlc3QgQ2VudGVyIENSWVBUTy1QUk8wHhcNMTIxMDE1MTEwNDIzWhcNMTQxMDA0MDcwOTQxWjAhMRIwEAYDVQQDDAl0ZXN0IGdvc3QxCzAJBgNVBAYTAlJVMGMwHAYGKoUDAgITMBIGByqFAwICJAAGByqFAwICHgEDQwAEQPz/F99AG8wyMQz5uK3vJ3MdHk7ZyFzM4Ofnq8nAmDgI5/Nuzcu791/0hRd+1i+fArRsiPMdQXOF0E7bEMHwWfWjggFjMIIBXzAOBgNVHQ8BAf8EBAMCBPAwEwYDVR0lBAwwCgYIKwYBBQUHAwIwHQYDVR0OBBYEFO353ZD7sLCx6rVR2o/IsSxuE1gAMB8GA1UdIwQYMBaAFG2PXgXZX6yRF5QelZoFMDg3ehAqMFUGA1UdHwROMEwwSqBIoEaGRGh0dHA6Ly93d3cuY3J5cHRvcHJvLnJ1L0NlcnRFbnJvbGwvVGVzdCUyMENlbnRlciUyMENSWVBUTy1QUk8oMikuY3JsMIGgBggrBgEFBQcBAQSBkzCBkDAzBggrBgEFBQcwAYYnaHR0cDovL3d3dy5jcnlwdG9wcm8ucnUvb2NzcG5jL29jc3Auc3JmMFkGCCsGAQUFBzAChk1odHRwOi8vd3d3LmNyeXB0b3Byby5ydS9DZXJ0RW5yb2xsL3BraS1zaXRlX1Rlc3QlMjBDZW50ZXIlMjBDUllQVE8tUFJPKDIpLmNydDAIBgYqhQMCAgMDQQBAR4mr69a62d3lyK/UZ4Yz/Yi3jqURtbnJR2gugdzkG5pYHRwC41BbDaa1ItP+1gDp4s78+EiKAJc17CHGZTz3MYHVMIHSAgEBMHMwZTEgMB4GCSqGSIb3DQEJARYRaW5mb0BjcnlwdG9wcm8ucnUxCzAJBgNVBAYTAlJVMRMwEQYDVQQKEwpDUllQVE8tUFJPMR8wHQYDVQQDExZUZXN0IENlbnRlciBDUllQVE8tUFJPAgopoLG9AAIAArWeMAoGBiqFAwICCQUAMAoGBiqFAwICEwUABED0Gs9zP9lSz/2/e3BUSpzCI3dx39gfl/pFVkx4p5N/GW5o4gHIST9OhDSmdxwpMSK+39YSRD4R0Ue0faOqWEsjAAAAAAAAAAAAAAAAAAAAAA==");
        noAttrEncData = Base64.decode((String)"MIIFjwYJKoZIhvcNAQcCoIIFgDCCBXwCAQExDTALBglghkgBZQMEAgEwgdAGCSqGSIb3DQEHAaCBwgSBv01JTUUtVmVyc2lvbjogMS4wCkNvbnRlbnQtVHlwZTogYXBwbGljYXRpb24vb2N0ZXQtc3RyZWFtCkNvbnRlbnQtVHJhbnNmZXItRW5jb2Rpbmc6IGJpbmFyeQpDb250ZW50LURpc3Bvc2l0aW9uOiBhdHRhY2htZW50OyBmaWxlbmFtZT1kb2MuYmluCgpUaGlzIGlzIGEgdmVyeSBodWdlIHNlY3JldCwgbWFkZSB3aXRoIG9wZW5zc2wKCgoKoIIDNDCCAzAwggKZoAMCAQICAQEwDQYJKoZIhvcNAQEFBQAwgawxCzAJBgNVBAYTAkFUMRAwDgYDVQQIEwdBdXN0cmlhMQ8wDQYDVQQHEwZWaWVubmExFTATBgNVBAoTDFRpYW5pIFNwaXJpdDEUMBIGA1UECxMLSlVuaXQgdGVzdHMxGjAYBgNVBAMTEU1hc3NpbWlsaWFubyBNYXNpMTEwLwYJKoZIhvcNAQkBFiJtYXNzaW1pbGlhbm8ubWFzaUB0aWFuaS1zcGlyaXQuY29tMCAXDTEyMDEwMjA5MDAzNVoYDzIxOTEwNjA4MDkwMDM1WjCBjzELMAkGA1UEBhMCQVQxEDAOBgNVBAgTB0F1c3RyaWExFTATBgNVBAoTDFRpYW5pIFNwaXJpdDEUMBIGA1UECxMLSlVuaXQgVGVzdHMxDjAMBgNVBAMTBWNlcnQxMTEwLwYJKoZIhvcNAQkBFiJtYXNzaW1pbGlhbm8ubWFzaUB0aWFuaS1zcGlyaXQuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYHz8nsoeWpILn+5tK8XgJc3k5n0h0MOlRXLbZZVB7yuxKMBIZwl8kqqnehfqxX+hrb2MXSCgKEstnVunJVPUGuNxnQ8Z0R9p1o/9gR0KTXmoJ+Epx5wdEofk4PhsiMxjC8FVvt3sSnzal1/m0/9KntrPWksefumGm5XD3W43e5wIDAQABo3sweTAJBgNVHRMEAjAAMCwGCWCGSAGG+EIBDQQfFh1PcGVuU1NMIEdlbmVyYXRlZCBDZXJ0aWZpY2F0ZTAdBgNVHQ4EFgQU8mTZGl0EFv6aHo3bup144d6wYW8wHwYDVR0jBBgwFoAUdHG2RdrchT0PFcUBiIiYcy5hAA4wDQYJKoZIhvcNAQEFBQADgYEATcc52eo73zEA4wmbyPv0lRrmyAxrHvZGIHiKpM8bP38WUB39lgmS8J0S1ioj21bosiakGj/gXnxlk8M8O+mm4zzpYjy8gqGXiUt20+j3bm7MJYM8ePcqdG/kReNuLUbRgIA6b0T4o+0WCELhrd9IlTk5IBKjHIjsP/GR1h0t//kxggFbMIIBVwIBATCBsjCBrDELMAkGA1UEBhMCQVQxEDAOBgNVBAgTB0F1c3RyaWExDzANBgNVBAcTBlZpZW5uYTEVMBMGA1UEChMMVGlhbmkgU3Bpcml0MRQwEgYDVQQLEwtKVW5pdCB0ZXN0czEaMBgGA1UEAxMRTWFzc2ltaWxpYW5vIE1hc2kxMTAvBgkqhkiG9w0BCQEWIm1hc3NpbWlsaWFuby5tYXNpQHRpYW5pLXNwaXJpdC5jb20CAQEwCwYJYIZIAWUDBAIBMA0GCSqGSIb3DQEBAQUABIGAEthqA7FKV1i+MzzS4zz4DxT4lwUYkWfHaDtZADUyTD5lnP3Pf+t/ScpBEGkEtI7hDqOOzE0WfkBshTx5B/uxDibc/jqjQpSYSz5cvBTgpocIalbqsErOkDYF1QP6UgaVZoVGwvGYIuIrFgWqgk08NsPHVVjYseTEhUDwkI1KSxU=");
        mixedSignedData = Base64.decode((String)"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");
        noParams = new HashSet();
        ecPublicKeyExample = Base64.decode((String)"MIIEdwYJKoZIhvcNAQcCoIIEaDCCBGQCAQExDzANBglghkgBZQMEAgEFADAUBgkqhkiG9w0BBwGgBwQFAQIDBAWgggMPMIIDCzCCAm6gAwIBAgIJALt88oa4pHaNMAkGByqGSM49BAEwYzELMAkGA1UEBhMCR0ExCzAJBgNVBAgTAkFXMRAwDgYDVQQHEwdBdGxhbnRhMQwwCgYDVQQKEwNWTVcxDzANBgNVBAsTBkFXIEVNTTEWMBQGA1UEAxMNd3d3LmF3bWRtLmNvbTAeFw0xNjA2MDgxNjQ2MTdaFw0xNjA3MDgxNjQ2MTdaMGMxCzAJBgNVBAYTAkdBMQswCQYDVQQIEwJBVzEQMA4GA1UEBxMHQXRsYW50YTEMMAoGA1UEChMDVk1XMQ8wDQYDVQQLEwZBVyBFTU0xFjAUBgNVBAMTDXd3dy5hd21kbS5jb20wgZswEAYHKoZIzj0CAQYFK4EEACMDgYYABAAAlWsasReERY0vzpm6WvDuznypGIyXfaf8Q/sieuHOdUxhzcMS8Gg4qxry9voSKozDn3vI1sFQ3ZPxDgIouHSKZAA8G4aP72k/gQ7G8wnHx2DF+UgchfIL0GypTZqmjo0c7jb8ZDgklfGr+arFeL8gIVH+EqmUdJoYzBW0FX9RZmerjKOByDCBxTAdBgNVHQ4EFgQUHkakN+xGDRr7GCER2OSy0FvvN7QwgZUGA1UdIwSBjTCBioAUHkakN+xGDRr7GCER2OSy0FvvN7ShZ6RlMGMxCzAJBgNVBAYTAkdBMQswCQYDVQQIEwJBVzEQMA4GA1UEBxMHQXRsYW50YTEMMAoGA1UEChMDVk1XMQ8wDQYDVQQLEwZBVyBFTU0xFjAUBgNVBAMTDXd3dy5hd21kbS5jb22CCQC7fPKGuKR2jTAMBgNVHRMEBTADAQH/MAkGByqGSM49BAEDgYsAMIGHAkIByvkebPlDlHVbZT+G+beFDwBzuSbTLp5cae0R+qUxbd24sXD5wozRiMs3GVRGd7L0sDeHbq8iJrLrKv7UJuh7HqECQVJVwthEuknri/pIajiuolJodLgVnaTqcCaOshuMejK1qT38yCqX/G5W/STw6iBv1/Dg6pwaIsmtrTn3NMDZkH+1MYIBIzCCAR8CAQEwcDBjMQswCQYDVQQGEwJHQTELMAkGA1UECBMCQVcxEDAOBgNVBAcTB0F0bGFudGExDDAKBgNVBAoTA1ZNVzEPMA0GA1UECxMGQVcgRU1NMRYwFAYDVQQDEw13d3cuYXdtZG0uY29tAgkAu3zyhrikdo0wDQYJYIZIAWUDBAIBBQAwCwYHKoZIzj0CAQUABIGLMIGIAkIAth4AncbHuAVpUqiie/nY3E/2jarczGI4HfMHci4a+yLbsMaAfU6baty0Ei6VUCWX7je5dmV/wb1gcU0RogDu9AwCQgFuI0qfrnXiC8Rfir7PpYl66P6eD7bGT3XK+2UlfIO0N05yYZAaHu7jCIdHIhi1wwtq9dsHwpcEJhLlJ8LyifAxDw==");
        wrongRSASHA1Message = Base64.decode((String)"MIAGCSqGSIb3DQEHAqCAMIACAQExCzAJBgUrDgMCHQUAMIAGCSqGSIb3DQEHAaCAJIAEDEhlbGxvIHdvcmxkIQAAAAAAAKCAMIICDTCCAXagAwIBAgIBATANBgkqhkiG9w0BAQUFADAlMRYwFAYDVQQKDA1Cb3VuY3kgQ2FzdGxlMQswCQYDVQQGEwJBVTAeFw0yMzEwMjMwNDI1NDZaFw0yNDAxMzEwNDI1NDZaMCUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxCzAJBgNVBAYTAkFVMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCPeTZYUeho8Keog+YJOdJWYOZbZCT/VWMjofN1hTvTauOeXVjDVB5D4rtdXE21hDdJTzWeO4axJxVfDsJ107Ejs6yF4WwJCNz8BDPZptga8Kl4ioGmpU5TTIPgqMHHclX/QDvbTRp6MImcKZ2Md5WECbdWYHAtPzo6H1pDWPiehQIDAQABo00wSzAdBgNVHQ4EFgQUa5xUEZKF6MTpJbRPGiwjkGGtGHEwHwYDVR0jBBgwFoAUa5xUEZKF6MTpJbRPGiwjkGGtGHEwCQYDVR0TBAIwADANBgkqhkiG9w0BAQUFAAOBgQCDkD5qMw2eim+Xp3U7T2FdJ46iLUjK31wrsEpTMT3RQz/mT5M6DLNVJQt8aIzyISAjdo5BLEFK7lNMWexEkH3IdQ+9uYT7adB9LWs6gtUMv+H6BE9G0/DAvM3K+fxUM4LTVY2EdZjIWOTyMBYtmjp63nP9NRDzOK2awhk2kKhdPDCCAiswggGUoAMCAQICAQIwDQYJKoZIhvcNAQEFBQAwJTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTELMAkGA1UEBhMCQVUwHhcNMjMxMDIzMDQyNTQ2WhcNMjQwMTMxMDQyNTQ2WjBDMQwwCgYDVQQDDANCb2IxDjAMBgNVBAsMBVNhbGVzMRYwFAYDVQQKDA1Cb3VuY3kgQ2FzdGxlMQswCQYDVQQGEwJBVTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEArIVf3YhZQHM6CBiussIy1NBE7uuRhdIszxdQX4cj4QavDj3F1lzGiIZNrCjGUcXQG3oItl96XvqY4VLmWw0LRkMvKf6wD+pr3jdNqUACcPE5B3I40OQRAq52KYpn10pg36C9XOKg8UbPKbLCueM8MdOina+0YL2UkI64Uw8s9MECAwEAAaNNMEswHQYDVR0OBBYEFJRiFuPZf1w4go0ONwDnVf3sswpfMB8GA1UdIwQYMBaAFGucVBGShejE6SW0TxosI5BhrRhxMAkGA1UdEwQCMAAwDQYJKoZIhvcNAQEFBQADgYEAXzYymmGBbv5MnxQdQ202koelj8GEx/VhGuYHnGFcAbxyCizobo8IE6RJUO3NLfnKiP1EK1aFNhqw+LU3pk84IS0wmXFXakmx1EuTG7JtRBQPrwBfbEDKDKT2vBOrq9gSRIFohrBZ9WNpJaBfgGdAkMogj8Dj98PuH3QzAsnclgoAADGBzzCBzAIBATAqMCUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxCzAJBgNVBAYTAkFVAgEBMAkGBSsOAwIdBQAwDQYJKoZIhvcNAQEBBQAEgYBrEz/W4bk+JCLcMulXBgghSo9DeDufRZl6p0rGjxMEk/AmWQac/K+Y6eAl4MNoVLdHzVvDlkUSMb4bz25fBys+B7A2Wn2gWyssRT5PfcxK91o24JPwnFypwLNqEgFrkC8c690ABj1OCEVTbAKOgI9ID7kXMJc+WZpQD2JLCGUG0AAAAAAAAA==");
        wrongRSASHA1MessageWithAttributes = Base64.decode((String)"MIAGCSqGSIb3DQEHAqCAMIACAQExCTAHBgUrDgMCHTCABgkqhkiG9w0BBwGggCSA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\nYlpnThaYbDCnWg8tbWYAAAAAAAA=");
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA1);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA224);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA256);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA384);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA512);
        noParams.add(X9ObjectIdentifiers.id_dsa_with_sha1);
        noParams.add(NISTObjectIdentifiers.dsa_with_sha224);
        noParams.add(NISTObjectIdentifiers.dsa_with_sha256);
        noParams.add(NISTObjectIdentifiers.dsa_with_sha384);
        noParams.add(NISTObjectIdentifiers.dsa_with_sha512);
        noParams.add(NISTObjectIdentifiers.id_dsa_with_sha3_224);
        noParams.add(NISTObjectIdentifiers.id_dsa_with_sha3_256);
        noParams.add(NISTObjectIdentifiers.id_dsa_with_sha3_384);
        noParams.add(NISTObjectIdentifiers.id_dsa_with_sha3_512);
        noParams.add(NISTObjectIdentifiers.id_ecdsa_with_sha3_224);
        noParams.add(NISTObjectIdentifiers.id_ecdsa_with_sha3_256);
        noParams.add(NISTObjectIdentifiers.id_ecdsa_with_sha3_384);
        noParams.add(NISTObjectIdentifiers.id_ecdsa_with_sha3_512);
        noParams.add(EdECObjectIdentifiers.id_Ed25519);
        noParams.add(EdECObjectIdentifiers.id_Ed448);
    }

    private static class TestCMSSignatureAlgorithmNameGenerator
    extends DefaultCMSSignatureAlgorithmNameGenerator {
        private TestCMSSignatureAlgorithmNameGenerator() {
        }

        void setDigestAlgorithmMapping(ASN1ObjectIdentifier oid, String algName) {
            super.setSigningDigestAlgorithmMapping(oid, algName);
        }

        void setEncryptionAlgorithmMapping(ASN1ObjectIdentifier oid, String algName) {
            super.setSigningEncryptionAlgorithmMapping(oid, algName);
        }
    }

    private static class MyRightSignerInformation
    extends SignerInformation {
        private boolean used;

        protected MyRightSignerInformation(SignerInformation baseInfo) {
            super(baseInfo);
        }

        boolean isUsed() {
            return this.used;
        }

        public byte[] getEncodedSignedAttributes() throws IOException {
            this.used = true;
            return this.signedAttributeSet.getEncoded("DL");
        }
    }

    private static class MyWrongSignerInformation
    extends SignerInformation {
        protected MyWrongSignerInformation(SignerInformation baseInfo) {
            super(baseInfo);
        }

        public byte[] getEncodedSignedAttributes() throws IOException {
            return new byte[this.signedAttributeSet.getEncoded("DL").length];
        }
    }
}

