/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSCompressedData;
import org.bouncycastle.cms.CMSCompressedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.ZlibCompressor;
import org.bouncycastle.cms.jcajce.ZlibExpanderProvider;
import org.bouncycastle.cms.test.CMSTestSetup;
import org.bouncycastle.operator.InputExpanderProvider;
import org.bouncycastle.operator.OutputCompressor;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.StreamOverflowException;

public class NewCompressedDataTest
extends TestCase {
    private static final byte[] TEST_DATA = "Hello world!".getBytes();
    static /* synthetic */ Class class$org$bouncycastle$cms$test$NewCompressedDataTest;

    public NewCompressedDataTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$bouncycastle$cms$test$NewCompressedDataTest == null ? (class$org$bouncycastle$cms$test$NewCompressedDataTest = NewCompressedDataTest.class$("org.bouncycastle.cms.test.NewCompressedDataTest")) : class$org$bouncycastle$cms$test$NewCompressedDataTest));
    }

    public static Test suite() {
        return new CMSTestSetup((Test)new TestSuite(class$org$bouncycastle$cms$test$NewCompressedDataTest == null ? (class$org$bouncycastle$cms$test$NewCompressedDataTest = NewCompressedDataTest.class$("org.bouncycastle.cms.test.NewCompressedDataTest")) : class$org$bouncycastle$cms$test$NewCompressedDataTest));
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testWorkingData() throws Exception {
        byte[] compData = Base64.decode((String)"MIAGCyqGSIb3DQEJEAEJoIAwgAIBADANBgsqhkiG9w0BCRADCDCABgkqhkiG9w0BBwGggCSABIICHnic7ZRdb9owFIbvK/k/5PqVYPFXGK12YYyboVFASSp1vQtZGiLRACZE49/XHoUW7S/0tXP8EfuxfU5ivWnasml72XFb3gb5druui7ytN803M570nii7C5r8tfwR281hy/p/KSM3+jzH5s3+pbQ90xSbP3VT3QbLusnt8WPIuN5vN/vaA2+DulnXTXkXvNTr8j8ouZmkCmGI/UW+ZS/C8zP0bz2dz0zwLt+1UEk2M8mlaxjRMByAhZTj0RGYg4TvogiRASROsZgjpVcJCb1KV6QzQeDJ1XkoQ5Jm+C5PbOHZZGRiv+ORAcshOGeCcdFJyfgFxdtCdEcmOrbinc/+BBMzRThEYpwl+jEBpciSGWQkI0TSlREmD/eOHb2DSGLuESm/iKUFt1y4XHBO2a5oq0IKJKWLS9kUZTA7vC5LSxYmgVL46SIWxIfWBQd6AdrnjLmH94UTvGxVibLqRCtIpp4g2qpdtqK1LiOeolpVK5wVQ5P7+QjZAlrh0cePYTx/gNZuB9Vhndtgujl9T/tgW9ogK+3rnmg3YWygnTuF5GDS+Q/jIVLnCcYZFc6Kk/+c80wKwZjwdZIqDYWRH68MuBQSXLgXYXj23CAaYOBNJMliTl0X7eV5DnoKIFSKYdj3cRpD/cK/JWTHJRe76MUXnfBW8m7Hd5zhQ4ri2NrVF/WL+kV1/3AGSlJ32bFPd2BsQD8uSzIx6lObkjdz95c0AAAAAAAAAAAAAAAA");
        byte[] uncompData = Base64.decode((String)"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");
        CMSCompressedData ed = new CMSCompressedData(compData);
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(uncompData, ed.getContent((InputExpanderProvider)new ZlibExpanderProvider())));
    }

    public void testEach() throws Exception {
        CMSCompressedData cd = this.getStdData();
        Assert.assertEquals((Object)PKCSObjectIdentifiers.data, (Object)cd.getCompressedContentType());
        Assert.assertEquals((Object)PKCSObjectIdentifiers.data, (Object)cd.getContentStream((InputExpanderProvider)new ZlibExpanderProvider()).getContentType());
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(TEST_DATA, cd.getContent((InputExpanderProvider)new ZlibExpanderProvider())));
    }

    public void testContentType() throws Exception {
        CMSCompressedData cd = this.getStdData(PKCSObjectIdentifiers.safeContentsBag);
        Assert.assertEquals((Object)PKCSObjectIdentifiers.safeContentsBag, (Object)cd.getCompressedContentType());
        Assert.assertEquals((Object)PKCSObjectIdentifiers.safeContentsBag, (Object)cd.getContentStream((InputExpanderProvider)new ZlibExpanderProvider()).getContentType());
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(TEST_DATA, cd.getContent((InputExpanderProvider)new ZlibExpanderProvider())));
    }

    public void testLimitUnder() throws Exception {
        CMSCompressedData cd = this.getStdData();
        try {
            cd.getContent((InputExpanderProvider)new ZlibExpanderProvider((long)(TEST_DATA.length / 2)));
        }
        catch (CMSException e) {
            Assert.assertEquals((boolean)true, (boolean)(e.getCause() instanceof StreamOverflowException));
        }
    }

    public void testLimitOver() throws Exception {
        CMSCompressedData cd = this.getStdData();
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(TEST_DATA, cd.getContent((InputExpanderProvider)new ZlibExpanderProvider((long)(TEST_DATA.length * 2)))));
    }

    public void testLimitEqual() throws Exception {
        CMSCompressedData cd = this.getStdData();
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(TEST_DATA, cd.getContent((InputExpanderProvider)new ZlibExpanderProvider((long)TEST_DATA.length))));
    }

    private CMSCompressedData getStdData(ASN1ObjectIdentifier contentType) throws CMSException {
        CMSProcessableByteArray testData = new CMSProcessableByteArray(contentType, TEST_DATA);
        CMSCompressedDataGenerator gen = new CMSCompressedDataGenerator();
        return gen.generate((CMSTypedData)testData, (OutputCompressor)new ZlibCompressor());
    }

    private CMSCompressedData getStdData() throws CMSException {
        return this.getStdData(PKCSObjectIdentifiers.data);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

