/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSAuthenticatedDataParser;
import org.bouncycastle.cms.CMSAuthenticatedDataStreamGenerator;
import org.bouncycastle.cms.OriginatorInfoGenerator;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceCMSMacCalculatorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransAuthenticatedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.cms.test.CMSTestSetup;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class NewAuthenticatedDataStreamTest
extends TestCase {
    private static final String BC = "BC";
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static String _reciDN;
    private static KeyPair _reciKP;
    private static X509Certificate _reciCert;
    private static KeyPair _origEcKP;
    private static KeyPair _reciEcKP;
    private static X509Certificate _reciEcCert;
    private static boolean _initialised;
    public boolean DEBUG = true;
    static /* synthetic */ Class class$org$bouncycastle$cms$test$NewAuthenticatedDataStreamTest;

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            Security.addProvider((Provider)new BouncyCastleProvider());
            _signDN = "O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _signKP, _signDN);
            _origDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _signKP, _signDN);
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
            _origEcKP = CMSTestUtil.makeEcDsaKeyPair();
            _reciEcKP = CMSTestUtil.makeEcDsaKeyPair();
            _reciEcCert = CMSTestUtil.makeCertificate(_reciEcKP, _reciDN, _signKP, _signDN);
        }
    }

    public void setUp() throws Exception {
        NewAuthenticatedDataStreamTest.init();
    }

    public NewAuthenticatedDataStreamTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$bouncycastle$cms$test$NewAuthenticatedDataStreamTest == null ? (class$org$bouncycastle$cms$test$NewAuthenticatedDataStreamTest = NewAuthenticatedDataStreamTest.class$("org.bouncycastle.cms.test.NewAuthenticatedDataStreamTest")) : class$org$bouncycastle$cms$test$NewAuthenticatedDataStreamTest));
    }

    public static Test suite() throws Exception {
        NewAuthenticatedDataStreamTest.init();
        return new CMSTestSetup((Test)new TestSuite(class$org$bouncycastle$cms$test$NewAuthenticatedDataStreamTest == null ? (class$org$bouncycastle$cms$test$NewAuthenticatedDataStreamTest = NewAuthenticatedDataStreamTest.class$("org.bouncycastle.cms.test.NewAuthenticatedDataStreamTest")) : class$org$bouncycastle$cms$test$NewAuthenticatedDataStreamTest));
    }

    public void testKeyTransDESede() throws Exception {
        this.tryKeyTrans("Eric H. Echidna".getBytes(), CMSAlgorithm.DES_EDE3_CBC);
        this.tryKeyTrans(new byte[2500], CMSAlgorithm.DES_EDE3_CBC);
    }

    public void testKeyTransDESedeWithDigest() throws Exception {
        this.tryKeyTransWithDigest("Eric H. Echidna".getBytes(), CMSAlgorithm.DES_EDE3_CBC);
        this.tryKeyTransWithDigest(new byte[2500], CMSAlgorithm.DES_EDE3_CBC);
    }

    public void testOriginatorInfo() throws Exception {
        ASN1ObjectIdentifier macAlg = CMSAlgorithm.DES_EDE3_CBC;
        byte[] data = "Eric H. Echidna".getBytes();
        CMSAuthenticatedDataStreamGenerator adGen = new CMSAuthenticatedDataStreamGenerator();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        X509CertificateHolder origCert = new X509CertificateHolder(_origCert.getEncoded());
        adGen.setOriginatorInfo(new OriginatorInfoGenerator(origCert).generate());
        adGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        OutputStream aOut = adGen.open((OutputStream)bOut, new JceCMSMacCalculatorBuilder(macAlg).setProvider(BC).build());
        aOut.write(data);
        aOut.close();
        CMSAuthenticatedDataParser ad = new CMSAuthenticatedDataParser(bOut.toByteArray());
        Assert.assertTrue((boolean)ad.getOriginatorInfo().getCertificates().getMatches(null).contains(origCert));
        RecipientInformationStore recipients = ad.getRecipientInfos();
        Assert.assertEquals((String)ad.getMacAlgOID(), (String)macAlg.getId());
        Collection c = recipients.getRecipients();
        Assert.assertEquals((int)1, (int)c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            Assert.assertEquals((String)recipient.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] recData = recipient.getContent((Recipient)new JceKeyTransAuthenticatedRecipient(_reciKP.getPrivate()).setProvider(BC));
            Assert.assertTrue((boolean)Arrays.equals(data, recData));
            Assert.assertTrue((boolean)Arrays.equals(ad.getMac(), recipient.getMac()));
        }
    }

    private void tryKeyTrans(byte[] data, ASN1ObjectIdentifier macAlg) throws Exception {
        CMSAuthenticatedDataStreamGenerator adGen = new CMSAuthenticatedDataStreamGenerator();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        adGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        OutputStream aOut = adGen.open((OutputStream)bOut, new JceCMSMacCalculatorBuilder(macAlg).setProvider(BC).build());
        aOut.write(data);
        aOut.close();
        CMSAuthenticatedDataParser ad = new CMSAuthenticatedDataParser(bOut.toByteArray());
        RecipientInformationStore recipients = ad.getRecipientInfos();
        Assert.assertEquals((String)ad.getMacAlgOID(), (String)macAlg.getId());
        Collection c = recipients.getRecipients();
        Assert.assertEquals((int)1, (int)c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            Assert.assertEquals((String)recipient.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] recData = recipient.getContent((Recipient)new JceKeyTransAuthenticatedRecipient(_reciKP.getPrivate()).setProvider(BC));
            Assert.assertTrue((boolean)Arrays.equals(data, recData));
            Assert.assertTrue((boolean)Arrays.equals(ad.getMac(), recipient.getMac()));
        }
    }

    private void tryKeyTransWithDigest(byte[] data, ASN1ObjectIdentifier macAlg) throws Exception {
        CMSAuthenticatedDataStreamGenerator adGen = new CMSAuthenticatedDataStreamGenerator();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DigestCalculatorProvider calcProvider = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        adGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        OutputStream aOut = adGen.open((OutputStream)bOut, new JceCMSMacCalculatorBuilder(macAlg).setProvider(BC).build(), calcProvider.get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1)));
        aOut.write(data);
        aOut.close();
        CMSAuthenticatedDataParser ad = new CMSAuthenticatedDataParser(bOut.toByteArray(), calcProvider);
        RecipientInformationStore recipients = ad.getRecipientInfos();
        Assert.assertEquals((String)ad.getMacAlgOID(), (String)macAlg.getId());
        Collection c = recipients.getRecipients();
        Assert.assertEquals((int)1, (int)c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            Assert.assertEquals((String)recipient.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] recData = recipient.getContent((Recipient)new JceKeyTransAuthenticatedRecipient(_reciKP.getPrivate()).setProvider(BC));
            Assert.assertTrue((boolean)Arrays.equals(data, recData));
            Assert.assertTrue((boolean)Arrays.equals(ad.getMac(), recipient.getMac()));
            Assert.assertTrue((boolean)Arrays.equals(ad.getContentDigest(), recipient.getContentDigest()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _initialised = false;
    }
}

