/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.cms.InputStreamWithMAC;
import org.bouncycastle.cms.test.CMSTestSetup;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class InputStreamWithMACTest
extends TestCase {
    static /* synthetic */ Class class$org$bouncycastle$cms$test$InputStreamWithMACTest;

    public static void main(String[] args) throws IOException {
        InputStreamWithMACTest test = new InputStreamWithMACTest();
        test.testReadBlock();
    }

    public static Test suite() throws Exception {
        return new CMSTestSetup((Test)new TestSuite(class$org$bouncycastle$cms$test$InputStreamWithMACTest == null ? (class$org$bouncycastle$cms$test$InputStreamWithMACTest = InputStreamWithMACTest.class$("org.bouncycastle.cms.test.InputStreamWithMACTest")) : class$org$bouncycastle$cms$test$InputStreamWithMACTest));
    }

    public void testReadBlock() throws IOException {
        byte[] array = new byte[32];
        byte[] mac = Hex.decode((String)"0102030405060708090a0b0c0d0e0f10");
        InputStreamWithMAC inputStream = new InputStreamWithMAC((InputStream)new ByteArrayInputStream(array), mac);
        try {
            inputStream.getMAC();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"input stream not fully processed", (String)e.getMessage());
        }
        Assert.assertEquals((int)32, (int)inputStream.read(new byte[46], 0, 46));
        byte[] tailBytes = new byte[19];
        Assert.assertEquals((int)1, (int)inputStream.read(tailBytes, 0, 1));
        Assert.assertEquals((int)1, (int)inputStream.read(tailBytes, 1, 1));
        Assert.assertEquals((int)14, (int)inputStream.read(tailBytes, 2, 17));
        Assert.assertEquals((int)-1, (int)inputStream.read());
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])inputStream.getMAC(), (byte[])mac));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])inputStream.getMAC(), (byte[])Arrays.copyOfRange((byte[])tailBytes, (int)0, (int)16)));
        inputStream = new InputStreamWithMAC((InputStream)new ByteArrayInputStream(array), mac);
        Assert.assertEquals((int)32, (int)inputStream.read(new byte[46], 0, 46));
        tailBytes = new byte[17];
        Assert.assertEquals((int)16, (int)inputStream.read(tailBytes, 0, 17));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])inputStream.getMAC(), (byte[])Arrays.copyOfRange((byte[])tailBytes, (int)0, (int)16)));
        Assert.assertEquals((int)-1, (int)inputStream.read(new byte[17], 0, 17));
        Assert.assertEquals((int)-1, (int)inputStream.read());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

