/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.math.BigInteger;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.jcajce.JcaSelectorConverter;
import org.bouncycastle.cms.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.jce.cert.X509CertSelector;
import org.bouncycastle.util.Arrays;

public class ConverterTest
extends TestCase {
    static /* synthetic */ Class class$org$bouncycastle$cms$test$ConverterTest;

    public void testSignerIdConversion() throws Exception {
        JcaX509CertSelectorConverter converter = new JcaX509CertSelectorConverter();
        JcaSelectorConverter toSelector = new JcaSelectorConverter();
        SignerId sid1 = new SignerId(new X500Name("CN=Test"), BigInteger.valueOf(1L), new byte[20]);
        X509CertSelector conv = converter.getCertSelector(sid1);
        Assert.assertTrue((boolean)conv.getIssuerAsString().equals("CN=Test"));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])conv.getSubjectKeyIdentifier(), (byte[])new DEROctetString(new byte[20]).getEncoded()));
        Assert.assertEquals((Object)conv.getSerialNumber(), (Object)sid1.getSerialNumber());
        SignerId sid2 = toSelector.getSignerId(conv);
        Assert.assertEquals((Object)sid1, (Object)sid2);
        sid1 = new SignerId(new X500Name("CN=Test"), BigInteger.valueOf(1L));
        conv = converter.getCertSelector(sid1);
        Assert.assertTrue((boolean)conv.getIssuerAsString().equals("CN=Test"));
        Assert.assertNull((Object)conv.getSubjectKeyIdentifier());
        Assert.assertEquals((Object)conv.getSerialNumber(), (Object)sid1.getSerialNumber());
        sid2 = toSelector.getSignerId(conv);
        Assert.assertEquals((Object)sid1, (Object)sid2);
        sid1 = new SignerId(new byte[20]);
        conv = converter.getCertSelector(sid1);
        Assert.assertNull((Object)conv.getIssuerAsString());
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])conv.getSubjectKeyIdentifier(), (byte[])new DEROctetString(new byte[20]).getEncoded()));
        Assert.assertNull((Object)conv.getSerialNumber());
        sid2 = toSelector.getSignerId(conv);
        Assert.assertEquals((Object)sid1, (Object)sid2);
    }

    public void testRecipientIdConversion() throws Exception {
        JcaX509CertSelectorConverter converter = new JcaX509CertSelectorConverter();
        JcaSelectorConverter toSelector = new JcaSelectorConverter();
        KeyTransRecipientId ktid1 = new KeyTransRecipientId(new X500Name("CN=Test"), BigInteger.valueOf(1L), new byte[20]);
        X509CertSelector conv = converter.getCertSelector(ktid1);
        Assert.assertTrue((boolean)conv.getIssuerAsString().equals("CN=Test"));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])conv.getSubjectKeyIdentifier(), (byte[])new DEROctetString(new byte[20]).getEncoded()));
        Assert.assertEquals((Object)conv.getSerialNumber(), (Object)ktid1.getSerialNumber());
        KeyTransRecipientId ktid2 = toSelector.getKeyTransRecipientId(conv);
        Assert.assertEquals((Object)ktid1, (Object)ktid2);
        ktid1 = new KeyTransRecipientId(new X500Name("CN=Test"), BigInteger.valueOf(1L));
        conv = converter.getCertSelector(ktid1);
        Assert.assertTrue((boolean)conv.getIssuerAsString().equals("CN=Test"));
        Assert.assertNull((Object)conv.getSubjectKeyIdentifier());
        Assert.assertEquals((Object)conv.getSerialNumber(), (Object)ktid1.getSerialNumber());
        ktid2 = toSelector.getKeyTransRecipientId(conv);
        Assert.assertEquals((Object)ktid1, (Object)ktid2);
        ktid1 = new KeyTransRecipientId(new byte[20]);
        conv = converter.getCertSelector(ktid1);
        Assert.assertNull((Object)conv.getIssuerAsString());
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])conv.getSubjectKeyIdentifier(), (byte[])new DEROctetString(new byte[20]).getEncoded()));
        Assert.assertNull((Object)conv.getSerialNumber());
        ktid2 = toSelector.getKeyTransRecipientId(conv);
        Assert.assertEquals((Object)ktid1, (Object)ktid2);
    }

    public static Test suite() throws Exception {
        return new TestSuite(class$org$bouncycastle$cms$test$ConverterTest == null ? (class$org$bouncycastle$cms$test$ConverterTest = ConverterTest.class$("org.bouncycastle.cms.test.ConverterTest")) : class$org$bouncycastle$cms$test$ConverterTest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

