/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.test;

import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.DeltaCertificateDescriptor;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectAltPublicKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.DeltaCertificateTool;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jcajce.spec.MLDSAParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.util.encoders.Base64;

public class DeltaCertTest
extends TestCase {
    private static byte[] deltaCertReq = Base64.decode((String)"MIIP2zCCD4ACAQAwDzENMAsGA1UEAwwEVGVzdDBZMBMGByqGSM49AgEGCCqGSM49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\nahofKFqOtfmLrzh+a8VCq30wqdJhqf+imN28KcziNA==");
    static /* synthetic */ Class class$org$bouncycastle$cert$test$DeltaCertTest;

    public void setUp() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public void testSameName() throws Exception {
        KeyPairGenerator rsaKeyGen = KeyPairGenerator.getInstance("RSA", "BC");
        rsaKeyGen.initialize(2048, new SecureRandom());
        KeyPair deltaKeyPair = rsaKeyGen.generateKeyPair();
        KeyPair baseKeyPair = rsaKeyGen.generateKeyPair();
        X509v3CertificateBuilder deltaCertBuilder = new X509v3CertificateBuilder(new X500Name("CN=Issuer"), BigInteger.valueOf(1L), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 31536000000L), new X500Name("CN=Subject"), SubjectPublicKeyInfo.getInstance((Object)deltaKeyPair.getPublic().getEncoded()));
        ContentSigner deltaRootSigner = new JcaContentSignerBuilder("SHA256withRSA").build(deltaKeyPair.getPrivate());
        X509CertificateHolder deltaCert = deltaCertBuilder.build(deltaRootSigner);
        X509v3CertificateBuilder baseCertBuilder = new X509v3CertificateBuilder(new X500Name("CN=Issuer"), BigInteger.valueOf(2L), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 31536000000L), new X500Name("CN=Subject"), SubjectPublicKeyInfo.getInstance((Object)baseKeyPair.getPublic().getEncoded()));
        Extension deltaCertExtension = DeltaCertificateTool.makeDeltaCertificateExtension((boolean)false, (X509CertificateHolder)deltaCert);
        baseCertBuilder.addExtension(deltaCertExtension);
        ContentSigner baseRootSigner = new JcaContentSignerBuilder("SHA256withRSA").build(baseKeyPair.getPrivate());
        X509CertificateHolder baseCert = baseCertBuilder.build(baseRootSigner);
    }

    public void testDeltaCertWithExtensions() throws Exception {
        X500Name subject = new X500Name("CN=Test Subject");
        KeyPairGenerator kpgA = KeyPairGenerator.getInstance("RSA", "BC");
        kpgA.initialize(2048);
        KeyPair kpA = kpgA.generateKeyPair();
        KeyPairGenerator kpgB = KeyPairGenerator.getInstance("EC", "BC");
        kpgB.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("P-256"));
        KeyPair kpB = kpgB.generateKeyPair();
        ContentSigner signerA = new JcaContentSignerBuilder("SHA256withRSA").build(kpA.getPrivate());
        Date notBefore = new Date(System.currentTimeMillis() - 5000L);
        Date notAfter = new Date(System.currentTimeMillis() + 3600000L);
        X509v3CertificateBuilder bldr = new X509v3CertificateBuilder(new X500Name("CN=Chameleon CA 1"), BigInteger.valueOf(System.currentTimeMillis()), notBefore, notAfter, subject, SubjectPublicKeyInfo.getInstance((Object)kpA.getPublic().getEncoded()));
        bldr.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        ContentSigner signerB = new JcaContentSignerBuilder("SHA256withECDSA").build(kpB.getPrivate());
        X509v3CertificateBuilder deltaBldr = new X509v3CertificateBuilder(new X500Name("CN=Chameleon CA 2"), BigInteger.valueOf(System.currentTimeMillis()), notBefore, notAfter, subject, SubjectPublicKeyInfo.getInstance((Object)kpB.getPublic().getEncoded()));
        deltaBldr.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        X509CertificateHolder deltaCert = deltaBldr.build(signerB);
        Extension deltaExt = DeltaCertificateTool.makeDeltaCertificateExtension((boolean)false, (X509CertificateHolder)deltaCert);
        bldr.addExtension(deltaExt);
        X509CertificateHolder chameleonCert = bldr.build(signerA);
        Assert.assertTrue((boolean)chameleonCert.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(kpA.getPublic())));
        DeltaCertificateDescriptor deltaCertDesc = DeltaCertificateDescriptor.fromExtensions((Extensions)chameleonCert.getExtensions());
        Assert.assertNull((Object)deltaCertDesc.getExtensions());
        Assert.assertNull((Object)deltaCertDesc.getSubject());
        Assert.assertNotNull((Object)deltaCertDesc.getIssuer());
        X509CertificateHolder exDeltaCert = DeltaCertificateTool.extractDeltaCertificate((X509CertificateHolder)chameleonCert);
        Assert.assertTrue((boolean)exDeltaCert.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(kpB.getPublic())));
    }

    public void testCheckCreationAltCertWithDelta() throws Exception {
        KeyPairGenerator kpgB = KeyPairGenerator.getInstance("EC", "BC");
        kpgB.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("P-256"));
        KeyPair kpB = kpgB.generateKeyPair();
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("ML-DSA", "BC");
        kpGen.initialize((AlgorithmParameterSpec)MLDSAParameterSpec.ml_dsa_44, new SecureRandom());
        KeyPair kp = kpGen.generateKeyPair();
        PrivateKey privKey = kp.getPrivate();
        PublicKey pubKey = kp.getPublic();
        KeyPairGenerator ecKpGen = KeyPairGenerator.getInstance("EC", "BC");
        ecKpGen.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("P-256"), new SecureRandom());
        KeyPair ecKp = ecKpGen.generateKeyPair();
        PrivateKey ecPrivKey = ecKp.getPrivate();
        PublicKey ecPubKey = ecKp.getPublic();
        Date notBefore = new Date(System.currentTimeMillis() - 5000L);
        Date notAfter = new Date(System.currentTimeMillis() + 3600000L);
        X500Name issuer = new X500Name("CN=Chameleon Base Issuer");
        X500Name subject = new X500Name("CN=Chameleon Base Subject");
        ContentSigner sigGen = new JcaContentSignerBuilder("SHA256withECDSA").setProvider("BC").build(ecPrivKey);
        ContentSigner altSigGen = new JcaContentSignerBuilder("ML-DSA-44").setProvider("BC").build(privKey);
        X509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(issuer, BigInteger.valueOf(1L), notBefore, notAfter, subject, ecPubKey).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false)).addExtension(Extension.subjectAltPublicKeyInfo, false, (ASN1Encodable)SubjectAltPublicKeyInfo.getInstance((Object)kp.getPublic().getEncoded()));
        ContentSigner signerB = new JcaContentSignerBuilder("SHA256withECDSA").build(kpB.getPrivate());
        X509v3CertificateBuilder deltaBldr = new X509v3CertificateBuilder(new X500Name("CN=Chameleon CA 2"), BigInteger.valueOf(System.currentTimeMillis()), notBefore, notAfter, subject, SubjectPublicKeyInfo.getInstance((Object)kpB.getPublic().getEncoded()));
        deltaBldr.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false)).addExtension(Extension.subjectAltPublicKeyInfo, false, (ASN1Encodable)SubjectAltPublicKeyInfo.getInstance((Object)kp.getPublic().getEncoded()));
        X509CertificateHolder deltaCert = deltaBldr.build(signerB, false, altSigGen);
        Assert.assertTrue((boolean)deltaCert.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(kpB.getPublic())));
        Extension deltaExt = DeltaCertificateTool.makeDeltaCertificateExtension((boolean)false, (X509CertificateHolder)deltaCert);
        certGen.addExtension(deltaExt);
        X509CertificateHolder certHldr = certGen.build(sigGen, false, altSigGen);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHldr);
        cert.checkValidity(new Date());
        cert.verify(cert.getPublicKey());
        cert.getEncoded();
        JcaX509CertificateHolder certHolder = new JcaX509CertificateHolder(cert);
        X509CertificateHolder exDeltaCert = DeltaCertificateTool.extractDeltaCertificate((X509CertificateHolder)new X509CertificateHolder(cert.getEncoded()));
        Assert.assertTrue((boolean)exDeltaCert.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(kpB.getPublic())));
        Assert.assertTrue((boolean)exDeltaCert.isAlternativeSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(pubKey)));
        Assert.assertTrue((boolean)certHldr.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(ecPubKey)));
        Assert.assertTrue((boolean)certHldr.isAlternativeSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(pubKey)));
    }

    public void testDraftMLDSARoot() throws Exception {
        X509CertificateHolder baseCert = DeltaCertTest.readCert("ml_dsa_root.pem");
        Assert.assertTrue((boolean)baseCert.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(baseCert.getSubjectPublicKeyInfo())));
        X509CertificateHolder deltaCert = DeltaCertificateTool.extractDeltaCertificate((X509CertificateHolder)baseCert);
        Assert.assertTrue((boolean)deltaCert.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(deltaCert.getSubjectPublicKeyInfo())));
        X509CertificateHolder extCert = DeltaCertTest.readCert("ec_dsa_root.pem");
        Assert.assertTrue((boolean)extCert.equals((Object)deltaCert));
    }

    public void testDraftMLDSAEndEntity() throws Exception {
        X509CertificateHolder rootCert = DeltaCertTest.readCert("ml_dsa_root.pem");
        X509CertificateHolder ecRootCert = DeltaCertTest.readCert("ec_dsa_root.pem");
        X509CertificateHolder baseCert = DeltaCertTest.readCert("ec_dsa_ee.pem");
        Assert.assertTrue((boolean)baseCert.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(ecRootCert.getSubjectPublicKeyInfo())));
        X509CertificateHolder deltaCert = DeltaCertificateTool.extractDeltaCertificate((X509CertificateHolder)baseCert);
        Assert.assertTrue((boolean)deltaCert.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(rootCert.getSubjectPublicKeyInfo())));
        X509CertificateHolder extCert = DeltaCertTest.readCert("ml_dsa_ee.pem");
        Assert.assertTrue((boolean)extCert.equals((Object)deltaCert));
    }

    public void testDraftDualUseEcDsaEndEntity() throws Exception {
        X509CertificateHolder ecRootCert = DeltaCertTest.readCert("ec_dsa_root.pem");
        X509CertificateHolder baseCert = DeltaCertTest.readCert("ec_dsa_dual_xch_ee.pem");
        Assert.assertTrue((boolean)baseCert.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(ecRootCert.getSubjectPublicKeyInfo())));
        X509CertificateHolder deltaCert = DeltaCertificateTool.extractDeltaCertificate((X509CertificateHolder)baseCert);
        X509CertificateHolder extCert = DeltaCertTest.readCert("ec_dsa_dual_sig_ee.pem");
        Assert.assertTrue((boolean)extCert.equals((Object)deltaCert));
        Assert.assertTrue((boolean)deltaCert.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(ecRootCert.getSubjectPublicKeyInfo())));
    }

    private static X509CertificateHolder readCert(String name) throws Exception {
        PEMParser p = new PEMParser((Reader)new InputStreamReader((class$org$bouncycastle$cert$test$DeltaCertTest == null ? (class$org$bouncycastle$cert$test$DeltaCertTest = DeltaCertTest.class$("org.bouncycastle.cert.test.DeltaCertTest")) : class$org$bouncycastle$cert$test$DeltaCertTest).getResourceAsStream("delta/" + name)));
        X509CertificateHolder cert = (X509CertificateHolder)p.readObject();
        p.close();
        return cert;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

