/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.test;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.dane.DANEEntry;
import org.bouncycastle.cert.dane.DANEEntryFactory;
import org.bouncycastle.cert.dane.DANEException;
import org.bouncycastle.cert.dane.TruncatingDigestCalculator;
import org.bouncycastle.cert.test.SHA256DigestCalculator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class DANETest
extends SimpleTest {
    byte[] randomCert = Base64.decode((String)"MIIDbDCCAtWgAwIBAgIBADANBgkqhkiG9w0BAQQFADCBtzELMAkGA1UEBhMCQVUxETAPBgNVBAgTCFZpY3RvcmlhMRgwFgYDVQQHEw9Tb3V0aCBNZWxib3VybmUxGjAYBgNVBAoTEUNvbm5lY3QgNCBQdHkgTHRkMR4wHAYDVQQLExVDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxFTATBgNVBAMTDENvbm5lY3QgNCBDQTEoMCYGCSqGSIb3DQEJARYZd2VibWFzdGVyQGNvbm5lY3Q0LmNvbS5hdTAeFw0wMDA2MDIwNzU1MzNaFw0wMTA2MDIwNzU1MzNaMIG3MQswCQYDVQQGEwJBVTERMA8GA1UECBMIVmljdG9yaWExGDAWBgNVBAcTD1NvdXRoIE1lbGJvdXJuZTEaMBgGA1UEChMRQ29ubmVjdCA0IFB0eSBMdGQxHjAcBgNVBAsTFUNlcnRpZmljYXRlIEF1dGhvcml0eTEVMBMGA1UEAxMMQ29ubmVjdCA0IENBMSgwJgYJKoZIhvcNAQkBFhl3ZWJtYXN0ZXJAY29ubmVjdDQuY29tLmF1MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDgs5ptNG6Qv1ZpCDuUNGmvrhjqMDPd3ri8JzZNRiiFlBA4e6/ReaO1U8ASewDeQMH6i9R6degFdQRLngbuJP0sxcEE+SksEWNvygfzLwV9J/q+TQDyJYK52utb++lS0b48A1KPLwEsyL6kOAgelburukwxowprKUIV7Knf1ajetQIDAQABo4GFMIGCMCQGA1UdEQQdMBuBGXdlYm1hc3RlckBjb25uZWN0NC5jb20uYXUwDwYDVR0TBAgwBgEB/wIBADA2BglghkgBhvhCAQ0EKRYnbW9kX3NzbCBnZW5lcmF0ZWQgY3VzdG9tIENBIGNlcnRpZmljYXRlMBEGCWCGSAGG+EIBAQQEAwICBDANBgkqhkiG9w0BAQQFAAOBgQCsGvfdghH8pPhlwm1r3pQkmsnLAVIBb01EhbXm2861iXZfWqGQjrGAaA0ZpXNk9oo110yxoqEoSJSzniZa7XtzsoTwNUpE0SLHvWf/SlKdFWlzXA+vOZbzEv4UmjeelekTm7lc01EEa5QRVzOxHFtQDhkaJ8VqOMajkQFma2r9iA==");

    public String getName() {
        return "DANETest";
    }

    private void shouldCreateDANEEntry() throws IOException, DANEException {
        DANEEntryFactory daneEntryFactory = new DANEEntryFactory((DigestCalculator)new TruncatingDigestCalculator((DigestCalculator)new SHA256DigestCalculator()));
        DANEEntry entry = daneEntryFactory.createEntry("test@test.com", new X509CertificateHolder(this.randomCert));
        if (!DANEEntry.isValidCertificate((byte[])entry.getRDATA())) {
            this.fail("encoding error in RDATA");
        }
        if (!"9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15._smimecert.test.com".equals(entry.getDomainName())) {
            this.fail("domain name associated with entry wrong");
        }
        byte[] rdata = entry.getRDATA();
        byte[] certData = new byte[rdata.length - 3];
        System.arraycopy(rdata, 3, certData, 0, certData.length);
        if (!Arrays.areEqual((byte[])certData, (byte[])this.randomCert)) {
            this.fail("certificate encoding does not match");
        }
    }

    public void performTest() throws Exception {
        this.shouldCreateDANEEntry();
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new DANETest());
    }
}

