/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.test;

import java.math.BigInteger;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cert.selector.jcajce.JcaSelectorConverter;
import org.bouncycastle.cert.selector.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.jce.cert.X509CertSelector;
import org.bouncycastle.util.Arrays;

public class ConverterTest
extends TestCase {
    static /* synthetic */ Class class$org$bouncycastle$cert$test$ConverterTest;

    public void testCertificateSelectorConversion() throws Exception {
        JcaX509CertSelectorConverter converter = new JcaX509CertSelectorConverter();
        JcaSelectorConverter toSelector = new JcaSelectorConverter();
        X509CertificateHolderSelector sid1 = new X509CertificateHolderSelector(new X500Name("CN=Test"), BigInteger.valueOf(1L), new byte[20]);
        X509CertSelector conv = converter.getCertSelector(sid1);
        Assert.assertTrue((boolean)conv.getIssuerAsString().equals("CN=Test"));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])conv.getSubjectKeyIdentifier(), (byte[])new DEROctetString(new byte[20]).getEncoded()));
        Assert.assertEquals((Object)conv.getSerialNumber(), (Object)sid1.getSerialNumber());
        X509CertificateHolderSelector sid2 = toSelector.getCertificateHolderSelector(conv);
        Assert.assertEquals((Object)sid1, (Object)sid2);
        sid1 = new X509CertificateHolderSelector(new X500Name("CN=Test"), BigInteger.valueOf(1L));
        conv = converter.getCertSelector(sid1);
        Assert.assertTrue((boolean)conv.getIssuerAsString().equals("CN=Test"));
        Assert.assertNull((Object)conv.getSubjectKeyIdentifier());
        Assert.assertEquals((Object)conv.getSerialNumber(), (Object)sid1.getSerialNumber());
        sid2 = toSelector.getCertificateHolderSelector(conv);
        Assert.assertEquals((Object)sid1, (Object)sid2);
        sid1 = new X509CertificateHolderSelector(new byte[20]);
        conv = converter.getCertSelector(sid1);
        Assert.assertNull((Object)conv.getIssuerAsString());
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])conv.getSubjectKeyIdentifier(), (byte[])new DEROctetString(new byte[20]).getEncoded()));
        Assert.assertNull((Object)conv.getSerialNumber());
        sid2 = toSelector.getCertificateHolderSelector(conv);
        Assert.assertEquals((Object)sid1, (Object)sid2);
    }

    public static Test suite() {
        return new TestSuite(class$org$bouncycastle$cert$test$ConverterTest == null ? (class$org$bouncycastle$cert$test$ConverterTest = ConverterTest.class$("org.bouncycastle.cert.test.ConverterTest")) : class$org$bouncycastle$cert$test$ConverterTest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

