/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.test;

import java.math.BigInteger;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.Target;
import org.bouncycastle.asn1.x509.TargetInformation;
import org.bouncycastle.cert.AttributeCertificateHolder;
import org.bouncycastle.cert.AttributeCertificateIssuer;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v2AttributeCertificateBuilder;
import org.bouncycastle.cert.selector.X509AttributeCertificateHolderSelectorBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.util.encoders.Base64;

public class BcAttrCertSelectorTest
extends TestCase {
    DefaultSignatureAlgorithmIdentifierFinder sigAlgFinder = new DefaultSignatureAlgorithmIdentifierFinder();
    DefaultDigestAlgorithmIdentifierFinder digAlgFinder = new DefaultDigestAlgorithmIdentifierFinder();
    static final RSAPrivateCrtKeyParameters RSA_PRIVATE_KEY_SPEC = new RSAPrivateCrtKeyParameters(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16), new BigInteger("9f66f6b05410cd503b2709e88115d55daced94d1a34d4e32bf824d0dde6028ae79c5f07b580f5dce240d7111f7ddb130a7945cd7d957d1920994da389f490c89", 16), new BigInteger("c0a0758cdf14256f78d4708c86becdead1b50ad4ad6c5c703e2168fbf37884cb", 16), new BigInteger("f01734d7960ea60070f1b06f2bb81bfac48ff192ae18451d5e56c734a5aab8a5", 16), new BigInteger("b54bb9edff22051d9ee60f9351a48591b6500a319429c069a3e335a1d6171391", 16), new BigInteger("d3d83daf2a0cecd3367ae6f8ae1aeb82e9ac2f816c6fc483533d8297dd7884cd", 16), new BigInteger("b8f52fc6f38593dabb661d3f50f8897f8106eee68b1bce78a95b132b4e5b5d19", 16));
    static final byte[] holderCert = Base64.decode((String)"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");

    public String getName() {
        return "AttrCertSelector";
    }

    private X509AttributeCertificateHolder createAttrCert() throws Exception {
        X509CertificateHolder iCertHolder = new X509CertificateHolder(holderCert);
        X509v2AttributeCertificateBuilder gen = new X509v2AttributeCertificateBuilder(new AttributeCertificateHolder(iCertHolder.getSubject()), new AttributeCertificateIssuer(new X500Name("cn=test")), BigInteger.ONE, new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L));
        GeneralName roleName = new GeneralName(1, "DAU123456789@test.com");
        ASN1EncodableVector roleSyntax = new ASN1EncodableVector();
        roleSyntax.add((ASN1Encodable)roleName);
        gen.addAttribute(new ASN1ObjectIdentifier("2.5.24.72"), (ASN1Encodable)new DERSequence(roleSyntax));
        AlgorithmIdentifier sigAlg = this.sigAlgFinder.find("SHA1withRSA");
        AlgorithmIdentifier digAlg = this.digAlgFinder.find(sigAlg);
        ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlg, digAlg).build((AsymmetricKeyParameter)RSA_PRIVATE_KEY_SPEC);
        Target targetName = new Target(0, new GeneralName(2, "www.test.com"));
        Target targetGroup = new Target(1, new GeneralName(4, "o=Test, ou=Test"));
        Target[] targets = new Target[]{targetName, targetGroup};
        TargetInformation targetInformation = new TargetInformation(targets);
        gen.addExtension(Extension.targetInformation, true, (ASN1Encodable)targetInformation);
        return gen.build(sigGen);
    }

    public void testSelector() throws Exception {
        X509AttributeCertificateHolder aCert = this.createAttrCert();
        X509AttributeCertificateHolderSelectorBuilder sel = new X509AttributeCertificateHolderSelectorBuilder();
        sel.setAttributeCert(aCert);
        boolean match = sel.build().match((Object)aCert);
        if (!match) {
            Assert.fail((String)"Selector does not match attribute certificate.");
        }
        sel.setAttributeCert(null);
        match = sel.build().match((Object)aCert);
        if (!match) {
            Assert.fail((String)"Selector does not match attribute certificate.");
        }
        sel.setHolder(aCert.getHolder());
        match = sel.build().match((Object)aCert);
        if (!match) {
            Assert.fail((String)"Selector does not match attribute certificate holder.");
        }
        sel.setHolder(null);
        sel.setIssuer(aCert.getIssuer());
        match = sel.build().match((Object)aCert);
        if (!match) {
            Assert.fail((String)"Selector does not match attribute certificate issuer.");
        }
        sel.setIssuer(null);
        X509CertificateHolder iCert = new X509CertificateHolder(holderCert);
        match = aCert.getHolder().match((Object)iCert);
        if (!match) {
            Assert.fail((String)"Issuer holder does not match signing certificate of attribute certificate.");
        }
        sel.setSerialNumber(aCert.getSerialNumber());
        match = sel.build().match((Object)aCert);
        if (!match) {
            Assert.fail((String)"Selector does not match attribute certificate serial number.");
        }
        sel.setAttributeCertificateValid(new Date());
        match = sel.build().match((Object)aCert);
        if (!match) {
            Assert.fail((String)"Selector does not match attribute certificate time.");
        }
        sel.addTargetName(new GeneralName(2, "www.test.com"));
        match = sel.build().match((Object)aCert);
        if (!match) {
            Assert.fail((String)"Selector does not match attribute certificate target name.");
        }
        sel.setTargetNames(null);
        sel.addTargetGroup(new GeneralName(4, "o=Test, ou=Test"));
        match = sel.build().match((Object)aCert);
        if (!match) {
            Assert.fail((String)"Selector does not match attribute certificate target group.");
        }
        sel.setTargetGroups(null);
    }
}

