/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.path.test;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509ContentVerifierProviderBuilder;
import org.bouncycastle.cert.jcajce.JcaX509ContentVerifierProviderBuilder;
import org.bouncycastle.cert.path.CertPath;
import org.bouncycastle.cert.path.CertPathValidation;
import org.bouncycastle.cert.path.CertPathValidationResult;
import org.bouncycastle.cert.path.validations.BasicConstraintsValidation;
import org.bouncycastle.cert.path.validations.KeyUsageValidation;
import org.bouncycastle.cert.path.validations.ParentCertIssuedValidation;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.test.SimpleTest;

public class PKITSBasicConstraintsTest
extends SimpleTest {
    public static final String PKITS_DATA_RESOURCE_PREFIX = "/PKITS/certs/";

    public String getName() {
        return "PKITSBasicConstraintsTest";
    }

    private static X509CertificateHolder readPKITSCert(String fileName) throws IOException {
        ASN1InputStream asn1In = new ASN1InputStream(TestResourceFinder.findTestResource(PKITS_DATA_RESOURCE_PREFIX, fileName));
        return new X509CertificateHolder(Certificate.getInstance((Object)asn1In.readObject()));
    }

    private static CertPath readPKITSPath(String eeCertFile, String[] intermCertFiles) throws IOException {
        X509CertificateHolder[] certsInPath = new X509CertificateHolder[intermCertFiles.length + 2];
        certsInPath[certsInPath.length - 1] = PKITSBasicConstraintsTest.readPKITSCert("TrustAnchorRootCertificate.crt");
        certsInPath[0] = PKITSBasicConstraintsTest.readPKITSCert(eeCertFile);
        int i = 0;
        while (i < intermCertFiles.length) {
            certsInPath[certsInPath.length - 2 - i] = PKITSBasicConstraintsTest.readPKITSCert(intermCertFiles[i]);
            ++i;
        }
        return new CertPath(certsInPath);
    }

    private static CertPathValidationResult checkPKITSPath(String eeCertFile, String[] intermCertFiles) throws IOException {
        CertPath path = PKITSBasicConstraintsTest.readPKITSPath(eeCertFile, intermCertFiles);
        JcaX509ContentVerifierProviderBuilder verifier = new JcaX509ContentVerifierProviderBuilder();
        CertPathValidation[] validators = new CertPathValidation[]{new BasicConstraintsValidation(), new KeyUsageValidation(), new ParentCertIssuedValidation((X509ContentVerifierProviderBuilder)verifier)};
        return path.validate(validators);
    }

    private void expectBCValidationSuccess(String eeCertFile, String[] intermCertFiles) throws IOException {
        CertPathValidationResult cpvr = PKITSBasicConstraintsTest.checkPKITSPath(eeCertFile, intermCertFiles);
        this.isTrue("Valid path was rejected", cpvr.isValid());
    }

    private void expectBCValidationFailure(String eeCertFile, String[] intermCertFiles, String expectedMessage) throws IOException {
        CertPathValidationResult cpvr = PKITSBasicConstraintsTest.checkPKITSPath(eeCertFile, intermCertFiles);
        this.isTrue("Invalid path was accepted", !cpvr.isValid());
        String reasonMessage = cpvr.getCause().getMessage();
        this.isEquals("Rejection reasons do not match: expected " + expectedMessage + ", got " + reasonMessage, expectedMessage, reasonMessage);
    }

    public void performTest() throws Exception {
        this.expectBCValidationFailure("InvalidMissingbasicConstraintsTest1EE.crt", new String[]{"MissingbasicConstraintsCACert.crt"}, "Basic constraints violated: issuer is not a CA");
        CertPath invalidPath = PKITSBasicConstraintsTest.readPKITSPath("InvalidMissingbasicConstraintsTest1EE.crt", new String[]{"MissingbasicConstraintsCACert.crt"});
        CertPathValidation[] lenientValidators = new CertPathValidation[]{new BasicConstraintsValidation(false), new KeyUsageValidation(), new ParentCertIssuedValidation((X509ContentVerifierProviderBuilder)new JcaX509ContentVerifierProviderBuilder())};
        this.isTrue(invalidPath.validate(lenientValidators).isValid());
        this.expectBCValidationFailure("InvalidcAFalseTest2EE.crt", new String[]{"basicConstraintsCriticalcAFalseCACert.crt"}, "Basic constraints violated: issuer is not a CA");
        this.expectBCValidationFailure("InvalidcAFalseTest3EE.crt", new String[]{"basicConstraintsNotCriticalcAFalseCACert.crt"}, "Basic constraints violated: issuer is not a CA");
        this.expectBCValidationSuccess("ValidbasicConstraintsNotCriticalTest4EE.crt", new String[]{"basicConstraintsNotCriticalCACert.crt"});
        this.expectBCValidationFailure("InvalidpathLenConstraintTest5EE.crt", new String[]{"pathLenConstraint0CACert.crt", "pathLenConstraint0subCACert.crt"}, "Basic constraints violated: path length exceeded");
        this.expectBCValidationFailure("InvalidpathLenConstraintTest6EE.crt", new String[]{"pathLenConstraint0CACert.crt", "pathLenConstraint0subCACert.crt"}, "Basic constraints violated: path length exceeded");
        this.expectBCValidationSuccess("ValidpathLenConstraintTest7EE.crt", new String[]{"pathLenConstraint0CACert.crt"});
        this.expectBCValidationSuccess("ValidpathLenConstraintTest8EE.crt", new String[]{"pathLenConstraint0CACert.crt"});
        this.expectBCValidationFailure("InvalidpathLenConstraintTest9EE.crt", new String[]{"pathLenConstraint6CACert.crt", "pathLenConstraint6subCA0Cert.crt", "pathLenConstraint6subsubCA00Cert.crt"}, "Basic constraints violated: path length exceeded");
        this.expectBCValidationFailure("InvalidpathLenConstraintTest10EE.crt", new String[]{"pathLenConstraint6CACert.crt", "pathLenConstraint6subCA0Cert.crt", "pathLenConstraint6subsubCA00Cert.crt"}, "Basic constraints violated: path length exceeded");
        this.expectBCValidationFailure("InvalidpathLenConstraintTest11EE.crt", new String[]{"pathLenConstraint6CACert.crt", "pathLenConstraint6subCA1Cert.crt", "pathLenConstraint6subsubCA11Cert.crt", "pathLenConstraint6subsubsubCA11XCert.crt"}, "Basic constraints violated: path length exceeded");
        this.expectBCValidationFailure("InvalidpathLenConstraintTest12EE.crt", new String[]{"pathLenConstraint6CACert.crt", "pathLenConstraint6subCA1Cert.crt", "pathLenConstraint6subsubCA11Cert.crt", "pathLenConstraint6subsubsubCA11XCert.crt"}, "Basic constraints violated: path length exceeded");
        this.expectBCValidationSuccess("ValidpathLenConstraintTest13EE.crt", new String[]{"pathLenConstraint6CACert.crt", "pathLenConstraint6subCA4Cert.crt", "pathLenConstraint6subsubCA41Cert.crt", "pathLenConstraint6subsubsubCA41XCert.crt"});
        this.expectBCValidationSuccess("ValidpathLenConstraintTest14EE.crt", new String[]{"pathLenConstraint6CACert.crt", "pathLenConstraint6subCA4Cert.crt", "pathLenConstraint6subsubCA41Cert.crt", "pathLenConstraint6subsubsubCA41XCert.crt"});
        this.expectBCValidationSuccess("ValidSelfIssuedpathLenConstraintTest15EE.crt", new String[]{"pathLenConstraint0CACert.crt", "pathLenConstraint0SelfIssuedCACert.crt"});
        this.expectBCValidationFailure("InvalidSelfIssuedpathLenConstraintTest16EE.crt", new String[]{"pathLenConstraint0CACert.crt", "pathLenConstraint0SelfIssuedCACert.crt", "pathLenConstraint0subCA2Cert.crt"}, "Basic constraints violated: path length exceeded");
        this.expectBCValidationSuccess("ValidSelfIssuedpathLenConstraintTest17EE.crt", new String[]{"pathLenConstraint1CACert.crt", "pathLenConstraint1SelfIssuedCACert.crt", "pathLenConstraint1subCACert.crt", "pathLenConstraint1SelfIssuedsubCACert.crt"});
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new PKITSBasicConstraintsTest());
    }
}

