/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.crmf.test;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import org.bouncycastle.asn1.crmf.EncKeyWithID;
import org.bouncycastle.asn1.crmf.EncryptedValue;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.crmf.Control;
import org.bouncycastle.cert.crmf.EncryptedValueBuilder;
import org.bouncycastle.cert.crmf.EncryptedValuePadder;
import org.bouncycastle.cert.crmf.EncryptedValueParser;
import org.bouncycastle.cert.crmf.PKIArchiveControl;
import org.bouncycastle.cert.crmf.PKMACBuilder;
import org.bouncycastle.cert.crmf.PKMACValuesCalculator;
import org.bouncycastle.cert.crmf.ValueDecryptorGenerator;
import org.bouncycastle.cert.crmf.bc.BcFixedLengthMGF1Padder;
import org.bouncycastle.cert.crmf.jcajce.JcaCertificateRequestMessage;
import org.bouncycastle.cert.crmf.jcajce.JcaCertificateRequestMessageBuilder;
import org.bouncycastle.cert.crmf.jcajce.JcaEncryptedValueBuilder;
import org.bouncycastle.cert.crmf.jcajce.JcaPKIArchiveControlBuilder;
import org.bouncycastle.cert.crmf.jcajce.JceAsymmetricValueDecryptorGenerator;
import org.bouncycastle.cert.crmf.jcajce.JceCRMFEncryptorBuilder;
import org.bouncycastle.cert.crmf.jcajce.JcePKMACValuesCalculator;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.KeyWrapper;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JceAsymmetricKeyWrapper;
import org.bouncycastle.util.Arrays;

public class AllTests
extends TestCase {
    private static final byte[] TEST_DATA = "Hello world!".getBytes();
    private static final String BC = "BC";
    private static final String PASSPHRASE = "hello world";
    static /* synthetic */ Class class$org$bouncycastle$cert$crmf$test$AllTests;

    public AllTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$bouncycastle$cert$crmf$test$AllTests == null ? (class$org$bouncycastle$cert$crmf$test$AllTests = AllTests.class$("org.bouncycastle.cert.crmf.test.AllTests")) : class$org$bouncycastle$cert$crmf$test$AllTests));
    }

    public static Test suite() {
        return new TestSuite(class$org$bouncycastle$cert$crmf$test$AllTests == null ? (class$org$bouncycastle$cert$crmf$test$AllTests = AllTests.class$("org.bouncycastle.cert.crmf.test.AllTests")) : class$org$bouncycastle$cert$crmf$test$AllTests);
    }

    public void setUp() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void tearDown() {
    }

    public void testKeySizes() throws Exception {
        this.verifyKeySize(NISTObjectIdentifiers.id_aes128_CBC, 128);
        this.verifyKeySize(NISTObjectIdentifiers.id_aes192_CBC, 192);
        this.verifyKeySize(NISTObjectIdentifiers.id_aes256_CBC, 256);
        this.verifyKeySize(NTTObjectIdentifiers.id_camellia128_cbc, 128);
        this.verifyKeySize(NTTObjectIdentifiers.id_camellia192_cbc, 192);
        this.verifyKeySize(NTTObjectIdentifiers.id_camellia256_cbc, 256);
        this.verifyKeySize(PKCSObjectIdentifiers.des_EDE3_CBC, 192);
    }

    private void verifyKeySize(ASN1ObjectIdentifier oid, int keySize) throws Exception {
        JceCRMFEncryptorBuilder encryptorBuilder = new JceCRMFEncryptorBuilder(oid);
        OutputEncryptor outputEncryptor = encryptorBuilder.build();
        Assert.assertEquals((int)(keySize / 8), (int)((byte[])outputEncryptor.getKey().getRepresentation()).length);
    }

    public void testBasicMessageWithArchiveControl() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509Certificate cert = AllTests.makeV1Certificate(kp, "CN=Test", kp, "CN=Test");
        JcaCertificateRequestMessageBuilder certReqBuild = new JcaCertificateRequestMessageBuilder(BigInteger.ONE);
        certReqBuild.setPublicKey(kp.getPublic()).setSubject(new X500Name("CN=Test"));
        certReqBuild.addControl((Control)new JcaPKIArchiveControlBuilder(kp.getPrivate(), new X500Name("CN=Test")).addRecipientGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(cert).setProvider(BC)).build(new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(CMSEnvelopedGenerator.AES128_CBC)).setProvider(BC).build()));
        JcaCertificateRequestMessage certReqMsg = new JcaCertificateRequestMessage(certReqBuild.build());
        Assert.assertEquals((Object)new X500Name("CN=Test"), (Object)certReqMsg.getCertTemplate().getSubject());
        Assert.assertEquals((Object)kp.getPublic(), (Object)certReqMsg.getPublicKey());
        PKIArchiveControl archiveControl = (PKIArchiveControl)certReqMsg.getControl(CRMFObjectIdentifiers.id_regCtrl_pkiArchiveOptions);
        Assert.assertEquals((int)0, (int)archiveControl.getArchiveType());
        Assert.assertTrue((boolean)archiveControl.isEnvelopedData());
        RecipientInformationStore recips = archiveControl.getEnvelopedData().getRecipientInfos();
        JceKeyTransRecipientId recipientId = new JceKeyTransRecipientId(cert);
        RecipientInformation recipientInformation = recips.get((RecipientId)recipientId);
        Assert.assertNotNull((Object)recipientInformation);
        EncKeyWithID encKeyWithID = EncKeyWithID.getInstance((Object)recipientInformation.getContent((Recipient)new JceKeyTransEnvelopedRecipient(kp.getPrivate()).setProvider(BC)));
        Assert.assertTrue((boolean)encKeyWithID.hasIdentifier());
        Assert.assertFalse((boolean)encKeyWithID.isIdentifierUTF8String());
        Assert.assertEquals((Object)new GeneralName(X500Name.getInstance((Object)new X500Name("CN=Test").getEncoded())), (Object)encKeyWithID.getIdentifier());
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])kp.getPrivate().getEncoded(), (byte[])encKeyWithID.getPrivateKey().getEncoded()));
    }

    public void testProofOfPossessionWithoutSender() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509Certificate cert = AllTests.makeV1Certificate(kp, "CN=Test", kp, "CN=Test");
        JcaCertificateRequestMessageBuilder certReqBuild = new JcaCertificateRequestMessageBuilder(BigInteger.ONE);
        certReqBuild.setPublicKey(kp.getPublic()).setAuthInfoPKMAC(new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator()), "fred".toCharArray()).setProofOfPossessionSigningKeySigner(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(kp.getPrivate()));
        certReqBuild.addControl((Control)new JcaPKIArchiveControlBuilder(kp.getPrivate(), new X500Name("CN=test")).addRecipientGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(cert).setProvider(BC)).build(new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(CMSEnvelopedGenerator.AES128_CBC)).setProvider(BC).build()));
        JcaCertificateRequestMessage certReqMsg = new JcaCertificateRequestMessage(certReqBuild.build());
        try {
            certReqMsg.isValidSigningKeyPOP(new JcaContentVerifierProviderBuilder().setProvider(BC).build(kp.getPublic()));
            Assert.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Assert.assertTrue((boolean)certReqMsg.isValidSigningKeyPOP(new JcaContentVerifierProviderBuilder().setProvider(BC).build(kp.getPublic()), new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator().setProvider(BC)), "fred".toCharArray()));
        Assert.assertEquals((Object)kp.getPublic(), (Object)certReqMsg.getPublicKey());
    }

    public void testProofOfPossessionWithSender() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509Certificate cert = AllTests.makeV1Certificate(kp, "CN=Test", kp, "CN=Test");
        JcaCertificateRequestMessageBuilder certReqBuild = new JcaCertificateRequestMessageBuilder(BigInteger.ONE);
        certReqBuild.setPublicKey(kp.getPublic()).setAuthInfoSender(new X500Name("CN=Test")).setProofOfPossessionSigningKeySigner(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(kp.getPrivate()));
        certReqBuild.addControl((Control)new JcaPKIArchiveControlBuilder(kp.getPrivate(), new X500Name("CN=test")).addRecipientGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(cert).setProvider(BC)).build(new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(CMSEnvelopedGenerator.AES128_CBC)).setProvider(BC).build()));
        JcaCertificateRequestMessage certReqMsg = new JcaCertificateRequestMessage(certReqBuild.build());
        try {
            certReqMsg.isValidSigningKeyPOP(new JcaContentVerifierProviderBuilder().setProvider(BC).build(kp.getPublic()), new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator().setProvider(BC)), "fred".toCharArray());
            Assert.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Assert.assertTrue((boolean)certReqMsg.isValidSigningKeyPOP(new JcaContentVerifierProviderBuilder().setProvider(BC).build(kp.getPublic())));
        Assert.assertEquals((Object)kp.getPublic(), (Object)certReqMsg.getPublicKey());
    }

    public void testEncryptedValue() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509Certificate cert = AllTests.makeV1Certificate(kp, "CN=Test", kp, "CN=Test");
        JcaEncryptedValueBuilder build = new JcaEncryptedValueBuilder((KeyWrapper)new JceAsymmetricKeyWrapper(cert.getPublicKey()).setProvider(BC), new JceCRMFEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider(BC).build());
        EncryptedValue value = build.build(cert);
        JceAsymmetricValueDecryptorGenerator decGen = new JceAsymmetricValueDecryptorGenerator(kp.getPrivate()).setProvider(BC);
        this.encryptedValueParserTest(value, (ValueDecryptorGenerator)decGen, cert);
        this.encryptedValueParserTest(EncryptedValue.getInstance((Object)value.getEncoded()), (ValueDecryptorGenerator)decGen, cert);
    }

    private void encryptedValueParserTest(EncryptedValue value, ValueDecryptorGenerator decGen, X509Certificate cert) throws Exception {
        EncryptedValueParser parser = new EncryptedValueParser(value);
        X509CertificateHolder holder = parser.readCertificateHolder(decGen);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])cert.getEncoded(), (byte[])holder.getEncoded()));
    }

    public void testEncryptedValuePassphrase() throws Exception {
        char[] passphrase = PASSPHRASE.toCharArray();
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509Certificate cert = AllTests.makeV1Certificate(kp, "CN=Test", kp, "CN=Test");
        EncryptedValueBuilder build = new EncryptedValueBuilder((KeyWrapper)new JceAsymmetricKeyWrapper(cert.getPublicKey()).setProvider(BC), new JceCRMFEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider(BC).build());
        EncryptedValue value = build.build(passphrase);
        JceAsymmetricValueDecryptorGenerator decGen = new JceAsymmetricValueDecryptorGenerator(kp.getPrivate()).setProvider(BC);
        this.encryptedValuePassphraseParserTest(value, null, (ValueDecryptorGenerator)decGen, cert);
        this.encryptedValuePassphraseParserTest(EncryptedValue.getInstance((Object)value.getEncoded()), null, (ValueDecryptorGenerator)decGen, cert);
    }

    public void testEncryptedValuePassphraseWithPadding() throws Exception {
        char[] passphrase = PASSPHRASE.toCharArray();
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509Certificate cert = AllTests.makeV1Certificate(kp, "CN=Test", kp, "CN=Test");
        BcFixedLengthMGF1Padder mgf1Padder = new BcFixedLengthMGF1Padder(200, new SecureRandom());
        EncryptedValueBuilder build = new EncryptedValueBuilder((KeyWrapper)new JceAsymmetricKeyWrapper(cert.getPublicKey()).setProvider(BC), new JceCRMFEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider(BC).build(), (EncryptedValuePadder)mgf1Padder);
        EncryptedValue value = build.build(passphrase);
        JceAsymmetricValueDecryptorGenerator decGen = new JceAsymmetricValueDecryptorGenerator(kp.getPrivate()).setProvider(BC);
        this.encryptedValuePassphraseParserTest(value, (EncryptedValuePadder)mgf1Padder, (ValueDecryptorGenerator)decGen, cert);
        this.encryptedValuePassphraseParserTest(EncryptedValue.getInstance((Object)value.getEncoded()), (EncryptedValuePadder)mgf1Padder, (ValueDecryptorGenerator)decGen, cert);
    }

    private void encryptedValuePassphraseParserTest(EncryptedValue value, EncryptedValuePadder padder, ValueDecryptorGenerator decGen, X509Certificate cert) throws Exception {
        EncryptedValueParser parser = new EncryptedValueParser(value, padder);
        Assert.assertTrue((boolean)Arrays.areEqual((char[])PASSPHRASE.toCharArray(), (char[])parser.readPassphrase(decGen)));
    }

    private static X509Certificate makeV1Certificate(KeyPair subKP, String _subDN, KeyPair issKP, String _issDN) throws GeneralSecurityException, IOException, OperatorCreationException {
        PublicKey subPub = subKP.getPublic();
        PrivateKey issPriv = issKP.getPrivate();
        PublicKey issPub = issKP.getPublic();
        JcaX509v1CertificateBuilder v1CertGen = new JcaX509v1CertificateBuilder(new X500Name(_issDN), BigInteger.valueOf(System.currentTimeMillis()), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 8640000000L), new X500Name(_subDN), subPub);
        JcaContentSignerBuilder signerBuilder = null;
        signerBuilder = issPub instanceof RSAPublicKey ? new JcaContentSignerBuilder("SHA1WithRSA") : (issPub.getAlgorithm().equals("DSA") ? new JcaContentSignerBuilder("SHA1withDSA") : (issPub.getAlgorithm().equals("ECDSA") ? new JcaContentSignerBuilder("SHA1withECDSA") : (issPub.getAlgorithm().equals("ECGOST3410") ? new JcaContentSignerBuilder("GOST3411withECGOST3410") : new JcaContentSignerBuilder("GOST3411WithGOST3410"))));
        signerBuilder.setProvider(BC);
        X509Certificate _cert = new JcaX509CertificateConverter().setProvider(BC).getCertificate(v1CertGen.build(signerBuilder.build(issPriv)));
        _cert.checkValidity(new Date());
        _cert.verify(issPub);
        return _cert;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

