/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.cmp.test;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.crmf.SubsequentMessage;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertException;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.cmp.CMSProcessableCMPCertificate;
import org.bouncycastle.cert.cmp.CertificateConfirmationContent;
import org.bouncycastle.cert.cmp.CertificateConfirmationContentBuilder;
import org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import org.bouncycastle.cert.cmp.ProtectedPKIMessageBuilder;
import org.bouncycastle.cert.crmf.CertificateRepMessage;
import org.bouncycastle.cert.crmf.CertificateRepMessageBuilder;
import org.bouncycastle.cert.crmf.CertificateReqMessages;
import org.bouncycastle.cert.crmf.CertificateReqMessagesBuilder;
import org.bouncycastle.cert.crmf.CertificateRequestMessage;
import org.bouncycastle.cert.crmf.CertificateResponse;
import org.bouncycastle.cert.crmf.CertificateResponseBuilder;
import org.bouncycastle.cert.crmf.jcajce.JcaCertificateRequestMessageBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKEMEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKEMRecipientInfoGenerator;
import org.bouncycastle.jcajce.spec.MLDSAParameterSpec;
import org.bouncycastle.jcajce.spec.MLKEMParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.MacCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.PBEMacCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.pkcs.jcajce.JcePBMac1CalculatorBuilder;
import org.bouncycastle.pkcs.jcajce.JcePBMac1CalculatorProviderBuilder;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.pqc.jcajce.spec.BIKEParameterSpec;
import org.bouncycastle.pqc.jcajce.spec.CMCEParameterSpec;
import org.bouncycastle.pqc.jcajce.spec.HQCParameterSpec;
import org.bouncycastle.pqc.jcajce.spec.NTRUParameterSpec;
import org.bouncycastle.util.BigIntegers;

public class PQCTest
extends TestCase {
    public void setUp() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Security.addProvider((Provider)new BouncyCastlePQCProvider());
    }

    public void tearDown() {
    }

    public void testMlKemRequestWithMlDsaCA() throws Exception {
        char[] senderMacPassword = "secret".toCharArray();
        GeneralName sender = new GeneralName(new X500Name("CN=ML-KEM Subject"));
        GeneralName recipient = new GeneralName(new X500Name("CN=ML-DSA Issuer"));
        KeyPairGenerator dilKpGen = KeyPairGenerator.getInstance("ML-DSA", "BC");
        dilKpGen.initialize((AlgorithmParameterSpec)MLDSAParameterSpec.ml_dsa_65);
        KeyPair dilKp = dilKpGen.generateKeyPair();
        X509CertificateHolder caCert = PQCTest.makeV3Certificate("CN=ML-DSA Issuer", dilKp);
        KeyPairGenerator kybKpGen = KeyPairGenerator.getInstance("ML-KEM", "BC");
        kybKpGen.initialize((AlgorithmParameterSpec)MLKEMParameterSpec.ml_kem_768);
        KeyPair kybKp = kybKpGen.generateKeyPair();
        JcaCertificateRequestMessageBuilder certReqBuild = new JcaCertificateRequestMessageBuilder(BigIntegers.ONE);
        certReqBuild.setPublicKey(kybKp.getPublic()).setSubject(X500Name.getInstance((Object)sender.getName())).setProofOfPossessionSubsequentMessage(SubsequentMessage.encrCert);
        CertificateReqMessagesBuilder certReqMsgsBldr = new CertificateReqMessagesBuilder();
        certReqMsgsBldr.addRequest(certReqBuild.build());
        MacCalculator senderMacCalculator = new JcePBMac1CalculatorBuilder("HmacSHA256", 256).setProvider("BC").build(senderMacPassword);
        ProtectedPKIMessage message = new ProtectedPKIMessageBuilder(sender, recipient).setBody(0, certReqMsgsBldr.build()).build(senderMacCalculator);
        Assert.assertTrue((boolean)message.getProtectionAlgorithm().equals((Object)senderMacCalculator.getAlgorithmIdentifier()));
        PBEMacCalculatorProvider macCalcProvider = new JcePBMac1CalculatorProviderBuilder().setProvider("BC").build();
        Assert.assertTrue((boolean)message.verify(macCalcProvider, senderMacPassword));
        Assert.assertEquals((int)0, (int)message.getBody().getType());
        CertificateReqMessages requestMessages = CertificateReqMessages.fromPKIBody((PKIBody)message.getBody());
        CertificateRequestMessage senderReqMessage = requestMessages.getRequests()[0];
        CertTemplate certTemplate = senderReqMessage.getCertTemplate();
        X509CertificateHolder cert = PQCTest.makeV3Certificate(certTemplate.getPublicKey(), certTemplate.getSubject(), dilKp, "CN=ML-DSA Issuer");
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKEMRecipientInfoGenerator(senderReqMessage.getCertReqId().getEncoded(), new JcaX509CertificateConverter().setProvider("BC").getCertificate(cert).getPublicKey(), CMSAlgorithm.AES256_WRAP).setKDF(new AlgorithmIdentifier(NISTObjectIdentifiers.id_shake256)));
        CMSEnvelopedData encryptedCert = edGen.generate((CMSTypedData)new CMSProcessableCMPCertificate(cert), new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider("BC").build());
        CertificateResponseBuilder certRespBuilder = new CertificateResponseBuilder(senderReqMessage.getCertReqId(), new PKIStatusInfo(PKIStatus.granted));
        certRespBuilder.withCertificate(encryptedCert);
        CertificateRepMessageBuilder repMessageBuilder = new CertificateRepMessageBuilder(caCert);
        repMessageBuilder.addCertificateResponse(certRespBuilder.build());
        ContentSigner signer = new JcaContentSignerBuilder("ML-DSA").setProvider("BC").build(dilKp.getPrivate());
        CertificateRepMessage repMessage = repMessageBuilder.build();
        ProtectedPKIMessage responsePkixMessage = new ProtectedPKIMessageBuilder(sender, recipient).setBody(1, repMessage).build(signer);
        Assert.assertTrue((boolean)responsePkixMessage.verify(new JcaContentVerifierProviderBuilder().build(caCert)));
        CertificateRepMessage certRepMessage = CertificateRepMessage.fromPKIBody((PKIBody)responsePkixMessage.getBody());
        CertificateResponse certResp = certRepMessage.getResponses()[0];
        Assert.assertEquals((boolean)true, (boolean)certResp.hasEncryptedCertificate());
        CMSEnvelopedData receivedEnvelope = certResp.getEncryptedCertificate();
        RecipientInformationStore recipients = receivedEnvelope.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Assert.assertEquals((int)1, (int)c.size());
        RecipientInformation recInfo = (RecipientInformation)c.iterator().next();
        Assert.assertEquals((String)recInfo.getKeyEncryptionAlgOID(), (String)NISTObjectIdentifiers.id_alg_ml_kem_768.getId());
        byte[] recData = recInfo.getContent((Recipient)new JceKEMEnvelopedRecipient(kybKp.getPrivate()).setProvider("BC"));
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(new CMPCertificate(cert.toASN1Structure()).getEncoded(), recData));
        CMPCertificate receivedCMPCert = certResp.getCertificate((Recipient)new JceKEMEnvelopedRecipient(kybKp.getPrivate()));
        X509CertificateHolder receivedCert = new X509CertificateHolder(receivedCMPCert.getX509v3PKCert());
        X509CertificateHolder caCertHolder = certRepMessage.getX509Certificates()[0];
        Assert.assertEquals((boolean)true, (boolean)receivedCert.isSignatureValid(new JcaContentVerifierProviderBuilder().build(caCertHolder)));
        CertificateConfirmationContent content = new CertificateConfirmationContentBuilder().addAcceptedCertificate(cert, BigInteger.ONE).build(new JcaDigestCalculatorProviderBuilder().build());
        message = new ProtectedPKIMessageBuilder(sender, recipient).setBody(24, content).build(senderMacCalculator);
        Assert.assertTrue((boolean)content.getStatusMessages()[0].isVerified(receivedCert, new JcaDigestCalculatorProviderBuilder().build()));
        Assert.assertEquals((int)24, (int)message.getBody().getType());
        CertificateConfirmationContent recContent = CertificateConfirmationContent.fromPKIBody((PKIBody)message.getBody());
        Assert.assertTrue((boolean)recContent.getStatusMessages()[0].isVerified(receivedCert, new JcaDigestCalculatorProviderBuilder().build()));
    }

    public void testNTRURequestWithMlDsaCA() throws Exception {
        char[] senderMacPassword = "secret".toCharArray();
        GeneralName sender = new GeneralName(new X500Name("CN=NTRU Subject"));
        GeneralName recipient = new GeneralName(new X500Name("CN=ML-DSA Issuer"));
        KeyPairGenerator dilKpGen = KeyPairGenerator.getInstance("ML-DSA", "BC");
        dilKpGen.initialize((AlgorithmParameterSpec)MLDSAParameterSpec.ml_dsa_44);
        KeyPair dilKp = dilKpGen.generateKeyPair();
        X509CertificateHolder caCert = PQCTest.makeV3Certificate("CN=ML-DSA Issuer", dilKp);
        KeyPairGenerator kybKpGen = KeyPairGenerator.getInstance("NTRU", "BCPQC");
        kybKpGen.initialize((AlgorithmParameterSpec)NTRUParameterSpec.ntruhrss701);
        KeyPair ntruKp = kybKpGen.generateKeyPair();
        JcaCertificateRequestMessageBuilder certReqBuild = new JcaCertificateRequestMessageBuilder(BigIntegers.ONE);
        certReqBuild.setPublicKey(ntruKp.getPublic()).setSubject(X500Name.getInstance((Object)sender.getName())).setProofOfPossessionSubsequentMessage(SubsequentMessage.encrCert);
        CertificateReqMessagesBuilder certReqMsgsBldr = new CertificateReqMessagesBuilder();
        certReqMsgsBldr.addRequest(certReqBuild.build());
        MacCalculator senderMacCalculator = new JcePBMac1CalculatorBuilder("HmacSHA256", 256).setProvider("BC").build(senderMacPassword);
        ProtectedPKIMessage initMessage = new ProtectedPKIMessageBuilder(sender, recipient).setBody(0, certReqMsgsBldr.build()).build(senderMacCalculator);
        Assert.assertTrue((boolean)initMessage.getProtectionAlgorithm().equals((Object)senderMacCalculator.getAlgorithmIdentifier()));
        PBEMacCalculatorProvider macCalcProvider = new JcePBMac1CalculatorProviderBuilder().setProvider("BC").build();
        Assert.assertTrue((boolean)initMessage.verify(macCalcProvider, senderMacPassword));
        Assert.assertEquals((int)0, (int)initMessage.getBody().getType());
        CertificateReqMessages requestMessages = CertificateReqMessages.fromPKIBody((PKIBody)initMessage.getBody());
        CertificateRequestMessage senderReqMessage = requestMessages.getRequests()[0];
        CertTemplate certTemplate = senderReqMessage.getCertTemplate();
        X509CertificateHolder cert = PQCTest.makeV3Certificate(certTemplate.getPublicKey(), certTemplate.getSubject(), dilKp, "CN=ML-DSA Issuer");
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKEMRecipientInfoGenerator(senderReqMessage.getCertReqId().getEncoded(), new JcaX509CertificateConverter().setProvider("BC").getCertificate(cert).getPublicKey(), CMSAlgorithm.AES256_WRAP).setKDF(new AlgorithmIdentifier(NISTObjectIdentifiers.id_shake256)));
        CMSEnvelopedData encryptedCert = edGen.generate((CMSTypedData)new CMSProcessableCMPCertificate(cert), new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES192_CBC).setProvider("BC").build());
        CertificateResponseBuilder certRespBuilder = new CertificateResponseBuilder(senderReqMessage.getCertReqId(), new PKIStatusInfo(PKIStatus.granted));
        certRespBuilder.withCertificate(encryptedCert);
        CertificateRepMessageBuilder repMessageBuilder = new CertificateRepMessageBuilder(caCert);
        repMessageBuilder.addCertificateResponse(certRespBuilder.build());
        ContentSigner signer = new JcaContentSignerBuilder("ML-DSA").setProvider("BC").build(dilKp.getPrivate());
        CertificateRepMessage repMessage = repMessageBuilder.build();
        ProtectedPKIMessage responsePkixMessage = new ProtectedPKIMessageBuilder(sender, recipient).setBody(1, repMessage).build(signer);
        Assert.assertTrue((boolean)responsePkixMessage.verify(new JcaContentVerifierProviderBuilder().build(caCert)));
        CertificateRepMessage certRepMessage = CertificateRepMessage.fromPKIBody((PKIBody)responsePkixMessage.getBody());
        CertificateResponse certResp = certRepMessage.getResponses()[0];
        Assert.assertEquals((boolean)true, (boolean)certResp.hasEncryptedCertificate());
        CMSEnvelopedData receivedEnvelope = certResp.getEncryptedCertificate();
        RecipientInformationStore recipients = receivedEnvelope.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Assert.assertEquals((int)1, (int)c.size());
        RecipientInformation recInfo = (RecipientInformation)c.iterator().next();
        Assert.assertEquals((String)recInfo.getKeyEncryptionAlgOID(), (String)BCObjectIdentifiers.ntruhrss701.getId());
        byte[] recData = recInfo.getContent((Recipient)new JceKEMEnvelopedRecipient(ntruKp.getPrivate()));
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(new CMPCertificate(cert.toASN1Structure()).getEncoded(), recData));
        CMPCertificate receivedCMPCert = certResp.getCertificate((Recipient)new JceKEMEnvelopedRecipient(ntruKp.getPrivate()));
        X509CertificateHolder receivedCert = new X509CertificateHolder(receivedCMPCert.getX509v3PKCert());
        X509CertificateHolder caCertHolder = certRepMessage.getX509Certificates()[0];
        Assert.assertEquals((boolean)true, (boolean)receivedCert.isSignatureValid(new JcaContentVerifierProviderBuilder().build(caCertHolder)));
        CertificateConfirmationContent content = new CertificateConfirmationContentBuilder().addAcceptedCertificate(cert, BigInteger.ONE).build(new JcaDigestCalculatorProviderBuilder().build());
        ProtectedPKIMessage certConf = new ProtectedPKIMessageBuilder(sender, recipient).setBody(24, content).build(senderMacCalculator);
        Assert.assertTrue((boolean)content.getStatusMessages()[0].isVerified(receivedCert, new JcaDigestCalculatorProviderBuilder().build()));
        Assert.assertEquals((int)24, (int)certConf.getBody().getType());
        CertificateConfirmationContent recContent = CertificateConfirmationContent.fromPKIBody((PKIBody)certConf.getBody());
        Assert.assertTrue((boolean)recContent.getStatusMessages()[0].isVerified(receivedCert, new JcaDigestCalculatorProviderBuilder().build()));
    }

    public void testBIKERequestWithMlDsaCA() throws Exception {
        char[] senderMacPassword = "secret".toCharArray();
        GeneralName sender = new GeneralName(new X500Name("CN=Bike128 Subject"));
        GeneralName recipient = new GeneralName(new X500Name("CN=ML-DSA Issuer"));
        KeyPairGenerator dilKpGen = KeyPairGenerator.getInstance("ML-DSA", "BC");
        dilKpGen.initialize((AlgorithmParameterSpec)MLDSAParameterSpec.ml_dsa_44);
        KeyPair dilKp = dilKpGen.generateKeyPair();
        X509CertificateHolder caCert = PQCTest.makeV3Certificate("CN=ML-DSA Issuer", dilKp);
        KeyPairGenerator kybKpGen = KeyPairGenerator.getInstance("BIKE", "BCPQC");
        kybKpGen.initialize((AlgorithmParameterSpec)BIKEParameterSpec.bike128);
        KeyPair ntruKp = kybKpGen.generateKeyPair();
        JcaCertificateRequestMessageBuilder certReqBuild = new JcaCertificateRequestMessageBuilder(BigIntegers.ONE);
        certReqBuild.setPublicKey(ntruKp.getPublic()).setSubject(X500Name.getInstance((Object)sender.getName())).setProofOfPossessionSubsequentMessage(SubsequentMessage.encrCert);
        CertificateReqMessagesBuilder certReqMsgsBldr = new CertificateReqMessagesBuilder();
        certReqMsgsBldr.addRequest(certReqBuild.build());
        MacCalculator senderMacCalculator = new JcePBMac1CalculatorBuilder("HmacSHA256", 256).setProvider("BC").build(senderMacPassword);
        ProtectedPKIMessage initMessage = new ProtectedPKIMessageBuilder(sender, recipient).setBody(0, certReqMsgsBldr.build()).build(senderMacCalculator);
        Assert.assertTrue((boolean)initMessage.getProtectionAlgorithm().equals((Object)senderMacCalculator.getAlgorithmIdentifier()));
        PBEMacCalculatorProvider macCalcProvider = new JcePBMac1CalculatorProviderBuilder().setProvider("BC").build();
        Assert.assertTrue((boolean)initMessage.verify(macCalcProvider, senderMacPassword));
        Assert.assertEquals((int)0, (int)initMessage.getBody().getType());
        CertificateReqMessages requestMessages = CertificateReqMessages.fromPKIBody((PKIBody)initMessage.getBody());
        CertificateRequestMessage senderReqMessage = requestMessages.getRequests()[0];
        CertTemplate certTemplate = senderReqMessage.getCertTemplate();
        X509CertificateHolder cert = PQCTest.makeV3Certificate(certTemplate.getPublicKey(), certTemplate.getSubject(), dilKp, "CN=ML-DSA Issuer");
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKEMRecipientInfoGenerator(senderReqMessage.getCertReqId().getEncoded(), new JcaX509CertificateConverter().setProvider("BC").getCertificate(cert).getPublicKey(), CMSAlgorithm.AES256_WRAP).setKDF(new AlgorithmIdentifier(NISTObjectIdentifiers.id_shake256)));
        CMSEnvelopedData encryptedCert = edGen.generate((CMSTypedData)new CMSProcessableCMPCertificate(cert), new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES192_CBC).setProvider("BC").build());
        CertificateResponseBuilder certRespBuilder = new CertificateResponseBuilder(senderReqMessage.getCertReqId(), new PKIStatusInfo(PKIStatus.granted));
        certRespBuilder.withCertificate(encryptedCert);
        CertificateRepMessageBuilder repMessageBuilder = new CertificateRepMessageBuilder(caCert);
        repMessageBuilder.addCertificateResponse(certRespBuilder.build());
        ContentSigner signer = new JcaContentSignerBuilder("ML-DSA").setProvider("BC").build(dilKp.getPrivate());
        CertificateRepMessage repMessage = repMessageBuilder.build();
        ProtectedPKIMessage responsePkixMessage = new ProtectedPKIMessageBuilder(sender, recipient).setBody(1, repMessage).build(signer);
        Assert.assertTrue((boolean)responsePkixMessage.verify(new JcaContentVerifierProviderBuilder().build(caCert)));
        CertificateRepMessage certRepMessage = CertificateRepMessage.fromPKIBody((PKIBody)responsePkixMessage.getBody());
        CertificateResponse certResp = certRepMessage.getResponses()[0];
        Assert.assertEquals((boolean)true, (boolean)certResp.hasEncryptedCertificate());
        CMSEnvelopedData receivedEnvelope = certResp.getEncryptedCertificate();
        RecipientInformationStore recipients = receivedEnvelope.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Assert.assertEquals((int)1, (int)c.size());
        RecipientInformation recInfo = (RecipientInformation)c.iterator().next();
        Assert.assertEquals((String)recInfo.getKeyEncryptionAlgOID(), (String)BCObjectIdentifiers.bike128.getId());
        byte[] recData = recInfo.getContent((Recipient)new JceKEMEnvelopedRecipient(ntruKp.getPrivate()));
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(new CMPCertificate(cert.toASN1Structure()).getEncoded(), recData));
        CMPCertificate receivedCMPCert = certResp.getCertificate((Recipient)new JceKEMEnvelopedRecipient(ntruKp.getPrivate()));
        X509CertificateHolder receivedCert = new X509CertificateHolder(receivedCMPCert.getX509v3PKCert());
        X509CertificateHolder caCertHolder = certRepMessage.getX509Certificates()[0];
        Assert.assertEquals((boolean)true, (boolean)receivedCert.isSignatureValid(new JcaContentVerifierProviderBuilder().build(caCertHolder)));
        CertificateConfirmationContent content = new CertificateConfirmationContentBuilder().addAcceptedCertificate(cert, BigInteger.ONE).build(new JcaDigestCalculatorProviderBuilder().build());
        ProtectedPKIMessage certConf = new ProtectedPKIMessageBuilder(sender, recipient).setBody(24, content).build(senderMacCalculator);
        Assert.assertTrue((boolean)content.getStatusMessages()[0].isVerified(receivedCert, new JcaDigestCalculatorProviderBuilder().build()));
        Assert.assertEquals((int)24, (int)certConf.getBody().getType());
        CertificateConfirmationContent recContent = CertificateConfirmationContent.fromPKIBody((PKIBody)certConf.getBody());
        Assert.assertTrue((boolean)recContent.getStatusMessages()[0].isVerified(receivedCert, new JcaDigestCalculatorProviderBuilder().build()));
    }

    public void testHQCRequestWithMlDsaCA() throws Exception {
        char[] senderMacPassword = "secret".toCharArray();
        GeneralName sender = new GeneralName(new X500Name("CN=HQC128 Subject"));
        GeneralName recipient = new GeneralName(new X500Name("CN=ML-DSA Issuer"));
        KeyPairGenerator dilKpGen = KeyPairGenerator.getInstance("ML-DSA", "BC");
        dilKpGen.initialize((AlgorithmParameterSpec)MLDSAParameterSpec.ml_dsa_44);
        KeyPair dilKp = dilKpGen.generateKeyPair();
        X509CertificateHolder caCert = PQCTest.makeV3Certificate("CN=ML-DSA Issuer", dilKp);
        KeyPairGenerator kybKpGen = KeyPairGenerator.getInstance("HQC", "BCPQC");
        kybKpGen.initialize((AlgorithmParameterSpec)HQCParameterSpec.hqc128);
        KeyPair hqcKp = kybKpGen.generateKeyPair();
        JcaCertificateRequestMessageBuilder certReqBuild = new JcaCertificateRequestMessageBuilder(BigIntegers.ONE);
        certReqBuild.setPublicKey(hqcKp.getPublic()).setSubject(X500Name.getInstance((Object)sender.getName())).setProofOfPossessionSubsequentMessage(SubsequentMessage.encrCert);
        CertificateReqMessagesBuilder certReqMsgsBldr = new CertificateReqMessagesBuilder();
        certReqMsgsBldr.addRequest(certReqBuild.build());
        MacCalculator senderMacCalculator = new JcePBMac1CalculatorBuilder("HmacSHA256", 256).setProvider("BC").build(senderMacPassword);
        ProtectedPKIMessage initMessage = new ProtectedPKIMessageBuilder(sender, recipient).setBody(0, certReqMsgsBldr.build()).build(senderMacCalculator);
        Assert.assertTrue((boolean)initMessage.getProtectionAlgorithm().equals((Object)senderMacCalculator.getAlgorithmIdentifier()));
        PBEMacCalculatorProvider macCalcProvider = new JcePBMac1CalculatorProviderBuilder().setProvider("BC").build();
        Assert.assertTrue((boolean)initMessage.verify(macCalcProvider, senderMacPassword));
        Assert.assertEquals((int)0, (int)initMessage.getBody().getType());
        CertificateReqMessages requestMessages = CertificateReqMessages.fromPKIBody((PKIBody)initMessage.getBody());
        CertificateRequestMessage senderReqMessage = requestMessages.getRequests()[0];
        CertTemplate certTemplate = senderReqMessage.getCertTemplate();
        X509CertificateHolder cert = PQCTest.makeV3Certificate(certTemplate.getPublicKey(), certTemplate.getSubject(), dilKp, "CN=ML-DSA Issuer");
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKEMRecipientInfoGenerator(senderReqMessage.getCertReqId().getEncoded(), new JcaX509CertificateConverter().setProvider("BC").getCertificate(cert).getPublicKey(), CMSAlgorithm.AES256_WRAP).setKDF(new AlgorithmIdentifier(NISTObjectIdentifiers.id_shake256)));
        CMSEnvelopedData encryptedCert = edGen.generate((CMSTypedData)new CMSProcessableCMPCertificate(cert), new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES192_CBC).setProvider("BC").build());
        CertificateResponseBuilder certRespBuilder = new CertificateResponseBuilder(senderReqMessage.getCertReqId(), new PKIStatusInfo(PKIStatus.granted));
        certRespBuilder.withCertificate(encryptedCert);
        CertificateRepMessageBuilder repMessageBuilder = new CertificateRepMessageBuilder(caCert);
        repMessageBuilder.addCertificateResponse(certRespBuilder.build());
        ContentSigner signer = new JcaContentSignerBuilder("ML-DSA").setProvider("BC").build(dilKp.getPrivate());
        CertificateRepMessage repMessage = repMessageBuilder.build();
        ProtectedPKIMessage responsePkixMessage = new ProtectedPKIMessageBuilder(sender, recipient).setBody(1, repMessage).build(signer);
        Assert.assertTrue((boolean)responsePkixMessage.verify(new JcaContentVerifierProviderBuilder().build(caCert)));
        CertificateRepMessage certRepMessage = CertificateRepMessage.fromPKIBody((PKIBody)responsePkixMessage.getBody());
        CertificateResponse certResp = certRepMessage.getResponses()[0];
        Assert.assertEquals((boolean)true, (boolean)certResp.hasEncryptedCertificate());
        CMSEnvelopedData receivedEnvelope = certResp.getEncryptedCertificate();
        RecipientInformationStore recipients = receivedEnvelope.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Assert.assertEquals((int)1, (int)c.size());
        RecipientInformation recInfo = (RecipientInformation)c.iterator().next();
        Assert.assertEquals((String)recInfo.getKeyEncryptionAlgOID(), (String)BCObjectIdentifiers.hqc128.getId());
        byte[] recData = recInfo.getContent((Recipient)new JceKEMEnvelopedRecipient(hqcKp.getPrivate()));
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(new CMPCertificate(cert.toASN1Structure()).getEncoded(), recData));
        CMPCertificate receivedCMPCert = certResp.getCertificate((Recipient)new JceKEMEnvelopedRecipient(hqcKp.getPrivate()));
        X509CertificateHolder receivedCert = new X509CertificateHolder(receivedCMPCert.getX509v3PKCert());
        X509CertificateHolder caCertHolder = certRepMessage.getX509Certificates()[0];
        Assert.assertEquals((boolean)true, (boolean)receivedCert.isSignatureValid(new JcaContentVerifierProviderBuilder().build(caCertHolder)));
        CertificateConfirmationContent content = new CertificateConfirmationContentBuilder().addAcceptedCertificate(cert, BigInteger.ONE).build(new JcaDigestCalculatorProviderBuilder().build());
        ProtectedPKIMessage certConf = new ProtectedPKIMessageBuilder(sender, recipient).setBody(24, content).build(senderMacCalculator);
        Assert.assertTrue((boolean)content.getStatusMessages()[0].isVerified(receivedCert, new JcaDigestCalculatorProviderBuilder().build()));
        Assert.assertEquals((int)24, (int)certConf.getBody().getType());
        CertificateConfirmationContent recContent = CertificateConfirmationContent.fromPKIBody((PKIBody)certConf.getBody());
        Assert.assertTrue((boolean)recContent.getStatusMessages()[0].isVerified(receivedCert, new JcaDigestCalculatorProviderBuilder().build()));
    }

    public void testCMCERequestWithMlDsaCA() throws Exception {
        char[] senderMacPassword = "secret".toCharArray();
        GeneralName sender = new GeneralName(new X500Name("CN=mceliece3488864 Subject"));
        GeneralName recipient = new GeneralName(new X500Name("CN=ML-DSA Issuer"));
        KeyPairGenerator dilKpGen = KeyPairGenerator.getInstance("ML-DSA", "BC");
        dilKpGen.initialize((AlgorithmParameterSpec)MLDSAParameterSpec.ml_dsa_44);
        KeyPair dilKp = dilKpGen.generateKeyPair();
        X509CertificateHolder caCert = PQCTest.makeV3Certificate("CN=ML-DSA Issuer", dilKp);
        KeyPairGenerator cmceKpGen = KeyPairGenerator.getInstance("CMCE", "BCPQC");
        cmceKpGen.initialize((AlgorithmParameterSpec)CMCEParameterSpec.mceliece348864);
        KeyPair hqcKp = cmceKpGen.generateKeyPair();
        JcaCertificateRequestMessageBuilder certReqBuild = new JcaCertificateRequestMessageBuilder(BigIntegers.ONE);
        certReqBuild.setPublicKey(hqcKp.getPublic()).setSubject(X500Name.getInstance((Object)sender.getName())).setProofOfPossessionSubsequentMessage(SubsequentMessage.encrCert);
        CertificateReqMessagesBuilder certReqMsgsBldr = new CertificateReqMessagesBuilder();
        certReqMsgsBldr.addRequest(certReqBuild.build());
        MacCalculator senderMacCalculator = new JcePBMac1CalculatorBuilder("HmacSHA256", 256).setProvider("BC").build(senderMacPassword);
        ProtectedPKIMessage initMessage = new ProtectedPKIMessageBuilder(sender, recipient).setBody(0, certReqMsgsBldr.build()).build(senderMacCalculator);
        Assert.assertTrue((boolean)initMessage.getProtectionAlgorithm().equals((Object)senderMacCalculator.getAlgorithmIdentifier()));
        PBEMacCalculatorProvider macCalcProvider = new JcePBMac1CalculatorProviderBuilder().setProvider("BC").build();
        Assert.assertTrue((boolean)initMessage.verify(macCalcProvider, senderMacPassword));
        Assert.assertEquals((int)0, (int)initMessage.getBody().getType());
        CertificateReqMessages requestMessages = CertificateReqMessages.fromPKIBody((PKIBody)initMessage.getBody());
        CertificateRequestMessage senderReqMessage = requestMessages.getRequests()[0];
        CertTemplate certTemplate = senderReqMessage.getCertTemplate();
        X509CertificateHolder cert = PQCTest.makeV3Certificate(certTemplate.getPublicKey(), certTemplate.getSubject(), dilKp, "CN=ML-DSA Issuer");
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKEMRecipientInfoGenerator(senderReqMessage.getCertReqId().getEncoded(), new JcaX509CertificateConverter().setProvider("BC").getCertificate(cert).getPublicKey(), CMSAlgorithm.AES256_WRAP).setKDF(new AlgorithmIdentifier(NISTObjectIdentifiers.id_shake256)));
        CMSEnvelopedData encryptedCert = edGen.generate((CMSTypedData)new CMSProcessableCMPCertificate(cert), new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES192_CBC).setProvider("BC").build());
        CertificateResponseBuilder certRespBuilder = new CertificateResponseBuilder(senderReqMessage.getCertReqId(), new PKIStatusInfo(PKIStatus.granted));
        certRespBuilder.withCertificate(encryptedCert);
        CertificateRepMessageBuilder repMessageBuilder = new CertificateRepMessageBuilder(caCert);
        repMessageBuilder.addCertificateResponse(certRespBuilder.build());
        ContentSigner signer = new JcaContentSignerBuilder("ML-DSA").setProvider("BC").build(dilKp.getPrivate());
        CertificateRepMessage repMessage = repMessageBuilder.build();
        ProtectedPKIMessage responsePkixMessage = new ProtectedPKIMessageBuilder(sender, recipient).setBody(1, repMessage).build(signer);
        Assert.assertTrue((boolean)responsePkixMessage.verify(new JcaContentVerifierProviderBuilder().build(caCert)));
        CertificateRepMessage certRepMessage = CertificateRepMessage.fromPKIBody((PKIBody)responsePkixMessage.getBody());
        CertificateResponse certResp = certRepMessage.getResponses()[0];
        Assert.assertEquals((boolean)true, (boolean)certResp.hasEncryptedCertificate());
        CMSEnvelopedData receivedEnvelope = certResp.getEncryptedCertificate();
        RecipientInformationStore recipients = receivedEnvelope.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Assert.assertEquals((int)1, (int)c.size());
        RecipientInformation recInfo = (RecipientInformation)c.iterator().next();
        Assert.assertEquals((String)recInfo.getKeyEncryptionAlgOID(), (String)BCObjectIdentifiers.mceliece348864_r3.getId());
        byte[] recData = recInfo.getContent((Recipient)new JceKEMEnvelopedRecipient(hqcKp.getPrivate()));
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(new CMPCertificate(cert.toASN1Structure()).getEncoded(), recData));
        CMPCertificate receivedCMPCert = certResp.getCertificate((Recipient)new JceKEMEnvelopedRecipient(hqcKp.getPrivate()));
        X509CertificateHolder receivedCert = new X509CertificateHolder(receivedCMPCert.getX509v3PKCert());
        X509CertificateHolder caCertHolder = certRepMessage.getX509Certificates()[0];
        Assert.assertEquals((boolean)true, (boolean)receivedCert.isSignatureValid(new JcaContentVerifierProviderBuilder().build(caCertHolder)));
        CertificateConfirmationContent content = new CertificateConfirmationContentBuilder().addAcceptedCertificate(cert, BigInteger.ONE).build(new JcaDigestCalculatorProviderBuilder().build());
        ProtectedPKIMessage certConf = new ProtectedPKIMessageBuilder(sender, recipient).setBody(24, content).build(senderMacCalculator);
        Assert.assertTrue((boolean)content.getStatusMessages()[0].isVerified(receivedCert, new JcaDigestCalculatorProviderBuilder().build()));
        Assert.assertEquals((int)24, (int)certConf.getBody().getType());
        CertificateConfirmationContent recContent = CertificateConfirmationContent.fromPKIBody((PKIBody)certConf.getBody());
        Assert.assertTrue((boolean)recContent.getStatusMessages()[0].isVerified(receivedCert, new JcaDigestCalculatorProviderBuilder().build()));
    }

    public void testExternalCMCERequestWithMlDsaCA() throws Exception {
        char[] senderMacPassword = "secret".toCharArray();
        GeneralName sender = new GeneralName(new X500Name("CN=mceliece3488864 Subject"));
        GeneralName recipient = new GeneralName(new X500Name("CN=ML-DSA Issuer"));
        KeyPairGenerator dilKpGen = KeyPairGenerator.getInstance("ML-DSA", "BC");
        dilKpGen.initialize((AlgorithmParameterSpec)MLDSAParameterSpec.ml_dsa_44);
        KeyPair dilKp = dilKpGen.generateKeyPair();
        X509CertificateHolder caCert = PQCTest.makeV3Certificate("CN=ML-DSA Issuer", dilKp);
        KeyPairGenerator cmceKpGen = KeyPairGenerator.getInstance("CMCE", "BCPQC");
        cmceKpGen.initialize((AlgorithmParameterSpec)CMCEParameterSpec.mceliece348864);
        KeyPair hqcKp = cmceKpGen.generateKeyPair();
        JcaCertificateRequestMessageBuilder certReqBuild = new JcaCertificateRequestMessageBuilder(BigIntegers.ONE);
        certReqBuild.setPublicKey(hqcKp.getPublic()).setSubject(X500Name.getInstance((Object)sender.getName())).setProofOfPossessionSubsequentMessage(SubsequentMessage.encrCert);
        CertificateReqMessagesBuilder certReqMsgsBldr = new CertificateReqMessagesBuilder();
        certReqMsgsBldr.addRequest(certReqBuild.build());
        MacCalculator senderMacCalculator = new JcePBMac1CalculatorBuilder("HmacSHA256", 256).setProvider("BC").build(senderMacPassword);
        ProtectedPKIMessage initMessage = new ProtectedPKIMessageBuilder(sender, recipient).setBody(0, certReqMsgsBldr.build()).build(senderMacCalculator);
        Assert.assertTrue((boolean)initMessage.getProtectionAlgorithm().equals((Object)senderMacCalculator.getAlgorithmIdentifier()));
        PBEMacCalculatorProvider macCalcProvider = new JcePBMac1CalculatorProviderBuilder().setProvider("BC").build();
        Assert.assertTrue((boolean)initMessage.verify(macCalcProvider, senderMacPassword));
        Assert.assertEquals((int)0, (int)initMessage.getBody().getType());
        CertificateReqMessages requestMessages = CertificateReqMessages.fromPKIBody((PKIBody)initMessage.getBody());
        CertificateRequestMessage senderReqMessage = requestMessages.getRequests()[0];
        CertTemplate certTemplate = senderReqMessage.getCertTemplate();
        X509CertificateHolder cert = PQCTest.makeV3Certificate(certTemplate.getPublicKey(), certTemplate.getSubject(), dilKp, "CN=ML-DSA Issuer");
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKEMRecipientInfoGenerator(senderReqMessage.getCertReqId().getEncoded(), new JcaX509CertificateConverter().setProvider("BC").getCertificate(cert).getPublicKey(), CMSAlgorithm.AES256_WRAP).setKDF(new AlgorithmIdentifier(NISTObjectIdentifiers.id_shake256)));
        CMSEnvelopedData encryptedCert = edGen.generate((CMSTypedData)new CMSProcessableCMPCertificate(cert), new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES192_CBC).setProvider("BC").build());
        CertificateResponseBuilder certRespBuilder = new CertificateResponseBuilder(senderReqMessage.getCertReqId(), new PKIStatusInfo(PKIStatus.granted));
        certRespBuilder.withCertificate(encryptedCert);
        CertificateRepMessageBuilder repMessageBuilder = new CertificateRepMessageBuilder(caCert);
        repMessageBuilder.addCertificateResponse(certRespBuilder.build());
        ContentSigner signer = new JcaContentSignerBuilder("ML-DSA").setProvider("BC").build(dilKp.getPrivate());
        CertificateRepMessage repMessage = repMessageBuilder.build();
        ProtectedPKIMessage responsePkixMessage = new ProtectedPKIMessageBuilder(sender, recipient).setBody(1, repMessage).build(signer);
        Assert.assertTrue((boolean)responsePkixMessage.verify(new JcaContentVerifierProviderBuilder().build(caCert)));
        CertificateRepMessage certRepMessage = CertificateRepMessage.fromPKIBody((PKIBody)responsePkixMessage.getBody());
        CertificateResponse certResp = certRepMessage.getResponses()[0];
        Assert.assertEquals((boolean)true, (boolean)certResp.hasEncryptedCertificate());
        CMSEnvelopedData receivedEnvelope = certResp.getEncryptedCertificate();
        RecipientInformationStore recipients = receivedEnvelope.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Assert.assertEquals((int)1, (int)c.size());
        RecipientInformation recInfo = (RecipientInformation)c.iterator().next();
        Assert.assertEquals((String)recInfo.getKeyEncryptionAlgOID(), (String)BCObjectIdentifiers.mceliece348864_r3.getId());
        byte[] recData = recInfo.getContent((Recipient)new JceKEMEnvelopedRecipient(hqcKp.getPrivate()));
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(new CMPCertificate(cert.toASN1Structure()).getEncoded(), recData));
        CMPCertificate receivedCMPCert = certResp.getCertificate((Recipient)new JceKEMEnvelopedRecipient(hqcKp.getPrivate()));
        X509CertificateHolder receivedCert = new X509CertificateHolder(receivedCMPCert.getX509v3PKCert());
        X509CertificateHolder caCertHolder = certRepMessage.getX509Certificates()[0];
        Assert.assertEquals((boolean)true, (boolean)receivedCert.isSignatureValid(new JcaContentVerifierProviderBuilder().build(caCertHolder)));
        CertificateConfirmationContent content = new CertificateConfirmationContentBuilder().addAcceptedCertificate(cert, BigInteger.ONE).build(new JcaDigestCalculatorProviderBuilder().build());
        ProtectedPKIMessage certConf = new ProtectedPKIMessageBuilder(sender, recipient).setBody(24, content).build(senderMacCalculator);
        Assert.assertTrue((boolean)content.getStatusMessages()[0].isVerified(receivedCert, new JcaDigestCalculatorProviderBuilder().build()));
        Assert.assertEquals((int)24, (int)certConf.getBody().getType());
        CertificateConfirmationContent recContent = CertificateConfirmationContent.fromPKIBody((PKIBody)certConf.getBody());
        Assert.assertTrue((boolean)recContent.getStatusMessages()[0].isVerified(receivedCert, new JcaDigestCalculatorProviderBuilder().build()));
    }

    private static X509CertificateHolder makeV3Certificate(String _subDN, KeyPair issKP) throws OperatorCreationException, CertException, CertIOException {
        PrivateKey issPriv = issKP.getPrivate();
        PublicKey issPub = issKP.getPublic();
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(new X500Name(_subDN), BigInteger.valueOf(System.currentTimeMillis()), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 8640000000L), new X500Name(_subDN), issKP.getPublic());
        certGen.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0));
        ContentSigner signer = new JcaContentSignerBuilder("ML-DSA").build(issPriv);
        X509CertificateHolder certHolder = certGen.build(signer);
        ContentVerifierProvider verifier = new JcaContentVerifierProviderBuilder().build(issPub);
        Assert.assertTrue((boolean)certHolder.isSignatureValid(verifier));
        return certHolder;
    }

    private static X509CertificateHolder makeV3Certificate(SubjectPublicKeyInfo pubKey, X500Name _subDN, KeyPair issKP, String _issDN) throws OperatorCreationException, CertException, CertIOException {
        PrivateKey issPriv = issKP.getPrivate();
        PublicKey issPub = issKP.getPublic();
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(new X500Name(_issDN), BigInteger.valueOf(System.currentTimeMillis()), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 8640000000L), _subDN, pubKey);
        certGen.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        ContentSigner signer = new JcaContentSignerBuilder("ML-DSA").build(issPriv);
        X509CertificateHolder certHolder = certGen.build(signer);
        ContentVerifierProvider verifier = new JcaContentVerifierProviderBuilder().build(issPub);
        Assert.assertTrue((boolean)certHolder.isSignatureValid(verifier));
        return certHolder;
    }
}

