/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.cmp.test;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.crmf.SubsequentMessage;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.cmp.CertificateConfirmationContent;
import org.bouncycastle.cert.cmp.CertificateConfirmationContentBuilder;
import org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import org.bouncycastle.cert.cmp.ProtectedPKIMessageBuilder;
import org.bouncycastle.cert.cmp.test.TestUtils;
import org.bouncycastle.cert.crmf.CertificateRepMessage;
import org.bouncycastle.cert.crmf.CertificateRepMessageBuilder;
import org.bouncycastle.cert.crmf.CertificateReqMessages;
import org.bouncycastle.cert.crmf.CertificateReqMessagesBuilder;
import org.bouncycastle.cert.crmf.CertificateRequestMessage;
import org.bouncycastle.cert.crmf.CertificateResponse;
import org.bouncycastle.cert.crmf.CertificateResponseBuilder;
import org.bouncycastle.cert.crmf.jcajce.JcaCertificateRequestMessageBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.jcajce.spec.DHDomainParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.AsymmetricKeyWrapper;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.MacCalculator;
import org.bouncycastle.operator.PBEMacCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.operator.jcajce.JceAsymmetricKeyWrapper;
import org.bouncycastle.pkcs.jcajce.JcePBMac1CalculatorBuilder;
import org.bouncycastle.pkcs.jcajce.JcePBMac1CalculatorProviderBuilder;
import org.bouncycastle.util.BigIntegers;

public class ElgamalDSATest
extends TestCase {
    public void setUp() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void tearDown() {
    }

    public void testElgamalWithDSA() throws Exception {
        char[] senderMacPassword = "secret".toCharArray();
        GeneralName sender = new GeneralName(new X500Name("CN=Elgamal Subject"));
        GeneralName recipient = new GeneralName(new X500Name("CN=DSA Issuer"));
        KeyPairGenerator dsaKpGen = KeyPairGenerator.getInstance("DSA", "BC");
        DSAParameters dsaParams = (DSAParameters)CryptoServicesRegistrar.getSizedProperty((CryptoServicesRegistrar.Property)CryptoServicesRegistrar.Property.DSA_DEFAULT_PARAMS, (int)2048);
        dsaKpGen.initialize(new DSAParameterSpec(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG()));
        KeyPair dsaKp = dsaKpGen.generateKeyPair();
        X509CertificateHolder caCert = TestUtils.makeV3Certificate("CN=DSA Issuer", dsaKp);
        KeyPairGenerator elgKpGen = KeyPairGenerator.getInstance("Elgamal", "BC");
        elgKpGen.initialize((AlgorithmParameterSpec)new DHDomainParameterSpec((DHParameters)CryptoServicesRegistrar.getSizedProperty((CryptoServicesRegistrar.Property)CryptoServicesRegistrar.Property.DH_DEFAULT_PARAMS, (int)2048)));
        KeyPair elgKp = elgKpGen.generateKeyPair();
        JcaCertificateRequestMessageBuilder certReqBuild = new JcaCertificateRequestMessageBuilder(BigIntegers.ONE);
        certReqBuild.setPublicKey(elgKp.getPublic()).setSubject(X500Name.getInstance((Object)sender.getName())).setProofOfPossessionSubsequentMessage(SubsequentMessage.encrCert);
        CertificateReqMessagesBuilder certReqMsgsBldr = new CertificateReqMessagesBuilder();
        certReqMsgsBldr.addRequest(certReqBuild.build());
        MacCalculator senderMacCalculator = new JcePBMac1CalculatorBuilder("HmacSHA256", 256).setProvider("BC").build(senderMacPassword);
        ProtectedPKIMessage message = new ProtectedPKIMessageBuilder(sender, recipient).setBody(0, certReqMsgsBldr.build()).build(senderMacCalculator);
        Assert.assertTrue((boolean)message.getProtectionAlgorithm().equals((Object)senderMacCalculator.getAlgorithmIdentifier()));
        PBEMacCalculatorProvider macCalcProvider = new JcePBMac1CalculatorProviderBuilder().setProvider("BC").build();
        Assert.assertTrue((boolean)message.verify(macCalcProvider, senderMacPassword));
        Assert.assertEquals((int)0, (int)message.getBody().getType());
        CertificateReqMessages requestMessages = CertificateReqMessages.fromPKIBody((PKIBody)message.getBody());
        CertificateRequestMessage senderReqMessage = requestMessages.getRequests()[0];
        CertTemplate certTemplate = senderReqMessage.getCertTemplate();
        X509CertificateHolder cert = TestUtils.makeV3Certificate(certTemplate.getPublicKey(), certTemplate.getSubject(), dsaKp, "CN=DSA Issuer");
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(senderReqMessage.getCertReqId().getEncoded(), (AsymmetricKeyWrapper)new JceAsymmetricKeyWrapper(new JcaX509CertificateConverter().setProvider("BC").getCertificate(cert))));
        CMSEnvelopedData encryptedCert = edGen.generate((CMSTypedData)new CMSProcessableByteArray(new CMPCertificate(cert.toASN1Structure()).getEncoded()), new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider("BC").build());
        CertificateResponseBuilder certRespBuilder = new CertificateResponseBuilder(senderReqMessage.getCertReqId(), new PKIStatusInfo(PKIStatus.granted));
        certRespBuilder.withCertificate(encryptedCert);
        CertificateRepMessageBuilder repMessageBuilder = new CertificateRepMessageBuilder(caCert);
        repMessageBuilder.addCertificateResponse(certRespBuilder.build());
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withDSA").setProvider("BC").build(dsaKp.getPrivate());
        CertificateRepMessage repMessage = repMessageBuilder.build();
        ProtectedPKIMessage responsePkixMessage = new ProtectedPKIMessageBuilder(sender, recipient).setBody(1, repMessage).build(signer);
        Assert.assertTrue((boolean)responsePkixMessage.verify(new JcaContentVerifierProviderBuilder().build(caCert)));
        CertificateRepMessage certRepMessage = CertificateRepMessage.fromPKIBody((PKIBody)responsePkixMessage.getBody());
        CertificateResponse certResp = certRepMessage.getResponses()[0];
        X509CertificateHolder receivedCert = new X509CertificateHolder(certResp.getCertificate((Recipient)new JceKeyTransEnvelopedRecipient(elgKp.getPrivate())).getX509v3PKCert());
        X509CertificateHolder caCertHolder = certRepMessage.getX509Certificates()[0];
        Assert.assertEquals((boolean)true, (boolean)receivedCert.isSignatureValid(new JcaContentVerifierProviderBuilder().build(caCertHolder)));
        CertificateConfirmationContent content = new CertificateConfirmationContentBuilder().addAcceptedCertificate(cert, BigInteger.ONE).build(new JcaDigestCalculatorProviderBuilder().build());
        message = new ProtectedPKIMessageBuilder(sender, recipient).setBody(24, content).build(senderMacCalculator);
        Assert.assertTrue((boolean)content.getStatusMessages()[0].isVerified(receivedCert, new JcaDigestCalculatorProviderBuilder().build()));
        Assert.assertEquals((int)24, (int)message.getBody().getType());
        CertificateConfirmationContent recContent = CertificateConfirmationContent.fromPKIBody((PKIBody)message.getBody());
        Assert.assertTrue((boolean)recContent.getStatusMessages()[0].isVerified(receivedCert, new JcaDigestCalculatorProviderBuilder().build()));
    }
}

