/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.cmp.test;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CertConfirmContent;
import org.bouncycastle.asn1.cmp.CertOrEncCert;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.EncryptedKey;
import org.bouncycastle.asn1.crmf.EncryptedValue;
import org.bouncycastle.asn1.crmf.SubsequentMessage;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.CertException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.cmp.CertificateConfirmationContent;
import org.bouncycastle.cert.cmp.CertificateConfirmationContentBuilder;
import org.bouncycastle.cert.cmp.CertificateStatus;
import org.bouncycastle.cert.cmp.GeneralPKIMessage;
import org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import org.bouncycastle.cert.cmp.ProtectedPKIMessageBuilder;
import org.bouncycastle.cert.crmf.CertificateRequestMessage;
import org.bouncycastle.cert.crmf.CertificateRequestMessageBuilder;
import org.bouncycastle.cert.crmf.PKMACBuilder;
import org.bouncycastle.cert.crmf.PKMACValuesCalculator;
import org.bouncycastle.cert.crmf.jcajce.JcaCertificateRequestMessageBuilder;
import org.bouncycastle.cert.crmf.jcajce.JcaEncryptedValueBuilder;
import org.bouncycastle.cert.crmf.jcajce.JceCRMFEncryptorBuilder;
import org.bouncycastle.cert.crmf.jcajce.JcePKMACValuesCalculator;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.KeyWrapper;
import org.bouncycastle.operator.MacCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.PBEMacCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.operator.jcajce.JceAsymmetricKeyUnwrapper;
import org.bouncycastle.operator.jcajce.JceAsymmetricKeyWrapper;
import org.bouncycastle.operator.jcajce.JceInputDecryptorProviderBuilder;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.jcajce.JcePBMac1CalculatorBuilder;
import org.bouncycastle.pkcs.jcajce.JcePBMac1CalculatorProviderBuilder;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class AllTests
extends TestCase {
    private static final byte[] TEST_DATA = "Hello world!".getBytes();
    private static final String BC = "BC";
    static /* synthetic */ Class class$org$bouncycastle$cert$cmp$test$AllTests;

    public AllTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$bouncycastle$cert$cmp$test$AllTests == null ? (class$org$bouncycastle$cert$cmp$test$AllTests = AllTests.class$("org.bouncycastle.cert.cmp.test.AllTests")) : class$org$bouncycastle$cert$cmp$test$AllTests));
    }

    public static Test suite() {
        return new TestSuite(class$org$bouncycastle$cert$cmp$test$AllTests == null ? (class$org$bouncycastle$cert$cmp$test$AllTests = AllTests.class$("org.bouncycastle.cert.cmp.test.AllTests")) : class$org$bouncycastle$cert$cmp$test$AllTests);
    }

    public void setUp() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void tearDown() {
    }

    public void testProtectedMessage() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509CertificateHolder cert = AllTests.makeV3Certificate(kp, "CN=Test", kp, "CN=Test");
        GeneralName sender = new GeneralName(new X500Name("CN=Sender"));
        GeneralName recipient = new GeneralName(new X500Name("CN=Recip"));
        ContentSigner signer = new JcaContentSignerBuilder("MD5WithRSAEncryption").setProvider(BC).build(kp.getPrivate());
        ProtectedPKIMessage message = new ProtectedPKIMessageBuilder(sender, recipient).setBody(new PKIBody(1, (ASN1Encodable)CertRepMessage.getInstance((Object)new DERSequence((ASN1Encodable)new DERSequence())))).addCMPCertificate(cert).build(signer);
        X509Certificate jcaCert = new JcaX509CertificateConverter().setProvider(BC).getCertificate(message.getCertificates()[0]);
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider(BC).build(jcaCert.getPublicKey());
        Assert.assertTrue((boolean)message.verify(verifierProvider));
        Assert.assertEquals((Object)sender, (Object)message.getHeader().getSender());
        Assert.assertEquals((Object)recipient, (Object)message.getHeader().getRecipient());
    }

    public void testMacProtectedMessage() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509CertificateHolder cert = AllTests.makeV3Certificate(kp, "CN=Test", kp, "CN=Test");
        GeneralName sender = new GeneralName(new X500Name("CN=Sender"));
        GeneralName recipient = new GeneralName(new X500Name("CN=Recip"));
        ProtectedPKIMessage message = new ProtectedPKIMessageBuilder(sender, recipient).setBody(new PKIBody(1, (ASN1Encodable)CertRepMessage.getInstance((Object)new DERSequence((ASN1Encodable)new DERSequence())))).addCMPCertificate(cert).build(new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator().setProvider(BC)).build("secret".toCharArray()));
        PKMACBuilder pkMacBuilder = new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator().setProvider(BC));
        Assert.assertTrue((boolean)message.verify((PBEMacCalculatorProvider)pkMacBuilder, "secret".toCharArray()));
        Assert.assertEquals((Object)sender, (Object)message.getHeader().getSender());
        Assert.assertEquals((Object)recipient, (Object)message.getHeader().getRecipient());
    }

    public void testPBMac1ProtectedMessage() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509CertificateHolder cert = AllTests.makeV3Certificate(kp, "CN=Test", kp, "CN=Test");
        GeneralName sender = new GeneralName(new X500Name("CN=Sender"));
        GeneralName recipient = new GeneralName(new X500Name("CN=Recip"));
        MacCalculator pbCalculator = new JcePBMac1CalculatorBuilder("HmacSHA256", 256).setProvider(BC).build("secret".toCharArray());
        ProtectedPKIMessage message = new ProtectedPKIMessageBuilder(sender, recipient).setBody(new PKIBody(1, (ASN1Encodable)CertRepMessage.getInstance((Object)new DERSequence((ASN1Encodable)new DERSequence())))).addCMPCertificate(cert).build(pbCalculator);
        PBEMacCalculatorProvider macProvider = new JcePBMac1CalculatorProviderBuilder().setProvider(BC).build();
        Assert.assertTrue((boolean)message.verify(macProvider, "secret".toCharArray()));
        Assert.assertEquals((Object)sender, (Object)message.getHeader().getSender());
        Assert.assertEquals((Object)recipient, (Object)message.getHeader().getRecipient());
    }

    public void testConfirmationMessage() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509CertificateHolder cert = AllTests.makeV3Certificate(kp, "CN=Test", kp, "CN=Test");
        GeneralName sender = new GeneralName(new X500Name("CN=Sender"));
        GeneralName recipient = new GeneralName(new X500Name("CN=Recip"));
        CertificateConfirmationContent content = new CertificateConfirmationContentBuilder().addAcceptedCertificate(cert, BigInteger.valueOf(1L)).build(new JcaDigestCalculatorProviderBuilder().build());
        ContentSigner signer = new JcaContentSignerBuilder("MD5WithRSAEncryption").setProvider(BC).build(kp.getPrivate());
        ProtectedPKIMessage message = new ProtectedPKIMessageBuilder(sender, recipient).setBody(new PKIBody(24, (ASN1Encodable)content.toASN1Structure())).addCMPCertificate(cert).build(signer);
        X509Certificate jcaCert = new JcaX509CertificateConverter().setProvider(BC).getCertificate(message.getCertificates()[0]);
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider(BC).build(jcaCert.getPublicKey());
        Assert.assertTrue((boolean)message.verify(verifierProvider));
        Assert.assertEquals((Object)sender, (Object)message.getHeader().getSender());
        Assert.assertEquals((Object)recipient, (Object)message.getHeader().getRecipient());
        content = new CertificateConfirmationContent(CertConfirmContent.getInstance((Object)message.getBody().getContent()));
        CertificateStatus[] statusList = content.getStatusMessages();
        Assert.assertEquals((int)1, (int)statusList.length);
        Assert.assertTrue((boolean)statusList[0].isVerified(cert, new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()));
    }

    public void testSampleCr() throws Exception {
        PKIMessage msg = AllTests.loadMessage("sample_cr.der");
        ProtectedPKIMessage procMsg = new ProtectedPKIMessage(new GeneralPKIMessage(msg));
        Assert.assertTrue((boolean)procMsg.verify((PBEMacCalculatorProvider)new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator().setProvider(BC)), "TopSecret1234".toCharArray()));
    }

    public void testSubsequentMessage() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509CertificateHolder cert = AllTests.makeV3Certificate(kp, "CN=Test", kp, "CN=Test");
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider(BC).build(kp.getPrivate());
        GeneralName user = new GeneralName(new X500Name("CN=Test"));
        CertificateRequestMessageBuilder builder = new JcaCertificateRequestMessageBuilder(BigInteger.valueOf(1L)).setPublicKey(kp.getPublic()).setProofOfPossessionSubsequentMessage(SubsequentMessage.encrCert);
        ProtectedPKIMessage certRequestMsg = new ProtectedPKIMessageBuilder(user, user).setTransactionID(new byte[]{1, 2, 3, 4, 5}).setBody(new PKIBody(7, (ASN1Encodable)new CertReqMessages(builder.build().toASN1Structure()))).addCMPCertificate(cert).build(signer);
        ProtectedPKIMessage msg = new ProtectedPKIMessage(new GeneralPKIMessage(certRequestMsg.toASN1Structure().getEncoded()));
        CertReqMessages reqMsgs = CertReqMessages.getInstance((Object)msg.getBody().getContent());
        CertReqMsg reqMsg = reqMsgs.toCertReqMsgArray()[0];
        Assert.assertEquals((int)2, (int)reqMsg.getPop().getType());
    }

    public void testServerSideKey() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509CertificateHolder cert = AllTests.makeV3Certificate(kp, "CN=Test", kp, "CN=Test");
        JcaEncryptedValueBuilder encBldr = new JcaEncryptedValueBuilder((KeyWrapper)new JceAsymmetricKeyWrapper(kp.getPublic()).setProvider(BC), new JceCRMFEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider(BC).build());
        GeneralName sender = new GeneralName(new X500Name("CN=Sender"));
        GeneralName recipient = new GeneralName(new X500Name("CN=Recip"));
        CertRepMessage msg = new CertRepMessage(null, new CertResponse[]{new CertResponse(new ASN1Integer(2L), new PKIStatusInfo(PKIStatus.granted), new CertifiedKeyPair(new CertOrEncCert(CMPCertificate.getInstance((Object)cert.getEncoded())), encBldr.build(kp.getPrivate()), null), null)});
        ContentSigner signer = new JcaContentSignerBuilder("MD5WithRSAEncryption").setProvider(BC).build(kp.getPrivate());
        ProtectedPKIMessage message = new ProtectedPKIMessageBuilder(sender, recipient).setBody(new PKIBody(1, (ASN1Encodable)msg)).addCMPCertificate(cert).build(signer);
        X509Certificate jcaCert = new JcaX509CertificateConverter().setProvider(BC).getCertificate(message.getCertificates()[0]);
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider(BC).build(jcaCert.getPublicKey());
        Assert.assertTrue((boolean)message.verify(verifierProvider));
        Assert.assertEquals((Object)sender, (Object)message.getHeader().getSender());
        Assert.assertEquals((Object)recipient, (Object)message.getHeader().getRecipient());
        CertRepMessage content = CertRepMessage.getInstance((Object)message.getBody().getContent());
        CertResponse[] responseList = content.getResponse();
        Assert.assertEquals((int)1, (int)responseList.length);
        CertResponse response = responseList[0];
        Assert.assertEquals((Object)PKIStatus.granted.getValue(), (Object)response.getStatus().getStatus());
        CertifiedKeyPair certKp = response.getCertifiedKeyPair();
        EncryptedKey encKey = certKp.getPrivateKey();
        EncryptedValue encValue = EncryptedValue.getInstance((Object)encKey.getValue());
        JceAsymmetricKeyUnwrapper unwrapper = new JceAsymmetricKeyUnwrapper(encValue.getKeyAlg(), kp.getPrivate());
        byte[] secKeyBytes = (byte[])unwrapper.generateUnwrappedKey(encValue.getKeyAlg(), encValue.getEncSymmKey().getBytes()).getRepresentation();
        PKCS8EncryptedPrivateKeyInfo respInfo = new PKCS8EncryptedPrivateKeyInfo(new EncryptedPrivateKeyInfo(encValue.getSymmAlg(), encValue.getEncValue().getBytes()));
        PrivateKeyInfo keyInfo = respInfo.decryptPrivateKeyInfo(new JceInputDecryptorProviderBuilder().setProvider(BC).build(secKeyBytes));
        Assert.assertEquals((Object)keyInfo.getPrivateKeyAlgorithm(), (Object)encValue.getIntendedAlg());
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])kp.getPrivate().getEncoded(), (byte[])keyInfo.getEncoded()));
    }

    public void testNotBeforeNotAfter() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        this.doNotBeforeNotAfterTest(kp, new Date(0L), new Date(60000L));
        this.doNotBeforeNotAfterTest(kp, null, new Date(60000L));
        this.doNotBeforeNotAfterTest(kp, new Date(0L), null);
    }

    private void doNotBeforeNotAfterTest(KeyPair kp, Date notBefore, Date notAfter) throws Exception {
        CertificateRequestMessageBuilder builder = new JcaCertificateRequestMessageBuilder(BigInteger.valueOf(1L)).setPublicKey(kp.getPublic()).setProofOfPossessionSubsequentMessage(SubsequentMessage.encrCert);
        builder.setValidity(notBefore, notAfter);
        CertificateRequestMessage message = builder.build();
        if (notBefore != null) {
            Assert.assertEquals((long)notBefore.getTime(), (long)message.getCertTemplate().getValidity().getNotBefore().getDate().getTime());
        } else {
            Assert.assertNull((Object)message.getCertTemplate().getValidity().getNotBefore());
        }
        if (notAfter != null) {
            Assert.assertEquals((long)notAfter.getTime(), (long)message.getCertTemplate().getValidity().getNotAfter().getDate().getTime());
        } else {
            Assert.assertNull((Object)message.getCertTemplate().getValidity().getNotAfter());
        }
    }

    private static X509CertificateHolder makeV3Certificate(KeyPair subKP, String _subDN, KeyPair issKP, String _issDN) throws GeneralSecurityException, IOException, OperatorCreationException, CertException {
        PublicKey subPub = subKP.getPublic();
        PrivateKey issPriv = issKP.getPrivate();
        PublicKey issPub = issKP.getPublic();
        JcaX509v3CertificateBuilder v1CertGen = new JcaX509v3CertificateBuilder(new X500Name(_issDN), BigInteger.valueOf(System.currentTimeMillis()), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 8640000000L), new X500Name(_subDN), subPub);
        ContentSigner signer = new JcaContentSignerBuilder("SHA1WithRSA").setProvider(BC).build(issPriv);
        X509CertificateHolder certHolder = v1CertGen.build(signer);
        ContentVerifierProvider verifier = new JcaContentVerifierProviderBuilder().setProvider(BC).build(issPub);
        Assert.assertTrue((boolean)certHolder.isSignatureValid(verifier));
        return certHolder;
    }

    private static PKIMessage loadMessage(String name) {
        try {
            return PKIMessage.getInstance((Object)ASN1Primitive.fromByteArray((byte[])Streams.readAll((InputStream)TestResourceFinder.findTestResource("/cmp", name))));
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

