/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class X9Test
extends SimpleTest {
    private byte[] namedPub = Base64.decode((String)"MDcwEwYHKoZIzj0CAQYIKoZIzj0DAQEDIAADG5xRI+Iki/JrvL20hoDUa7Cggzorv5B9yyqSMjYu");
    private byte[] expPub = Base64.decode((String)"MIH8MIHXBgcqhkjOPQIBMIHLAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH///////zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTLA9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BB8DZ2iujhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laAh5///////////////9///+XXetBs6YFfDxDIUZSZVECAQEDIAADG5xRI+Iki/JrvL20hoDUa7Cggzorv5B9yyqSMjYu");
    private byte[] namedPriv = Base64.decode((String)"MDkCAQAwEwYHKoZIzj0CAQYIKoZIzj0DAQEEHzAdAgEBBBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAo=");
    private byte[] expPriv = Base64.decode((String)"MIIBBAIBADCB1wYHKoZIzj0CATCBywIBATApBgcqhkjOPQEBAh5///////////////9///////+AAAAAAAB///////8wVwQef///////////////f///////gAAAAAAAf//////8BB4lVwX6KjBmVLH0ywPWp1CjDCUBAtSYhxfZuhWrbT4DFQB9c3QWj/40cbYKhXaGoZR107+i/wQfA2doro4Yu5LPzwBclJqixtlIU9DmYLv4VLHJUF/pWgIef///////////////f///l13rQbOmBXw8QyFGUmVRAgEBBCUwIwIBAQQeAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAU");

    private void encodePublicKey() throws Exception {
        ASN1Primitive o;
        ECPoint point;
        DEROctetString p;
        X962Parameters params;
        SubjectPublicKeyInfo info;
        X9IntegerConverter conv = new X9IntegerConverter();
        X9ECParameters ecP = X962NamedCurves.getByOID((ASN1ObjectIdentifier)X9ObjectIdentifiers.prime239v3);
        if (conv.getByteLength(ecP.getCurve()) != 30) {
            this.fail("wrong byte length reported for curve");
        }
        if (ecP.getCurve().getFieldSize() != 239) {
            this.fail("wrong field size reported for curve");
        }
        if (!this.areEqual((info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)(params = new X962Parameters(X9ObjectIdentifiers.prime192v1))), (p = new DEROctetString((point = ecP.getG().multiply(BigInteger.valueOf(100L))).getEncoded(true))).getOctets())).getEncoded(), this.namedPub)) {
            this.fail("failed public named generation");
        }
        X9ECPoint x9P = new X9ECPoint(ecP.getCurve(), (ASN1OctetString)p);
        if (!Arrays.areEqual((byte[])p.getOctets(), (byte[])x9P.getPointEncoding())) {
            this.fail("point encoding not preserved");
        }
        if (!info.equals((Object)(o = ASN1Primitive.fromByteArray((byte[])this.namedPub)))) {
            this.fail("failed public named equality");
        }
        if (!this.areEqual((info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)(params = new X962Parameters(ecP))), p.getOctets())).getEncoded(), this.expPub)) {
            this.fail("failed public explicit generation");
        }
        if (!info.equals((Object)(o = ASN1Primitive.fromByteArray((byte[])this.expPub)))) {
            this.fail("failed public explicit equality");
        }
    }

    private void encodePrivateKey() throws Exception {
        ASN1Primitive o;
        X962Parameters params = new X962Parameters(X9ObjectIdentifiers.prime192v1);
        X9ECParameters ecP = X962NamedCurves.getByOID((ASN1ObjectIdentifier)X9ObjectIdentifiers.prime192v1);
        PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)params), (ASN1Encodable)new ECPrivateKey(ecP.getN().bitLength(), BigInteger.valueOf(10L)));
        if (!this.areEqual(info.getEncoded(), this.namedPriv)) {
            this.fail("failed private named generation");
        }
        if (!info.equals((Object)(o = ASN1Primitive.fromByteArray((byte[])this.namedPriv)))) {
            this.fail("failed private named equality");
        }
        if (!this.areEqual((info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)(params = new X962Parameters(ecP = X962NamedCurves.getByOID((ASN1ObjectIdentifier)X9ObjectIdentifiers.prime239v3)))), (ASN1Encodable)new ECPrivateKey(ecP.getN().bitLength(), BigInteger.valueOf(20L)))).getEncoded(), this.expPriv)) {
            this.fail("failed private explicit generation");
        }
        if (!info.equals((Object)(o = ASN1Primitive.fromByteArray((byte[])this.expPriv)))) {
            this.fail("failed private explicit equality");
        }
    }

    public void performTest() throws Exception {
        this.encodePublicKey();
        this.encodePrivateKey();
    }

    public String getName() {
        return "X9";
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new X9Test());
    }
}

