/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AltSignatureAlgorithm;
import org.bouncycastle.asn1.x509.AltSignatureValue;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.SubjectAltPublicKeyInfo;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class X509AltTest
extends SimpleTest {
    public String getName() {
        return "X509Alt";
    }

    public void performTest() throws Exception {
        SubjectAltPublicKeyInfo subAlt = new SubjectAltPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), (ASN1BitString)new DERBitString(Hex.decode((String)"0102030405060708090807060504030201")));
        AltSignatureValue sigValAlt = new AltSignatureValue(Hex.decode((String)"0102030405060708090807060504030201"));
        AltSignatureAlgorithm sigAlgAlt = new AltSignatureAlgorithm(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
        AltSignatureAlgorithm sigAlgAlt2 = new AltSignatureAlgorithm(PKCSObjectIdentifiers.md5WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE);
        this.isEquals(sigAlgAlt, sigAlgAlt2);
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.subjectAltPublicKeyInfo, false, (ASN1Encodable)subAlt);
        extGen.addExtension(Extension.altSignatureAlgorithm, false, (ASN1Encodable)sigAlgAlt);
        extGen.addExtension(Extension.altSignatureValue, false, (ASN1Encodable)sigValAlt);
        Extensions exts = extGen.generate();
        this.isEquals(subAlt, SubjectAltPublicKeyInfo.fromExtensions((Extensions)exts));
        this.isEquals(sigAlgAlt, AltSignatureAlgorithm.fromExtensions((Extensions)exts));
        this.isEquals(sigValAlt, AltSignatureValue.fromExtensions((Extensions)exts));
        this.isEquals(subAlt, SubjectAltPublicKeyInfo.getInstance((Object)subAlt.getEncoded()));
        this.isEquals(sigAlgAlt, AltSignatureAlgorithm.getInstance((Object)sigAlgAlt.getEncoded()));
        this.isEquals(sigValAlt, AltSignatureValue.getInstance((Object)sigValAlt.getEncoded()));
        this.isEquals(subAlt, SubjectAltPublicKeyInfo.getInstance((ASN1TaggedObject)new DERTaggedObject(1, (ASN1Encodable)subAlt), (boolean)true));
        this.isEquals(sigAlgAlt, AltSignatureAlgorithm.getInstance((ASN1TaggedObject)new DERTaggedObject(1, (ASN1Encodable)sigAlgAlt), (boolean)true));
        this.isEquals(sigValAlt, AltSignatureValue.getInstance((ASN1TaggedObject)new DERTaggedObject(1, (ASN1Encodable)sigValAlt), (boolean)true));
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new X509AltTest());
    }
}

