/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1PrintableString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.BCStrictStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.X509DefaultEntryConverter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class X500NameTest
extends SimpleTest {
    String[] subjects = new String[]{"C=AU,ST=Victoria,L=South Melbourne,O=Connect 4 Pty Ltd,OU=Webserver Team,CN=www2.connect4.com.au,E=webmaster@connect4.com.au", "C=AU,ST=Victoria,L=South Melbourne,O=Connect 4 Pty Ltd,OU=Certificate Authority,CN=Connect 4 CA,E=webmaster@connect4.com.au", "C=AU,ST=QLD,CN=SSLeay/rsa test cert", "C=US,O=National Aeronautics and Space Administration,SERIALNUMBER=16+CN=Steve Schoch", "E=cooke@issl.atl.hp.com,C=US,OU=Hewlett Packard Company (ISSL),CN=Paul A. Cooke", "O=Sun Microsystems Inc,CN=store.sun.com", "unstructuredAddress=192.168.1.33,unstructuredName=pixfirewall.ciscopix.com,CN=pixfirewall.ciscopix.com", "CN=*.canal-plus.com,OU=Provided by TBS INTERNET https://www.tbs-certificats.com/,OU=\\ CANAL \\+,O=CANAL\\+DISTRIBUTION,L=issy les moulineaux,ST=Hauts de Seine,C=FR", "O=Bouncy Castle,CN=www.bouncycastle.org\\ ", "O=Bouncy Castle,CN=c:\\\\fred\\\\bob", "C=0,O=1,OU=2,T=3,CN=4,SERIALNUMBER=5,STREET=6,SERIALNUMBER=7,L=8,ST=9,SURNAME=10,GIVENNAME=11,INITIALS=12,GENERATION=13,UniqueIdentifier=14,BusinessCategory=15,PostalCode=16,DN=17,Pseudonym=18,PlaceOfBirth=19,Gender=20,CountryOfCitizenship=21,CountryOfResidence=22,NameAtBirth=23,PostalAddress=24,2.5.4.54=25,TelephoneNumber=26,Name=27,E=28,unstructuredName=29,unstructuredAddress=30,E=31,DC=32,UID=33", "C=DE,L=Berlin,O=Wohnungsbaugenossenschaft \\\"Humboldt-Universit\u00e4t\\\" eG,CN=transfer.wbg-hub.de"};
    String[] hexSubjects = new String[]{"CN=\\20Test\\20X,O=\\20Test,C=GB", "CN=\\ Test X,O=\\ Test,C=GB", "CN=\\20Test\\20X\\20,O=\\20Test,C=GB", "CN=\\ Test X\\ ,O=\\ Test,C=GB"};
    private static final String dnqSubject = "DNQ=Legion of the Bouncy Castle Inc.";

    public String getName() {
        return "X500Name";
    }

    private static X500Name fromBytes(byte[] bytes) throws IOException {
        return X500Name.getInstance((Object)bytes);
    }

    private ASN1Encodable createEntryValue(ASN1ObjectIdentifier oid, String value) {
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(oid, value);
        X500Name name = builder.build();
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)name.toASN1Primitive());
        ASN1Set set = ASN1Set.getInstance((Object)seq.getObjectAt(0).toASN1Primitive());
        seq = ASN1Sequence.getInstance((Object)set.getObjectAt(0));
        return seq.getObjectAt(1);
    }

    private ASN1Encodable createEntryValueFromString(ASN1ObjectIdentifier oid, String value) {
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(oid, value);
        X500Name name = new X500Name(builder.build().toString());
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)name.toASN1Primitive());
        ASN1Set set = ASN1Set.getInstance((Object)seq.getObjectAt(0).toASN1Primitive());
        seq = ASN1Sequence.getInstance((Object)set.getObjectAt(0));
        return seq.getObjectAt(1);
    }

    private void testEncodingPrintableString(ASN1ObjectIdentifier oid, String value) {
        ASN1Encodable converted = this.createEntryValue(oid, value);
        if (!(converted instanceof ASN1PrintableString)) {
            this.fail("encoding for " + oid + " not printable string");
        }
    }

    private void testEncodingIA5String(ASN1ObjectIdentifier oid, String value) {
        ASN1Encodable converted = this.createEntryValue(oid, value);
        if (!(converted instanceof ASN1IA5String)) {
            this.fail("encoding for " + oid + " not IA5String");
        }
    }

    private void testEncodingUTF8String(ASN1ObjectIdentifier oid, String value) throws IOException {
        ASN1Encodable converted = this.createEntryValue(oid, value);
        if (!(converted instanceof ASN1UTF8String)) {
            this.fail("encoding for " + oid + " not UTF8String");
        }
        if (!value.equals(ASN1UTF8String.getInstance((Object)converted.toASN1Primitive().getEncoded()).getString())) {
            this.fail("decoding not correct");
        }
    }

    private void testEncodingGeneralizedTime(ASN1ObjectIdentifier oid, String value) {
        ASN1Encodable converted = this.createEntryValue(oid, value);
        if (!(converted instanceof ASN1GeneralizedTime)) {
            this.fail("encoding for " + oid + " not GeneralizedTime");
        }
        if (!((converted = this.createEntryValueFromString(oid, value)) instanceof ASN1GeneralizedTime)) {
            this.fail("encoding for " + oid + " not GeneralizedTime");
        }
    }

    public void performTest() throws Exception {
        String[] aliases;
        RDN[] vls;
        X500Name n;
        X500Name name;
        DERTaggedObject tag;
        X500Name nested;
        ASN1ObjectIdentifier[] types;
        this.ietfUtilsTest();
        this.bogusEqualsTest();
        this.testEncodingPrintableString(BCStyle.C, "AU");
        this.testEncodingPrintableString(BCStyle.SERIALNUMBER, "123456");
        this.testEncodingPrintableString(BCStyle.DN_QUALIFIER, "123456");
        this.testEncodingIA5String(BCStyle.EmailAddress, "test@test.com");
        this.testEncodingIA5String(BCStyle.DC, "test");
        this.testEncodingGeneralizedTime(BCStyle.DATE_OF_BIRTH, "#180F32303032303132323132323232305A");
        this.testEncodingGeneralizedTime(BCStyle.DATE_OF_BIRTH, "20020122122220Z");
        this.testEncodingUTF8String(BCStyle.CN, "M\u00f6rsky");
        this.testEncodingUTF8String(BCStyle.ORGANIZATION_IDENTIFIER, "M\u00f6rsky");
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(BCStyle.C, "AU");
        builder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        builder.addRDN(BCStyle.L, "Melbourne");
        builder.addRDN(BCStyle.ST, "Victoria");
        builder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        X500Name name1 = builder.build();
        if (!name1.equals((Object)name1)) {
            this.fail("Failed same object test");
        }
        X500Name dnqName = new X500Name((X500NameStyle)DNQStyle.INSTANCE, dnqSubject);
        this.isEquals(dnqName.toString(), dnqSubject);
        builder = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(BCStyle.C, "AU");
        builder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        builder.addRDN(BCStyle.L, "Melbourne");
        builder.addRDN(BCStyle.ST, "Victoria");
        builder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        X500Name name2 = builder.build();
        if (!name1.equals((Object)name2)) {
            this.fail("Failed same name test");
        }
        if (name1.hashCode() != name2.hashCode()) {
            this.fail("Failed same name test - in Order");
        }
        X500NameBuilder builder1 = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(BCStyle.C, "AU");
        builder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        builder.addRDN(BCStyle.L, "Melbourne");
        builder.addRDN(BCStyle.ST, "Victoria");
        builder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        X500NameBuilder builder2 = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        builder.addRDN(BCStyle.C, "AU");
        builder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        builder.addRDN(BCStyle.L, "Melbourne");
        builder.addRDN(BCStyle.ST, "Victoria");
        name1 = builder1.build();
        name2 = builder2.build();
        if (!name1.equals((Object)name2)) {
            this.fail("Failed reverse name test");
        }
        if (name1.hashCode() != name2.hashCode()) {
            this.fail("Failed reverse name test hashCode");
        }
        int i = 0;
        while (i != this.subjects.length) {
            X500Name name3 = new X500Name(this.subjects[i]);
            if (!(name3 = X500NameTest.fromBytes(name3.getEncoded())).toString().equals(this.subjects[i])) {
                this.fail("failed regeneration test " + i + " got: " + name3.toString() + " expected " + this.subjects[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.hexSubjects.length) {
            X500Name name4 = new X500Name(this.hexSubjects[i2]);
            if (!(name4 = X500NameTest.fromBytes(name4.getEncoded())).toString().equals(this.hexSubjects[i2 + 1])) {
                this.fail("failed hex regeneration test " + i2 + " got: " + name4.toString() + " expected " + this.hexSubjects[i2 + 1]);
            }
            i2 += 2;
        }
        X500Name unsorted = new X500Name("SERIALNUMBER=BBB + CN=AA");
        if (!X500NameTest.fromBytes(unsorted.getEncoded()).toString().equals("CN=AA+SERIALNUMBER=BBB")) {
            this.fail("failed sort test 1");
        }
        if (!X500NameTest.fromBytes((unsorted = new X500Name("CN=AA + SERIALNUMBER=BBB")).getEncoded()).toString().equals("CN=AA+SERIALNUMBER=BBB")) {
            this.fail("failed sort test 2");
        }
        if (!X500NameTest.fromBytes((unsorted = new X500Name("SERIALNUMBER=B + CN=AA")).getEncoded()).toString().equals("SERIALNUMBER=B+CN=AA")) {
            this.fail("failed sort test 3");
        }
        if (!X500NameTest.fromBytes((unsorted = new X500Name("CN=AA + SERIALNUMBER=B")).getEncoded()).toString().equals("SERIALNUMBER=B+CN=AA")) {
            this.fail("failed sort test 4");
        }
        this.equalityTest(new X500Name("CN=The     Legion"), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=   The Legion"), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=The Legion   "), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=  The     Legion "), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=  the     legion "), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=  the     legion+C=AU, O=Legion "), new X500Name("CN=The Legion+C=AU, O=Legion"));
        X500Name n1 = new X500Name("SERIALNUMBER=8,O=ABC,CN=ABC Class 3 CA,C=LT");
        X500Name n2 = new X500Name("2.5.4.5=8,O=ABC,CN=ABC Class 3 CA,C=LT");
        X500Name n3 = new X500Name("2.5.4.5=#130138,O=ABC,CN=ABC Class 3 CA,C=LT");
        this.equalityTest(n1, n2);
        this.equalityTest(n2, n3);
        this.equalityTest(n3, n1);
        n1 = new X500Name("2.5.4.5=#130138,CN=SSC Class 3 CA,O=UAB Skaitmeninio sertifikavimo centras,C=LT");
        n2 = new X500Name("SERIALNUMBER=#130138,CN=SSC Class 3 CA,O=UAB Skaitmeninio sertifikavimo centras,C=LT");
        n3 = X500NameTest.fromBytes(Hex.decode((String)"3063310b3009060355040613024c54312f302d060355040a132655414220536b6169746d656e696e696f20736572746966696b6176696d6f2063656e74726173311730150603550403130e53534320436c6173732033204341310a30080603550405130138"));
        this.equalityTest(n1, n2);
        this.equalityTest(n2, n3);
        this.equalityTest(n3, n1);
        n1 = new X500Name("SERIALNUMBER=8,O=XX,CN=ABC Class 3 CA,C=LT");
        n2 = new X500Name("2.5.4.5=8,O=,CN=ABC Class 3 CA,C=LT");
        n1 = new X500Name("SERIALNUMBER=8,O=,CN=ABC Class 3 CA,C=LT");
        n2 = new X500Name("2.5.4.5=8,O=,CN=ABC Class 3 CA,C=LT");
        this.equalityTest(n1, n2);
        this.equalityTest(X500Name.getInstance((X500NameStyle)BCStrictStyle.INSTANCE, (Object)n1), X500Name.getInstance((X500NameStyle)BCStrictStyle.INSTANCE, (Object)n2));
        n2 = new X500Name("C=LT,2.5.4.5=8,O=,CN=ABC Class 3 CA");
        this.equalityTest(n1, n2);
        if (X500Name.getInstance((X500NameStyle)BCStrictStyle.INSTANCE, (Object)n1).equals((Object)X500Name.getInstance((X500NameStyle)BCStrictStyle.INSTANCE, (Object)n2))) {
            this.fail("strict comparison failed");
        }
        if ((name1 = new X500Name("CN=The Legion")).equals((Object)new DERSequence())) {
            this.fail("inequality test with sequence");
        }
        if (name1.equals((Object)new DERSequence((ASN1Encodable)new DERSet()))) {
            this.fail("inequality test with sequence and set");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.1"));
        v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.1"));
        if (name1.equals((Object)new DERSequence((ASN1Encodable)new DERSet((ASN1Encodable)new DERSet(v))))) {
            this.fail("inequality test with sequence and bad set");
        }
        if (name1.equals((Object)new DERSequence((ASN1Encodable)new DERSet((ASN1Encodable)new DERSet(v))))) {
            this.fail("inequality test with sequence and bad set");
        }
        if (name1.equals((Object)new DERSequence((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence())))) {
            this.fail("inequality test with sequence and short sequence");
        }
        if (name1.equals((Object)new DERSequence((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence())))) {
            this.fail("inequality test with sequence and short sequence");
        }
        v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.1"));
        v.add((ASN1Encodable)new DERSequence());
        if (name1.equals((Object)new DERSequence((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence(v))))) {
            this.fail("inequality test with sequence and bad sequence");
        }
        if (name1.equals(null)) {
            this.fail("inequality test with null");
        }
        if (!((types = (unsorted = new X500Name("CN=AA + CN=AA + CN=AA")).getAttributeTypes()).length == 3 && types[0].equals((ASN1Primitive)BCStyle.CN) && types[1].equals((ASN1Primitive)BCStyle.CN) && types[2].equals((ASN1Primitive)BCStyle.CN))) {
            this.fail("types not matched correctly");
        }
        if (!((types = (nested = new X500Name("CN=AA + CN=AA, C=AU")).getAttributeTypes()).length == 3 && types[0].equals((ASN1Primitive)BCStyle.CN) && types[1].equals((ASN1Primitive)BCStyle.CN) && types[2].equals((ASN1Primitive)BCStyle.C))) {
            this.fail("nested types not matched correctly");
        }
        if (!(tag = new DERTaggedObject(false, 1, (ASN1Encodable)new X500Name("CN=AA"))).isExplicit()) {
            this.fail("failed to explicitly tag CHOICE object");
        }
        if (!(name = X500Name.getInstance((ASN1TaggedObject)tag, (boolean)false)).equals((Object)new X500Name("CN=AA"))) {
            this.fail("failed to recover tagged name");
        }
        DERUTF8String testString = new DERUTF8String("The Legion of the Bouncy Castle");
        byte[] encodedBytes = testString.getEncoded();
        byte[] hexEncodedBytes = Hex.encode((byte[])encodedBytes);
        String hexEncodedString = "#" + new String(hexEncodedBytes);
        ASN1UTF8String converted = (ASN1UTF8String)new X509DefaultEntryConverter().getConvertedValue(BCStyle.L, hexEncodedString);
        if (!converted.equals((ASN1Primitive)testString)) {
            this.fail("failed X509DefaultEntryConverter test");
        }
        if (!(converted = (ASN1UTF8String)new X509DefaultEntryConverter().getConvertedValue(BCStyle.L, "\\" + hexEncodedString)).equals((ASN1Primitive)new DERUTF8String(hexEncodedString))) {
            this.fail("failed X509DefaultEntryConverter test got " + converted + " expected: " + hexEncodedString);
        }
        if (!(n = new X500Name("CN=\\#nothex#string")).toString().equals("CN=\\#nothex#string")) {
            this.fail("# string not properly escaped.");
        }
        if ((vls = n.getRDNs(BCStyle.CN)).length != 1 || !this.getValue(vls[0]).equals("#nothex#string")) {
            this.fail("escaped # not reduced properly");
        }
        if ((types = n.getAttributeTypes()).length != 1 || !types[0].equals((ASN1Primitive)BCStyle.CN)) {
            this.fail("type not matched correctly");
        }
        if ((vls = (n = new X500Name("CN=\"a+b\"")).getRDNs(BCStyle.CN)).length != 1 || !this.getValue(vls[0]).equals("a+b")) {
            this.fail("escaped + not reduced properly");
        }
        if ((vls = (n = new X500Name("CN=a\\+b")).getRDNs(BCStyle.CN)).length != 1 || !this.getValue(vls[0]).equals("a+b")) {
            this.fail("escaped + not reduced properly");
        }
        if (!n.toString().equals("CN=a\\+b")) {
            this.fail("+ in string not properly escaped.");
        }
        if ((vls = (n = new X500Name("CN=a\\=b")).getRDNs(BCStyle.CN)).length != 1 || !this.getValue(vls[0]).equals("a=b")) {
            this.fail("escaped = not reduced properly");
        }
        if (!n.toString().equals("CN=a\\=b")) {
            this.fail("= in string not properly escaped.");
        }
        if ((vls = (n = new X500Name("TELEPHONENUMBER=\"+61999999999\"")).getRDNs(BCStyle.TELEPHONE_NUMBER)).length != 1 || !this.getValue(vls[0]).equals("+61999999999")) {
            this.fail("telephonenumber escaped + not reduced properly");
        }
        if ((vls = (n = new X500Name("TELEPHONENUMBER=\\+61999999999")).getRDNs(BCStyle.TELEPHONE_NUMBER)).length != 1 || !this.getValue(vls[0]).equals("+61999999999")) {
            this.fail("telephonenumber escaped + not reduced properly");
        }
        if (!"E".equals(BCStyle.INSTANCE.oidToDisplayName(BCStyle.EmailAddress))) {
            this.fail("display name for E incorrect");
        }
        if ((aliases = BCStyle.INSTANCE.oidToAttrNames(BCStyle.EmailAddress)).length != 2) {
            this.fail("no aliases found");
        }
        if (!"e".equals(aliases[0]) && !"e".equals(aliases[1])) {
            this.fail("first alias name for E incorrect");
        }
        if (!"emailaddress".equals(aliases[0]) && !"emailaddress".equals(aliases[1])) {
            this.fail("second alias name for E incorrect");
        }
        if (BCStyle.INSTANCE.oidToDisplayName(new ASN1ObjectIdentifier("1.2.1")) != null) {
            this.fail("unknown oid matched!");
        }
        if (BCStyle.INSTANCE.oidToAttrNames(new ASN1ObjectIdentifier("1.2.1")).length != 0) {
            this.fail("unknown oid matched aliases!");
        }
        if (!new X500Name("CN=\"  CA1 -   CP.04.03\", OU=Testing, OU=Dod, O=U.S. Government, C=US").equals((Object)new X500Name("CN=\"ca1 - CP.04.03  \", OU=Testing, OU=Dod, O=U.S. Government, C=US"))) {
            this.fail("padded equality test failed");
        }
        this.isTrue(BCStyle.INSTANCE.attrNameToOID("jurisdictionCountry").equals((ASN1Primitive)BCStyle.JURISDICTION_C));
        this.isTrue(BCStyle.INSTANCE.attrNameToOID("jurisdictionState").equals((ASN1Primitive)BCStyle.JURISDICTION_ST));
        this.isTrue(BCStyle.INSTANCE.attrNameToOID("jurisdictionLocality").equals((ASN1Primitive)BCStyle.JURISDICTION_L));
    }

    private String getValue(RDN vl) {
        return ((ASN1String)vl.getFirst().getValue()).getString();
    }

    private void ietfUtilsTest() throws Exception {
        IETFUtils.valueToString((ASN1Encodable)new DERUTF8String(" "));
    }

    private void bogusEqualsTest() throws Exception {
        try {
            new X500Name("CN=foo=bar");
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("badly formatted directory string", e.getMessage());
        }
    }

    private void equalityTest(X500Name name1, X500Name name2) {
        if (!name1.equals((Object)name2)) {
            this.fail("equality test failed for " + name1 + " : " + name2);
        }
        if (name1.hashCode() != name2.hashCode()) {
            this.fail("hashCodeTest test failed for " + name1 + " : " + name2);
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new X500NameTest());
    }

    public static class DNQStyle
    extends BCStyle {
        public static final DNQStyle INSTANCE = new DNQStyle();

        private DNQStyle() {
            this.defaultLookUp.put("dnq", BCStyle.DN_QUALIFIER);
            this.defaultSymbols.put(BCStyle.DN_QUALIFIER, "DNQ");
        }
    }
}

