/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import org.bouncycastle.util.test.SimpleTest;

public class TypeOfBiometricDataUnitTest
extends SimpleTest {
    public String getName() {
        return "TypeOfBiometricData";
    }

    public void performTest() throws Exception {
        this.checkPredefinedType(0);
        this.checkPredefinedType(1);
        ASN1ObjectIdentifier localType = new ASN1ObjectIdentifier("1.1");
        TypeOfBiometricData type = new TypeOfBiometricData(localType);
        this.checkNonPredefined(type, localType);
        type = TypeOfBiometricData.getInstance((Object)type);
        this.checkNonPredefined(type, localType);
        ASN1Primitive obj = type.toASN1Primitive();
        type = TypeOfBiometricData.getInstance((Object)obj);
        this.checkNonPredefined(type, localType);
        type = TypeOfBiometricData.getInstance(null);
        if (type != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            TypeOfBiometricData.getInstance((Object)new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new TypeOfBiometricData(100);
            this.fail("constructor failed to detect bad predefined type.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void checkPredefinedType(int predefinedType) throws IOException {
        TypeOfBiometricData type = new TypeOfBiometricData(predefinedType);
        this.checkPredefined(type, predefinedType);
        type = TypeOfBiometricData.getInstance((Object)type);
        this.checkPredefined(type, predefinedType);
        ASN1InputStream aIn = new ASN1InputStream(type.toASN1Primitive().getEncoded());
        ASN1Primitive obj = aIn.readObject();
        type = TypeOfBiometricData.getInstance((Object)obj);
        this.checkPredefined(type, predefinedType);
    }

    private void checkPredefined(TypeOfBiometricData type, int value) {
        if (!type.isPredefined()) {
            this.fail("predefined type expected but not found.");
        }
        if (type.getPredefinedBiometricType() != value) {
            this.fail("predefined type does not match.");
        }
    }

    private void checkNonPredefined(TypeOfBiometricData type, ASN1ObjectIdentifier value) {
        if (type.isPredefined()) {
            this.fail("predefined type found when not expected.");
        }
        if (!type.getBiometricDataOid().equals((ASN1Primitive)value)) {
            this.fail("data oid does not match.");
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new TypeOfBiometricDataUnitTest());
    }
}

