/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class TagTest
extends SimpleTest {
    byte[] longTagged = Base64.decode((String)"ZSRzIp8gEEZFRENCQTk4NzY1NDMyMTCfIQwyMDA2MDQwMTEyMzSUCCAFERVzA4kCAHEXGBkalAggBRcYGRqUCCAFZS6QAkRFkQlURUNITklLRVKSBQECAwQFkxAREhMUFRYXGBkalAggBREVcwOJAgBxFxgZGpQIIAUXGBkalAggBWUukAJERZEJVEVDSE5JS0VSkgUBAgMEBZMQERITFBUWFxgZGpQIIAURFXMDiQIAcRcYGRqUCCAFFxgZGpQIIAVlLpACREWRCVRFQ0hOSUtFUpIFAQIDBAWTEBESExQVFhcYGRqUCCAFERVzA4kCAHEXGBkalAggBRcYGRqUCCAFFxgZGpQIIAUXGBkalAg=");
    byte[] longAppSpecificTag = Hex.decode((String)"5F610101");
    byte[] taggedInteger = Hex.decode((String)"BF2203020101");

    public String getName() {
        return "Tag";
    }

    public void performTest() throws IOException {
        ASN1Sequence seq;
        ASN1TaggedObject tagged;
        ASN1InputStream aIn = new ASN1InputStream(this.longTagged);
        ASN1TaggedObject app = (ASN1TaggedObject)aIn.readObject();
        if (!app.hasTag(64, 5)) {
            this.fail("unexpected tag value found - not 5");
        }
        if (!(app = app.getExplicitBaseTagged()).hasTag(64, 19)) {
            this.fail("unexpected tag value found - not 19");
        }
        if (!(tagged = (ASN1TaggedObject)(seq = (ASN1Sequence)app.getBaseUniversal(false, 16)).getObjectAt(0)).hasContextTag(32)) {
            this.fail("unexpected tag value found - not 32");
        }
        if (!(tagged = (ASN1TaggedObject)ASN1Primitive.fromByteArray((byte[])tagged.getEncoded())).hasContextTag(32)) {
            this.fail("unexpected tag value found on recode - not 32");
        }
        if (!(tagged = (ASN1TaggedObject)seq.getObjectAt(1)).hasContextTag(33)) {
            this.fail("unexpected tag value found - not 33");
        }
        if (!(tagged = (ASN1TaggedObject)ASN1Primitive.fromByteArray((byte[])tagged.getEncoded())).hasContextTag(33)) {
            this.fail("unexpected tag value found on recode - not 33");
        }
        if (!(app = (ASN1TaggedObject)(aIn = new ASN1InputStream(this.longAppSpecificTag)).readObject()).hasTag(64, 97)) {
            this.fail("incorrect tag number read");
        }
        if (!(app = (ASN1TaggedObject)ASN1Primitive.fromByteArray((byte[])app.getEncoded())).hasTag(64, 97)) {
            this.fail("incorrect tag number read on recode");
        }
        SecureRandom sr = new SecureRandom();
        int i = 0;
        while (i < 100) {
            int testTag = sr.nextInt() >>> 1 + (sr.nextInt() >>> 1) % 26;
            app = new DERTaggedObject(false, 64, testTag, (ASN1Encodable)new DEROctetString(new byte[]{1}));
            if (!(app = (ASN1TaggedObject)ASN1Primitive.fromByteArray((byte[])app.getEncoded())).hasTag(64, testTag)) {
                this.fail("incorrect tag number read on recode (random test value: " + testTag + ")");
            }
            ++i;
        }
        tagged = new DERTaggedObject(false, 34, (ASN1Encodable)new DERTaggedObject(true, 1000, (ASN1Encodable)new ASN1Integer(1L)));
        if (!this.areEqual(this.taggedInteger, tagged.getEncoded())) {
            this.fail("incorrect encoding for implicit explicit tagged integer");
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new TagTest());
    }
}

