/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTest;

public class StringTest
extends SimpleTest {
    public String getName() {
        return "String";
    }

    public void performTest() throws IOException {
        DERUniversalString us;
        DERBitString bs = new DERBitString(new byte[]{1, 35, 69, 103, -119, -85, -51, -17});
        if (!bs.getString().equals("#0309000123456789ABCDEF")) {
            this.fail("DERBitString.getString() result incorrect");
        }
        if (!bs.toString().equals("#0309000123456789ABCDEF")) {
            this.fail("DERBitString.toString() result incorrect");
        }
        if (!(bs = new DERBitString(new byte[]{-2, -36, -70, -104, 118, 84, 50, 16})).getString().equals("#030900FEDCBA9876543210")) {
            this.fail("DERBitString.getString() result incorrect");
        }
        if (!bs.toString().equals("#030900FEDCBA9876543210")) {
            this.fail("DERBitString.toString() result incorrect");
        }
        if (!(us = new DERUniversalString(new byte[]{1, 35, 69, 103, -119, -85, -51, -17})).getString().equals("#1C080123456789ABCDEF")) {
            this.fail("DERUniversalString.getString() result incorrect");
        }
        if (!us.toString().equals("#1C080123456789ABCDEF")) {
            this.fail("DERUniversalString.toString() result incorrect");
        }
        if (!(us = new DERUniversalString(new byte[]{-2, -36, -70, -104, 118, 84, 50, 16})).getString().equals("#1C08FEDCBA9876543210")) {
            this.fail("DERUniversalString.getString() result incorrect");
        }
        if (!us.toString().equals("#1C08FEDCBA9876543210")) {
            this.fail("DERUniversalString.toString() result incorrect");
        }
        byte[] t61Bytes = new byte[]{-1, -2, -3, -4, -5, -6, -7, -8};
        try {
            String t61String = new String(t61Bytes, "iso-8859-1");
            DERT61String t61 = new DERT61String(Strings.fromByteArray((byte[])t61Bytes));
            if (!t61.getString().equals(t61String)) {
                this.fail("DERT61String.getString() result incorrect");
            }
            if (!t61.toString().equals(t61String)) {
                this.fail("DERT61String.toString() result incorrect");
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        char[] shortChars = new char[]{'a', 'b', 'c', 'd', 'e'};
        char[] longChars = new char[1000];
        int i = 0;
        while (i != longChars.length) {
            longChars[i] = 88;
            ++i;
        }
        this.checkString((ASN1String)new DERBMPString(new String(shortChars)), (ASN1String)new DERBMPString(new String(longChars)));
        this.checkString((ASN1String)new DERUTF8String(new String(shortChars)), (ASN1String)new DERUTF8String(new String(longChars)));
        this.checkString((ASN1String)new DERIA5String(new String(shortChars)), (ASN1String)new DERIA5String(new String(longChars)));
        this.checkString((ASN1String)new DERPrintableString(new String(shortChars)), (ASN1String)new DERPrintableString(new String(longChars)));
        this.checkString((ASN1String)new DERVisibleString(new String(shortChars)), (ASN1String)new DERVisibleString(new String(longChars)));
        this.checkString((ASN1String)new DERGeneralString(new String(shortChars)), (ASN1String)new DERGeneralString(new String(longChars)));
        this.checkString((ASN1String)new DERT61String(new String(shortChars)), (ASN1String)new DERT61String(new String(longChars)));
        shortChars = new char[]{'1', '2', '3', '4', '5'};
        longChars = new char[1000];
        int i2 = 0;
        while (i2 != longChars.length) {
            longChars[i2] = 49;
            ++i2;
        }
        this.checkString((ASN1String)new DERNumericString(new String(shortChars)), (ASN1String)new DERNumericString(new String(longChars)));
        byte[] shortBytes = new byte[]{97, 98, 99, 100, 101};
        byte[] longBytes = new byte[1000];
        int i3 = 0;
        while (i3 != longChars.length) {
            longBytes[i3] = 88;
            ++i3;
        }
        this.checkString((ASN1String)new DERUniversalString(shortBytes), (ASN1String)new DERUniversalString(longBytes));
    }

    private void checkString(ASN1String shortString, ASN1String longString) throws IOException {
        ASN1String short2 = (ASN1String)ASN1Primitive.fromByteArray((byte[])((ASN1Primitive)shortString).getEncoded());
        if (!shortString.toString().equals(short2.toString())) {
            this.fail(short2.getClass().getName() + " shortBytes result incorrect");
        }
        ASN1String long2 = (ASN1String)ASN1Primitive.fromByteArray((byte[])((ASN1Primitive)longString).getEncoded());
        if (!longString.toString().equals(long2.toString())) {
            this.fail(long2.getClass().getName() + " longBytes result incorrect");
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new StringTest());
    }
}

