/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.util.test.SimpleTest;

public class SetTest
extends SimpleTest {
    public String getName() {
        return "Set";
    }

    private void checkedSortedSet(int attempt, ASN1Set s) {
        if (s.getObjectAt(0) instanceof ASN1Boolean && s.getObjectAt(1) instanceof ASN1Integer && s.getObjectAt(2) instanceof DERBitString && s.getObjectAt(3) instanceof DEROctetString) {
            return;
        }
        this.fail("sorting failed on attempt: " + attempt);
    }

    public void performTest() throws Exception {
        ASN1EncodableVector v = new ASN1EncodableVector();
        byte[] data = new byte[10];
        v.add((ASN1Encodable)new DEROctetString(data));
        v.add((ASN1Encodable)new DERBitString(data));
        v.add((ASN1Encodable)new ASN1Integer(100L));
        v.add((ASN1Encodable)ASN1Boolean.getInstance((boolean)true));
        this.checkedSortedSet(0, (ASN1Set)new DERSet(v));
        v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(100L));
        v.add((ASN1Encodable)ASN1Boolean.getInstance((boolean)true));
        v.add((ASN1Encodable)new DEROctetString(data));
        v.add((ASN1Encodable)new DERBitString(data));
        this.checkedSortedSet(1, (ASN1Set)new DERSet(v));
        v = new ASN1EncodableVector();
        v.add((ASN1Encodable)ASN1Boolean.getInstance((boolean)true));
        v.add((ASN1Encodable)new DEROctetString(data));
        v.add((ASN1Encodable)new DERBitString(data));
        v.add((ASN1Encodable)new ASN1Integer(100L));
        this.checkedSortedSet(2, (ASN1Set)new DERSet(v));
        v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new DERBitString(data));
        v.add((ASN1Encodable)new DEROctetString(data));
        v.add((ASN1Encodable)new ASN1Integer(100L));
        v.add((ASN1Encodable)ASN1Boolean.getInstance((boolean)true));
        this.checkedSortedSet(3, (ASN1Set)new DERSet(v));
        v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new DEROctetString(data));
        v.add((ASN1Encodable)new DERBitString(data));
        v.add((ASN1Encodable)new ASN1Integer(100L));
        v.add((ASN1Encodable)ASN1Boolean.getInstance((boolean)true));
        BERSet s = new BERSet(v);
        if (!(s.getObjectAt(0) instanceof DEROctetString)) {
            this.fail("BER set sort order changed.");
        }
        DERTaggedObject tag = new DERTaggedObject(false, 1, (ASN1Encodable)new DERSequence(v));
        s = ASN1Set.getInstance((ASN1TaggedObject)(tag = (ASN1TaggedObject)ASN1Primitive.fromByteArray((byte[])tag.getEncoded("DER"))), (boolean)false);
        if (s.getObjectAt(0) instanceof ASN1Boolean) {
            this.fail("sorted when shouldn't be.");
        }
        v = new ASN1EncodableVector();
        v.add((ASN1Encodable)ASN1Boolean.getInstance((boolean)true));
        v.add((ASN1Encodable)ASN1Boolean.getInstance((boolean)true));
        v.add((ASN1Encodable)ASN1Boolean.getInstance((boolean)true));
        DERSet dERSet = new DERSet(v);
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new SetTest());
    }
}

