/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1RelativeOID;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class RelativeOIDTest
extends SimpleTest {
    private static final byte[] req1 = Hex.decode((String)"0D03813403");
    private static final byte[] req2 = Hex.decode((String)"0D082A36FFFFFFDD6311");

    public String getName() {
        return "RelativeOID";
    }

    private void recodeCheck(String oid, byte[] enc) throws IOException {
        byte[] bytes;
        ASN1RelativeOID o = new ASN1RelativeOID(oid);
        ByteArrayInputStream bIn = new ByteArrayInputStream(enc);
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        ASN1RelativeOID encO = (ASN1RelativeOID)aIn.readObject();
        if (!o.equals((ASN1Primitive)encO)) {
            this.fail("relative OID didn't match", o, encO);
        }
        if ((bytes = o.getEncoded("DER")).length != enc.length) {
            this.fail("failed length test");
        }
        int i = 0;
        while (i != enc.length) {
            if (bytes[i] != enc[i]) {
                this.fail("failed comparison test", new String(Hex.encode((byte[])enc)), new String(Hex.encode((byte[])bytes)));
            }
            ++i;
        }
    }

    private void checkValid(String oid) throws IOException {
        this.isTrue(ASN1RelativeOID.tryFromID((String)oid) != null);
        ASN1RelativeOID o = new ASN1RelativeOID(oid);
        o = (ASN1RelativeOID)ASN1Primitive.fromByteArray((byte[])o.getEncoded());
        if (!o.getId().equals(oid)) {
            this.fail("failed relative oid check for " + oid);
        }
    }

    private void checkInvalid(String oid) {
        this.isTrue(ASN1RelativeOID.tryFromID((String)oid) == null);
        try {
            new ASN1RelativeOID(oid);
            this.fail("failed to catch bad relative oid: " + oid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void branchCheck(String stem, String branch) {
        String actual;
        String expected = stem + "." + branch;
        if (!expected.equals(actual = new ASN1RelativeOID(stem).branch(branch).getId())) {
            this.fail("failed 'branch' check for " + stem + "/" + branch);
        }
    }

    public void performTest() throws IOException {
        this.recodeCheck("180.3", req1);
        this.recodeCheck("42.54.34359733987.17", req2);
        this.checkValid("0");
        this.checkValid("37");
        this.checkValid("0.1");
        this.checkValid("1.0");
        this.checkValid("1.0.2");
        this.checkValid("1.0.20");
        this.checkValid("1.0.200");
        this.checkValid("1.1.127.32512.8323072.2130706432.545460846592.139637976727552.35747322042253312.9151314442816847872");
        this.checkValid("1.2.123.12345678901.1.1.1");
        this.checkValid("2.25.196556539987194312349856245628873852187.1");
        this.checkValid("3.1");
        this.checkValid("37.196556539987194312349856245628873852187.100");
        this.checkValid("192.168.1.1");
        this.checkInvalid("00");
        this.checkInvalid("0.01");
        this.checkInvalid("00.1");
        this.checkInvalid("1.00.2");
        this.checkInvalid("1.0.02");
        this.checkInvalid("1.2.00");
        this.checkInvalid(".1");
        this.checkInvalid("..1");
        this.checkInvalid("3..1");
        this.checkInvalid(".123452");
        this.checkInvalid("1.");
        this.checkInvalid("1.345.23.34..234");
        this.checkInvalid("1.345.23.34.234.");
        this.checkInvalid(".12.345.77.234");
        this.checkInvalid(".12.345.77.234.");
        this.checkInvalid("1.2.3.4.A.5");
        this.checkInvalid("1,2");
        this.branchCheck("1.1", "2.2");
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new RelativeOIDTest());
    }
}

