/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.PolicyConstraints;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.test.SimpleTest;

public class PolicyConstraintsTest
extends SimpleTest {
    public String getName() {
        return "PolicyConstraints";
    }

    public void performTest() throws Exception {
        PolicyConstraints constraints = new PolicyConstraints(BigInteger.valueOf(1L), BigInteger.valueOf(2L));
        PolicyConstraints c = PolicyConstraints.getInstance((Object)constraints.getEncoded());
        this.isTrue("1 requireExplicitPolicyMapping", c.getRequireExplicitPolicyMapping().equals(BigInteger.valueOf(1L)));
        this.isTrue("2 inhibitPolicyMapping", c.getInhibitPolicyMapping().equals(BigInteger.valueOf(2L)));
        constraints = new PolicyConstraints(BigInteger.valueOf(3L), null);
        c = PolicyConstraints.getInstance((Object)constraints.getEncoded());
        this.isTrue("3 requireExplicitPolicyMapping", c.getRequireExplicitPolicyMapping().equals(BigInteger.valueOf(3L)));
        this.isTrue("4 inhibitPolicyMapping", c.getInhibitPolicyMapping() == null);
        constraints = new PolicyConstraints(null, BigInteger.valueOf(4L));
        c = PolicyConstraints.getInstance((Object)constraints.getEncoded());
        this.isTrue("5 inhibitPolicyMapping", c.getInhibitPolicyMapping().equals(BigInteger.valueOf(4L)));
        this.isTrue("6 requireExplicitPolicyMapping", c.getRequireExplicitPolicyMapping() == null);
        this.isTrue("encoding test", Arrays.areEqual((byte[])new PolicyConstraints(BigInteger.valueOf(1L), null).getEncoded(), (byte[])new DERSequence((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new ASN1Integer(1L))).getEncoded()));
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new PolicyConstraintsTest());
    }
}

