/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestResult;

public class ObjectIdentifierTest
extends SimpleTest {
    public String getName() {
        return "ObjectIdentifier";
    }

    public void performTest() throws Exception {
        try {
            ASN1ObjectIdentifier.fromContents((byte[])new byte[0]);
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("invalid OID contents", e.getMessage());
        }
        int i = 0;
        while (i < 100) {
            int j = 0;
            while (j < 100) {
                byte[] encoded2;
                ASN1ObjectIdentifier oid4;
                ASN1ObjectIdentifier oid3;
                byte[] encoded1;
                ASN1ObjectIdentifier oid2;
                ASN1ObjectIdentifier oid1 = new ASN1ObjectIdentifier("1.1." + i + "." + j);
                if (oid1 == (oid2 = ASN1ObjectIdentifier.getInstance((Object)(encoded1 = oid1.getEncoded())))) {
                    this.fail("Shouldn't be the same: " + oid1 + " " + oid2);
                }
                if (!oid1.equals((ASN1Primitive)oid2)) {
                    this.fail("Should be equal: " + oid1 + " " + oid2);
                }
                if (oid2 != (oid3 = oid2.intern())) {
                    this.fail("Should be the same: " + oid2 + " " + oid3);
                }
                if (!oid2.equals((ASN1Primitive)oid3)) {
                    this.fail("Should be equal: " + oid2 + " " + oid3);
                }
                if (oid3 != (oid4 = ASN1ObjectIdentifier.getInstance((Object)(encoded2 = oid3.getEncoded())))) {
                    this.fail("Should be taken from cache: " + oid3 + " " + oid4);
                }
                if (!oid3.equals((ASN1Primitive)oid4)) {
                    this.fail("Should be equal: " + oid3 + " " + oid4);
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < 100) {
            int j = 0;
            while (j < 100) {
                ASN1ObjectIdentifier oid1 = new ASN1ObjectIdentifier("1.1.2." + i2 + "." + j);
                byte[] encoded1 = oid1.getEncoded();
                ASN1ObjectIdentifier oid2 = ASN1ObjectIdentifier.getInstance((Object)encoded1);
                ASN1ObjectIdentifier oid3 = ASN1ObjectIdentifier.getInstance((Object)encoded1);
                if (oid1 == oid2) {
                    this.fail("Shouldn't be the same: " + oid1 + " " + oid2);
                }
                if (oid2 == oid3) {
                    this.fail("Shouldn't be the same: " + oid2 + " " + oid3);
                }
                ++j;
            }
            ++i2;
        }
    }

    public static void main(String[] args) {
        ObjectIdentifierTest test = new ObjectIdentifierTest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

