/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class OIDTest
extends SimpleTest {
    byte[] req1 = Hex.decode((String)"0603813403");
    byte[] req2 = Hex.decode((String)"06082A36FFFFFFDD6311");

    public String getName() {
        return "OID";
    }

    private void recodeCheck(String oid, byte[] enc) throws IOException {
        byte[] bytes;
        ASN1ObjectIdentifier o = new ASN1ObjectIdentifier(oid);
        ByteArrayInputStream bIn = new ByteArrayInputStream(enc);
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        ASN1ObjectIdentifier encO = (ASN1ObjectIdentifier)aIn.readObject();
        if (!o.equals((ASN1Primitive)encO)) {
            this.fail("oid ID didn't match", o, encO);
        }
        if ((bytes = o.getEncoded("DER")).length != enc.length) {
            this.fail("failed length test");
        }
        int i = 0;
        while (i != enc.length) {
            if (bytes[i] != enc[i]) {
                this.fail("failed comparison test", new String(Hex.encode((byte[])enc)), new String(Hex.encode((byte[])bytes)));
            }
            ++i;
        }
    }

    private void validOidCheck(String oid) throws IOException {
        this.isTrue(ASN1ObjectIdentifier.tryFromID((String)oid) != null);
        ASN1ObjectIdentifier o = new ASN1ObjectIdentifier(oid);
        o = (ASN1ObjectIdentifier)ASN1Primitive.fromByteArray((byte[])o.getEncoded());
        if (!o.getId().equals(oid)) {
            this.fail("failed oid check for " + oid);
        }
    }

    private void invalidOidCheck(String oid) {
        this.isTrue(ASN1ObjectIdentifier.tryFromID((String)oid) == null);
        try {
            new ASN1ObjectIdentifier(oid);
            this.fail("failed to catch bad oid: " + oid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void branchCheck(String stem, String branch) {
        String actual;
        String expected = stem + "." + branch;
        if (!expected.equals(actual = new ASN1ObjectIdentifier(stem).branch(branch).getId())) {
            this.fail("failed 'branch' check for " + stem + "/" + branch);
        }
    }

    private void onCheck(String stem, String test, boolean expected) {
        if (expected != new ASN1ObjectIdentifier(test).on(new ASN1ObjectIdentifier(stem))) {
            this.fail("failed 'on' check for " + stem + "/" + test);
        }
    }

    private void testIntern() {
        ASN1ObjectIdentifier oid1 = new ASN1ObjectIdentifier("2.2.100").intern();
        ASN1ObjectIdentifier oid2 = new ASN1ObjectIdentifier("2.2.100").intern();
        this.isTrue(oid2 != null);
        this.isEquals(oid1, oid2);
    }

    public void performTest() throws IOException {
        this.recodeCheck("2.100.3", this.req1);
        this.recodeCheck("1.2.54.34359733987.17", this.req2);
        this.validOidCheck(PKCSObjectIdentifiers.pkcs_9_at_contentType.getId());
        this.validOidCheck("0.1");
        this.validOidCheck("1.0");
        this.validOidCheck("1.0.2");
        this.validOidCheck("1.0.20");
        this.validOidCheck("1.0.200");
        this.validOidCheck("1.1.127.32512.8323072.2130706432.545460846592.139637976727552.35747322042253312.9151314442816847872");
        this.validOidCheck("1.2.123.12345678901.1.1.1");
        this.validOidCheck("2.25.196556539987194312349856245628873852187.1");
        this.validOidCheck("0.0");
        this.validOidCheck("0.0.1");
        this.validOidCheck("0.39");
        this.validOidCheck("0.39.1");
        this.validOidCheck("1.0");
        this.validOidCheck("1.0.1");
        this.validOidCheck("1.39");
        this.validOidCheck("1.39.1");
        this.validOidCheck("2.0");
        this.validOidCheck("2.0.1");
        this.validOidCheck("2.40");
        this.validOidCheck("2.40.1");
        this.invalidOidCheck("0");
        this.invalidOidCheck("1");
        this.invalidOidCheck("2");
        this.invalidOidCheck("3.1");
        this.invalidOidCheck("0.01");
        this.invalidOidCheck("00.1");
        this.invalidOidCheck("1.00.2");
        this.invalidOidCheck("1.0.02");
        this.invalidOidCheck("1.2.00");
        this.invalidOidCheck("..1");
        this.invalidOidCheck("192.168.1.1");
        this.invalidOidCheck(".123452");
        this.invalidOidCheck("1.");
        this.invalidOidCheck("1.345.23.34..234");
        this.invalidOidCheck("1.345.23.34.234.");
        this.invalidOidCheck(".12.345.77.234");
        this.invalidOidCheck(".12.345.77.234.");
        this.invalidOidCheck("1.2.3.4.A.5");
        this.invalidOidCheck("1,2");
        this.invalidOidCheck("0.40");
        this.invalidOidCheck("0.40.1");
        this.invalidOidCheck("0.100");
        this.invalidOidCheck("0.100.1");
        this.invalidOidCheck("1.40");
        this.invalidOidCheck("1.40.1");
        this.invalidOidCheck("1.100");
        this.invalidOidCheck("1.100.1");
        this.branchCheck("1.1", "2.2");
        this.onCheck("1.1", "1.1", false);
        this.onCheck("1.1", "1.2", false);
        this.onCheck("1.1", "1.2.1", false);
        this.onCheck("1.1", "2.1", false);
        this.onCheck("1.1", "1.11", false);
        this.onCheck("1.12", "1.1.2", false);
        this.onCheck("1.1", "1.1.1", true);
        this.onCheck("1.1", "1.1.2", true);
        this.onCheck("1.2.3.4.5.6", "1.2.3.4.5.6", false);
        this.onCheck("1.2.3.4.5.6", "1.2.3.4.5.6.7", true);
        this.onCheck("1.2.3.4.5.6", "1.2.3.4.5.6.7.8", true);
        this.testIntern();
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new OIDTest());
    }
}

