/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.test.ASN1UnitTest;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x509.sigi.NameOrPseudonym;
import org.bouncycastle.util.test.SimpleTest;

public class NameOrPseudonymUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "NameOrPseudonym";
    }

    public void performTest() throws Exception {
        String pseudonym = "pseudonym";
        DirectoryString surname = new DirectoryString("surname");
        DERSequence givenName = new DERSequence((ASN1Encodable)new DirectoryString("givenName"));
        NameOrPseudonym id = new NameOrPseudonym(pseudonym);
        this.checkConstruction(id, pseudonym, null, null);
        id = new NameOrPseudonym(surname, (ASN1Sequence)givenName);
        this.checkConstruction(id, null, surname, (ASN1Sequence)givenName);
        id = NameOrPseudonym.getInstance(null);
        if (id != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            NameOrPseudonym.getInstance((Object)new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void checkConstruction(NameOrPseudonym id, String pseudonym, DirectoryString surname, ASN1Sequence givenName) throws IOException {
        this.checkValues(id, pseudonym, surname, givenName);
        id = NameOrPseudonym.getInstance((Object)id);
        this.checkValues(id, pseudonym, surname, givenName);
        ASN1InputStream aIn = new ASN1InputStream(id.toASN1Primitive().getEncoded());
        if (surname != null) {
            ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
            id = NameOrPseudonym.getInstance((Object)seq);
        } else {
            ASN1String s = (ASN1String)aIn.readObject();
            id = NameOrPseudonym.getInstance((Object)s);
        }
        this.checkValues(id, pseudonym, surname, givenName);
    }

    private void checkValues(NameOrPseudonym id, String pseudonym, DirectoryString surname, ASN1Sequence givenName) {
        if (surname != null) {
            this.checkMandatoryField("surname", (ASN1Encodable)surname, (ASN1Encodable)id.getSurname());
            this.checkMandatoryField("givenName", (ASN1Encodable)givenName, (ASN1Encodable)new DERSequence((ASN1Encodable)id.getGivenName()[0]));
        } else {
            this.checkOptionalField("pseudonym", (ASN1Encodable)new DirectoryString(pseudonym), (ASN1Encodable)id.getPseudonym());
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new NameOrPseudonymUnitTest());
    }
}

