/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.internal.asn1.misc.CAST5CBCParameters;
import org.bouncycastle.internal.asn1.misc.IDEACBCPar;
import org.bouncycastle.internal.asn1.misc.NetscapeCertType;
import org.bouncycastle.internal.asn1.misc.NetscapeRevocationURL;
import org.bouncycastle.internal.asn1.misc.VerisignCzagExtension;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class MiscTest
extends SimpleTest {
    public void shouldFailOnExtraData() throws Exception {
        block2: {
            DERBitString s1 = new DERBitString(new byte[0], 0);
            ASN1Primitive.fromByteArray((byte[])s1.getEncoded());
            ASN1Primitive.fromByteArray((byte[])new BERSequence((ASN1Encodable)s1).getEncoded());
            try {
                ASN1Primitive obj = ASN1Primitive.fromByteArray((byte[])Arrays.concatenate((byte[])s1.getEncoded(), (byte[])new byte[1]));
                this.fail("no exception");
            }
            catch (IOException e) {
                if ("Extra data detected in stream".equals(e.getMessage())) break block2;
                this.fail("wrong exception");
            }
        }
    }

    public void asn1IntegerTest() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        try {
            new ASN1Integer(new byte[]{0, 0, 0, 1});
            this.fail("expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            this.isTrue("wrong exc 1: " + e.getMessage(), "malformed integer".equals(e.getMessage()));
        }
        try {
            new ASN1Integer(new byte[]{-1, -128, 0, 1});
            this.fail("expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            this.isTrue("wrong exc 2: " + e.getMessage(), "malformed integer".equals(e.getMessage()));
        }
        try {
            new ASN1Enumerated(new byte[]{0, 0, 0, 1});
            this.fail("expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            this.isTrue("wrong exc 3: " + e.getMessage(), "malformed enumerated".equals(e.getMessage()));
        }
        try {
            new ASN1Enumerated(new byte[]{-1, -128, 0, 1});
            this.fail("expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            this.isTrue("wrong exc 4: " + e.getMessage(), "malformed enumerated".equals(e.getMessage()));
        }
    }

    public void performTest() throws Exception {
        byte[] testIv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        ASN1Encodable[] values = new ASN1Encodable[]{new CAST5CBCParameters(testIv, 128), new NetscapeCertType(32), new VerisignCzagExtension((ASN1IA5String)new DERIA5String("hello")), new IDEACBCPar(testIv), new NetscapeRevocationURL((ASN1IA5String)new DERIA5String("http://test"))};
        byte[] data = Base64.decode((String)"MA4ECAECAwQFBgcIAgIAgAMCBSAWBWhlbGxvMAoECAECAwQFBgcIFgtodHRwOi8vdGVzdA==");
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = ASN1OutputStream.create((OutputStream)bOut);
        int i = 0;
        while (i != values.length) {
            aOut.writeObject(values[i]);
            ++i;
        }
        if (!this.areEqual(bOut.toByteArray(), data)) {
            this.fail("Failed data check");
        }
        ASN1InputStream aIn = new ASN1InputStream(data);
        int i2 = 0;
        while (i2 != values.length) {
            ASN1Primitive o = aIn.readObject();
            if (!values[i2].equals(o)) {
                this.fail("Failed equality test for " + o);
            }
            if (o.hashCode() != values[i2].hashCode()) {
                this.fail("Failed hashCode test for " + o);
            }
            ++i2;
        }
        this.shouldFailOnExtraData();
        this.asn1IntegerTest();
    }

    public String getName() {
        return "Misc";
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new MiscTest());
    }
}

