/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.bc.LinkedCertificate;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.test.ASN1UnitTest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.util.test.SimpleTest;

public class LinkedCertificateTest
extends ASN1UnitTest {
    public String getName() {
        return "LinkedCertificate";
    }

    public void performTest() throws Exception {
        DigestInfo digInfo = new DigestInfo(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256), new byte[32]);
        GeneralName certLocation = new GeneralName(6, "https://www.bouncycastle.org/certs");
        X500Name certIssuer = null;
        GeneralNames cACerts = null;
        LinkedCertificate linked = new LinkedCertificate(digInfo, certLocation);
        this.checkConstruction(linked, digInfo, certLocation, certIssuer, cACerts);
        certIssuer = new X500Name("CN=Test");
        cACerts = new GeneralNames(new GeneralName(new X500Name("CN=CA Test")));
        linked = new LinkedCertificate(digInfo, certLocation, certIssuer, cACerts);
        this.checkConstruction(linked, digInfo, certLocation, certIssuer, cACerts);
        linked = LinkedCertificate.getInstance(null);
        if (linked != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            LinkedCertificate.getInstance((Object)new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void checkConstruction(LinkedCertificate linked, DigestInfo digestInfo, GeneralName certLocation, X500Name certIssuer, GeneralNames caCerts) throws IOException {
        this.checkValues(linked, digestInfo, certLocation, certIssuer, caCerts);
        linked = LinkedCertificate.getInstance((Object)linked);
        this.checkValues(linked, digestInfo, certLocation, certIssuer, caCerts);
        ASN1InputStream aIn = new ASN1InputStream(linked.toASN1Primitive().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        linked = LinkedCertificate.getInstance((Object)seq);
        this.checkValues(linked, digestInfo, certLocation, certIssuer, caCerts);
    }

    private void checkValues(LinkedCertificate linked, DigestInfo digestInfo, GeneralName certLocation, X500Name certIssuer, GeneralNames caCerts) {
        this.checkMandatoryField("digest", (ASN1Encodable)digestInfo, (ASN1Encodable)linked.getDigest());
        this.checkMandatoryField("certLocatin", (ASN1Encodable)certLocation, (ASN1Encodable)linked.getCertLocation());
        this.checkOptionalField("certIssuer", (ASN1Encodable)certIssuer, (ASN1Encodable)linked.getCertIssuer());
        this.checkOptionalField("caCerts", (ASN1Encodable)caCerts, (ASN1Encodable)linked.getCACerts());
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new LinkedCertificateTest());
    }
}

