/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.nist.KMACwithSHAKE128_params;
import org.bouncycastle.asn1.nist.KMACwithSHAKE256_params;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTest;

public class KMACParamsTest
extends SimpleTest {
    public void performTest() throws Exception {
        this.isTrue(Arrays.areEqual((byte[])new KMACwithSHAKE128_params(256).getEncoded(), (byte[])new DERSequence().getEncoded()));
        this.isTrue(Arrays.areEqual((byte[])new KMACwithSHAKE256_params(512).getEncoded(), (byte[])new DERSequence().getEncoded()));
        this.isTrue(Arrays.areEqual((byte[])new KMACwithSHAKE128_params(512).getEncoded(), (byte[])new DERSequence((ASN1Encodable)new ASN1Integer(512L)).getEncoded()));
        this.isTrue(Arrays.areEqual((byte[])new KMACwithSHAKE256_params(256).getEncoded(), (byte[])new DERSequence((ASN1Encodable)new ASN1Integer(256L)).getEncoded()));
        this.isTrue(Arrays.areEqual((byte[])new KMACwithSHAKE128_params(512).getEncoded(), (byte[])KMACwithSHAKE128_params.getInstance((Object)new DERSequence((ASN1Encodable)new ASN1Integer(512L))).getEncoded()));
        this.isTrue(Arrays.areEqual((byte[])new KMACwithSHAKE256_params(256).getEncoded(), (byte[])KMACwithSHAKE256_params.getInstance((Object)new DERSequence((ASN1Encodable)new ASN1Integer(256L))).getEncoded()));
        byte[] customizationString = Strings.toByteArray((String)"hello, world!");
        this.isTrue(Arrays.areEqual((byte[])new KMACwithSHAKE128_params(512, customizationString).getEncoded(), (byte[])new DERSequence(new ASN1Encodable[]{new ASN1Integer(512L), new DEROctetString(customizationString)}).getEncoded()));
        this.isTrue(Arrays.areEqual((byte[])new KMACwithSHAKE256_params(256, customizationString).getEncoded(), (byte[])new DERSequence(new ASN1Encodable[]{new ASN1Integer(256L), new DEROctetString(customizationString)}).getEncoded()));
        this.isTrue(Arrays.areEqual((byte[])new KMACwithSHAKE128_params(512, customizationString).getEncoded(), (byte[])KMACwithSHAKE128_params.getInstance((Object)new DERSequence(new ASN1Encodable[]{new ASN1Integer(512L), new DEROctetString(customizationString)})).getEncoded()));
        this.isTrue(Arrays.areEqual((byte[])new KMACwithSHAKE256_params(256, customizationString).getEncoded(), (byte[])KMACwithSHAKE256_params.getInstance((Object)new DERSequence(new ASN1Encodable[]{new ASN1Integer(256L), new DEROctetString(customizationString)})).getEncoded()));
        this.isTrue(Arrays.areEqual((byte[])new KMACwithSHAKE128_params(256, customizationString).getEncoded(), (byte[])new DERSequence(new ASN1Encodable[]{new DEROctetString(customizationString)}).getEncoded()));
        this.isTrue(Arrays.areEqual((byte[])new KMACwithSHAKE256_params(512, customizationString).getEncoded(), (byte[])new DERSequence(new ASN1Encodable[]{new DEROctetString(customizationString)}).getEncoded()));
        this.isTrue(Arrays.areEqual((byte[])new KMACwithSHAKE128_params(256, customizationString).getEncoded(), (byte[])KMACwithSHAKE128_params.getInstance((Object)new DERSequence(new ASN1Encodable[]{new DEROctetString(customizationString)})).getEncoded()));
        this.isTrue(Arrays.areEqual((byte[])new KMACwithSHAKE256_params(512, customizationString).getEncoded(), (byte[])KMACwithSHAKE256_params.getInstance((Object)new DERSequence(new ASN1Encodable[]{new DEROctetString(customizationString)})).getEncoded()));
        KMACwithSHAKE128_params p128 = new KMACwithSHAKE128_params(256, customizationString);
        this.isEquals(256, p128.getOutputLength());
        this.isTrue(Arrays.areEqual((byte[])customizationString, (byte[])p128.getCustomizationString()));
        this.isTrue(p128 == KMACwithSHAKE128_params.getInstance((Object)p128));
        KMACwithSHAKE256_params p256 = new KMACwithSHAKE256_params(512, customizationString);
        this.isEquals(512, p256.getOutputLength());
        this.isTrue(Arrays.areEqual((byte[])customizationString, (byte[])p256.getCustomizationString()));
        this.isTrue(p256 == KMACwithSHAKE256_params.getInstance((Object)p256));
        p128 = new KMACwithSHAKE128_params(512);
        this.isEquals(512, p128.getOutputLength());
        this.isTrue(Arrays.areEqual((byte[])new byte[0], (byte[])p128.getCustomizationString()));
        p256 = new KMACwithSHAKE256_params(256);
        this.isEquals(256, p256.getOutputLength());
        this.isTrue(Arrays.areEqual((byte[])new byte[0], (byte[])p256.getCustomizationString()));
    }

    public String getName() {
        return "KMACParams";
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new KMACParamsTest());
    }
}

